const fs = require("fs");
const https = require("https");
const path = require("path");
const WebSocket = require("ws");
const express = require("express");
const cors = require("cors");
const admin = require("firebase-admin");
const serviceAccount = require("./app/Config/firebaseServiceAccount.json");
const { sendFCM } = require("./app/Helpers/fcmHelper");
const WebSocketController = require("./app/Controllers/WebSocketController");
const apiRoutes = require("./app/Routes/api");

const app = express();
const io = require("@pm2/io");
const findDriverRoutes = require("./app/Routes/finddriver")


io.init({
  transactions: true,
  http: true,
  metrics: {
    eventLoopActive: true,
    eventLoopDelay: true,
  },
});


// ✅ Inisialisasi Firebase Admin SDK
admin.initializeApp({
  credential: admin.credential.cert(serviceAccount),
});

app.use(express.json());

// ✅ Endpoint API untuk kirim notifikasi
app.post("/send-notification", async (req, res) => {
   const { token, notification, data } = req.body;

   try {
     const result = await sendFCM(token, notification, data);
     res.json(result);
   } catch (error) {
     console.error("❌ Error kirim notifikasi:", error.message);
     res.status(400).json({ success: false, error: error.message });
   }
});

// ✅ CORS middleware
app.use(
  cors({
    origin: "https://alfago.alfateknologi.net",
    methods: ["GET", "POST", "PUT", "DELETE", "OPTIONS"],
    allowedHeaders: ["Content-Type", "Authorization"],
    credentials: true,
  })
);

// ✅ (Opsional) boleh hapus baris ini atau pakai '/api/*'
// app.options('/*', cors());
app.use("/find-driver", findDriverRoutes);

// === tambahkan routes API ===
app.use("/api", apiRoutes);
// app.use("/api/topup", apiRoutes);

// === HTTPS SERVER ===
// const server = https.createServer({
//     key: fs.readFileSync('C:/apps/alfago/ssl-keys/alfago.alfateknologi.com-key.pem'),
//     cert: fs.readFileSync('C:/apps/alfago/ssl-keys/alfago.alfateknologi.com-chain.pem'),

// }, app);

const server = https.createServer(
  {
    key: fs.readFileSync(
      "/etc/letsencrypt/live/alfago.alfateknologi.net/privkey.pem"
    ),
    cert: fs.readFileSync(
      "/etc/letsencrypt/live/alfago.alfateknologi.nwr/fullchain.pem"
    ),
  },
  app
);

// === WEBSOCKET SERVER ===
const wss = new WebSocket.Server({ server });
wss.on("connection", WebSocketController.onConnection);

// Heartbeat untuk deteksi koneksi zombie
WebSocketController.startHeartbeat(wss, 5000);

const PORT = 3755;
server.listen(PORT, () => {
  console.log(
    `🚀 HTTPS & WSS server running on https://alfago.alfateknologi.net:${PORT}`
  );
});
