module.exports = {
  apps: [
    {
      name: "alfago-wss",
      script: "./server.js",
      instances: 1,
      exec_mode: "fork",
      node_args: ["--max_old_space_size=1024"],
      max_memory_restart: "1200M",

      // 🧩 Log settings
      out_file: "./logs/alfago-out.log",
      error_file: "./logs/alfago-error.log",
      merge_logs: true,
      time: false,
      log_date_format: "YYYY-MM-DD HH:mm:ss", // ✅ Format tanggal log
      date_format: "YYYY-MM-DD HH:mm:ss", // (cadangan, untuk versi PM2 lama)

      // 🔧 Watch (nonaktifkan di production jika stabil)
      watch: true,
      ignore_watch: [
        "node_modules",
        "logs",
        "auth",
        "images",
        "ssl-keys",
        ".git",
      ],

      // 🔁 Restart rules
      exp_backoff_restart_delay: 1000,
      restart_delay: 2000,

      env: {
        NODE_ENV: "production",
        // NODE_ENV: "development",
        PORT: 3755,
      },
    },
  ],
};

