const express = require('express');
const router = express.Router();
const ApiController = require('../Controllers/ApiController');
const TopupController = require("../Controllers/topupMidtransController");
const MessageController = require('../Controllers/MessageController');
const OrderController = require('../Controllers/OrderController');
const WebSocketController = require('../Controllers/WebSocketController')
const auth = require('../Middleware/auth');
const DriverAPIController = require("../Controllers/DriverAPIController");
const WsSender = require("../Helpers/WsSender");

// semua route butuh token
// router.use(auth);

router.get('/users', ApiController.getUsers);
router.get('/users/:phone', ApiController.getUserByPhone);

router.post("/topup", TopupController.Topup);
router.post("/topup/payment", TopupController.postTopupPayment);
router.get("/topup/payment", TopupController.getTopupPayment);

router.post("/start-find-driver", DriverAPIController.start);

// === API baru untuk kirim pesan ===
router.post('/push', MessageController.pushMessage);


// router.post("/push", WsSender.sendToUuid);

router.post('/order/new', OrderController.OrderNew);

// === API update lokasi ===
router.post('/update_location', ApiController.updateLocation);

module.exports = router;
