const db = require("../Config/Database");

module.exports = {
  async setOnline(phone, token, uuid) {
    await db.query(
      "UPDATE users SET login_wss=?, uuid=? WHERE phone=? AND token=?",
      ["Y", uuid, phone, token]
    );
  },
  async setOffline(phone, token) {
    await db.query("UPDATE users SET login_wss=? WHERE phone=? AND token=?", [
      "N",
      phone,
      token,
    ]);
  },

  async getAll() {
    return db.query("SELECT * FROM users");
  },

  async getByPhone(phone) {
    return db.query("SELECT * FROM users WHERE phone = ?", [phone]);
  },

  async getByRestaurantID(restaurant_id) {
    return db.query("SELECT * FROM users WHERE restaurant_id = ?", [
      restaurant_id,
    ]);
  },

  async getByPhoneOrder(phone, tarif) {
    const trf = tarif - 1000;
    const fee = trf * 0.2;

    console.log(`FEE: ${fee}`);
    console.log(`PHONE: ${phone}`);
    return db.query("SELECT * FROM users WHERE phone = ? and saldo > '0'", [
      phone,
    ]);
  },

  async updateLocation(phone, lat, lng) {
    await db.query("UPDATE users SET loc_lat=?, loc_lng=? WHERE phone=?", [
      lat,
      lng,
      phone,
    ]);
  },
  async rideToggle(phone, rideToggled) {
    await db.query("UPDATE users SET driver_ride=? WHERE phone=?", [
      rideToggled,
      phone,
    ]);
  },
  async rideFood(phone, rideFood) {
    await db.query("UPDATE users SET driver_food=? WHERE phone=?", [
      rideFood,
      phone,
    ]);
  },
  async getByPhoneOrderRide(phone) {
    return db.query(
      "SELECT * FROM users WHERE phone = ? AND status_aktif=? AND login=? AND login_wss=? AND driver_ride= ?",
      [phone, "Y", "Y", "Y", "Y"]
    );
  },
  async getByPhoneOrderFood(phone) {
    return db.query(
      "SELECT * FROM users WHERE phone = ? AND status_aktif=? AND login=? AND login_wss=? AND driver_food= ?",
      [phone, "Y", "Y", "Y", "Y"]
    );
  },
};
