const db = require("../Config/Database");

module.exports = {
  async insertTopup(
    phone,
    jumlah_topup,
    order_id,
    pembayaran_via,
    bank,
    trx_id,
    link_pembayaran,
    status_pembayaran,
    link_expired_time,
    mode
  ) {
    await db.query(
      "INSERT into topup (phone,jumlah_topup,order_id,pembayaran_via,bank,trx_id,link_pembayaran,status_pembayaran,link_expired_time,mode) values (?,?,?,?,?,?,?,?,?,?)",
      [
        phone,
        jumlah_topup,
        order_id,
        pembayaran_via,
        bank,
        trx_id,
        link_pembayaran,
        status_pembayaran,
        link_expired_time,
        mode,
      ]
    );
  },
  async updatePayment(status_pembayaran, settlement_time, issuer, trx_id) {
    try {
      const [result] = await db.query(
        "UPDATE topup SET status_pembayaran = ?, settlement_time = ?, issuer = ? WHERE trx_id = ?",
        [status_pembayaran, settlement_time, issuer, trx_id]
      );

      // Jika tidak ada baris yang diperbarui (trx_id tidak ditemukan)
      if (result.affectedRows === 0) {
        return {
          success: false,
          message: `Tidak ada data dengan trx_id: ${trx_id}`,
        };
      }

      // Jika sukses
      return {
        success: true,
        message: "Status pembayaran berhasil diperbarui",
        updated_at: new Date().toISOString(),
        trx_id,
        status_pembayaran,
      };
    } catch (error) {
      console.error("💥 Error updatePayment:", error);
      return {
        success: false,
        message: "Gagal memperbarui status pembayaran",
        error: error.message,
      };
    }
  },
  async getTopup(trxID) {
    return db.query(
      `
    SELECT 
      o.*,

      -- 📍 Data Customer
      c.nama AS customer_name,
      c.phone AS customer_phone,
      c.uuid AS uuid_customer,
      c.fcm_token as fcm_token

    FROM topup o
    LEFT JOIN users c ON c.phone = o.phone
    WHERE o.trx_id = ?
  `,
      [trxID]
    );
  },
};
