const db = require("../Config/Database");
const User = require("./UserModel");

module.exports = {
  async getRiwayat(phone) {
    const sql = `
 SELECT 
  IFNULL(SUM(pendapatan_driver), 0) AS total_pendapatan,
  COUNT(*) AS total_order
FROM riwayat_driver
WHERE phone = ?
  AND created_at BETWEEN CURDATE() AND DATE_ADD(CURDATE(), INTERVAL 1 DAY);

  `;

    const [rows] = await db.query(sql, [phone]);
    return rows[0]; // hasil: { total_pendapatan: 12345, total_order: 3 }
  },
};
