module.exports = function (req, res, next) {
    const authHeader = req.headers['authorization'];
    if (!authHeader) {
        return res.status(401).json({ success: false, message: 'No token provided' });
    }

    const authKey = authHeader.split(' ')[1]; // format "Bearer <token>"
    if (!authKey) {
        return res.status(401).json({ success: false, message: 'Invalid token format' });
    }

    // contoh cek token statis dari .env
    if (authKey !== process.env.API_SECRET_KEY) {
        return res.status(403).json({ success: false, message: 'Forbidden' });
    }

    next();
};
