const fs = require('fs');
const moment = require('moment');
const path = require('path');

// Generate random alphanumeric string
exports.generateUniqueId = (length = 10) => {
  const prefix = "alfago-";
  const characters =
    "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
  let result = "";

  for (let i = 0; i < length; i++) {
    const randomIndex = Math.floor(Math.random() * characters.length);
    result += characters.charAt(randomIndex);
  }

  return prefix + result;
};

// Convert string to Base64
exports.encodeBase64 = (text) => {
    return Buffer.from(text, 'utf-8').toString('base64');
};

// Format number to Indonesian Rupiah format
exports.FormatRupiah = (angka) => {
    if (angka === null || angka === undefined || isNaN(angka)) return 'Rp0';

    const clean = parseInt(angka.toString().replace(/[^0-9]/g, ''), 10);
    return 'Rp ' + clean.toString().replace(/\B(?=(\d{3})+(?!\d))/g, '.');
};

exports.restart = async () => {
    const NoHPSuperAdmin = await userData.getNoHPSuperadmin();

    await sendWA.send(NoHPSuperAdmin, "", 'RESTART SERVER', `Keterangan : *Restart signal sent to server ...*`);

    fs.writeFileSync('restart.js', moment().format('DD/MM/YYYY HH:mm:ss')); // update isi file
    console.log(`\nRestart signal sent to nodemon`);
};

exports.production = async (prod) => {
    let st, _prod;
    if (prod === "1") {
        st = true;
        _prod = "PRODUCTION";
    } else {
        st = false;
        _prod = "DEVELOPER";
    }
    const envPath = path.resolve(process.cwd(), '.env');
    let envContent = fs.readFileSync(envPath, 'utf8');

    // Ganti nilai PRODUCTION
    envContent = envContent.replace(/PRODUCTION=.*/g, `PRODUCTION=${st}`);

    // Tulis kembali ke file
    fs.writeFileSync(envPath, envContent);

    const NoHPSuperAdmin = await userData.getNoHPSuperadmin();

    await sendWA.send(NoHPSuperAdmin, "", 'PRODUCTION', `Status production : *${_prod}*`);

    fs.writeFileSync('restart.js', moment().format('DD/MM/YYYY HH:mm:ss')); // update isi file
    console.log(`\nRestart signal sent to nodemon`);
};

exports.payment = async (payment) => {   
    const envPath = path.resolve(process.cwd(), '.env');
    let envContent = fs.readFileSync(envPath, 'utf8');

    // Ganti nilai PRODUCTION
    envContent = envContent.replace(/PAYMENT_GATEWAY=.*/g, `PAYMENT_GATEWAY=${payment.toUpperCase()}`);


    // Tulis kembali ke file
    fs.writeFileSync(envPath, envContent);

    const NoHPSuperAdmin = await userData.getNoHPSuperadmin();

    await sendWA.send(NoHPSuperAdmin, "", 'PAYMENT', `Payment mode : *${payment.toUpperCase()}*`);

    fs.writeFileSync('restart.js', moment().format('DD/MM/YYYY HH:mm:ss')); // update isi file
    console.log(`\nRestart signal sent to nodemon`);
};


exports.remove_qris = async (order_id) => {
    try {
        // ambil lokasi folder dari .env
        // const qrisFolder = path.resolve(process.cwd(), process.env.QRIS_SAVE_DIR);
        const qrisFolder = "/var/www/alfago/public/images/qris";

        // path file (misalnya qris-12345.png)
        const filePath = path.join(qrisFolder, `${order_id}`);
        console.log(filePath);
        // cek apakah file ada
        if (fs.existsSync(filePath)) {
            await fs.promises.unlink(filePath);
            console.log(`QRIS file removed: ${filePath}`);
            return { success: true, message: "QRIS image removed successfully." };
        } else {
            console.warn(`QRIS file not found for order_id: ${order_id}`);
            return { success: false, message: "QRIS image not found." };
        }
    } catch (error) {
        console.error("Error removing QRIS image:", error);
        return { success: false, message: "Error removing QRIS image.", error };
    }
};