// Helpers/WsSender.js

let connections = new Map();

function registerConnectionsMap(mapRef) {
  connections = mapRef; // reference asli
}

function sendToUuid(uuid, message) {
  console.log(`UUID: ${message}`);
  const ws = connections.get(uuid);
  if (ws && ws.readyState === ws.OPEN) {
    ws.send(JSON.stringify(message));
    return true;
  }
  return false;
}

function sendToAll(message) {
  connections.forEach((ws) => {
    if (ws.readyState === ws.OPEN) {
      ws.send(JSON.stringify(message));
    }
  });
}

module.exports = {
  registerConnectionsMap,
  sendToUuid,
  sendToAll,
};
