// Helpers/IpSecurity.js

const failed = new Map();
const blocked = new Map();

function addFailed(ip) {
  const count = (failed.get(ip) || 0) + 1;
  if (count >= 5) {
    blocked.set(ip, Date.now() + 10 * 60 * 1000);
    failed.delete(ip);
    return true;
  }
  failed.set(ip, count);
  return false;
}

function isBlocked(ip) {
  const until = blocked.get(ip);
  if (!until) return false;
  if (until < Date.now()) {
    blocked.delete(ip);
    return false;
  }
  return true;
}

module.exports = { addFailed, isBlocked };
