// Helpers/AuthValidator.js

const User = require("../Models/UserModel");

async function validateCredentials(ws, { authKey, phone, token }) {
  if (authKey !== process.env.API_SECRET_KEY) {
    ws.send(JSON.stringify({ type: "error", message: "Unauthorized API key" }));
    return false;
  }
  if (!phone || phone.trim() === "") {
    ws.send(JSON.stringify({ type: "error", message: "Phone required" }));
    return false;
  }
  if (!token || token.trim() === "") {
    ws.send(JSON.stringify({ type: "error", message: "Token required" }));
    return false;
  }

  const [rows] = await User.getByPhone(phone);
  if (!rows.length) {
    ws.send(JSON.stringify({ type: "error", message: "User not found" }));
    return false;
  }

  if (rows[0].token !== token) {
    ws.send(JSON.stringify({ type: "error", message: "Invalid token" }));
    return false;
  }

  return true;
}

module.exports = {
  validateCredentials,
};
