require("dotenv").config();
const WebSocketController = require("./WebSocketController");
const moment = require("moment");
const crypto = require("crypto");
const sendHttpPost = require("./httpPost");
const {
  generateUniqueId,
  encodeBase64,
  FormatRupiah,
} = require("../Helpers/utils");
const { sendFCM } = require("../Helpers/fcmHelper");
const User = require("../Models/UserModel");
const Topup = require("../Models/TopupModel");

const {
  MIDTRANS_SERVER_KEY,
  MIDTRANS_CLIENT_KEY,
  MIDTRANS_API_URL_QRIS,
  FASPAY_ID,
  FASPAY_USER,
  FASPAY_PASSWORD,
  FASPAY_SERVER,
  PAYMENT_MODE,
  MIDTRANS_DURATION_PAYMENT_EXPIRED,
} = require("./keysController");

module.exports = {
  async Topup(req, res) {
    const tanggal = moment().format("DD/MM/YYYY HH:mm:ss");
    const { pengirim, jlh_topup } = req.body;

    console.log("📩 Data diterima:", req.body);
    console.log("📩 Data diterima phone:", pengirim);

    try {
      // 🔍 1. Cek user
      const [userRows] = await User.getByPhone(pengirim);
      if (!userRows || userRows.length === 0) {
        console.log(`❌ Phone ${pengirim} tidak terdaftar`);
        return res.status(404).json({
          success: false,
          message: `Nomor ${pengirim} tidak terdaftar`,
        });
      }

      const user = userRows[0];
      const _IDUser = user.id;
      const _NoHPUser = user.phone;
      const _NamaUser = user.nama;

      // 🔗 2. Buat QRIS Midtrans
      const response = await CreateLinkPaymentMidtransQRIS(
        generateUniqueId(),
        jlh_topup,
        _NamaUser,
        _NoHPUser
      );

      // 🔍 3. Cek hasil
      if (response.data.status_code === "201") {
        console.log(`✅ [${tanggal}] TOPUP BERHASIL untuk ${_NamaUser}`);

        await Topup.insertTopup(
          pengirim,
          jlh_topup,
          response.data.order_id,
          response.data.payment_type,
          "",
          response.data.transaction_id,
          response.data.actions?.[0]?.url || null,
          response.data.transaction_status,
          response.data.expiry_time,
          ""
        );

        return res.status(200).json({
          success: true,
          message: "Topup QRIS berhasil dibuat",
          data: response,
        });
      } else {
        console.log(`⚠️ TOPUP GAGAL (${response.data.status_message})`);
        return res.status(400).json({
          success: false,
          message: response.data.status_message,
        });
      }
    } catch (error) {
      console.error("💥 Error TopupMidtrans:", error.stack);
      return res.status(500).json({
        success: false,
        message: "Terjadi kesalahan internal server",
        error: error.message,
      });
    }
  },

  async postTopupPayment(req, res) {
    const {
      MIDTRANS_SERVER_KEY,
      MIDTRANS_CLIENT_KEY,
      MIDTRANS_API_URL_QRIS,
    } = require("./keysController");

    console.log(`KEY: ${MIDTRANS_SERVER_KEY}`);
    let pesan;
    try {
      const received = req.body;
      console.log(received);

      const {
        transaction_id,
        order_id,
        status_code,
        gross_amount,
        signature_key,
        settlement_time,
      } = received;

      //console.log("Received from Midtrans:", received);

      const raw_signature =
        order_id + status_code + gross_amount + MIDTRANS_SERVER_KEY;
      const hash = crypto
        .createHash("sha512")
        .update(raw_signature)
        .digest("hex");
      // console.log(`${order_id}\n${status_code}\n${gross_amount}\n${MIDTRANS_SERVER_KEY}`);
      // console.log(hash);
      // console.log(signature_key);

      if (hash === signature_key) {
        const received = req.body;
        console.log("📩 Callback Midtrans diterima:", received);

        if (!order_id || !order_id.startsWith("alfago-")) {
          console.log("Bukan transaksi dari Alfa Go, proses dihentikan");
          return res.status(200).json({
            success: false,
            message: "Bukan transaksi dari Alfa Go, proses dihentikan",
          });
        }

        const status = received.transaction_status;
        const orderId = received.order_id;
        const trxId = received.transaction_id || null;
        const settlementTime = received.settlement_time || null;
        const paymentType = received.payment_type || "qris";
        const issuer = received.issuer;

        

        const [userRows] = await Topup.getTopup(trxId);
        if (!userRows || userRows.length === 0) {
          //    console.log(`❌ Phone ${pengirim} tidak terdaftar`);
          return res.status(404).json({
            success: false,
            //  message: `Nomor ${pengirim} tidak terdaftar`,
          });
        }

        const user = userRows[0];
        const UUID_CUSTOMER = user.uuid_customer;
        const FCMToken = user.fcm_token;

        console.log(`UUID_CUSTOMER: ${UUID_CUSTOMER}`);

        // 🔹 Log setiap event untuk monitoring
        console.log(
          `🔔 Status: ${status} | Order: ${orderId} | Payment: ${paymentType}`
        );

        // 🔸 PENDING
        if (status === "pending") {
          console.log(`🕓 Transaksi ${trxId} masih pending.`);
          await Topup.updatePayment(status, null, null, trxId);
        }

        // 🔸 EXPIRE
        else if (status === "expire") {
          console.log(`⏰ Transaksi ${trxId} sudah expired.`);
          await Topup.updatePayment(status, null, null, trxId);
        }

        // 🔸 CANCEL / DENY
        else if (status === "cancel" || status === "deny") {
          console.log(`❌ Transaksi ${orderId} dibatalkan / ditolak.`);
          await Topup.updatePayment(status, null, null, trxId);
        }

        // 🔸 SETTLEMENT
        else if (status === "settlement") {
          console.log(`✅ Transaksi ${trxId} sukses diselesaikan.`);
          console.log(`${status}, ${settlementTime}, ${issuer}, ${trxId}`);
          //   await Topup.updatePayment(status, settlementTime, issuer, trxId);

          const updateResult = await Topup.updatePayment(
            received.transaction_status,
            received.settlement_time,
            received.issuer,
            received.transaction_id
          );

          console.log(updateResult);

          if (updateResult.success) {
            console.log(
              `✅ Transaksi ${received.transaction_id} berhasil diupdate`
            );
            // WebSocketController.sendToUuid(UUID_CUSTOMER, {
            //   type: "notif",
            //   message: {
            //     title: "Top Up Berhasil",
            //     msg: `Saldo kamu bertambah Rp ${Number(
            //       received.gross_amount
            //     ).toLocaleString("id-ID")}`,
            //   },
            // });

            WebSocketController.sendToUuid(UUID_CUSTOMER, {
              type: "server_message",
              action: "topup_berhasil",
              message: {},
            });

            await sendFCM(
              FCMToken,
              {
                title: `Topup Berhasili`,
                body: `Saldo kamu bertambah Rp ${Number(
                  received.gross_amount
                ).toLocaleString("id-ID")}`,
              },
              {
                order_id: "",
                type: "new_order",
                click_action: "OPEN_ORDER_DETAIL",
              }
            );
          } else {
            console.log(`⚠️ Gagal update transaksi: ${updateResult.message}`);
          }

          //   // 💰 Tambah saldo user secara otomatis
          //   const topupData = await Topup.getByOrderId(orderId);
          //   if (topupData) {
          //     const { user_phone, nominal } = topupData;
          //     await Topup.addSaldoToUser(user_phone, nominal);
          //     console.log(`💵 Saldo user ${user_phone} bertambah Rp ${nominal}`);
          //   }
        }

        // ✅ Respon ke Midtrans WAJIB 200
        res.status(200).json({ message: "OK" });
      } else {
        // return res.status(403).json({ message: "Signature tidak valid!" });
        return res.status(200).json({
          success: false,
          message: "Signature tidak valid!",
        });
      }
    } catch (err) {
      console.error("Notification Handler Error:", err.stack);
      return res.sendStatus(500);
    }
  },

  async getTopupPayment(req, res) {
    const data = req.body;
    return res.status(200).json(data);
  },
};

async function CreateLinkPaymentMidtransQRIS(
  order_id,
  gross_amount,
  Nama,
  phone
) {
  const date = moment().format(`YYYY-MM-DD HH:mm:ss +0700`);
  if (!order_id || !gross_amount) {
    throw new Error("order_id and gross_amount are required");
  }

  const payload = {
    payment_type: "qris",
    transaction_details: {
      order_id,
      gross_amount,
    },
    customer_details: {
      first_name: Nama,
      last_name: "",
      email: "",
      phone: phone,
    },
    custom_expiry: {
      order_time: date,
      expiry_duration: MIDTRANS_DURATION_PAYMENT_EXPIRED,
      unit: "minute",
    },
  };

  try {
    const encodedAuth = encodeBase64(MIDTRANS_SERVER_KEY + ":");
    const response = await sendHttpPost.HttpPost(
      MIDTRANS_API_URL_QRIS,
      payload,
      "application/json",
      `Basic ${encodedAuth}`
    );
    // console.log(response);
    if (response.response_code !== 200) {
      console.error(
        `\nError GetUjian: topupController\nError Code: ${result.response_code}\nError data : ${result.response_data}`
      );
      return;
    }

    const data = response.response_data;
    // console.log(response);
    //const qrUrl = response.data.actions?.find(action => action.name === 'generate-qr-code')?.url;

    //console.log(qrUrl);

    return {
      success: true,
      data,
    };
  } catch (error) {
    console.error(
      "Midtrans QRIS Error:",
      error.response?.data || error.message
    );
    return {
      success: false,
      error: error.response?.data || error.message,
    };
  }
}

async function BatalTopup(_NoHP) {
  const userResult = await userData.getDataTopup(_NoHP, "PENDING");
  const row = userResult.data;
  // console.log(row);
  const _userResult = await userData.getUsers(_NoHP);
  const _row = _userResult.data;
  const KuotaIcon = await CekKuotaIcon.icon(row.kuota);
  if (!row) {
    // console.log(row);
    const _DataUser = `Nama : ${row.nama}\nNo HP : ${row.no_hp.replace(
      /^62/,
      "0"
    )}\nKode Satpas : ${row.kode_satpas}`;
    await sendWA.send(
      row.no_hp,
      "TIDAK ADA TRANSAKSI TOPUP YANG AKAN DI BATALKAN",
      "GAGAL",
      _DataUser,
      row.kuota
    );

    return;
  }

  try {
    await db.query(
      "update log_topup set status_pembayaran= ? where status_pembayaran = ?",
      ["CANCEL", "PENDING"]
    );
    const _DataUser = `Nama : ${row.nama}
No HP : ${row.no_hp.replace(/^62/, "0")}
Kode Satpas : ${row.kode_satpas}
Sisa Token : *${KuotaIcon}*
Metode Bayar : *${row.pembayaran_via}*
Jumlah Topup : *${FormatRupiah(row.jumlah_topup)}*
Batas Waktu : *${moment(row.link_expired_time, "YYYY-MM-DD HH:mm:ss").format(
      "DD/MM/YYYY HH:mm:ss"
    )}*
Link Pembayaran : ${process.env.URL_PAYMENT}${row.order_id}`;

    await sendWA.send(row.no_hp, "", "TOPUP CANCEL", _DataUser);
    return;
  } catch (err) {
    console.error("Error BatalTopup :", err.stack);
    return null;
  }
}
