const admin = require("firebase-admin");
const serviceAccount = require("../Config/firebaseServiceAccount.json");

// ✅ Inisialisasi Firebase Admin
if (!admin.apps.length) {
  admin.initializeApp({
    credential: admin.credential.cert(serviceAccount),
  });
}

async function sendNotification(token, title, body, data = {}) {
  const message = {
    token,
    notification: {
      title,
      body,
    },
    data, // 👈 payload tambahan
  };

  try {
    const response = await admin.messaging().send(message);
    console.log("✅ Notifikasi terkirim:", response);
  } catch (error) {
    console.error("❌ Gagal kirim notifikasi:", error);
  }
}

// ✅ Contoh pemanggilan
const deviceToken = "FCM_DEVICE_TOKEN"; // Token dari Android
sendNotification(
  deviceToken,
  "Order Baru!",
  "Ada pesanan baru dari pelanggan.",
  {
    order_id: "9876",
    type: "new_order",
  }
);
