require('dotenv').config();

const isProduction = process.env.PRODUCTION === "true";

// console.log(`isProduction : ${isProduction}`);

const MIDTRANS_SERVER_KEY = isProduction
    ? process.env.MIDTRANS_SERVER_KEY_PROD
    : process.env.MIDTRANS_SERVER_KEY_DEV;

const MIDTRANS_CLIENT_KEY = isProduction
    ? process.env.MIDTRANS_CLIENT_KEY_PROD
    : process.env.MIDTRANS_CLIENT_KEY_DEV;

const MIDTRANS_API_URL_QRIS = isProduction
    ? process.env.MIDTRANS_API_URL_QRIS_PROD
    : process.env.MIDTRANS_API_URL_QRIS_DEV;

const FASPAY_SERVER = isProduction
    ? process.env.FASPAY_QRIS_URL_PROD
    : process.env.FASPAY_QRIS_URL_DEV;

const FASPAY_ID = process.env.FASPAY_MERCHANT_ID;
const FASPAY_USER = process.env.FASPAY_MERCHANT_USER;
const FASPAY_PASSWORD = isProduction
    ? process.env.FASPAY_MERCHANT_PASSWORD_PROD
    : process.env.FASPAY_MERCHANT_PASSWORD_DEV;

const PAYMENT_MODE = isProduction
    ? 'LIVE'
    : 'SANBOX';

const MIDTRANS_DURATION_PAYMENT_EXPIRED = process.env.MIDTRANS_DURATION_PAYMENT_EXPIRED;

module.exports = {
    MIDTRANS_SERVER_KEY,
    MIDTRANS_CLIENT_KEY,
    MIDTRANS_API_URL_QRIS,
    FASPAY_ID,
    FASPAY_SERVER,
    FASPAY_USER,
    FASPAY_PASSWORD,
    PAYMENT_MODE,
    MIDTRANS_DURATION_PAYMENT_EXPIRED
};