const axios = require('axios');
const axiosRetry = require('axios-retry').default;
const { wrapper } = require('axios-cookiejar-support');
const { CookieJar } = require('tough-cookie');
const qs = require("qs");

axiosRetry(axios, {
    retries: 10, // batasi retry biar tidak infinite loop
    retryDelay: retryCount => Math.min(retryCount * 1000, 30000), // max 30 detik
    retryCondition: (error) => {
        return error.code === 'ECONNABORTED' ||
            error.code === 'ECONNRESET' ||
            error.code === 'ECONNREFUSED' ||
            axiosRetry.isNetworkError(error);
    },
    onRetry: (retryCount, error, requestConfig) => {
        console.warn(`\n🔄 Retrying request to ${requestConfig.url}... attempt #${retryCount}`);
    }
});

// 🥠 fungsi HttpPost
exports.HttpPost = async (url, data, content_type = "application/json", auth = null, cookie = null) => {
    try {
        const jar = new CookieJar();
        const client = wrapper(axios.create({ jar, withCredentials: true }));

       

        const headers = {
            "Content-Type": content_type,
            "Connection": "keep-alive",
            "User-Agent": "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36",
            "Cookie": cookie
        };
        if (auth) headers["Authorization"] = auth;

        const response = await client.post(url, data, {
            headers,
            timeout: 30000
        });

        // Ambil cookies dari jar
        const cookies = await jar.getCookies(url);
        const sessionCookie = cookies.find(c => c.key === "PHPSESSID");

        // console.log("Koki = " + cookies.map(c => `${c.key}=${c.value}`).join("; "));


        return {
            response_data: response.data,
            response_code: response.status,
            cookies: cookies.map(c => `${c.key}=${c.value}`).join("; "), // simpan cookies sebagai array
            session_id: sessionCookie ? sessionCookie.value : null
        };

    } catch (error) {
        return {
            error: error.message,
            response_data: error.response?.data || null,
            response_code: error.response?.status || null,
            cookies: []
        };
    }
};

// 🥠 fungsi HttpGet
exports.HttpGet = async (url, params = {}, accept = "application/json", auth = null, cookie = null) => {
    try {
        const jar = new CookieJar();
        const client = wrapper(axios.create({ jar, withCredentials: true }));

        const headers = {
            "Cookie": cookie,
            "User-Agent":"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/139.0.0.0 Safari/537.36",
            "Host": "vpn.alfateknologi.net:3000",
            "Connection":"keep-alive"
         
        };
        if (auth) headers["Authorization"] = auth;
        if (cookie) headers["Cookie"] = cookie; // kirim session dari login

        // const response = await client.get(url, {
        //     params,
        //     headers,
        //     timeout: 30000
        // });

        const response = await client.get(url, {
            params,
            // 👉 custom serializer manual, ganti spasi jadi %20 bukan +
            paramsSerializer: (p) =>
                Object.keys(p)
                    .map(key => {
                        const value = p[key];
                        return `${encodeURIComponent(key)}=${encodeURIComponent(value)}`;
                    })
                    .join("&"),
            headers,
            timeout: 30000
        });



        // Ambil cookies dari jar
        const cookies = await jar.getCookies(url);
        const sessionCookie = cookies.find(c => c.key === "PHPSESSID");

        return {
            response_data: response.data,
            response_code: response.status,
            cookies: cookies.map(c => `${c.key}=${c.value}`),
            session_id: sessionCookie ? sessionCookie.value : null
        };

    } catch (error) {
        return {
            error: error.message,
            response_data: error.response?.data || null,
            response_code: error.response?.status || null,
            cookies: []
        };
    }
};

