const orderEvents = require("../Events/orderEvents");

const WebSocketController = require("./WebSocketController");
const Order = require("../Models/OrderModel");
const User = require("../Models/UserModel");

let rejectedDrivers = new Set(); // gunakan Set biar cepat

let orderID = null;
let action = null;
let customer_phone = null;
let customer_name = null;
let pickup = null;
let destination = null;
let pickup_lat = null;
let pickup_lng = null;
let dst_lat = null;
let dst_lng = null;
let distance = null;
let duration = null;
let price = null;

module.exports = {
  // POST /api/push
  async OrderNew0(req, res) {
    const data = req.body;
    console.log(data);

    if (!data) {
      return res
        .status(400)
        .json({ success: false, message: "Message is required" });
    }

    action = data.order_type;
    customer_phone = data.customer_phone;
    customer_name = data.customer_name;
    pickup = data.pickup;
    destination = data.destination;
    pickup_lat = data.pickup_lat;
    pickup_lng = data.pickup_lng;
    dst_lat = data.dst_lat;
    dst_lng = data.dst_lng;
    distance = data.distance;
    duration = data.duration;
    price = data.price;

    orderID = await Order.generateOrderId(action);
    await Order.insertOrder(
      orderID,
      action,
      customer_phone,
      customer_name,
      null,
      pickup,
      destination,
      pickup_lat,
      pickup_lng,
      dst_lat,
      dst_lng,
      distance,
      duration,
      price,
      ""
    );

    // findDriverLoop();

    return res.json({ success: true, message: "Pesan diterima" });
  },
  async OrderNew(req, res) {
    console.log("WEBSOCKET");
    const data = req.body;
    const restaurantID = data.restaurant_id;
    console.log("Request body:", data);

    if (!data) {
      return res
        .status(400)
        .json({ success: false, message: "Message is required" });
    }

    const [userResult] = await User.getByRestaurantID(restaurantID);
    const user = userResult[0];

    UUIDRestaurant = user.uuid;

    console.log("UUID RESTO:", UUIDRestaurant); // cara benar
    // console.log("User result:", JSON.stringify(user, null, 2)); // cara rapi

    WebSocketController.sendToUuid(UUIDRestaurant, {
      type: "server_message",
      action: "food_order_new",
      message: {},
    });

    return res.json({ success: true, message: "Pesan diterima" });
  },
};

async function findDriverLoop() {
  // 🔄 SIMPAN STATUS ORDER
  let accepted = false;
  let startTime = Date.now();
  let driverList = []; // untuk menyimpan semua driver di radius 2km

  const [userRows] = await User.getByPhone(customer_phone);
  if (userRows && userRows.length > 0) {
    UUIDCustomer = userRows[0].uuid;
  }
  console.log(UUIDCustomer);

  if (accepted) return;

  // ⏱️ cek timeout 1 menit
  if (Date.now() - startTime > 30000) {
    // if (Date.now() - startTime > 300000) {
    console.log(
      "⏱️ Tidak ada driver yang terima dalam 5 menit. Order dibatalkan."
    );
    await Order.cancelOrder(orderID);
    ws.send(
      JSON.stringify({ type: "order_status", status: "cancelled", orderID })
    );
    module.exports.sendToUuid(UUIDCustomer, {
      type: "notif",
      message: {
        title: "Alfa Ride",
        msg: `Driver tidak ada di daerah anda. Pesanan anda di batalkan oleh system`,
      },
    });
    module.exports.sendToUuid(UUIDCustomer, {
      type: "reload",
    });
    return;
  }

  const nearby = await Order.nearbyDriver(customer_phone, action, 2000);

  if (!nearby || nearby.length === 0) {
    console.log("❌ Tidak ada driver dalam radius 2 km. Mencoba lagi...");
    setTimeout(findDriverLoop, 5000);
    return;
  }

  // 🔎 Cek apakah semua driver sudah pernah menolak
  const availableDrivers = nearby.filter((d) => !rejectedDrivers.has(d.phone));

  if (availableDrivers.length === 0) {
    console.log(
      "🔁 Semua driver sudah pernah menolak. Reset daftar penolakan..."
    );
    rejectedDrivers.clear(); // ✅ Reset agar bisa dikirim lagi ke semua driver
  }

  // 🔁 Kirim ke setiap driver yang belum menolak (setelah reset jika perlu)
  for (const driver of nearby) {
    if (accepted) break;
    if (rejectedDrivers.has(driver.phone)) {
      console.log(
        `⏭️ Skip driver ${driver.phone} karena sudah menolak sebelumnya.`
      );
      continue;
    }

    driverPhone = driver.phone;
    UUIDDriver = driver.uuid;
    driverName = driver.nama;

    console.log(`🚀 Mengirim order ke driver ${driver.phone}`);

    WebSocketController.sendToUuid(UUIDDriver, {
      type: "order",
      message: {
        orderID,
        type: "ride",
        action: "new",
        customer_name: customer_name,
        customer_phone: customer_phone,
        driverPhone: driverPhone,
        pickup: pickup,
        destination: destination,
        price: price,
        distance: distance,
        duration: duration,
        pickup_lat: pickup_lat,
        pickup_lng: pickup_lng,
        dst_lat: dst_lat,
        dst_lng: dst_lng,
      },
    });

    await Order.accepttOrder(driver.phone, orderID, "new");

    WebSocketController.sendToUuid(UUIDDriver, {
      type: "notif",
      message: {
        title: "Alfa Ride",
        msg: `Pesanan ride baru dari ${customer_name}`,
      },
    });

    await new Promise((resolve) => {
      let responded = false;
      // 🧹 Bersihkan listener lama untuk driver ini
      orderEvents.removeAllListeners(`reject_${orderID}_${driver.phone}`);
      orderEvents.removeAllListeners(`accept_${orderID}_${driver.phone}`);

      orderEvents.once(`reject_${orderID}_${driver.phone}`, async () => {
        await Order.accepttOrder(driver.phone, "", "0");

        console.log(`❌ Driver ${driver.phone} menolak order.`);
        rejectedDrivers.add(driver.phone); // ✅ Simpan driver yang menolak
        responded = true;
        resolve();
      });

      orderEvents.once(`accept_${orderID}_${driver.phone}`, async () => {
        console.log(`✅ Driver ${driver.phone} menerima order!`);
        accepted = true;
        responded = true;
        await Order.accepttOrder(driver.phone, orderID, "driver_to_customer");

        const [userRows] = await User.getByPhone(customer_phone);
        const [userRowsDriver] = await User.getByPhone(driver.phone);

        // console.log(`payload.driverLat : ${payload.driverLat}`)

        driverName = userRowsDriver[0].nama;
        driverTipeKendaraan = userRowsDriver[0].driver_tipe_kendaraan;
        driverNoPol = userRowsDriver[0].driver_no_pol;
        driverLat = userRowsDriver[0].loc_lat;
        driverLng = userRowsDriver[0].loc_lng;
        customerLat = userRows[0].loc_lat;
        customerLng = userRows[0].loc_lng;
        // UUIDCustomer = userRows[0].uuid;

        // module.exports.sendToUuid(UUIDCustomer, {
        //     type: "order",
        //     message: {
        //         orderID,
        //         type: "ride",
        //         action: "accept",
        //         driverName: driverName,
        //         driverTipeKendaraan: driverTipeKendaraan,
        //         driverNoPol: driverNoPol,
        //         driverLat: driverLat,
        //         driverLng: driverLng,
        //         customerLat: customerLat,
        //         customerLng: customerLng,
        //         dst_lat: dst_lat,
        //         dst_lng: dst_lng
        //     },
        // });

        WebSocketController.sendToUuid(UUIDCustomer, {
          type: "notif",
          message: {
            title: "Alfa Ride",
            msg: `Driver dengan nomor polisi ${driverNoPol} menuju ke lokasi kamu`,
          },
        });

        WebSocketController.sendToUuid(UUIDCustomer, {
          type: "server_message",
          message: {
            type: "ride_accept",
            message: {
              orderID,
              driverName: driverName,
              driverTipeKendaraan: driverTipeKendaraan,
              driverNoPol: driverNoPol,
              driverLat: driverLat,
              driverLng: driverLng,
              customerLat: customerLat,
              customerLng: customerLng,
              dst_lat: dst_lat,
              dst_lng: dst_lng,
              pickup: pickup,
              destination: destination,
              price: price,
            },
          },
        });

        resolve();
      });

      setTimeout(() => {
        if (!responded) {
          console.log(`⌛ Driver ${driver.phone} tidak merespons.`);
          rejectedDrivers.add(driver.phone); // ✅ Timeout = dianggap menolak
          resolve();
        }
      }, 15000);
    });
  }

  // 🔁 Jika belum ada yang terima → coba lagi
  if (!accepted) {
    console.log("🔄 Tidak ada driver yang menerima, mencoba lagi...");
    setTimeout(findDriverLoop, 3000);
  }
}
