require("dotenv").config();

const WebSocketController = require("./WebSocketController");

// Ambil IP whitelist dari ENV
const allowedIPs = process.env.PUSH_ALLOWED_IPS.split(",").map((ip) =>
  ip.trim()
);

module.exports = {
  async pushMessage(req, res) {
    const ip =
      req.headers["x-forwarded-for"]?.split(",")[0].trim() ||
      req.socket.remoteAddress;

    const normalizedIp = ip.replace("::ffff:", "");

    console.log(`normalizedIp: ${normalizedIp}`);

    if (!allowedIPs.includes(normalizedIp)) {
      return res.status(200).json({
        success: false,
        message: "Access denied",
      });
    }

    // === logic lama kamu ===
    const { uuid, message } = req.body;
    console.log(`message: ${message.action}`);

    if (!message) {
      return res
        .status(400)
        .json({ success: false, message: "Message is required" });
    }

    if (uuid) {
      const sent = WebSocketController.sendToUuid(uuid, {
        type: "server_message",
        message,
      });
      if (!sent) {
        return res.status(404).json({
          success: false,
          message: "UUID not found or offline",
        });
      }
      return res.json({ success: true });
    } else {
      WebSocketController.sendToAll({
        type: "server_broadcast",
        message,
      });
      return res.json({ success: true });
    }
  },
};
