const { invokeFindDriverLoop } = require("../Services/FindDriverService");

module.exports = {
  async start(req, res) {
    const params = req.body;
    // console.log(params);
    if (!params.order_id) {
      return res.status(400).json({
        success: false,
        message: "orderID is required",
      });
    }

    const ok = invokeFindDriverLoop(params);
    console.log(`ok: ${ok}`);
    if (!ok) {
      return res.status(500).json({
        success: false,
        message: "findDriverLoop not available",
      });
    }

    return res.json({
      success: true,
      message: "Driver search started",
      orderID: params.order_id,
    });
  },
};
