const User = require("../Models/UserModel");
const crypto = require("crypto");

module.exports = {
  // GET /api/users
  async getUsers(req, res) {
    try {
      const [rows] = await User.getAll();
      res.json({ success: true, data: rows });
    } catch (err) {
      console.error(err);
      res.status(500).json({ success: false, message: "Server error" });
    }
  },

  // GET /api/users/:phone
  async getUserByPhone(req, res) {
    try {
      const phone = req.params.phone;
      const [rows] = await User.getByPhone(phone);
      if (rows.length === 0) {
        return res
          .status(404)
          .json({ success: false, message: "User not found" });
      }
      res.json({ success: true, data: rows[0] });
    } catch (err) {
      console.error(err);
      res.status(500).json({ success: false, message: "Server error" });
    }
  },

  // GET /api/users/:phone

  async updateLocation(req, res) {
    console.log(req.body);
    try {
      const { phone, lat, lng } = req.body;

      if (!phone || lat == null || lng == null) {
        return res
          .status(400)
          .json({ success: false, message: "phone, lat, lng wajib diisi" });
      }

      const user = await user.getUserByPhone(phone);
      if (!user) {
        return res
          .status(404)
          .json({ success: false, message: "User tidak ditemukan" });
      }

      await user.updateLocation(phone, lat, lng);
      return res.json({ success: true, message: "Lokasi berhasil diperbarui" });
    } catch (err) {
      console.error("Update lokasi error:", err);
      return res.status(500).json({ success: false, message: "Server error" });
    }
  },


};
