const mysql = require('mysql2/promise');
const dotenv = require('dotenv');
const path = require('path');

dotenv.config({ path: path.join(__dirname, '../../../.env') });

const db = mysql.createPool({
    host: process.env['database.default.hostname'],
    user: process.env['database.default.username'],
    password: process.env['database.default.password'],
    database: process.env['database.default.database'],
    port: process.env['database.default.port'] || 3306,
    charset: 'utf8mb4' // ✅ penting agar emoji tidak error
});

db.getConnection()
    .then(() => console.log('✅ Database connected!'))
    .catch(err => {
        console.error('❌ Database error:', err.message);
        process.exit(1);
    });

module.exports = db;