const nominalInput = document.getElementById("nominal");
async function prosesTopup() {
  showLoading();
  // Format otomatis ke Rupiah

  const nominal = getNominalNumber(nominalInput);
  if (!nominal || nominal < 10000) {
    showModal("info", "Informasi", "Minimal top up Rp 10.000");
    return;
  }

  try {
    const hasil = await kirimTopup(phone, nominal);
    console.log("📦 Data hasil:", hasil);

    if (hasil.success) {
      hideLoading();

      const data = hasil.data.data;

      // Animasi transisi ke QRIS
      document.getElementById("form-screen").classList.add("hidden");
      const qrisScreen = document.getElementById("qris-screen");
      setTimeout(() => qrisScreen.classList.remove("hidden"), 300);

      const options = { width: 300, margin: 1 };

      // menghasilkan data URL (base64 PNG)
      const dataUrl = await QRCode.toDataURL(data.qr_string, options);

      // set sebagai src image
      document.getElementById("qrisImage").src = dataUrl;

      //   document.getElementById("qrisImage").src = data.actions?.[0]?.url || null;
      document.getElementById("qrisAmount").textContent =
        "Rp " + Number(nominal).toLocaleString("id-ID");

      startCountdown(600); // 10 menit
    } else {
    }
  } catch (err) {
    console.error("💥 Terjadi error:", err);
  }

  //   kirimTopup(phone, nominal);
}

function backToForm() {
  document.getElementById("qris-screen").classList.add("hidden");
  setTimeout(() => {
    document.getElementById("form-screen").classList.remove("hidden");
  }, 300);
}

function startCountdown(seconds) {
  const countdown = document.getElementById("countdown");
  let remaining = seconds;

  const timer = setInterval(() => {
    const min = Math.floor(remaining / 60);
    const sec = remaining % 60;
    countdown.textContent = `Berlaku selama ${min}:${sec
      .toString()
      .padStart(2, "0")} menit`;
    remaining--;
    if (remaining < 0) {
      clearInterval(timer);
      countdown.textContent = "⏰ QRIS sudah kedaluwarsa";
    }
  }, 1000);
}

nominalInput.addEventListener("input", function (e) {
  // Hapus semua karakter non-digit
  let value = e.target.value.replace(/\D/g, "");

  // Cegah nilai lebih dari 12 digit (bisa ubah sesuai kebutuhan)
  if (value.length > 12) value = value.slice(0, 12);

  // Format ke Rupiah
  e.target.value = formatRupiah(value);
});

window.addEventListener("msgFromServer", function (e) {
  const data = e.detail;
  const msgType = data.action;
  const msg = data.message;

  if (msgType == "cek_data") {
    phone = msg.user.phone;
    role = msg.user.role;
  } else if (msgType == "topup_berhasil") {
    if (role == "driver") {
      window.location.href = "/driver";
    } else if (role == "customer" || role == "restaurant") {
      window.location.href = `/profile`;
    }
  }
});
  const backBtn = document.getElementById("backToMenu");
  backBtn.addEventListener("click", () => {
      window.history.back();
  });