// const User = require('../Models/UserModel');
// const User = require('../wss-server/app/Models/UserModel');

const baseUrl = document.querySelector('meta[name="base-url"]').content;

let longPressTimer = null;

document.addEventListener("contextmenu", function (e) {
    if (
        !(e.target instanceof HTMLInputElement) &&
        !(e.target instanceof HTMLTextAreaElement) &&
        e.target.getAttribute("contenteditable") !== "true"
    ) {
        e.preventDefault();
    }
});

document.addEventListener("selectstart", function (e) {
    if (
        !(e.target instanceof HTMLInputElement) &&
        !(e.target instanceof HTMLTextAreaElement) &&
        e.target.getAttribute("contenteditable") !== "true"
    ) {
        e.preventDefault(); // ✅ blokir select
    }
});

document.addEventListener("touchstart", function (e) {
    if (
        !(e.target instanceof HTMLInputElement) &&
        !(e.target instanceof HTMLTextAreaElement) &&
        e.target.getAttribute("contenteditable") !== "true"
    ) {
        longPressTimer = setTimeout(() => {
            e.preventDefault(); // ✅ blokir long-press
        }, 500);
    }
});



function showFullscreenNotif(status, message) {
    let title = "";
    switch (status) {
        case "success":
            icon = `<i class="fas fa-check-circle text-success"></i>`;
            title = "✅ Sukses";
            break;
        case "error":
            icon = `<i class="fas fa-times-circle text-danger"></i>`;
            title = "❌ Error";
            break;
        case "warning":
            icon = `<i class="fas fa-exclamation-triangle text-warning"></i>`;
            title = "⚠️ Peringatan";
            break;
        default:
            icon = `<i class="fas fa-info-circle text-primary"></i>`;
            title = "ℹ️ Info";
    }

    const notif = document.getElementById("fullscreenNotif");
    notif.querySelector("h2").textContent = title;
    notif.querySelector("p").textContent = message;

    notif.classList.add("show");

    // Auto close 4 detik
    setTimeout(() => {
        notif.classList.remove("show");
    }, 3000);
}

async function loadPage(url) {
    hideLoading();
    try {
        const res = await fetch(url);
        if (!res.ok) throw new Error(`HTTP ${res.status}`);
        const html = await res.text();
        document.getElementById('page-container').innerHTML = html;
        window.history.pushState({}, '', url); // opsional update URL

    } catch (err) {
        NotifAndroidApp('Gagal load halaman : ', err);
    }
}

const urlSendMessage = "https://alfago.alfateknologi.net:3755/api/push";


const tokenAPI = "@AlfaGoSuperSecretKey123!";
const urlAPI = "https://alfago.alfateknologi.net:3755/"


let activeInput = null; // menyimpan input mana yang terakhir dipilih (awal / akhir)
// Pastikan variabel map global
let statusOrderRide = null;rideToggle
let centerMarker;

 // simpan timer biar tidak numpuk




const divMaps = document.getElementById("map");


const rideToggle = document.getElementById("rideToggle");
const rideFood = document.getElementById("foodToggle");
const driverCount = document.getElementById("driverCount");















window.reload = async function () {
    location.reload();
};

window.AndroidApp.getUserData = async function (token, phone, role) {
    alert(phone);
};
// ✅ Minta Android reconnect WebSocket
if (window.AndroidApp && AndroidApp.reconnectWebSocketFromJS) {
    // AndroidApp.reconnectWebSocketFromJS();
}

// window.order = function (message) {
//     console.log('Pesan diterima:', message);
//     // alert(JSON.stringify(message)); // tampilkan isi object
//     // atau akses langsung
//     alert(message.pickup);
// };


// window.WSS = async function (wss) {
//     if (!wss) {
//         // alert(wss);
//     }
// };
// getUserData('08123456789', 'abc123tokenxyz');
async function getUserData(phone, token) {
    try {
        const response = await fetch('/get-user', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded'
            },
            body: new URLSearchParams({
                phone: phone,
                token: token
            })
        });

        const result = await response.json();
        if (result.success) {
            console.log('✅ Data user:', result.data);
        } else {
            console.warn('⚠️ Gagal:', result.message);
        }
    } catch (err) {
        console.error('❌ Error ambil data user:', err);
    }
}


// Fungsi manual untuk non-driver
function requestManualLocation() {
    if (Latitude && Longitude) {
        getCurrentLocation();
    } else {
        window.AndroidApp.showNotif("Lokasi belum tersedia dari device");
    }
}




async function getCurrentLocation0() {
    try {
        const getLocation = await getCurrentLocationFetchOnly();
        const status = getLocation.status;

        if (status === "OK" && getLocation.results.length > 0) {
            const fullAddress = getLocation.results[0].formatted_address;

            // Ambil bagian pertama sebelum koma
            const shortAddress = fullAddress.split(",")[0];

            if (locationText) {
                locationText.textContent = shortAddress;
            }

            if (inputAwal) {
                inputAwal.value = shortAddress;
                // startMarker.setPosition(center);
            }
        } else {
            if (locationText)
                locationText.textContent = `Lat: ${Latitude}, Lon: ${Longitude}`;
        }
    } catch (err) {
        console.error("Error geocoding:", err);
        if (locationText)
            locationText.textContent = `Lat: ${Latitude}, Lon: ${Longitude}`;
    }
}
// === Tambahkan variabel global di atas ===
let lastGetNamaTempatCall = 0; // timestamp terakhir pemanggilan getNamaTempat()


// Fungsi nunggu lokasi pertama kali
function waitForLocation() {
    return new Promise((resolve) => {
        if (Latitude && Longitude) {
            // sudah ada -> langsung balikin
            resolve({ lat: Latitude, lng: Longitude });
        } else {
            // override sementara receiveLocation
            const originalReceive = window.receiveLocation;
            window.receiveLocation = function (lat, lng) {
                Latitude = lat;
                Longitude = lng;

                // kembalikan fungsi asli kalau ada
                if (originalReceive) originalReceive(lat, lng);

                resolve({ lat, lng });
            };
        }
    });
}




// const center = { lat: -6.175392, lng: 106.827153 };


async function initMap_ok1() {
    if (map) {
        NotifAndroidApp("✅ Map sudah pernah di-inisialisasi");
        return; // tidak perlu init ulang
    }

    activeInput = "lokasi_awal";

    const { Map } = await google.maps.importLibrary("maps");

    let center;
    if (Longitude == null || Latitude == null) {
        center = { lat: -6.175392, lng: 106.827153 };
    } else {
        center = { lat: Latitude, lng: Longitude };
    }

    map = new Map(divMaps, {
        center: center,
        zoom: 15,
        disableDefaultUI: true,
        zoomControl: false,
        streetViewControl: false,
        fullscreenControl: false,
        mapTypeControl: false,
        rotateControl: false,
        scaleControl: false,
        clickableIcons: false
    });

    const interval = setInterval(() => {
        if (map) {
            clearInterval(interval);
            // getCurrentLocation();
            getNamaTempat();
            // NotifAndroidApp("⚠️ Map Ready");
        }



        directionsService = new google.maps.DirectionsService();
        directionsRenderer = new google.maps.DirectionsRenderer({
            map,
            suppressMarkers: true // Mencegah marker otomatis dari DirectionsRenderer
        });

        autocompleteAwal = new google.maps.places.Autocomplete(inputAwal);
        autocompleteAkhir = new google.maps.places.Autocomplete(inputAkhir);

        autocompleteAwal.setFields(["name", "formatted_address", "geometry"]);
        autocompleteAkhir.setFields(["name", "formatted_address", "geometry"]);



        // const userPos = { lat: Latitude, lng: Longitude };
        const circle = new google.maps.Circle({
            center: userPos,
            radius: 5000
        });

        if (autocompleteAwal) autocompleteAwal.setBounds(circle.getBounds());
        if (autocompleteAkhir) autocompleteAkhir.setBounds(circle.getBounds());

        if (startMarker) startMarker.setMap(null);
        startMarker = new google.maps.Marker({
            position: userPos, map, icon: {
                url: IconMarker(activeInput),
                scaledSize: new google.maps.Size(40, 40)
            }
        });

        if (inputAwal) {
            startMarker.placeName = inputAwal.value;
        }

        // map.setCenter(userPos);
        calculateRoute();




        autocompleteAwal.addListener("place_changed", () => {
            autocompleteAwalFungsi();
            activeInput = null;
        });



        autocompleteAkhir.addListener("place_changed", () => {
            autocompleteAkhirFungsi();
            activeInput = null;
        });

        // NotifAndroidApp("✅ Map pertama kali dibuat");
    }, 500); // cek setiap 0.5 detik
}
async function initMapok() {

    if (map) {
        NotifAndroidApp("✅ Map sudah pernah di-inisialisasi");
        return; // tidak perlu init ulang
    }
    activeInput = "lokasi_awal";
    NotifAndroidApp("initMap");

    const { Map } = await google.maps.importLibrary("maps");

    let center;
    if (Longitude == null || Latitude == null) {
        center = { lat: -6.175392, lng: 106.827153 };
    } else {
        center = { lat: Latitude, lng: Longitude };
    }

    map = new Map(divMaps, {
        center: center,
        zoom: 15,
        disableDefaultUI: true,
        zoomControl: false,
        streetViewControl: false,
        fullscreenControl: false,
        mapTypeControl: false,
        rotateControl: false,
        scaleControl: false,
        clickableIcons: false
    });

    // // return;
    // if (map) {
    //     getCurrentLocation();
    //     NotifAndroidApp("⚠️ Map Ready");     
    //     // alert("⚠️ Map Ready"); 
    // }

    const interval = setInterval(() => {
        if (map) {
            clearInterval(interval);
            getCurrentLocation();

            NotifAndroidApp("⚠️ Map Ready");
        }
    }, 500); // cek setiap 0.5 detik


    // Icon custom start (misal bendera hijau)
    startIcon = {
        url: IconMarker("lokasi_awal"), // ganti URL dengan icon kamu
        scaledSize: new google.maps.Size(40, 40), // ukuran icon
        anchor: new google.maps.Point(20, 40) // titik anchor di bawah icon
    };

    // Icon custom finish (misal bendera merah)
    finishIcon = {
        url: IconMarker("lokasi_akhir"), // ganti URL dengan icon kamu
        scaledSize: new google.maps.Size(40, 40),
        anchor: new google.maps.Point(20, 40)
    };

    directionsService = new google.maps.DirectionsService();
    directionsRenderer = new google.maps.DirectionsRenderer({
        map,
        suppressMarkers: true // Mencegah marker otomatis dari DirectionsRenderer
    });

    autocompleteAwal = new google.maps.places.Autocomplete(inputAwal);
    autocompleteAkhir = new google.maps.places.Autocomplete(inputAkhir);

    autocompleteAwal.setFields(["name", "formatted_address", "geometry"]);
    autocompleteAkhir.setFields(["name", "formatted_address", "geometry"]);



    // const userPos = { lat: Latitude, lng: Longitude };
    const circle = new google.maps.Circle({
        center: userPos,
        radius: 5000
    });

    if (autocompleteAwal) autocompleteAwal.setBounds(circle.getBounds());
    if (autocompleteAkhir) autocompleteAkhir.setBounds(circle.getBounds());

    if (startMarker) startMarker.setMap(null);
    startMarker = new google.maps.Marker({
        position: userPos, map, icon: {
            url: IconMarker(activeInput),
            scaledSize: new google.maps.Size(40, 40)
        }
    });

    if (inputAwal) {
        startMarker.placeName = inputAwal.value;
    }

    map.setCenter(userPos);
    calculateRoute();




    autocompleteAwal.addListener("place_changed", () => {
        autocompleteAwalFungsi();
        activeInput = null;
    });



    autocompleteAkhir.addListener("place_changed", () => {
        autocompleteAkhirFungsi();
        activeInput = null;
    });
}
async function initMap9() {
    // const divMaps = document.getElementById("map");
    if (!divMaps) return; // jika halaman ini tidak punya map, hentikan

    if (window.AndroidApp) {
        const mapReady = window.AndroidApp.isMapReady(); // cek dari Android SharedPref
        NotifAndroidApp("Map ready:", mapReady);

        if (!mapReady) {
            NotifAndroidApp("🔄 Map belum siap — jalankan initMap");

            const center = { lat: -6.175392, lng: 106.827153 };

            map = new google.maps.Map(divMaps, {
                center: center,
                zoom: 15,
                disableDefaultUI: true,
                zoomControl: false,
                streetViewControl: false,
                fullscreenControl: false,
                mapTypeControl: false,
                rotateControl: false,
                scaleControl: false,
                clickableIcons: false
            });

            window.AndroidApp.setMapReady(true); // simpan status map sudah ready
        } else {
            NotifAndroidApp("✅ Map sudah ready — tidak perlu load ulang");
        }
    } else {
        NotifAndroidApp("⚠️ AndroidApp tidak ditemukan");
    }
}
// Fungsi ini hanya dipanggil jika script Google Maps belum pernah di-load
function loadGoogleMaps0() {

    // NotifAndroidApp("📡 Memuat Google Maps API...");
    // const script = document.createElement('script');
    // script.src =
    //     "https://maps.googleapis.com/maps/api/js?key=AIzaSyDsFlGo6S8RGU7JV72iBMolPzrJNKgfk-M&loading=async&callback=initMap&libraries=places";
    // script.async = true;
    // script.defer = true;
    // document.head.appendChild(script);


    if (!window.AndroidApp || !window.AndroidApp.isMapReady || !window.AndroidApp.isMapReady()) {
        NotifAndroidApp("📡 Memuat Google Maps API...");
        const script = document.createElement('script');
        script.src =
            "https://maps.googleapis.com/maps/api/js?key=AIzaSyDsFlGo6S8RGU7JV72iBMolPzrJNKgfk-M&loading=async&callback=initMap&libraries=places";
        script.async = true;
        script.defer = true;
        document.head.appendChild(script);
        window.AndroidApp.setMapReady(true);
    } else {
        NotifAndroidApp("✅ Map sudah ready — tidak load ulang script");
        // initMap(); // pastikan map diaktifkan kembali jika script sudah ada
        getCurrentLocation();
    }
}

function loadGoogleMapsok() {
    // NotifAndroidApp("📡 Memuat Google Maps API...");
    const script = document.createElement('script');
    script.src =
        "https://maps.googleapis.com/maps/api/js?key=AIzaSyDsFlGo6S8RGU7JV72iBMolPzrJNKgfk-M&loading=async&callback=initMap&libraries=places,geometry";
    script.async = true;
    script.defer = true;
    document.head.appendChild(script);
    // window.AndroidApp.setMapReady(true);  


}
// Jalankan saat halaman pertama kali load

document.addEventListener("DOMContentLoaded", function () {
    if (divMaps) {
        // loadGoogleMaps();
    }
});






async function initMap0() {
    window.AndroidApp.showNotif("init");
    activeInput = "lokasi_awal";
    if (divMaps) {
        async function initMap0() {
            window.AndroidApp.showNotif("init");
            activeInput = "lokasi_awal";
            if (divMaps) {
                const center = { lat: -6.175392, lng: 106.827153 };

                map = new google.maps.Map(divMaps, {
                    center: center,
                    zoom: 15,
                    disableDefaultUI: true,
                    zoomControl: false,
                    streetViewControl: false,
                    fullscreenControl: false,
                    mapTypeControl: false,
                    rotateControl: false,
                    scaleControl: false,
                    clickableIcons: false
                });


                // 🔑 Tunggu sampai lokasi pertama kali ada
                const userPos = await waitForLocation();

                // Icon custom start (misal bendera hijau)
                const startIcon = {
                    url: IconMarker("lokasi_awal"), // ganti URL dengan icon kamu
                    scaledSize: new google.maps.Size(40, 40), // ukuran icon
                    anchor: new google.maps.Point(20, 40) // titik anchor di bawah icon
                };

                // Icon custom finish (misal bendera merah)
                const finishIcon = {
                    url: IconMarker("lokasi_akhir"), // ganti URL dengan icon kamu
                    scaledSize: new google.maps.Size(40, 40),
                    anchor: new google.maps.Point(20, 40)
                };

                directionsService = new google.maps.DirectionsService();
                directionsRenderer = new google.maps.DirectionsRenderer({
                    map,
                    suppressMarkers: true // Mencegah marker otomatis dari DirectionsRenderer
                });

                const inputAwal = document.getElementById("lokasi_awal");
                const inputAkhir = document.getElementById("lokasi_akhir");

                autocompleteAwal = new google.maps.places.Autocomplete(inputAwal);
                autocompleteAkhir = new google.maps.places.Autocomplete(inputAkhir);

                autocompleteAwal.setFields(["name", "formatted_address", "geometry"]);
                autocompleteAkhir.setFields(["name", "formatted_address", "geometry"]);

                try {
                    const getLocation = await getCurrentLocationFetchOnly();
                    const status = getLocation.status;

                    // window.AndroidApp.showNotif(`Status: ${status}`);

                    if (status === "OK" && getLocation.results.length > 0) {


                        // const userPos = { lat: Latitude, lng: Longitude };
                        const circle = new google.maps.Circle({
                            center: userPos,
                            radius: 5000
                        });

                        if (autocompleteAwal) autocompleteAwal.setBounds(circle.getBounds());
                        if (autocompleteAkhir) autocompleteAkhir.setBounds(circle.getBounds());


                        if (startMarker) startMarker.setMap(null);
                        startMarker = new google.maps.Marker({
                            position: userPos, map, icon: {
                                url: IconMarker(activeInput),
                                scaledSize: new google.maps.Size(40, 40)
                            }
                        });
                        startMarker.placeName = inputAwal.value;
                        map.setCenter(userPos);
                        calculateRoute();
                    }
                } catch (err) {
                    window.AndroidApp.showNotif("Error ambil lokasi:", err);
                    // window.AndroidApp.showNotif("Gagal ambil lokasi");
                }

                inputAwal.addEventListener("focus", () => {

                    activeInput = "lokasi_awal";
                    // Hapus marker lama
                    if (startMarker) {
                        startMarker.setMap(null);
                        startMarker = null;
                    }

                    routeCard.style.display = "none"; // pastikan card tampil
                    if (directionsRenderer) {
                        directionsRenderer.setMap(null); // Menghapus garis rute
                    }

                    // alert("Input Awal Focus");
                    if (inputAwal !== "") {
                        inputAwal.value = ""; // kosongkan input
                    }
                });

                inputAkhir.addEventListener("focus", () => {
                    if (inputAkhir !== "") {
                        inputAkhir.value = ""; // kosongkan input
                    }
                    activeInput = "lokasi_akhir";

                    // Hapus marker lama
                    if (endMarker) {
                        endMarker.setMap(null);
                        endMarker = null;
                    }


                    routeCard.style.display = "none"; // pastikan card tampil
                    if (directionsRenderer) {
                        directionsRenderer.setMap(null); // Menghapus garis rute
                    }
                });


                autocompleteAwal.addListener("place_changed", () => {
                    autocompleteAwalFungsi();
                    activeInput = null;
                });

                function autocompleteAwalFungsi() {
                    const place = autocompleteAwal.getPlace();
                    if (!place.geometry) return;

                    // Pilih nama tempat (lebih singkat) atau alamat kalau tidak ada nama
                    const displayName = place.name || place.formatted_address;
                    // window.AndroidApp.showNotif(displayName);

                    // Set langsung ke input agar tampil nama tempat, bukan alamat panjang
                    document.getElementById("lokasi_awal").value = displayName;


                    // 🔥 Hapus marker user location kalau ada
                    if (userMarker) {
                        userMarker.setMap(null);
                        userMarker = null;
                    }


                    // Hapus marker lama
                    if (startMarker) {
                        startMarker.setMap(null);
                        startMarker = null;
                    }

                    // Membuat marker start
                    startMarker = new google.maps.Marker({
                        position: place.geometry.location,
                        map,
                        icon: startIcon
                    });

                    // Simpan nama tempat di marker untuk ditampilkan di info rute
                    startMarker.placeName = displayName;

                    map.setCenter(place.geometry.location);
                    calculateRoute();
                }


                autocompleteAkhir.addListener("place_changed", () => {
                    autocompleteAkhirFungsi();
                    activeInput = null;
                });

                function autocompleteAkhirFungsi() {
                    // window.AndroidApp.showNotif("autocompleteAkhirFungsi");
                    const place = autocompleteAkhir.getPlace();
                    if (!place.geometry) return;

                    // Pilih nama tempat (lebih singkat) atau alamat kalau tidak ada nama
                    const displayName = place.name || place.formatted_address;
                    // window.AndroidApp.showNotif(displayName);

                    // Set langsung ke input agar tampil nama tempat, bukan alamat panjang
                    inputAkhir.value = displayName;


                    // 🔥 Hapus marker user location kalau ada
                    if (userMarker) {
                        userMarker.setMap(null);
                        userMarker = null;
                    }


                    // Hapus marker lama
                    if (endMarker) {
                        endMarker.setMap(null);
                        endMarker = null;
                    }

                    // Membuat marker start
                    endMarker = new google.maps.Marker({
                        position: place.geometry.location,
                        map,
                        icon: finishIcon
                    });

                    // Simpan nama tempat di marker untuk ditampilkan di info rute
                    endMarker.placeName = displayName;

                    map.setCenter(place.geometry.location);
                    calculateRoute();
                }



                inputAwalClose.addEventListener("click", () => {
                    inputAwal.value = "";
                    inputAwal.focus();


                    // 🔥 Hapus marker user location kalau ada
                    if (userMarker) {
                        userMarker.setMap(null);
                        userMarker = null;
                    }


                    // Hapus marker lama
                    if (startMarker) {
                        startMarker.setMap(null);
                        startMarker = null;
                    }

                    if (directionsRenderer) {
                        directionsRenderer.setMap(null); // Menghapus garis rute
                    }
                });

                inputAkhirClose.addEventListener("click", () => {
                    inputAkhir.value = "";
                    inputAkhir.focus();


                    // 🔥 Hapus marker user location kalau ada
                    if (userMarker) {
                        userMarker.setMap(null);
                        userMarker = null;
                    }


                    // Hapus marker lama
                    if (endMarker) {
                        endMarker.setMap(null);
                        endMarker = null;
                    }


                    routeCard.style.display = "none"; // pastikan card tampil
                    if (directionsRenderer) {
                        directionsRenderer.setMap(null); // Menghapus garis rute
                    }
                });
            }
        }

        // 🔑 Tunggu sampai lokasi pertama kali ada
        const userPos = await waitForLocation();

        // Icon custom start (misal bendera hijau)
        const startIcon = {
            url: IconMarker("lokasi_awal"), // ganti URL dengan icon kamu
            scaledSize: new google.maps.Size(40, 40), // ukuran icon
            anchor: new google.maps.Point(20, 40) // titik anchor di bawah icon
        };

        // Icon custom finish (misal bendera merah)
        const finishIcon = {
            url: IconMarker("lokasi_akhir"), // ganti URL dengan icon kamu
            scaledSize: new google.maps.Size(40, 40),
            anchor: new google.maps.Point(20, 40)
        };

        directionsService = new google.maps.DirectionsService();
        directionsRenderer = new google.maps.DirectionsRenderer({
            map,
            suppressMarkers: true // Mencegah marker otomatis dari DirectionsRenderer
        });

        const inputAwal = document.getElementById("lokasi_awal");
        const inputAkhir = document.getElementById("lokasi_akhir");

        autocompleteAwal = new google.maps.places.Autocomplete(inputAwal);
        autocompleteAkhir = new google.maps.places.Autocomplete(inputAkhir);

        autocompleteAwal.setFields(["name", "formatted_address", "geometry"]);
        autocompleteAkhir.setFields(["name", "formatted_address", "geometry"]);

        try {
            const getLocation = await getCurrentLocationFetchOnly();
            const status = getLocation.status;

            // window.AndroidApp.showNotif(`Status: ${status}`);

            if (status === "OK" && getLocation.results.length > 0) {


                // const userPos = { lat: Latitude, lng: Longitude };
                const circle = new google.maps.Circle({
                    center: userPos,
                    radius: 5000
                });

                if (autocompleteAwal) autocompleteAwal.setBounds(circle.getBounds());
                if (autocompleteAkhir) autocompleteAkhir.setBounds(circle.getBounds());


                if (startMarker) startMarker.setMap(null);
                startMarker = new google.maps.Marker({
                    position: userPos, map, icon: {
                        url: IconMarker(activeInput),
                        scaledSize: new google.maps.Size(40, 40)
                    }
                });
                startMarker.placeName = inputAwal.value;
                map.setCenter(userPos);
                calculateRoute();
            }
        } catch (err) {
            window.AndroidApp.showNotif("Error ambil lokasi:", err);
            // window.AndroidApp.showNotif("Gagal ambil lokasi");
        }

        inputAwal.addEventListener("focus", () => {

            activeInput = "lokasi_awal";
            // Hapus marker lama
            if (startMarker) {
                startMarker.setMap(null);
                startMarker = null;
            }

            routeCard.style.display = "none"; // pastikan card tampil
            if (directionsRenderer) {
                directionsRenderer.setMap(null); // Menghapus garis rute
            }

            // alert("Input Awal Focus");
            if (inputAwal !== "") {
                inputAwal.value = ""; // kosongkan input
            }
        });

        inputAkhir.addEventListener("focus", () => {
            if (inputAkhir !== "") {
                inputAkhir.value = ""; // kosongkan input
            }
            activeInput = "lokasi_akhir";

            // Hapus marker lama
            if (endMarker) {
                endMarker.setMap(null);
                endMarker = null;
            }


            routeCard.style.display = "none"; // pastikan card tampil
            if (directionsRenderer) {
                directionsRenderer.setMap(null); // Menghapus garis rute
            }
        });


        autocompleteAwal.addListener("place_changed", () => {
            autocompleteAwalFungsi();
            activeInput = null;
        });

        function autocompleteAwalFungsi() {
            const place = autocompleteAwal.getPlace();
            if (!place.geometry) return;

            // Pilih nama tempat (lebih singkat) atau alamat kalau tidak ada nama
            const displayName = place.name || place.formatted_address;
            // window.AndroidApp.showNotif(displayName);

            // Set langsung ke input agar tampil nama tempat, bukan alamat panjang
            document.getElementById("lokasi_awal").value = displayName;


            // 🔥 Hapus marker user location kalau ada
            if (userMarker) {
                userMarker.setMap(null);
                userMarker = null;
            }


            // Hapus marker lama
            if (startMarker) {
                startMarker.setMap(null);
                startMarker = null;
            }

            // Membuat marker start
            startMarker = new google.maps.Marker({
                position: place.geometry.location,
                map,
                icon: startIcon
            });

            // Simpan nama tempat di marker untuk ditampilkan di info rute
            startMarker.placeName = displayName;

            map.setCenter(place.geometry.location);
            calculateRoute();
        }


        autocompleteAkhir.addListener("place_changed", () => {
            autocompleteAkhirFungsi();
            activeInput = null;
        });

        function autocompleteAkhirFungsi() {
            // window.AndroidApp.showNotif("autocompleteAkhirFungsi");
            const place = autocompleteAkhir.getPlace();
            if (!place.geometry) return;

            // Pilih nama tempat (lebih singkat) atau alamat kalau tidak ada nama
            const displayName = place.name || place.formatted_address;
            // window.AndroidApp.showNotif(displayName);

            // Set langsung ke input agar tampil nama tempat, bukan alamat panjang
            inputAkhir.value = displayName;


            // 🔥 Hapus marker user location kalau ada
            if (userMarker) {
                userMarker.setMap(null);
                userMarker = null;
            }


            // Hapus marker lama
            if (endMarker) {
                endMarker.setMap(null);
                endMarker = null;
            }

            // Membuat marker start
            endMarker = new google.maps.Marker({
                position: place.geometry.location,
                map,
                icon: finishIcon
            });

            // Simpan nama tempat di marker untuk ditampilkan di info rute
            endMarker.placeName = displayName;

            map.setCenter(place.geometry.location);
            calculateRoute();
        }

        const inputAwalClose = document.getElementById("btnCloseAwal");
        const inputAkhirClose = document.getElementById("btnCloseAkhir");
        const routeCard = document.getElementById("route-card");

        inputAwalClose.addEventListener("click", () => {
            inputAwal.value = "";
            inputAwal.focus();


            // 🔥 Hapus marker user location kalau ada
            if (userMarker) {
                userMarker.setMap(null);
                userMarker = null;
            }


            // Hapus marker lama
            if (startMarker) {
                startMarker.setMap(null);
                startMarker = null;
            }

            if (directionsRenderer) {
                directionsRenderer.setMap(null); // Menghapus garis rute
            }
        });

        inputAkhirClose.addEventListener("click", () => {
            inputAkhir.value = "";
            inputAkhir.focus();


            // 🔥 Hapus marker user location kalau ada
            if (userMarker) {
                userMarker.setMap(null);
                userMarker = null;
            }


            // Hapus marker lama
            if (endMarker) {
                endMarker.setMap(null);
                endMarker = null;
            }


            routeCard.style.display = "none"; // pastikan card tampil
            if (directionsRenderer) {
                directionsRenderer.setMap(null); // Menghapus garis rute
            }
        });
    }
}

function updateRouteInfo(startMarker, endMarker, route, durationText, biaya, biayaAplikasi, totalBiaya) {
    if (startText) {
        startText.textContent = startMarker.placeName || route.start_address;
    }
    if (endText) {
        endText.textContent = endMarker.placeName || route.end_address;
    }
    if (distance) {
        distance.textContent = route.distance.text;
    }

    if (duration) {
        duration.textContent = durationText;
    }
    if (biaya) {
        biaya.textContent = biaya.toLocaleString();
    }
    if (biayaAplikasi) {
        biayaAplikasi.textContent = biayaAplikasi.toLocaleString();
    }

    if (biayaTotal) {
        biayaTotal.textContent = "Rp " + totalBiaya.toLocaleString("id-ID");
    }




    // document.getElementById('start-text').textContent = startMarker.placeName || route.start_address;
    // document.getElementById('end-text').textContent = endMarker.placeName || route.end_address;
    // document.getElementById('distance-text').textContent = route.distance.text;
    // document.getElementById('duration-text').textContent = durationText;
    // document.getElementById('biaya-text').textContent = biaya.toLocaleString();
    // document.getElementById('biaya-aplikasi-text').textContent = biayaAplikasi.toLocaleString();
    // document.getElementById('total-text').textContent = totalBiaya.toLocaleString();
}

function calculateRoute() {
    if (!startMarker || !endMarker) return;

    directionsService.route(
        {
            origin: startMarker.getPosition(),
            destination: endMarker.getPosition(),
            travelMode: google.maps.TravelMode.DRIVING
        },
        (result, status) => {

            if (status === "OK") {
                directionsRenderer.setDirections(result);
                const route = result.routes[0].legs[0];

                const routeCard = document.getElementById("route-card");

                // 🔥 Atur zoom otomatis agar seluruh rute terlihat
                const bounds = new google.maps.LatLngBounds();
                bounds.extend(startMarker.getPosition());
                bounds.extend(endMarker.getPosition());
                map.fitBounds(bounds);


                const pos_pickup = startMarker.getPosition(); // LatLng object
                pickupLat = pos_pickup.lat();
                pickupLng = pos_pickup.lng();


                const pos_dst = endMarker.getPosition(); // LatLng object
                dstLat = pos_dst.lat();
                dstLng = pos_dst.lng();


                // Contoh biaya
                // const biayaPerKm = 5000; // ongkos per km (Rp)
                // const biayaAplikasi = 2000; // biaya aplikasi tetap (Rp)
                jarakKm = route.distance.value / 1000; // jarak dalam km

                // const totalBiaya = Math.round(biayaPerKm * jarakKm + biayaAplikasi);





                // Ganti kata
                durationText = route.duration.text.replace(/\bhours?\b/, "jam").replace(/\bmins?\b/, "menit");



                if (eta_text) {
                    eta_text.textContent = `Driver tiba dalam ${durationText}`
                }




                const jarak = route.distance.text;

                const biaya = hitungOngkos(jarakKm)
                // alert(biaya);
                const biayaAplikasi = 1000;
                totalBiaya = biaya + biayaAplikasi;
                // console.log(route.duration.text);
                // Update card info rute + tombol order full-width
                // panggil fungsi setelah data route didapat
                updateRouteInfo(startMarker, endMarker, route, durationText, biaya, biayaAplikasi, totalBiaya);



                // Event klik tombol order



                routeCard.style.display = "block"; // pastikan card tampil
                resizeMapHeight();
                // Menampilkan kembali rute
                if (directionsRenderer) {
                    directionsRenderer.setMap(map);
                }
            } else {
                document.getElementById("route-info").innerHTML =
                    `Gagal menghitung rute: ${status}`;
                routeCard.style.display = "block";
            }
        }
    );
}



// ✅ Tangkap error runtime JS

/**
 * Tampilkan modal dengan ikon dan pilihan OK/Batal
 * @param {"Info"|"Success"|"Warning"|"Error"} type
 * @param {string} title
 * @param {string} message
 * @param {function|null} onOk - callback jika klik OK
 * @param {boolean} showCancel - tampilkan tombol Batal
 */

// Untuk konfirmasi logout
// ✅ Konfirmasi logout




// Update data driver dari API atau dari AndroidApp
function updateDriverDashboard(balance, completed) {
    const driverBalance = document.getElementById("driverBalance");
    const orderCompleted = document.getElementById("orderCompleted");

    driverBalance && (driverBalance.textContent = `Rp ${(balance || 0).toLocaleString()}`);
    orderCompleted && (orderCompleted.textContent = completed);



}


// Contoh update saldo & order
// updateDriverDashboard(150000, 24);


if (driverCount) {
    // Contoh data jumlah driver di sekitar lokasi user
    let driverNearby = 0;

    // Fungsi untuk update floating
    function updateDriverCount(count) {
        driverCount.textContent = `${count} Driver`;
        if (driverCount) {

        }
    }

    // Contoh simulasi data dari server setiap 5 detik
    function fetchDriverNearby() {
        // Ganti ini dengan AJAX/Fetch API ke server kamu
        // Misalnya GET /api/driver-nearby?lat=xxx&lng=xxx
        driverNearby = Math.floor(Math.random() * 10); // simulasi 0–9 driver
        updateDriverCount(driverNearby);
    }



    // Jalankan setiap 5 detik untuk refresh jumlah driver
    fetchDriverNearby();
    setInterval(fetchDriverNearby, 5000);
}


window.order = function (message) {

    if (userRole === "driver") {
        // alert("ODER BARU DI WEBVIEW");
        try {
            const data = (typeof message === 'string') ? JSON.parse(message) : message;

            // Simpan data order sementara sebelum redirect
            sessionStorage.setItem("pendingOrder", JSON.stringify(data));

            // Jika bukan di /driver, redirect
            if (window.location.pathname !== "/driver") {
                window.location.href = "/driver";
            } else {
                // Jika sudah di /driver langsung jalankan
                showOrder(data);
            }
        } catch (e) {
            console.error('Pesan order tidak valid', e);
        }
    }
};





// ALFA RIDE //

const chatDriverBtn = document.getElementById('chat-driver-btn');

if (chatDriverBtn) {
    document.getElementById('chat-driver-btn').addEventListener('click', function (e) {
        e.preventDefault();
        const phone = "6281361442662"; // nomor driver
        const message = "";
        if (window.AndroidApp && window.AndroidApp.openWhatsApp) {
            window.AndroidApp.openWhatsApp(phone, message);
        } else {
            // fallback kalau dibuka di browser biasa
            window.location.href = `https://wa.me/${phone}?text=${encodeURIComponent(message)}`;
        }
    });
}



// =============================
// DRIVER
// =============================
