const baseUrl = document
  .querySelector('meta[name="base-url"]')
  .getAttribute("content");

const divMaps = document.getElementById("map");
let userRole = null;
let Latitude = null;
let Longitude = null;
let userData = null;
let token = null;
let phone = null;
let autoCenterEnabled = true;
window.StatusBarHeight = 0; // nilai default

let isFirstUpdate = true; // supaya non-driver cuma update sekali

let userName,
  map,
  userMarker,
  startMarker,
  endMarker,
  directionsService,
  directionsRenderer,
  autocompleteAwal,
  autocompleteAkhir,
  finishIcon,
  startIcon,
  DriverRide,
  DriverFood,
  userPos,
  pickupLat,
  pickupLng,
  dstLat,
  dstLng,
  driverLat,
  driverLng,
  pickupLatLng,
  driverLatLng,
  dstLatLng,
  jarakKm,
  durationText,
  totalBiaya,
  tmpMarker,
  driverMarker,
  statusOrderRide;

const locationText = document.getElementById("current-location");
const btnCenterMaps = document.getElementById("center-btn");
const navRole = document.getElementsByClassName("nav-role");

/**
 * Tampilkan modal dengan ikon dan pilihan OK/Batal
 * @param {"Info"|"Success"|"Warning"|"Error"} type
 * @param {string} title
 * @param {string} message
 * @param {function|null} onOk - callback jika klik OK
 * @param {boolean} showCancel - tampilkan tombol Batal
 */
function showModal(
  type = "Info",
  title = "Info",
  message = "",
  onOk = null,
  showCancel = false
) {
  hideLoading();
  const modal = document.getElementById("appModal");
  const modalIcon = document.getElementById("modalIcon");
  const modalTitle = document.getElementById("modalTitle");
  const modalMessage = document.getElementById("modalMessage");
  const btnOk = document.getElementById("modalOk");
  const btnCancel = document.getElementById("modalCancel");

  // reset icon
  modalIcon.className = "modal-icon";
  let iconHtml = "";
  switch (type) {
    case "Success":
      iconHtml = '<i class="fa-solid fa-check-circle"></i>';
      modalIcon.classList.add("success");
      break;
    case "Warning":
      iconHtml = '<i class="fa-solid fa-exclamation-triangle"></i>';
      modalIcon.classList.add("warning");
      break;
    case "Error":
      iconHtml = '<i class="fa-solid fa-times-circle"></i>';
      modalIcon.classList.add("error");
      break;
    default:
      iconHtml = '<i class="fa-solid fa-info-circle"></i>';
      modalIcon.classList.add("info");
  }
  modalIcon.innerHTML = iconHtml;

  modalTitle.textContent = title;
  modalMessage.textContent = message;

  // tampilkan / sembunyikan tombol Cancel
  btnCancel.style.display = showCancel ? "inline-block" : "none";

  // action tombol
  btnOk.onclick = () => {
    modal.classList.remove("show");
    if (onOk) onOk();
  };
  btnCancel.onclick = () => {
    modal.classList.remove("show");
  };

  modal.classList.add("show");
}
function showLoading(text = "Loading...") {
  const overlay = document.getElementById("globalLoading");
  if (!overlay) return;
  overlay.querySelector("p").textContent = text;
  overlay.style.display = "flex";
}
function hideLoading() {
  const overlay = document.getElementById("globalLoading");
  if (!overlay) return;
  overlay.style.display = "none";
}
function loadGoogleMaps() {
  // Cegah script dimuat dua kali
  if (document.getElementById("google-maps-script")) return;

  const script = document.createElement("script");
  script.id = "google-maps-script";
  script.src =
    "https://maps.googleapis.com/maps/api/js?key=AIzaSyAKXm381luA88ObHU63Drsk65P1zK3K5hg&loading=async&callback=initMap&libraries=places,geometry&language=id&region=ID";
  script.async = true;
  script.defer = true;
  document.head.appendChild(script);
}
async function initMap() {
  let center;
  if (Longitude == null || Latitude == null) {
    center = { lat: -6.175392, lng: 106.827153 };
  } else {
    center = { lat: Latitude, lng: Longitude };
  }
  const { Map } = await google.maps.importLibrary("maps");

  if (divMaps) {
    map = new Map(divMaps, {
      center: center,
      zoom: 15,
      disableDefaultUI: true,
      zoomControl: false,
      streetViewControl: false,
      fullscreenControl: false,
      mapTypeControl: false,
      rotateControl: false,
      scaleControl: false,
      clickableIcons: false,
    });

    directionsService = new google.maps.DirectionsService();
    directionsRenderer = new google.maps.DirectionsRenderer({
      map,
      suppressMarkers: true, // Mencegah marker otomatis dari DirectionsRenderer
    });

    resizeMapHeight();
  }
}
function resizeMapHeight() {
  const bottomNav = document.getElementById("bottom-nav");
  const routeCard = document.getElementById("route-card");
  const searchBar = document.getElementById("search-bar");
  const orderCard = document.getElementById("order-card");

  const bottomNavHeight = bottomNav ? bottomNav.offsetHeight : 0;
  const routeCardHeight = routeCard ? routeCard.offsetHeight : 0;
  const searchBarHeight = searchBar ? searchBar.offsetHeight : 0;
  const orderCardHeight = orderCard ? orderCard.offsetHeight : 0;

  const orderCardHeight1 = orderCardHeight - 5;
  const searchBarHeight1 = searchBarHeight + 5;

  // searchBarHeight = searchBarHeight - 10;

  // const searchBarHeight = 300;

  // ✅ Total tinggi yang harus dikurangi dari bawah
  let totalReduce = null;

  let newHeight = null;
  if (userRole == "driver") {
    // ✅ Hitung tinggi baru map
    newHeight =
      window.innerHeight - routeCardHeight - searchBarHeight - orderCardHeight1;
  } else {
    // ✅ Hitung tinggi baru map
    newHeight = window.innerHeight - routeCardHeight - searchBarHeight;
  }

  // Terapkan ke elemen map
  const mapEl = document.getElementById("map");
  if (mapEl) {
    mapEl.style.height = `${newHeight}px`;
    mapEl.style.marginTop = `${searchBarHeight}px`; // ✅ Tambahkan margin-top sesuai tinggi search bar
  }

  // ✅ Trigger Google Maps agar re-render
  if (typeof google !== "undefined" && map) {
    google.maps.event.trigger(map, "resize");
  }
}
function waitUntilMapReady(callback, interval = 300, maxWait = 10000) {
  const startTime = Date.now();

  const check = () => {
    const mapsReady = typeof google !== "undefined" && google.maps; // cukup cek SDK Google Maps

    if (mapsReady) {
      console.log("✅ Google Maps SDK siap");
      callback();
    } else if (Date.now() - startTime < maxWait) {
      console.log("⏳ Menunggu Google Maps siap...");
      setTimeout(check, interval);
    } else {
      console.error(
        "❌ Timeout: Google Maps tidak siap setelah " +
          maxWait +
          "ms, lanjut tanpa Maps."
      );
      callback(); // fallback agar proses tidak macet
    }
  };

  check();
}

function NotifAndroidApp(notif) {
  try {
    window.AndroidApp.showNotif(notif);
  } catch (error) {}
}
// ✅ Menggunakan Geocoder bawaan Maps JS API
async function getCurrentLocationFetchOnly() {
  return new Promise((resolve, reject) => {
    console.log(Latitude, Longitude);
    if (!Latitude || !Longitude) {
      reject("Lokasi belum tersedia");
      return;
    }

    const geocoder = new google.maps.Geocoder();
    const latlng = { lat: parseFloat(Latitude), lng: parseFloat(Longitude) };

    geocoder.geocode({ location: latlng }, (results, status) => {
      if (status === "OK") {
        resolve({
          status: "OK",
          results: results,
        });
      } else {
        reject(status);
      }
    });
  });
}
async function getCurrentLocation() {
  // loadGoogleMaps();
  // NotifAndroidApp(`Lng : ${Longitude}, Lat : ${Latitude}`);

  // initMap();

  // return;
  if (!map) {
    // NotifAndroidApp("⚠️ Map belum siap, tunda setCenter");
    return;
  }
  map.setCenter({ lat: Latitude, lng: Longitude });
  map.zoom = 15;
  // alert("54");
  // return;

  // calculateRoute();

  // getNamaTempat();

  // ✅ Cek waktu terakhir pemanggilan getNamaTempat
  const now = Date.now(); // waktu sekarang dalam ms
  let lastGetNamaTempatCall = 0; // timestamp terakhir pemanggilan getNamaTempat()
  // alert(lastGetNamaTempatCall); // timestamp terakhir pemanggilan getNamaTempat()

  // ✅ Cek waktu terakhir pemanggilan getNamaTempat
  // const now = Date.now();

  if (lastGetNamaTempatCall === 0 || now - lastGetNamaTempatCall > 5000) {
    // 🔥 Pertama kali (lastGetNamaTempatCall masih 0) ATAU sudah lebih dari 5 detik
    getNamaTempat();
    lastGetNamaTempatCall = now; // update waktu terakhir pemanggilan
  }

  lastGetNamaTempatCall = now; // simpan waktu terakhir
  driverLatLng = new google.maps.LatLng(Latitude, Longitude);

  if (userRole == "driver") {
    if (startMarker) startMarker.setMap(null);
    startMarker = new google.maps.Marker({
      position: driverLatLng,
      map,
      icon: {
        path: google.maps.SymbolPath.FORWARD_CLOSED_ARROW,
        scale: 5,
        fillColor: "#1565C0",
        fillOpacity: 1,
        strokeWeight: 1,
        rotation: 0,
        anchor: new google.maps.Point(0, 2.5),
      },
    });
  } else {
    if (activeInput === "lokasi_awal") {
      if (startMarker) startMarker.setMap(null);
      startMarker = new google.maps.Marker({
        position: { lat: Latitude, lng: Longitude },
        map,
        icon: {
          url: IconMarker("lokasi_awal"),
          scaledSize: new google.maps.Size(40, 40),
        },
      });
    } else if (activeInput === "lokasi_akhir") {
      if (endMarker) endMarker.setMap(null);
      endMarker = new google.maps.Marker({
        position: { lat: Latitude, lng: Longitude },
        map,
        icon: {
          url: IconMarker("lokasi_akhir"),
          scaledSize: new google.maps.Size(40, 40),
        },
      });
    }
  }
}
if (window.AndroidApp) {
  const jsonString = AndroidApp.getUserData();
  const user = JSON.parse(jsonString);

  // Kirim badge ke native Android

  // console.log("✅ Data dari Android:");
  // console.log("Token:", user.token);
  // console.log("Phone:", user.phone);
  // console.log("Role:", user.role);
  phone = user.phone;
  token = user.token;
  userRole = user.role;

  if (userRole === "driver") {
    // Tampilkan menu driver (kalau sempat disembunyikan sebelumnya)
    document.querySelectorAll('a[href="/driver"]').forEach((el) => {
      el.style.display = "flex"; // atau "block", sesuai layout CSS kamu
    });

    // Sembunyikan menu non-driver
    document
      .querySelectorAll(
        'a[href="/alfafood"], a[href="/alfaride"], a[href="/order"]'
      )
      .forEach((el) => {
        el.style.display = "none";
      });
  } else {
    // Sembunyikan menu driver
    document.querySelectorAll('a[href="/driver"]').forEach((el) => {
      el.style.display = "none";
    });

    // Pastikan menu lain muncul
    document
      .querySelectorAll(
        'a[href="/alfafood"], a[href="/alfaride"], a[href="/order"]'
      )
      .forEach((el) => {
        el.style.display = "flex"; // atau "block"
      });
  }

  const loc = window.AndroidApp.getLocation();
  // NotifAndroidApp("Lokasi dari Android:", loc);
  if (loc && loc.includes("|")) {
    [Latitude, Longitude] = loc.split("|").map(Number);
    userPos = { lat: Latitude, lng: Longitude };
  }

  window.AndroidApp.requestLocation();
  // window.AndroidApp.getUserData();
  // if (cekWSS()) {
  //   window.AndroidApp.sendMessageToServerFromWebview("cek_data", "", "");
  // }

  // contoh penggunaan langsung ke API backend
  // fetch("/get-user", {
  //   method: "POST",
  //   headers: { "Content-Type": "application/x-www-form-urlencoded" },
  //   body: new URLSearchParams({
  //     phone: user.phone,
  //     token: user.token,
  //   }),
  // })
  //   .then((res) => res.json())
  //   .then((result) => console.log("User dari server:", result))
  //   .catch((err) => console.error("Error:", err));
}

function cekWSS() {
  let wss = false;
  if (window.AndroidApp) {
    wss = window.AndroidApp.isWssConnected();
  }
  return wss;
}
function tungguWssTersambung(callback, interval = 1000) {
  if (window.AndroidApp & (phone != "")) {
    const timer = setInterval(() => {
      try {
        const status = window.AndroidApp.isWssConnected();
        console.log("🔍 Status WSS:", status);

        if (status === true) {
          clearInterval(timer);
          console.log("✅ WSS sudah tersambung!");
          if (typeof callback === "function") callback();
        }
      } catch (err) {
        console.error("❌ Error saat cek koneksi:", err);
      }
    }, interval);
  }
}

function calcRoute0(startPosition, endPosition) {
  // if (!cekWSS()) {
  //     console.log("CalcRoute gagal");
  //     return;
  // }

  // alert(`startPosition: ${startPosition}, endPosition: ${endPosition} `);
  return new Promise((resolve, reject) => {
    directionsService.route(
      {
        origin: startPosition,
        destination: endPosition,
        travelMode: google.maps.TravelMode.DRIVING,
      },
      (result, status) => {
        if (status === "OK") {
          directionsRenderer.setDirections(result);
          const route = result.routes[0].legs[0];

          const waktu = route.duration.text
            .replace(/\bhours?\b/, "jam")
            .replace(/\bmins?\b/, "menit");

          durationText = waktu;

          let distanceM = route.distance.value.toFixed(1);
          let distanceKm = (route.distance.value / 1000).toFixed(1);

          if (directionsRenderer) {
            directionsRenderer.setMap(map);
          }

          resizeMapHeight();
          // ✅ Kembalikan data
          resolve({ durationText, distanceM, distanceKm });
        } else {
          reject("Gagal menghitung rute: " + status);
        }
      }
    );
  });
}
function calcRoute(startPosition, endPosition) {
  return new Promise((resolve, reject) => {
    // Jika directionsService belum dibuat, buat minimal versi dasar
    if (typeof directionsService === "undefined") {
      directionsService = new google.maps.DirectionsService();
    }

    directionsService.route(
      {
        origin: startPosition,
        destination: endPosition,
        travelMode: google.maps.TravelMode.DRIVING,
      },
      (result, status) => {
        if (status === "OK") {
          // ⛔ Aman: hanya jalankan ini jika renderer dan map ada
          if (
            typeof directionsRenderer !== "undefined" &&
            typeof map !== "undefined"
          ) {
            directionsRenderer.setDirections(result);
            directionsRenderer.setMap(map);
          }

          const route = result.routes[0].legs[0];

          const waktu = route.duration.text
            .replace(/\bhours?\b/, "jam")
            .replace(/\bmins?\b/, "menit");

          const distanceM = route.distance.value.toFixed(1);
          const distanceKm = (route.distance.value / 1000).toFixed(1);

          resolve({ durationText: waktu, distanceM, distanceKm });
        } else {
          reject("Gagal menghitung rute: " + status);
        }
      }
    );
  });
}

function calcRoute2(startPosition, endPosition) {
  return new Promise((resolve, reject) => {
    if (!map) {
      reject("Map belum siap");
      return;
    }

    // 🔥 Pastikan service hanya 1x dibuat
    if (!directionsService) {
      directionsService = new google.maps.DirectionsService();
    }

    // 🔥 Reset renderer lama (INI PENTING)
    if (directionsRenderer) {
      directionsRenderer.setMap(null);
    }

    directionsRenderer = new google.maps.DirectionsRenderer({
      suppressMarkers: true,
      preserveViewport: false,
      polylineOptions: {
        strokeColor: "#1565C0",
        strokeWeight: 5,
        strokeOpacity: 0.9,
      },
    });

    // 🔥 BIND MAP DULU
    directionsRenderer.setMap(map);

    directionsService.route(
      {
        origin: startPosition,
        destination: endPosition,
        travelMode: google.maps.TravelMode.DRIVING,
      },
      (result, status) => {
        if (status !== "OK" || !result.routes?.length) {
          reject("Gagal menghitung rute: " + status);
          return;
        }

        directionsRenderer.setDirections(result);

        // 🔥 Paksa viewport ke rute
        const bounds = new google.maps.LatLngBounds();
        result.routes[0].overview_path.forEach((p) => bounds.extend(p));
        map.fitBounds(bounds);

        const leg = result.routes[0].legs[0];

        const waktu = leg.duration.text
          .replace(/\bhours?\b/, "jam")
          .replace(/\bmins?\b/, "menit");

        const distanceM = leg.distance.value;
        const distanceKm = (distanceM / 1000).toFixed(1);

        resolve({ durationText: waktu, distanceM, distanceKm });
      }
    );
  });
}

if (btnCenterMaps) {
  btnCenterMaps.addEventListener("click", () => {
    if (map) {
      map.setCenter({ lat: Latitude, lng: Longitude });
      map.zoom = 15;
      // getCurrentLocation();
    }
  });
}
document.querySelectorAll(".sidebar-url").forEach((link) => {
  link.addEventListener("click", (e) => {
    showLoading("Loading...");
  });
});
function logout() {
  showModal(
    "Warning",
    "Konfirmasi Logout",
    "Apakah Anda yakin ingin keluar?",
    () => {
      showLoading();

      fetch("/logout", { method: "POST" })
        .then(() => {
          // Logout berhasil
          if (window.AndroidApp) {
            window.AndroidApp.saveRole("", "");
          }

          window.location.href = "/login";
        })
        .catch(() => {
          // Tampilkan modal error
          hideLoading(); // pastikan loading hilang jika error

          showModal(
            "Error",
            "Gagal Logout",
            "Terjadi kesalahan saat memproses logout. Silakan coba lagi.",
            null, // tidak ada action lanjut
            false // sembunyikan tombol Cancel
          );
        });
    },
    true
  );
}

window.onerror = function (message, source, lineno, colno, error) {
  const msg = `❌ JS Error: ${message} @${source}:${lineno}:${colno}`;
  if (window.AndroidApp) {
    NotifAndroidApp(msg);
  } else {
    NotifAndroidApp(msg, error);
  }
  return false; // tetap biarkan error muncul di console
};
// ✅ Tangkap Promise rejection tanpa catch
window.addEventListener("unhandledrejection", function (event) {
  const msg = `⚠️ Promise Error: ${event.reason}`;
  if (window.AndroidApp) {
    NotifAndroidApp(msg);
  } else {
    NotifAndroidApp(msg);
  }
});

// window.addEventListener('error', function (e) {
//   if (e.message && e.message.includes('parentNode')) {
//     console.warn('⚠️ Debugbar Kint error diabaikan:', e.message);
//     e.stopImmediatePropagation();
//   }
// });

// =============================
// 🚗 SMOOTH DRIVER MOVEMENT + AUTO ROUTE UPDATE
// =============================

// let driverMarker = null;
let lastDriverPosition = null;
let routeDrawn = false;
let isAnimating = false;
let lastRouteUpdate = 0; // waktu terakhir rute diupdate
const ROUTE_UPDATE_INTERVAL = 1000; // 10 detik sekali

function updateDriverLocation(driverLat, driverLng) {
  const newPos = new google.maps.LatLng(driverLat, driverLng);
  if (endMarker) endMarker.setMap(null);
  // Marker pertama kali dibuat
  if (!driverMarker) {
    driverMarker = new google.maps.Marker({
      position: newPos,
      map: map,
      icon: {
        path: google.maps.SymbolPath.FORWARD_CLOSED_ARROW,
        scale: 5,
        fillColor: "#1565C0",
        fillOpacity: 1,
        strokeWeight: 1,
        rotation: 0,
        anchor: new google.maps.Point(0, 2.5),
      },
      title: "📍 Lokasi Driver",
    });

    lastDriverPosition = newPos;
    updateRouteFirstThenMove(newPos);
    return;
  }

  // Marker sudah ada → animasikan dan update rute sesuai interval
  updateRouteFirstThenMove(newPos);
}

// ✅ Update rute jika waktunya sudah lewat (misal tiap 10 detik)
function updateRouteFirstThenMove(newPos) {
  if (userRole == "driver") {
    // alert("CC")
    autoCenterEnabled = false; // 🔒 Saat rute aktif, hentikan auto-center
  }

  let destination = null;
  if (statusOrderRide === "ride_accept") {
    destination = pickupLatLng;
  } else if (statusOrderRide === "with_customer") {
    destination = dstLatLng;
  }

  if (!destination) return;

  const now = Date.now();

  // Gambar rute pertama kali atau setiap 10 detik
  if (!routeDrawn || now - lastRouteUpdate > ROUTE_UPDATE_INTERVAL) {
    lastRouteUpdate = now;
    directionsService.route(
      {
        origin: newPos,
        destination: destination,
        travelMode: google.maps.TravelMode.DRIVING,
      },
      (result, status) => {
        if (status === "OK") {
          directionsRenderer.setDirections(result);
          routeDrawn = true;
          console.log("🗺️ Rute diperbarui @", new Date().toLocaleTimeString());

          const route = result.routes[0].legs[0];

          const waktu = route.duration.text
            .replace(/\bhours?\b/, "jam")
            .replace(/\bmins?\b/, "menit");

          let durationText = waktu;

          let distanceM = route.distance.value.toFixed(1);
          let distanceKm = (route.distance.value / 1000).toFixed(1);

          console.log(
            `durationText: ${durationText}, distanceKm: ${distanceKm}`
          );

          const eta_text = document.getElementById("eta-text");
          if (eta_text) {
            if (statusOrderRide === "ride_accept") {
              eta_text.textContent = `Driver tiba dalam ${durationText}`;
            } else if (statusOrderRide === "with_customer") {
              eta_text.textContent = `Tiba di tujuan dalam ${durationText}`;
            }
          }

          const distanceTextEl = document.getElementById(
            "distance-to-customer"
          );
          if (distanceTextEl) {
            distanceTextEl.textContent = `Jarak: ${distanceKm} km`;
          }
        } else {
          console.warn("⚠️ Gagal hitung rute:", status);
        }
      }
    );
  }

  // Gerakkan marker tetap setiap update lokasi
  smoothMoveAndRotate(driverMarker, lastDriverPosition, newPos, 1000, () => {
    lastDriverPosition = newPos;
  });
}

// ✅ Gerak & rotasi marker dengan halus
function smoothMoveAndRotate(
  marker,
  fromPos,
  toPos,
  duration = 1000,
  callback
) {
  if (!fromPos || !toPos || isAnimating) return;
  isAnimating = true;

  const start = performance.now();

  const animate = (now) => {
    const progress = Math.min((now - start) / duration, 1);
    const lat = fromPos.lat() + (toPos.lat() - fromPos.lat()) * progress;
    const lng = fromPos.lng() + (toPos.lng() - fromPos.lng()) * progress;
    const currentPos = new google.maps.LatLng(lat, lng);
    marker.setPosition(currentPos);

    // Rotasi marker ke arah pergerakan
    const heading = google.maps.geometry.spherical.computeHeading(
      fromPos,
      toPos
    );
    marker.setIcon({
      path: google.maps.SymbolPath.FORWARD_CLOSED_ARROW,
      scale: 5,
      fillColor: "#1565C0",
      fillOpacity: 1,
      strokeWeight: 1,
      rotation: heading,
      anchor: new google.maps.Point(0, 2.5),
    });

    if (progress < 1) {
      requestAnimationFrame(animate);
    } else {
      marker.setPosition(toPos);
      isAnimating = false;
      if (callback) callback();
    }
  };

  requestAnimationFrame(animate);
}
window.receiveLocation = function (lat, lng) {
  // Simpan koordinat sementara

  if (
    window.location.pathname.includes("/driver") ||
    window.location.href.includes("/driver")
  ) {
    // 🔥 Tunggu sampai Google Maps siap
    waitUntilMapReady(() => {
      console.log("✅ Jalankan receiveLocation setelah Maps siap");

      Latitude = lat;
      Longitude = lng;

      if (typeof google === "undefined" || !google.maps) {
        console.error("❌ Google Maps belum siap di callback");
        return;
      }

      driverLatLng = new google.maps.LatLng(Latitude, Longitude);

      if (!map) return;

      if (tmpMarker) tmpMarker.setMap(null);

      const newPos = new google.maps.LatLng(lat, lng);

      // Marker pertama kali
      if (!driverMarker) {
        if (startMarker) startMarker.setMap(null);
        driverMarker = new google.maps.Marker({
          position: newPos,
          map,
          icon: {
            path: google.maps.SymbolPath.FORWARD_CLOSED_ARROW,
            scale: 5,
            fillColor: "#1565C0",
            fillOpacity: 1,
            strokeWeight: 1,
            rotation: 0,
            anchor: new google.maps.Point(0, 2.5),
          },
          title: "📍 Lokasi Saya (Driver)",
        });

        lastDriverPosition = newPos;
        map.setCenter(newPos);
        return;
      }

      // Smooth move marker
      smoothMoveAndRotate(
        driverMarker,
        lastDriverPosition,
        newPos,
        1000,
        () => {
          lastDriverPosition = newPos;
        }
      );

      // ✅ Kalau belum ada rute (belum order) → map selalu center
      if (autoCenterEnabled && (!statusOrderRide || statusOrderRide === null)) {
        map.panTo(newPos);
      }

      // ✅ Kalau sedang ada rute → update rute
      if (
        statusOrderRide === "ride_accept" ||
        statusOrderRide === "driver_to_customer"
      ) {
        updateRouteFirstThenMove(newPos);
        calcRoute(newPos, pickupLatLng);
      }

      // ✅ Kalau sedang ada rute → update rute
      if (statusOrderRide === "with_customer") {
        updateRouteFirstThenMove(newPos);
        calcRoute(newPos, dstLatLng);
      }
    });
  } else {
    // console.log(`Lat: ${Latitude}, Lng: ${Longitude}`);
    if (isFirstUpdate) {
      getCurrentLocation();
      isFirstUpdate = false;
    }
  }
};
async function kirimTopup(phone, jlh_topup) {
  const data = {
    pengirim: phone,
    jlh_topup: jlh_topup,
  };

  try {
    const response = await fetch(
     `${baseUrl}:3755/api/topup`,
      {
        method: "POST",
        headers: { "Content-Type": "application/json" },
        body: JSON.stringify(data),
      }
    );

    if (!response.ok) {
      throw new Error(`HTTP error! Status: ${response.status}`);
    }

    const result = await response.json();
    console.log("✅ Respon dari server:", result);

    return result; // <=== 🔥 hasilnya dikembalikan ke pemanggil
  } catch (error) {
    console.error("❌ Gagal mengirim topup:", error);
    throw error; // <=== 🔥 lempar error agar bisa ditangkap di luar
  }
}
function IconMarker(Input) {
  let icon;

  if (userRole == "driver") {
    icon = `${baseUrl}/images/marker_driver.png`;
  } else {
    if (Input == "lokasi_awal") {
      icon = `${baseUrl}/images/6948631.png`;
    } else {
      icon = `${baseUrl}/images/marker_finish.png`;
    }
  }

  return icon;
}
let redirectDone = false;
window.msgFromServer = function (data) {
  const msgType = data.action;
  const msg = data.message;

  // --- logika utama tetap jalan ---
  if (msgType == "cek_data") {
    // window.AndroidApp.updateBadge("history", msg.order_count);
    // alert(redirectDone);
    // AutoBidRestoran = msg.user.auto_bid_resto;
    const currentUrl = window.location.href;
    const targetUrl = `${baseUrl}/driver/food_order`;

    if (
      userRole === "driver" &&
      msg.user.order_id &&
      !currentUrl.includes(targetUrl)
    ) {
      // window.location.href = `${targetUrl}?orderID=${msg.user.order_id}`;
    }

    // if (!redirectDone && userRole === "driver" && msg.user?.order_id != null) {
    //   redirectDone = true;
    //   window.location.href = `${baseUrl}/driver/food_order?orderID=${msg.user.order_id}`;
    // }
  } else if (msgType == "food_order_new") {
    // showFoodOrder(msg);
    // alert(`${baseUrl}/driver/food_order?orderID=${msg.order_id}`);
    // window.location.href = `${baseUrl}/driver/food_order?orderID=${msg.order_id}`;
    window.location.href = `${baseUrl}/driver`;
  }

  // --- kirim event agar file lain juga bisa tangani pesan ---
  window.dispatchEvent(new CustomEvent("msgFromServer", { detail: data }));
};

window.updateFCM = function (phone, fcm_token) {
  console.log("📱 updateFCM dipanggil:", phone, fcm_token);

  if (!phone || !fcm_token) {
    alert("❌ Phone atau FCM kosong!");
    return;
  }

  fetch(`${baseUrl}/user/fcm`, {
    method: "POST",
    headers: {
      "Content-Type": "application/x-www-form-urlencoded",
      "X-Requested-With": "XMLHttpRequest",
    },
    body:
      "phone=" +
      encodeURIComponent(phone) +
      "&fcm_token=" +
      encodeURIComponent(fcm_token),
  })
    .then((res) => res.json())
    .then((data) => {
      console.log("✅ FCM token updated:", data);
      // alert("✅ Update FCM token berhasil!");
    })
    .catch((err) => {
      console.error("❌ Error update FCM:", err);
      // alert("❌ Gagal update FCM token!");
    });
};
let height;
document.addEventListener("DOMContentLoaded", () => {
  if (window.AndroidApp) {
    height = AndroidApp.getStatusBarHeight();
  }

  const searchWrapper = document.querySelector(".header-wrapper");
  if (searchWrapper) {
    //   // Tambahkan padding top agar tidak tertutup status bar
    searchWrapper.style.paddingTop = height + "px";
  }

  if (!cekWSS()) {
    tungguWssTersambung(() => {
      console.log("Request cek_data ke server...");
      // misalnya: kirim pesan ke server, atau jalankan fungsi init
      window.AndroidApp.sendMessageToServerFromWebview("cache", "", "");
      window.AndroidApp.sendMessageToServerFromWebview("cek_data", "", "");
    });
  } else {
    window.AndroidApp.sendMessageToServerFromWebview("cache", "", "");
    window.AndroidApp.sendMessageToServerFromWebview("cek_data", "", "");
  }
});
function hitungOngkos(jarakKm) {
  let ongkos = 5000; // dasar untuk ≤ 2 km

  if (jarakKm > 2) {
    const sisaKm = jarakKm - 2;
    const kmPenuh = Math.floor(sisaKm); // km penuh setelah 2 km
    const sisa = sisaKm - kmPenuh; // sisa kurang dari 1 km

    ongkos += kmPenuh * 2000; // biaya per km penuh
    ongkos += sisa >= 0.5 ? 2000 : sisa > 0 ? 1000 : 0; // biaya sisa km
  }

  return ongkos;
}
function hitungOngkos1(jarakKm, order_type = "ride") {
  jarakKm = Number(jarakKm);

  // tarif dasar 2 KM pertama
  const baseFare = order_type === "food" ? 10000 : 5000;

  let ongkos = baseFare;

  if (jarakKm > 2) {
    const sisaKm = jarakKm - 2;
    const kmPenuh = Math.floor(sisaKm);
    const sisa = sisaKm - kmPenuh;

    // per km penuh setelah 2 km
    ongkos += kmPenuh * 2000;

    // sisa kurang dari 1 km
    if (sisa >= 0.5) {
      ongkos += 2000;
    } else if (sisa > 0) {
      ongkos += 1000;
    }
  }

  return ongkos;
}

// Preview + validasi + crop saat pilih gambar baru
document.querySelectorAll(".upload-box").forEach((box) => {
  // cek apakah harus disable
  if (box.classList.contains("disabled")) {
    box.style.pointerEvents = "none";
    return; // hentikan, jangan tambahkan listener klik
  }

  box.addEventListener("click", () => {
    const inputId = box.dataset.input;
    document.getElementById(inputId).click();
  });
});

let cropper = null;
let currentInput = null;

document.querySelectorAll("input[type='file']").forEach((input) => {
  input.addEventListener("change", function () {
    const file = this.files[0];
    if (!file) return;

    currentInput = this;

    const cropImage = document.getElementById("cropImage");
    cropImage.src = URL.createObjectURL(file);

    document.getElementById("cropModal").style.display = "flex";

    cropImage.onload = () => {
      if (cropper) cropper.destroy();

      const w = parseInt(this.dataset.width) || 200;
      const h = parseInt(this.dataset.height) || 200;

      cropper = new Cropper(cropImage, {
        aspectRatio: w / h,
        viewMode: 2,
        autoCropArea: 1,
        movable: true,
        zoomable: true,
        rotatable: true, // 🔥 diaktifkan
        scalable: false,
        wheelZoomRatio: 0.1, // zoom lebih halus
      });
    };
  });
});

async function applyCrop0() {
  const w = parseInt(currentInput.dataset.width) || 200;
  const h = parseInt(currentInput.dataset.height) || 200;

  const { width, height } = getOptimalCropSize(w, h);

  cropper.getCroppedCanvas({ width, height }).toBlob(
    async (blob) => {
      blob = await smartCompress(blob); // <500KB

      window.finalBlob = blob;

      // Update preview
      const group = currentInput.closest(".form-group");
      const preview = group.querySelector(".previewImageLogo");
      const icon = group.querySelector(".uploadIcon");

      preview.src = URL.createObjectURL(blob);
      preview.style.display = "block";
      icon.style.display = "none";

      closeCrop();
    },
    "image/jpg",
    0.9
  );
}
async function applyCrop1() {
  const w = parseInt(currentInput.dataset.width) || 200;
  const h = parseInt(currentInput.dataset.height) || 200;

  const { width, height } = getOptimalCropSize(w, h);

  cropper.getCroppedCanvas({ width, height }).toBlob(
    async (blob) => {
      blob = await smartCompress(blob); // <500KB

      window.finalBlob = blob;

      const group = currentInput.closest(".form-group");

      // === MULTIPLE PREVIEWS ===
      const previews = group.querySelectorAll(".previewImg");
      const icons = group.querySelectorAll(".uploadIcon");

      previews.forEach((preview) => {
        preview.src = URL.createObjectURL(blob);
        preview.style.display = "block";
      });

      icons.forEach((icon) => {
        icon.style.display = "none";
      });

      closeCrop();
    },
    "image/jpg",
    0.9
  );
}

async function applyCrop() {
  const w = parseInt(currentInput.dataset.width) || 200;
  const h = parseInt(currentInput.dataset.height) || 200;

  const { width, height } = getOptimalCropSize(w, h);

  cropper.getCroppedCanvas({ width, height }).toBlob(
    async (blob) => {
      blob = await smartCompress(blob); // <500KB

      // === TAMPILKAN ALERT SIZE ===
      const sizeText = formatSize(blob.size);
      // alert("Ukuran gambar setelah compress: " + sizeText);

      // === MULTI-BLOB STORAGE ===
      if (!window.finalBlob) window.finalBlob = {};
      window.finalBlob[currentInput.name] = blob;

      const group = currentInput.closest(".form-group");

      const previews = group.querySelectorAll(".previewImg");
      const icons = group.querySelectorAll(".uploadIcon");

      previews.forEach((preview) => {
        preview.src = URL.createObjectURL(blob);
        preview.style.display = "block";
      });

      icons.forEach((icon) => {
        icon.style.display = "none";
      });

      closeCrop();
    },
    "image/jpg",
    0.9
  );
}
function formatSize(bytes) {
  if (bytes < 1024) return bytes + " B";
  if (bytes < 1024 * 1024) return (bytes / 1024).toFixed(1) + " KB";
  return (bytes / (1024 * 1024)).toFixed(2) + " MB";
}

function getOptimalCropSize(baseWidth, baseHeight) {
  const dpr = Math.min(window.devicePixelRatio || 1, 3);
  return { width: baseWidth * dpr, height: baseHeight * dpr };
}
async function smartCompress(blob, maxSize = 200 * 1024) {
  let quality = 0.9;

  while (blob.size > maxSize && quality > 0.2) {
    blob = await new Promise((resolve) => {
      const reader = new FileReader();
      reader.onload = () => {
        const img = new Image();
        img.onload = () => {
          const canvas = document.createElement("canvas");
          canvas.width = img.width;
          canvas.height = img.height;
          canvas.getContext("2d").drawImage(img, 0, 0);

          canvas.toBlob((b) => resolve(b), "image/jpeg", quality);
        };
        img.src = reader.result;
      };
      reader.readAsDataURL(blob);
    });

    quality -= 0.1;
  }

  return blob;
}
async function smartCompress1(blob, maxSize = 200 * 1024) {
  let quality = 0.9;
  const MIN_QUALITY = 0.2;

  const loadImage = (blob) =>
    new Promise((resolve) => {
      const reader = new FileReader();
      reader.onload = () => {
        const img = new Image();
        img.onload = () => resolve(img);
        img.src = reader.result;
      };
      reader.readAsDataURL(blob);
    });

  let img = await loadImage(blob);

  let width = img.width;
  let height = img.height;

  // === AUTO RESIZE jika resolusi terlalu besar (> 2000px)
  const MAX_DIMENSION = 2000;
  if (width > MAX_DIMENSION || height > MAX_DIMENSION) {
    const ratio = Math.min(MAX_DIMENSION / width, MAX_DIMENSION / height);
    width = width * ratio;
    height = height * ratio;
  }

  while (true) {
    const compressedBlob = await new Promise((resolve) => {
      const canvas = document.createElement("canvas");
      canvas.width = width;
      canvas.height = height;

      const ctx = canvas.getContext("2d");
      ctx.drawImage(img, 0, 0, width, height);

      canvas.toBlob((b) => resolve(b), "image/jpeg", quality);
    });

    // Cegah null
    if (!compressedBlob) break;

    // Jika sudah cukup kecil, selesai
    if (compressedBlob.size <= maxSize || quality <= MIN_QUALITY) {
      return compressedBlob;
    }

    // Turunkan kualitas PERLAHAN (lebih halus daripada 0.1)
    quality -= 0.05;
  }

  return blob; // fallback kalau gagal kompres
}

function closeCrop() {
  document.getElementById("cropModal").style.display = "none";
}
function rotateLeft() {
  if (cropper) cropper.rotate(-90);
}
function rotateRight() {
  if (cropper) cropper.rotate(90);
}
function zoomIn() {
  if (cropper) cropper.zoom(0.1);
}
function zoomOut() {
  if (cropper) cropper.zoom(-0.1);
}
function formatRupiah(number) {
  if (!number) return "";
  return number.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ".");
}
// ambil semua input text dan textarea
const fields = document.querySelectorAll('input[type="text"], textarea');

fields.forEach((field) => {
  field.addEventListener("input", function () {
    let words = this.value.split(" ");
    this.value = words
      .map((word) =>
        word.length > 0
          ? word.charAt(0).toUpperCase() + word.slice(1).toLowerCase()
          : ""
      )
      .join(" ");
  });
});

// Untuk ambil nilai murni (tanpa titik)
function getNominalNumber(input) {
  const raw = input.value.replace(/\D/g, "");
  return parseInt(raw || "0", 10);
}
function showNavSafe() {
  if (window.AndroidApp?.showBottomNav) {
    AndroidApp.showBottomNav();
  }
}
// showLoading();
