document.addEventListener("DOMContentLoaded", () => {
  const stars = document.querySelectorAll(".star");
  const ratingInput = document.getElementById("ratingInput");
  const form = document.getElementById("reviewForm");
  const textarea = form ? form.querySelector("textarea[name='ulasan']") : null;
  const submitBtn = form ? form.querySelector("button[type='submit']") : null;
  const thanks = document.getElementById("thanksMessage");

  // Fungsi untuk cek status aktif tombol
  const updateButtonState = () => {
    if (!submitBtn) return;
    const rating = parseInt(ratingInput.value);
    const ulasan = textarea?.value.trim();
    if (rating > 0 && ulasan.length > 0) {
      submitBtn.disabled = false;
      submitBtn.classList.remove("disabled-btn");
    } else {
      submitBtn.disabled = true;
      submitBtn.classList.add("disabled-btn");
    }
  };

  // Aktifkan logika rating & validasi form
  if (form && stars.length > 0) {
    // Klik bintang
    stars.forEach((star) => {
      star.addEventListener("click", () => {
        const rating = parseInt(star.getAttribute("data-value"));
        ratingInput.value = rating;
        stars.forEach((s) => s.classList.remove("active"));
        for (let i = 0; i < rating; i++) stars[i].classList.add("active");
        updateButtonState();
      });
    });

    // Input ulasan
    textarea.addEventListener("input", updateButtonState);

    // Awalnya tombol nonaktif
    updateButtonState();

    // Saat submit
    form.addEventListener("submit", (e) => {
      e.preventDefault();
      thanks.style.display = "block";
      setTimeout(() => {
        form.submit();
      }, 800);
    });
  }

  // === Logika copy Order ID ===
  const copyBtn = document.getElementById("copyOrderIdBtn");
  const orderIdText = document.querySelector(".order-id-text");
  const feedback = document.getElementById("copyFeedback");

  if (copyBtn && orderIdText) {
    copyBtn.addEventListener("click", async () => {
      try {
        await navigator.clipboard.writeText(orderIdText.textContent.trim());
        feedback.style.display = "inline";
        setTimeout(() => (feedback.style.display = "none"), 1500);
      } catch (err) {
        alert("Gagal menyalin Order ID.");
      }
    });
  }
});
