document.addEventListener("DOMContentLoaded", () => {
  const firstInput = document.getElementById("name");
  if (firstInput) {
    firstInput.focus();
  }
});

document
  .getElementById("formRegister")
  .addEventListener("submit", function (e) {
    e.preventDefault(); // cegah reload halaman

    const form = e.target;
    const formData = new FormData(form);
    showLoading("Loading...");
    fetch(form.action, {
      method: "POST",
      body: formData,
    })
      .then((res) => res.json())
      .then((data) => {
        alert(data);
        if (data.success === "success") {
          alert(data.redirect);
          window.AndroidApp.saveTokenAndPhone(data.token, data.phone);
          window.location.href = data.redirect;
        } else {
          showModal("info", "Informasi", "Registrasi gagal");
        }
      })
      .catch((err) => {
        hideLoading();
        console.error(err);
        showModal("error", "Error", err);
      });
  });
