document.addEventListener("DOMContentLoaded", () => {
  const firstInput = document.querySelector("#otpForm input[type='tel']");
  if (firstInput) {
    firstInput.focus();
  }
});
// Auto fokus antar input OTP
const inputs = document.querySelectorAll(".otp-inputs input");
const verifyBtn = document.querySelector(".btn-verify");
const otpForm = document.getElementById("otpForm");

function checkOtpFilled() {
  let otp = "";
  let allFilled = true;

  inputs.forEach((input) => {
    if (!input.value) allFilled = false;
    otp += input.value;
  });

  if (allFilled) {
    if (window.AndroidApp && window.AndroidApp.hideKeyboard) {
      window.AndroidApp.hideKeyboard();
    }
    // buat hidden input OTP
    const hiddenOtp = document.createElement("input");
    hiddenOtp.type = "hidden";
    hiddenOtp.name = "otp";
    hiddenOtp.value = otp;
    otpForm.appendChild(hiddenOtp);

    // otomatis submit
    // otpForm.submit();
    showLoading("Loading...");
    fetch("/auth/verifyOtp", {
      method: "POST",
      credentials: "include", // 🔥 WAJIB
      body: new FormData(document.getElementById("otpForm")),
    })
      .then((res) => res.json())
      .then((data) => {
        console.log(data);
        if (data.status) {
          if (window.AndroidApp) {
            // window.AndroidApp.showToast(data.token);
            // window.AndroidApp.saveUserToken(data.token);

            window.AndroidApp.saveTokenAndPhone(data.token, data.phone);

            // Restart aplikasi (hanya jika method tersedia)
            // window.AndroidApp.restartAppFromWeb();
            // window.AndroidApp.reconnectWebSocketFromJS();
            // showToast("Kode OTP belum lengkap");
          }
          // if (typeof AndroidApp !== "undefined") {
          //     AndroidApp.saveUserToken(data.token);
          // }

          if (data.message === "Silakan daftar dulu") {
            // console.log(`/token?token=${data.token}&phone=${data.phone}`);
            window.location.href = `/register`;
          } else {
            // console.log(`/token?token=${data.token}&phone=${data.phone}`);
            window.location.href = `/role`;
          }
        } else {
          otpForm.reset();

          // fokus ke input OTP pertama
          const firstInput = otpForm.querySelector("input[type='tel']");
          if (firstInput) {
            firstInput.focus();
          }
          // showFullscreenNotif("error", data.message);
          // Untuk info biasa
          showModal("Info", "Info", data.message);
          // showToast(data.message, "error");
          // alert(data.message);
          setTimeout(() => {
            // window.location.href = data.redirect;
          }, 2000); // delay 2 detik (2000 ms)
        }
      });
  }
}

inputs.forEach((input, index) => {
  input.addEventListener("input", () => {
    if (input.value && index < inputs.length - 1) {
      inputs[index + 1].focus();
    }
    checkOtpFilled();
  });
  input.addEventListener("keydown", (e) => {
    if (e.key === "Backspace" && !input.value && index > 0) {
      inputs[index - 1].focus();
    }
  });
});

// Timer untuk kirim ulang OTP
let timeLeft = 60;
// const countdownEl = document.getElementById("countdown");
const resendLink = document.getElementById("resendLink");

const timer = setInterval(() => {
  timeLeft--;
  //   countdownEl.textContent = `Kirim ulang dalam ${timeLeft} detik`;
  resendLink.textContent = `Kirim ulang (${timeLeft})`;

  if (timeLeft <= 0) {
    clearInterval(timer);
    countdownEl.textContent = "";
    resendLink.textContent = "Kirim ulang";
    resendLink.classList.remove("disabled");
  }
}, 1000);

resendLink.addEventListener("click", function (e) {
  e.preventDefault();
  if (resendLink.classList.contains("disabled")) return;

  // Ambil nomor HP dari session atau hidden input
  const phone = "<?= esc(session()->get('phone')) ?>";

  // Format data sebagai url-encoded
  const formBody = new URLSearchParams();
  formBody.append("phone", phone); // sama dengan yang dicek di backend
  showLoading("Loading...");
  fetch("<?= base_url('auth/otp/send') ?>", {
    method: "POST",
    credentials: "include", // 🔥 WAJIB
    headers: { "Content-Type": "application/x-www-form-urlencoded" },
    body: formBody.toString(),
  })
    .then((res) => {
      // showToast("OTP baru berhasil dikirim!");
      showModal("Success", "Sukses", "OTP baru berhasil dikirim!");
      // showFullscreenNotif("sukses", "OTP baru berhasil dikirim!");
      if (window.AndroidApp) {
        // window.AndroidApp.showToast("OTP baru berhasil dikirim!");
      } else {
        // alert("OTP baru berhasil dikirim!");
      }
      setTimeout(() => {
        window.location.reload();
      }, 2000); // delay 2 detik (2000 ms)

      return;
    })
    .catch((err) => {
      // showFullscreenNotif("error", err);
      showModal("Error", "Error", err);

      // showToast(err, "error");
      if (window.AndroidApp) {
        // window.location.reload();
        // window.AndroidApp.showToast(err);
      } else {
        // alert(err);
      }
    });
});
