// // Cek lebar layar
// if (window.innerWidth > 768) {
//     // Sembunyikan form login
//     document.getElementById('loginForm').style.display = 'none';
//     // Tampilkan pesan mobile-only
//     document.getElementById('desktopMessage').style.display = 'block';

// }

// if (window.innerWidth > 900 && !/mobile|android|iphone|ipad/i.test(navigator.userAgent)) {
//     window.location.href = "/desktop";
// }

document.addEventListener("DOMContentLoaded", function () {
  const form = document.getElementById("formLogin");
  const phoneInput = form.querySelector("input[name='phone']");
  form.addEventListener("submit", function (e) {
    if (window.AndroidApp) {
      window.AndroidApp.hideKeyboard();
    }

    document.activeElement.blur(); // tutup keyboard
    e.preventDefault(); // cegah submit default

    const phone = phoneInput.value.trim();

    // validasi kosong
    if (phone === "") {
      // Untuk info biasa
      // showModalInfo("Info", "Nomor WhatsApp wajib diisi.");
      // ✅ Notifikasi biasa (OK saja)
      showModal("info", "Informasi", "Nomor WhatsApp wajib diisi.");

      // showFullscreenNotif("⚠️ Error", "Nomor WhatsApp wajib diisi.");
      // phoneInput.focus();
      return;
    }

    // validasi angka & panjang 10–15 digit
    const onlyNumber = /^[0-9]+$/.test(phone);
    if (!onlyNumber || phone.length < 10 || phone.length > 15) {
      // showFullscreenNotif("⚠️ Error", "Nomor WhatsApp tidak valid (10–15 digit angka)");
      // showModalInfo("Info", "Nomor WhatsApp tidak valid (10–15 digit angka)");
      showModal(
        "info",
        "Informasi",
        "Nomor WhatsApp tidak valid (10–15 digit angka"
      );
      // phoneInput.focus();
      return;
    }

    // ✅ submit manual tanpa trigger ulang event
    form.removeEventListener("submit", arguments.callee);
    showLoading("Loading...");
    form.submit();
    // hideLoading();
  });
});

// if (window.AndroidApp) {
//     window.AndroidApp.requestLocation();
// }
