let countdownInterval;
let progressTime = 5; // detik total
let orderID;
let driverPhone = null;
let customerPhone = null;
let LatLng = null;
let OrderData = null;
let UserData = null;
let PaymentMetode;
let OrderType = null;
// Tampilkan order-card

const routeCard = document.getElementById("route-card");
const orderTitle = document.getElementById("order-title");
const elData = document.getElementById("order-data");
const elUser = document.getElementById("user-data");
const driverBalance = document.getElementById("driverBalance");
const rideToggle = document.getElementById("rideToggle");
const foodToggle = document.getElementById("foodToggle");
const AutoBidToggle = document.getElementById("autoAcceptToggle");
const todayIncome = document.getElementById("todayIncome");
const orderCompleted = document.getElementById("orderCompleted");
const classOrderCard = document.getElementById(`order-card`);
const ClassFoodOrderCard = document.getElementById(`food-order-card`);
const DriverInfo = document.getElementById("driver-info");
const btnOrderFood = document.getElementById("actions-default");
const searchRestaurantWrapper = document.getElementById(
  "search-restaurant-wrapper"
);
const headerWrapper = document.getElementById("header-wrapper");
const SectionTitleItems = document.getElementById("section-title-items");
const SectionTitleRestoran = document.getElementById(
  "section-title-restaurant"
);
const InfoAddressCustomer = document.getElementById("info-address-customer");
const RestaurantName = document.getElementById("restaurant-name");
const InfoSectionDestination = document.getElementById(
  "info-section-destination"
);

const OrderTypeIcon = document.getElementById("order-icon");
const OrderTypeTitle = document.getElementById("order-title-text");
const OrderActionRide = document.getElementById("order-actions-default");
let SliderBtn;

let pinInput;

function showOrder(data) {
  // OrderType = "food";
  console.log(`DATA ${data}`);
  statusOrderRide = "ride_accept";
  orderID = data.orderID;
  driverPhone = data.driverPhone;
  customerPhone = data.customer_phone;
  pickupLat = data.pickup_lat;
  pickupLng = data.pickup_lng;
  driverLat = data.driverLat;
  driverLng = data.driverLng;
  dstLat = data.dst_lat;
  dstLng = data.dst_lng;
  PaymentMetode = data.payment_metode;

  // window.AndroidApp.showSnack(
  //   `Pesanan RIDE baru dari ${data.customer_name || "Penumpang"}`
  // );
  // alert(orderID);

  pickupLatLng = new google.maps.LatLng(pickupLat, pickupLng);
  dstLatLng = new google.maps.LatLng(dstLat, dstLng);

  // alert(pickupLatLng);

  const paymentEl = document.getElementById("paymentMethod");
  if (PaymentMetode === "Tunai") {
    paymentEl.textContent = "Tunai";
    paymentEl.classList.add("cash");
  } else {
    paymentEl.textContent = "Saldo";
    paymentEl.classList.add("saldo");
  }

  // Tambahkan teks pickup ke judul tanpa mengubah icon
  orderTitle.textContent = `Pesanan Baru (Order ID : ${orderID})`;
  document.getElementById("passenger-name").textContent =
    data.customer_name || "Penumpang";
  document.getElementById("pickup").textContent = data.pickup;
  document.getElementById("destination").textContent = data.destination;
  // document.getElementById('price').textContent = 'Rp ' + data.price.toLocaleString();
  const tarif = Number(data.price || 0);
  document.getElementById("price").textContent =
    "Rp " +
    tarif.toLocaleString("id-ID", {
      minimumFractionDigits: 0,
    });

  // ✅ Tambahan jarak & waktu
  if (data.distance !== undefined) {
    document.getElementById("distance").textContent = `${data.distance.toFixed(
      1
    )} Km`;
  }
  if (data.duration !== undefined) {
    document.getElementById("duration").textContent = data.duration;
  }

  // Sembunyikan route-card
  document.getElementById("route-card").classList.add("hidden");

  // Sembunyikan driverFloating
  document.getElementById("driverFloating").style.display = "none";

  // Sembunyikan center-btn
  document.getElementById("center-btn").style.display = "none";

  // Tampilkan order-card
  const card = document.getElementById("order-card");
  card.classList.remove("hidden");
  card.classList.add("show");

  // Reset progress bar
  const progressBar = document.getElementById("progress-bar");
  progressBar.style.width = "100%";

  // Hitung mundur di tombol Tolak
  let timeLeft = progressTime;
  const btnReject = document.getElementById("btnRejectFood");
  const btnAccept = document.getElementById("btnAcceptFood");

  if (AutoBidToggle.checked) {
    btnAccept.textContent = `Terima (${timeLeft})`;
    clearInterval(countdownInterval);
    countdownInterval = setInterval(() => {
      timeLeft--;
      btnAccept.textContent = `Terima (${timeLeft})`;
      let percent = (timeLeft / progressTime) * 100;
      progressBar.style.width = percent + "%";

      if (timeLeft <= 0) {
        clearInterval(countdownInterval);
        // hideOrder();
        // rejectOrder();
        acceptOrder("ride");
        // if (window.Android?.timeoutOrder) window.Android.timeoutOrder();
      }
    }, 1000);
    // resizeMapHeight();
  } else {
    btnReject.textContent = `Tolak (${timeLeft})`;
    clearInterval(countdownInterval);
    countdownInterval = setInterval(() => {
      timeLeft--;
      btnReject.textContent = `Tolak (${timeLeft})`;
      let percent = (timeLeft / progressTime) * 100;
      progressBar.style.width = percent + "%";

      if (timeLeft <= 0) {
        clearInterval(countdownInterval);
        // hideOrder();
        rejectOrder();
        // if (window.Android?.timeoutOrder) window.Android.timeoutOrder();
      }
    }, 1000);
    // resizeMapHeight();
  }
}
document.getElementById("btn-nav-pickup").onclick = () => {
  openNavigation(pickupLat, pickupLng);
};

document.getElementById("btn-nav-dst").onclick = () => {
  openNavigation(dstLat, dstLng);
};

function hideOrder() {
  clearInterval(countdownInterval);
  document.getElementById("order-card").classList.remove("show");
  document.getElementById("order-card").classList.add("hidden");
  document.getElementById("route-card").classList.remove("hidden");
  document.getElementById("route-card").classList.add("show");
  // Sembunyikan driverFloating
  document.getElementById("driverFloating").style.display = "block";

  // Sembunyikan center-btn
  document.getElementById("center-btn").style.display = "block";
}

function acceptOrder0() {
  // alert(driverPhone);
  // hideOrder();
  clearInterval(countdownInterval);
  // orderTitle.textContent = `Driver menuju ke lokasi anda (Order ID : ${orderID})`;
  // if (window.Android?.acceptOrder) window.Android.acceptOrder();

  // window.AndroidApp.sendMessageToServerFromWebview("order", "ride", JSON.stringify({
  //     action: "accept",
  //     customerPhone: customerPhone,
  //     // driver_phone:driverPhone;
  //     orderID: orderID
  // }));

  // Saat driver klik tombol "Tolak"
  const msg = {
    type: `acccept_${orderID}_${driverPhone}`, // <== harus sama persis
    orderID: orderID,
    driverPhone: driverPhone,
  };

  window.AndroidApp.sendMessageToServerFromWebview(
    "order",
    "ride",
    JSON.stringify(msg)
  );
}

function rejectOrder0() {
  if (!cekWSS()) {
    // showModal(
    //   "Warning",
    //   "Warning",
    //   "Ada kendala jaringan ke server. Silahkan coba lagi nanti."
    // );
    window.AndroidApp.showSnack(
      "Ada kendala jaringan ke server. Silahkan coba lagi nanti."
    );
    return;
  }
  hideOrder();
  // if (window.Android?.rejectOrder) window.Android.rejectOrder();
  // Contoh kirim pesan JSON ke Android
  window.AndroidApp.sendMessageToServerFromWebview(
    "order",
    "ride",
    JSON.stringify({
      action: "reject",
      driverPhone: driverPhone,
      orderID: orderID,
    })
  );
}

function rejectOrder() {
  if (!cekWSS()) {
    // showModal(
    //   "Warning",
    //   "Warning",
    //   "Ada kendala jaringan ke server. Silahkan coba lagi nanti."
    // );
    window.AndroidApp.showSnack(
      "Ada kendala jaringan ke server. Silahkan coba lagi."
    );
    return;
  }
  window.AndroidApp.stopOrderSound();
  hideOrder();
  // if (window.Android?.rejectOrder) window.Android.rejectOrder();
  // Contoh kirim pesan JSON ke Android
  window.AndroidApp.sendMessageToServerFromWebview(
    "order",
    order_type,
    JSON.stringify({
      action: "reject",
      driverPhone: driverPhone,
      orderID: orderID,
    })
  );
}

// Dipanggil dari Android

function acceptOrder() {
  if (!cekWSS()) {
    // showModal(
    //   "Warning",
    //   "Warning",
    //   "Ada kendala jaringan ke server. Silahkan coba lagi nanti."
    // );
    window.AndroidApp.showSnack(
      "Ada kendala jaringan ke server. Silahkan coba lagi"
    );
    return;
  }
  clearInterval(countdownInterval);
  window.AndroidApp.stopOrderSound();
  alert(OrderType);
  if (OrderType === "ride") {
    // 📍 Ambil lokasi customer dari data order yang sudah disimpan sebelumnya
    pickupLatLng = new google.maps.LatLng(pickupLat, pickupLng);

    // 🔥 Kirim ke server bahwa order diterima
    window.AndroidApp.sendMessageToServerFromWebview(
      "order",
      "ride",
      JSON.stringify({
        action: "accept",
        orderID: orderID,
        driverPhone: driverPhone,
        driverLat: Latitude,
        driveLng: Longitude,
        customer_phone: customerPhone,
        dst_lat: dstLat,
        dst_lng: dstLng,
      })
    );

    if (endMarker) endMarker.setMap(null);

    // 📍 Tambahkan marker lokasi customer
    endMarker = new google.maps.Marker({
      position: pickupLatLng,
      map,
      icon: {
        url: `${baseUrl}/images/4942358.png`,
        scaledSize: new google.maps.Size(40, 40),
      },
      title: "📍 Lokasi Customer",
    });

    // 🎯 Pusatkan peta ke lokasi customer
    // map.setCenter(pickupLatLng);
    // map.setZoom(5); // zoom lebih dekat agar lokasi terlihat jelas
    // calculateRoute();
    driverLatLng = new google.maps.LatLng(Latitude, Longitude);
    calcRoute(driverLatLng, pickupLatLng)
      .then(({ durationText, distanceM, distanceKm }) => {
        console.log("🕐 ETA:", durationText);
        console.log("📏 Jarak (m):", distanceM);
        console.log("📏 Jarak (km):", distanceKm);

        const eta_text = document.getElementById("eta-text");
        if (eta_text) {
          eta_text.textContent = `Driver tiba dalam ${durationText}`;
        }

        const distanceTextEl = document.getElementById("distance-to-customer");
        if (distanceTextEl) {
          distanceTextEl.textContent = `Jarak: ${distanceKm} km`;
        }

        if (distanceM < 50) {
          // 📍 Jika driver sudah < 50 meter dari lokasi customer
          statusTextEl.textContent = "Driver Sudah Tiba di Lokasi Anda";
        } else {
          // 📍 Jika masih dalam perjalanan
          statusTextEl.textContent = "Driver Menuju Lokasi Anda";
        }
      })
      .catch((err) => console.error(err));

    resizeMapHeight();
    document.getElementById("actions-default").classList.add("hidden");
    document.getElementById("pin-slider-wrapper").classList.remove("hidden");
  } else if (OrderType === "food") {
    stopAllTimers();
    // stopRejectCountdown();
    stopAutoReject(); // hentikan tim
    document.getElementById("summary-pin-box").classList.remove("hidden");
    document.getElementById("actions-default").classList.add("hidden");
    document.getElementById("pin-slider-wrapper").classList.remove("hidden");
    document
      .getElementById("section-title-restoran")
      .classList.remove("hidden");
    window.AndroidApp.stopOrderSound();
    window.AndroidApp.sendMessageToServerFromWebview(
      "order",
      "food",
      JSON.stringify({
        action: "accept",
        orderID,
        driverPhone,
        customerPhone,
      })
    );
  }

  // ✅ Ganti tombol
  // document.getElementById("order-actions-default").classList.add("hidden");
  // ✅ Ganti tombol
  // document.getElementById("food-actions").classList.add("hidden");

  // if (order_type === "food") {
  //   document
  //     .getElementById("order-actions-accepted-food")
  //     .classList.remove("hidden");
  // } else {
  //   document
  //     .getElementById("order-actions-accepted")
  //     .classList.remove("hidden");
  // }

  // 📌 Hapus marker tujuan lama jika ada
}

// ===== Slider Button Logic =====
let isSliding = false;
let startX = 0;

// ✅ Open Google Maps navigasi
function openNavigation(lat, lng) {
  if (!lat || !lat) {
    // showModal("Info", "Info", "Koordinat belum tersedia");
    window.AndroidApp.showSnack("Koordinat belum tersedia");
    return;
  }

  // Contoh: buka navigasi ke lokasi pickup
  window.AndroidApp.openMaps(Number(lat), Number(lng));
}

// 🔥 Fungsi slider multi-step
function startSlide(e, step) {
  isSliding = true;
  startX = e.touches[0].clientX;
}

function moveSlide0(e, step) {
  if (!isSliding) return;
  const handle = document.getElementById(`sliderHandle${step}`);
  const container = document.getElementById(`sliderBtn${step}`);
  const diff = e.touches[0].clientX - startX;
  const maxMove = container.offsetWidth - handle.offsetWidth - 8;

  if (diff >= 0 && diff <= maxMove) {
    handle.style.left = diff + "px";

    // ✅ Hitung persen geser untuk efek warna
    let percent = (diff / maxMove) * 100;
    container.classList.add("filled");
    container.style.setProperty("--fill", percent + "%");
  }
}

function moveSlide(e, step) {
  if (!isSliding) return;
  const handle = document.getElementById(`sliderHandle${step}`);
  const container = document.getElementById(`sliderBtn${step}`);
  const diff = e.touches[0].clientX - startX;
  const maxMove = container.offsetWidth - handle.offsetWidth - 8;

  if (diff >= 0 && diff <= maxMove) {
    handle.style.left = diff + "px";

    // ✅ Hitung persen geser untuk efek warna penuh
    let percent = (diff / maxMove) * 100;
    container.classList.add("filled");
    container.style.setProperty("--fill", percent + "%");

    // ✅ Pastikan variabel warna ter-set ulang saat step 2
    if (step === 2) {
      container.style.setProperty("--fill-color", "#e67e22");
    } else {
      container.style.setProperty("--fill-color", "#27ae60");
    }
  }
}

function endSlide(e, step) {
  isSliding = false;
  const handle = document.getElementById(`sliderHandle${step}`);
  const container = document.getElementById(`sliderBtn${step}`);
  const text = document.getElementById(`sliderText${step}`);
  const maxMove = container.offsetWidth - handle.offsetWidth - 8;
  const currentPos = parseInt(handle.style.left) || 0;
  const pin = document.getElementById("food-pin-input").value.trim();

  if (currentPos >= maxMove * 0.8) {
    container.classList.add("slider-complete");
    handle.style.left = maxMove + "px";

    if (step === 1) {
      if (!cekWSS()) {
        // showModal(
        //   "Warning",
        //   "Warning",
        //   "Ada kendala jaringan ke server. Silahkan coba lagi nanti."
        // );
        window.AndroidApp.showSnack(
          "Warning",
          "Ada kendala jaringan ke server. Silahkan coba lagi"
        );
        resetSliders();
        return;
      }

      statusOrderRide = "with_customer";
      // ✅ Sudah dengan customer
      text.textContent = "✅ Sudah bersama customer";

      let ac;
      if (OrderType == "food") {
        ac = "deliver";
      } else {
        ac = "with_customer";
      }

      window.AndroidApp.sendMessageToServerFromWebview(
        "order",
        OrderType,
        JSON.stringify({
          action: ac,
          orderID: orderID,
          driverPhone: driverPhone,
          customer_phone: customerPhone,
          pin: pin,
        })
      );
      // return;
      document.getElementById("order-actions-accepted").classList.add("hidden");
      document
        .getElementById("order-actions-complete")
        .classList.remove("hidden");

      const dstLatLng = new google.maps.LatLng(dstLat, dstLng);
      // 📌 Hapus marker tujuan lama jika ada
      if (endMarker) endMarker.setMap(null);

      // 📍 Tambahkan marker lokasi customer
      endMarker = new google.maps.Marker({
        position: dstLatLng,
        map,
        icon: {
          url: `${baseUrl}/images/4942358.png`,
          scaledSize: new google.maps.Size(40, 40),
        },
        title: "📍 Lokasi Customer",
      });

      // 🎯 Pusatkan peta ke lokasi customer
      // map.setCenter(dstLatLng);
      // map.setZoom(5); // zoom lebih dekat agar lokasi terlihat jelas
      // calculateRoute();
      calcRoute(driverLatLng, dstLatLng);
      // Tampilkan step 2 setelah 1 detik
      setTimeout(() => {}, 1000);
    } else if (step === 2) {
      if (!cekWSS()) {
        // showModal(
        //   "Warning",
        //   "Warning",
        //   "Ada kendala jaringan ke server. Silahkan coba lagi nanti."
        // );
        window.AndroidApp.showSnack(
          "Ada kendala jaringan ke server. Silahkan coba lagi"
        );
        resetSliders();
        return;
      }
      statusOrderRide = null;
      // hideOrder();
      // ✅ Selesai antar
      text.textContent = "✅ Order Selesai!";
      window.AndroidApp.sendMessageToServerFromWebview(
        "order",
        "ride",
        JSON.stringify({
          action: "completed",
          orderID: orderID,
          driverPhone: driverPhone,
          customer_phone: customerPhone,
        })
      );

      resetSliders();
      showLoading();
      location.reload();
    }
  } else {
    handle.style.left = "4px";
    container.style.setProperty("--fill", "0%");
    container.classList.remove("filled");
  }
}

function resetSliders() {
  ["1", "2"].forEach((step) => {
    const handle = document.getElementById(`sliderHandle${step}`);
    const container = document.getElementById(`sliderBtn${step}`);
    const text = document.getElementById(`sliderText${step}`);
    handle.style.left = "4px";
    container.style.setProperty("--fill", "0%");
    container.classList.remove("filled", "slider-complete");
    text.textContent =
      step === "1"
        ? "Geser jika sudah dengan customer"
        : "Geser jika sudah selesai antar";
  });
}

window.addEventListener("DOMContentLoaded", function () {
  pinInput = document.getElementById("pin-input");
  AndroidApp.showBottomNav();
  loadGoogleMaps();
  // OrderActionRide.classList.remove("hidden");
  // resizeMapHeight();

  //    const orderCard = document.getElementById(" order-card");
  // const orderCardHeight = orderCard ? orderCard.offsetHeight : 0;
  // alert(orderCardHeight);
  // tungguWssTersambung(() => {
  //   console.log("Lanjut ke proses berikutnya...");
  //   // misalnya: kirim pesan ke server, atau jalankan fungsi init

  //   console.log(`userData: ${UserData.nama}`);

  // });

  // 🔥 UPDATE SERVICE ROLE
  updateDriverServiceRole();

  let user = null;
  if (elUser) {
    user = JSON.parse(elUser.dataset.user);
  }

  let order = null;
  if (elData) {
    order = JSON.parse(elData.dataset.order);
  }

  if (elData) {
    AndroidApp.hideBottomNav();
    OrderType = order.action || order.order_type;
    orderID = order.order_id;
    driverPhone = order.driver_phone;
    customerPhone = order.customer_phone;
    pickupLat = order.pickup_lat;
    pickupLng = order.pickup_lng;
    dstLat = order.destination_lat;
    dstLng = order.destination_lng;

    DriverInfo.classList.add("hidden");
    ClassFoodOrderCard.classList.remove("hidden");
    routeCard.style.height = window.innerHeight * 0.6 + "px"; // 60% layar

    headerWrapper.classList.remove("hidden");
    resizeMapHeight();

    const header = document.getElementById("header-wrapper");

    header.classList.remove("ride", "food");
    btnOrderFood.classList.remove("hidden");
    //  alert(`${pickupLat}, ${pickupLng}`);

    if (user.order_id.toLowerCase().startsWith("f")) {
      OrderTypeIcon.className = "fa-solid fa-burger";
      OrderTypeTitle.textContent = "Pesanan Makanan Baru";
      header.classList.add("food");

      document.getElementById("btn-nav-pickup-food").onclick = () => {
        openNavigation(pickupLat, pickupLng);
      };

      document.getElementById("btn-nav-dst-food").onclick = () => {
        openNavigation(dstLat, dstLng);
      };

      renderItems(order.items);
      // panggil setelah UI siap

      if (AutoBidToggle.checked) {
        startAutoAccept();
      } else {
        startAutoReject(); // 🔥 Mulai timer auto reject
      }

      waitUntilMapReady(() => {
        driverLatLng = new google.maps.LatLng(Latitude, Longitude);
        pickupLatLng = new google.maps.LatLng(pickupLat, pickupLng);
        dstLatLng = new google.maps.LatLng(dstLat, dstLng);

        tmpMarker = new google.maps.Marker({
          position: driverLatLng,
          map,
          icon: {
            path: google.maps.SymbolPath.FORWARD_CLOSED_ARROW,
            scale: 5,
            fillColor: "#1565C0",
            fillOpacity: 1,
            strokeWeight: 1,
            rotation: 0,
            anchor: new google.maps.Point(0, 2.5),
          },
        });

        if (endMarker) endMarker.setMap(null);
        endMarker = new google.maps.Marker({
          position: pickupLatLng,
          map,
          icon: {
            url: `${baseUrl}/images/4942358.png`,
            scaledSize: new google.maps.Size(50, 50),
          },
        });

        // this.alert(driverLatLng);
        calcRoute(driverLatLng, pickupLatLng)
          .then(({ durationText, distanceM, distanceKm }) => {
            // alert(durationText);
          })
          .catch((err) => console.error(err));
      });
    } else if (user.order_id.toLowerCase().startsWith("r")) {
      SectionTitleRestoran.textContent = "Titik jemput";
      InfoAddressCustomer.classList.add("hidden");
      SectionTitleItems.classList.add("hidden");
      RestaurantName.textContent = order.pickup;
      InfoSectionDestination.classList.remove("hidden");

      OrderTypeIcon.className = "fa-solid fa-motorcycle";
      OrderTypeTitle.textContent = "Pesanan Ride Baru";
      header.classList.add("ride");
      // btnOrderFood.classList.add("hidden");
    }

    if (!pinInput) return;

    pinInput.addEventListener("input", function () {
      // hanya angka, max 4 digit
      this.value = this.value.replace(/\D/g, "").slice(0, 4);

      if (this.value.length === 4) {
        console.log("PIN lengkap, hide keyboard");

        // 1️⃣ blur dari JS
        this.blur();

        // 2️⃣ paksa Android tutup keyboard
        if (window.AndroidApp && window.AndroidApp.hideKeyboard) {
          window.AndroidApp.hideKeyboard();
        }
      }
    });
  } else {
    DriverInfo.classList.remove("hidden");
    searchRestaurantWrapper.classList.remove("hidden");
  }
});

function ShowData() {
  OrderType = "ride";
  if (OrderData == "" || OrderData == null) {
    // alert("ORDER KOSONG");
    driverLatLng = new google.maps.LatLng(Latitude, Longitude);
    // alert(driverLatLng);
    if (startMarker) startMarker.setMap(null);
    startMarker = new google.maps.Marker({
      position: driverLatLng,
      map,
      icon: {
        path: google.maps.SymbolPath.FORWARD_CLOSED_ARROW,
        scale: 5,
        fillColor: "#1565C0",
        fillOpacity: 1,
        strokeWeight: 1,
        rotation: 0,
        anchor: new google.maps.Point(0, 2.5),
      },
    });
  } else {
    // alert("ORDER READY");
    const objUser = UserData;
    const obj = OrderData;

    orderID = objUser.order_id;
    const objUserOrserStatus = objUser.order_status;
    driverPhone = obj.driver_phone;

    pickupLat = Number(obj.pickup_lat);
    pickupLng = Number(obj.pickup_lng);
    dstLat = Number(obj.destination_lat);
    dstLng = Number(obj.destination_lng);
    customerPhone = obj.customer_phone;

    pickupLatLng = new google.maps.LatLng(pickupLat, pickupLng);
    dstLatLng = new google.maps.LatLng(dstLat, dstLng);
    // alert(pickupLatLng);

    // Tambahkan teks pickup ke judul tanpa mengubah icon
    orderTitle.textContent = `Pesanan Baru (Order ID : ${obj.order_id})`;
    document.getElementById("passenger-name").textContent =
      obj.customer_name || "Penumpang";
    document.getElementById("pickup").textContent = obj.pickup;
    document.getElementById("destination").textContent = obj.destination;
    document.getElementById("price").textContent =
      "Rp " + Number(obj.tarif).toLocaleString("id-ID");

    // ✅ Tambahan jarak & waktu
    if (obj.distance !== undefined) {
      document.getElementById("distance").textContent = parseFloat(
        obj.distance
      ).toFixed(1);
    }
    if (obj.duration !== undefined) {
      document.getElementById("duration").textContent = obj.duration;
    }

    // Sembunyikan route-card
    document.getElementById("route-card").classList.add("hidden");

    // Sembunyikan driverFloating
    document.getElementById("driverFloating").style.display = "none";

    // Sembunyikan center-btn
    document.getElementById("center-btn").style.display = "none";

    // Tampilkan order-card
    const card = document.getElementById("order-card");
    card.classList.remove("hidden");
    card.classList.add("show");

    driverLatLng = new google.maps.LatLng(Latitude, Longitude);

    if (tmpMarker) tmpMarker.setMap(null);

    // ✅ Ganti tombol

    if (objUserOrserStatus == "driver_to_customer") {
      statusOrderRide = "driver_to_customer";
      // document.getElementById("order-actions-default").classList.add("hidden");
      document
        .getElementById("order-actions-accepted")
        .classList.remove("hidden");

      tmpMarker = new google.maps.Marker({
        position: driverLatLng,
        map,
        icon: {
          path: google.maps.SymbolPath.FORWARD_CLOSED_ARROW,
          scale: 5,
          fillColor: "#1565C0",
          fillOpacity: 1,
          strokeWeight: 1,
          rotation: 0,
          anchor: new google.maps.Point(0, 2.5),
        },
      });

      if (endMarker) endMarker.setMap(null);
      endMarker = new google.maps.Marker({
        position: pickupLatLng,
        map,
        icon: {
          url: `${baseUrl}/images/4942358.png`,
          scaledSize: new google.maps.Size(50, 50),
        },
      });
      calcRoute(driverLatLng, pickupLatLng);
    } else if (objUserOrserStatus == "with_customer") {
      statusOrderRide = "with_customer";
      // document.getElementById("order-actions-default").classList.add("hidden");
      document.getElementById("order-actions-accepted").classList.add("hidden");
      document
        .getElementById("order-actions-complete")
        .classList.remove("hidden");

      if (endMarker) endMarker.setMap(null);
      endMarker = new google.maps.Marker({
        position: dstLatLng,
        map,
        icon: {
          url: `${baseUrl}/images/4942358.png`,
          scaledSize: new google.maps.Size(50, 50),
        },
      });

      calcRoute(driverLatLng, dstLatLng);
    }
  }

  // resizeMapHeight();
  // const user = '<?= json_encode($user, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES) ?>';
  // const dt = '<?= json_encode($data, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES) ?>';
  // const objUser = JSON.parse(user);
  // const obj = JSON.parse(dt); // ✅ ubah jadi object

  // showOrder(obj);
  // acceptOrder();
  // alert(objUser.order_id);
}

function updateDriverServiceRole() {
  const rideOn = rideToggle && rideToggle.checked;
  const foodOn = foodToggle && foodToggle.checked;

  let roleText = "Driver Tidak Aktif";

  if (rideOn && foodOn) {
    roleText = "Driver Ride & Food";
  } else if (rideOn) {
    roleText = "Driver Ride";
  } else if (foodOn) {
    roleText = "Driver Food";
  }

  // 🔔 Kirim ke Android (jika tersedia)
  if (window.AndroidApp?.updateServiceRole) {
    window.AndroidApp.updateServiceRole(roleText);
  }
}

window.addEventListener("msgFromServer", function (e) {
  const data = e.detail;
  const msgType = data.action;
  const msg = data.message;

  // alert(msgType);

  if (msgType == "cek_data") {
    UserData = msg.user;
    driverRiwayat = msg.riwayat_driver;
    console.log(`cek_data diterima`);
  } else if (msgType == "ride_order_new") {
    // showOrder(msg);
    window.location.reload();
  } else if (msgType == "topup_berhasil") {
    window.location.reload();
  }
});

function showFoodOrder(order) {
  OrderType = "food";
  orderID = order.order_id;
  driverPhone = order.driver_phone;
  const card = document.getElementById("food-order-card");

  // Set data
  document.getElementById("food-customer-name").textContent =
    order.customer_name;
  document.getElementById("food-restaurant-name").textContent =
    order.restaurant_name;

  // Items
  const itemsBox = document.getElementById("food-items-list");
  itemsBox.innerHTML = "";

  order.items.forEach((i) => {
    let noteFormatted = "";

    if (i.note) {
      // Pecah baris berdasarkan enter, lalu beri bullet
      const lines = i.note.split(/\n/);
      noteFormatted = lines.map((line) => `• ${line}`).join("<br>");
    }

    itemsBox.innerHTML += `
    <div style="margin-bottom:6px;">
        <b>${i.name}</b> × ${i.qty}
        ${
          i.note
            ? `<div style="font-size:13px; color:#555; margin-left:5px"><i>${noteFormatted}</i></div>`
            : ``
        }
    </div>
  `;
  });

  // Payment
  document.getElementById("food-payment-method").textContent =
    order.payment_method.toUpperCase();

  // Total
  document.getElementById("food-total-price").textContent =
    "Rp " + Number(order.price).toLocaleString();

  // tampilkan popup
  card.classList.remove("hidden");
  setTimeout(() => card.classList.add("show"), 20);

  startFoodTimer(order.orderID);
}

// TIMER FOOD
let foodTimer;
function startFoodTimer(orderID) {
  let timeLeft = 10;
  const btn = document.getElementById("btnFoodReject");
  btn.textContent = `Tolak (${timeLeft})`;

  foodTimer = setInterval(() => {
    timeLeft--;
    btn.textContent = `Tolak (${timeLeft})`;

    if (timeLeft <= 0) {
      clearInterval(foodTimer);
      rejectFoodOrder(orderID);
    }
  }, 1000);
}

// Reject → kirim ke backend
function rejectFoodOrder(orderID) {
  clearInterval(foodTimer);
  document.getElementById("food-order-card").classList.remove("show");

  setTimeout(() => {
    document.getElementById("food-order-card").classList.add("hidden");
  }, 300);

  // orderSocketSendReject(orderID); // sesuaikan endpoint kamu
  rejectOrder("food");
}

// Accept Food
function acceptFoodOrder(orderID) {
  clearInterval(foodTimer);

  // orderSocketSendAccept(orderID); // sesuaikan endpoint kamu
  acceptOrder("food");
  // document.getElementById("food-order-card").classList.remove("show");
  // setTimeout(() => {
  //   document.getElementById("food-order-card").classList.add("hidden");
  // }, 300);
  document.getElementById("food-pin-box").classList.remove("hidden");
}

// console.log("📏 Status bar height diterima:", StatusBarHeight);

// // Simpan di CSS variable (biar bisa digunakan di mana-mana)
// document.documentElement.style.setProperty(
//   "--status-bar-height",
//   StatusBarHeight + "px"
// );

// // Atur tinggi / margin pada wrapper pencarian restoran
// const searchWrapper = document.querySelector(".search-restaurant-wrapper");
// if (searchWrapper) {
//   // Tambahkan padding top agar tidak tertutup status bar
//   searchWrapper.style.paddingTop = StatusBarHeight + "px";
// }

// // (opsional) Atur juga body margin-top jika perlu
// document.body.style.marginTop = heiStatusBarHeightght + "px";
async function toggleDriverRide0() {
  const res = await fetch("/driver/toggle_driver_ride", {
    method: "POST",
    headers: {
      "Content-Type": "application/json",
    },
  });

  const json = await res.json();

  if (!json.success) {
    alert(json.message || "Gagal mengubah Auto Terima");
    return;
  }

  autoAccept = json.newStatus === 1;

  // update UI
  if (autoAccept) {
    rideToggle.classList.remove("auto-off");
    rideToggle.classList.add("auto-on");
    rideToggle.innerHTML = `<i class="fa-solid fa-bolt"></i><span>Auto ON</span>`;
  } else {
    rideToggle.classList.remove("auto-on");
    rideToggle.classList.add("auto-off");
    rideToggle.innerHTML = `<i class="fa-solid fa-bolt"></i><span>Auto OFF</span>`;
  }
}

async function toggleDriverRide() {
  const res = await fetch("/driver/toggle_driver_ride", {
    method: "POST",
    headers: {
      "Content-Type": "application/json",
    },
  });

  const json = await res.json();

  if (!json.success) {
    alert(json.message || "Gagal mengubah Auto Terima");
    return;
  }

  autoAccept = json.newStatus === 1;

  // update UI
  if (autoAccept) {
    rideToggle.classList.remove("auto-off");
    rideToggle.classList.add("auto-on");
    // rideToggle.innerHTML = `<i class="fa-solid fa-bolt"></i><span>Auto ON</span>`;
    window.AndroidApp.showSnack("Layanan Driver Ride Aktif");
  } else {
    rideToggle.classList.remove("auto-on");
    rideToggle.classList.add("auto-off");
    // rideToggle.innerHTML = `<i class="fa-solid fa-bolt"></i><span>Auto OFF</span>`;
    window.AndroidApp.showSnack("Layanan Driver Ride Nonaktif");
  }
  updateDriverServiceRole();
}

async function toggleDriverFood() {
  const res = await fetch("/driver/toggle_driver_food", {
    method: "POST",
    headers: {
      "Content-Type": "application/json",
    },
  });

  const json = await res.json();

  if (!json.success) {
    alert(json.message || "Gagal mengubah Auto Terima");
    return;
  }

  autoAccept = json.newStatus === 1;

  // update UI
  if (autoAccept) {
    foodToggle.classList.remove("auto-off");
    foodToggle.classList.add("auto-on");
    // foodToggle.innerHTML = `<i class="fa-solid fa-bolt"></i><span>Auto ON</span>`;
    window.AndroidApp.showSnack("Layanan Driver Food Aktif");
  } else {
    foodToggle.classList.remove("auto-on");
    foodToggle.classList.add("auto-off");
    // foodToggle.innerHTML = `<i class="fa-solid fa-bolt"></i><span>Auto OFF</span>`;
    window.AndroidApp.showSnack("Layanan Driver Food Nonaktif");
  }
  updateDriverServiceRole();
}

async function toggleAutoBid(el) {
  const prevState = el.checked; // status SEBELUM request

  try {
    const res = await fetch("/driver/toggle_auto_bid", {
      method: "POST",
      headers: { "Content-Type": "application/json" },
    });

    const json = await res.json();

    if (!json.success) {
      throw new Error(json.message || "Gagal mengubah Auto Terima");
    }

    // Sinkronkan status dari backend
    const isActive = ["Y", 1, true, "1"].includes(json.newStatus);
    el.checked = isActive;

    /* ===============================
           KONDISI AKTIF / NON AKTIF
        =============================== */

    if (isActive) {
      // ✅ AUTO TERIMA AKTIF
      console.log("Auto Terima: AKTIF");

      // contoh aksi:
      // stopAllTimers();
      // startAutoAccept();

      // window.AndroidApp.showSnack("Auto Terima Aktif");
      window.AndroidApp.showSnack("Auto Terima Aktif");

      // showModal("Info", "Auto Terima Aktif", "Order akan diterima otomatis");
    } else {
      // ❌ AUTO TERIMA NON AKTIF
      console.log("Auto Terima: NON AKTIF");

      // contoh aksi:
      // stopAllTimers();
      // startAutoReject();
      // window.AndroidApp.showSnack("Auto Terima Nonaktif");
      window.AndroidApp.showSnack("Auto Terima Nonaktif");
      // showModal("Info", "Auto Terima Nonaktif", "Auto terima telah dimatikan");
    }
  } catch (err) {
    // 🔥 ROLLBACK ke status sebelumnya
    el.checked = prevState;
    // showModal("Error", "Error", err.message);
    window.AndroidApp.showSnack(`Error: ${err.message}`);
  }
}

// ** FOOD ** //

let countdownTimer = null;
let countdown = 5;

function renderItems(items) {
  let merged = mergeItems(items);
  let list = document.getElementById("food-items-list");

  document.getElementById("total-item-count").textContent = merged.length;

  let html = `<div class="item-box">`;

  merged.forEach((it, i) => {
    html += `
            <div>
                <b>${it.name} × ${it.qty}</b><br>
                ${it.note ? `<small>${formatNote(it.note)}</small>` : ""}
            </div>
        `;

    if (i < merged.length - 1) html += `<div class="item-separator"></div>`;
  });

  html += `</div>`;

  list.innerHTML = html;
}
/* ========== GABUNG ITEM SAMA ========== */
function mergeItems(items) {
  let grouped = {};

  items.forEach((it) => {
    let key = it.name.trim().toLowerCase();

    if (!grouped[key]) {
      grouped[key] = {
        name: it.name,
        qty: parseInt(it.qty),
        note: it.note || "",
      };
    } else {
      grouped[key].qty += parseInt(it.qty);

      // gabungkan note bila berbeda
      if (it.note && !grouped[key].note.includes(it.note)) {
        grouped[key].note += "\n" + it.note;
      }
    }
  });

  return Object.values(grouped);
}
/* ========== BULLET NOTE FORMAT ========== */
function formatNote(note) {
  if (!note) return "";
  let lines = note.split(/\r?\n/);
  return lines.map((l) => "• " + l.trim()).join("<br>");
}
/* ========== ACTION BUTTON ========== */
function rejectFood() {
  stopAllTimers();
  // stopRejectCountdown();
  stopAutoReject(); // hentikan tim
  window.AndroidApp.sendMessageToServerFromWebview(
    "order",
    "food",
    JSON.stringify({
      action: "reject",
      orderID,
      driverPhone,
    })
  );
  window.AndroidApp.stopOrderSound();
  window.location.href = `${baseUrl}/driver`;
}

function acceptFood() {
  stopAllTimers();
  // stopRejectCountdown();
  stopAutoReject(); // hentikan tim
  document.getElementById("summary-pin-box").classList.remove("hidden");
  document.getElementById("actions-default").classList.add("hidden");
  document.getElementById("pin-slider-wrapper").classList.remove("hidden");
  document.getElementById("section-title-restoran").classList.remove("hidden");
  window.AndroidApp.stopOrderSound();
  window.AndroidApp.sendMessageToServerFromWebview(
    "order",
    "food",
    JSON.stringify({
      action: "accept",
      orderID,
      driverPhone,
      customerPhone,
    })
  );
}

function completeDelivery() {
  window.AndroidApp.sendMessageToServerFromWebview(
    "order",
    "food",
    JSON.stringify({
      action: "completed",
      orderID,
      driverPhone,
    })
  );
}

/* ================= AUTO REJECT 10 DETIK ================= */
let autoRejectTimer = null;
const AUTO_REJECT_TIME = 10000; // 10 detik

function stopAutoReject() {
  if (autoRejectTimer) {
    clearTimeout(autoRejectTimer);
    autoRejectTimer = null;
  }
}

function startRejectCountdown0() {
  const rejectBtn = document.querySelector(".btn.reject");

  rejectBtn.textContent = `Tolak (${countdown})`;

  countdownTimer = setInterval(() => {
    countdown--;

    rejectBtn.textContent = `Tolak (${countdown})`;

    if (countdown <= 0) {
      clearInterval(countdownTimer);
    }
  }, 1000);
}

function stopRejectCountdown() {
  clearInterval(countdownTimer);
  const rejectBtn = document.querySelector(".btn.reject");
  rejectBtn.textContent = "Tolak";
  const acceptBtn = document.querySelector(".btn.accept");
  acceptBtn.textContent = "Terima";
}

function startAutoReject() {
  const rejectBtn = document.getElementById("btnReject");
  if (!rejectBtn) return;

  startCountdown(rejectBtn, "Tolak", countdown, () => {
    rejectOrder();
  });
}

function startAutoAccept() {
  const acceptBtn = document.getElementById("btnAccept");
  if (!acceptBtn) return;

  startCountdown(acceptBtn, "Terima", countdown, () => {
    acceptOrder();
  });
}

function stopAllTimers() {
  clearInterval(countdownTimer);
  clearTimeout(autoRejectTimer);
}

function sendPinRestaurant() {
  fetch(`${baseUrl}/restaurant/order/check-pin`, {
    method: "POST",
    headers: {
      "Content-Type": "application/json",
    },
    body: JSON.stringify({
      order_id: orderID,
      pin: pinInput.value,
      driver_phone: driverPhone,
    }),
  })
    .then((res) => res.json())
    .then((res) => {
      if (res.status === true) {
        window.AndroidApp.sendMessageToServerFromWebview(
          "order",
          "food",
          JSON.stringify({
            action: "deliver",
            orderID,
            driverPhone,
            customerPhone,
          })
        );

        // statusOrderRide = "Mengantar Pesanan.";
        // ✅ Sudah dengan customer
        // document.getElementById("sliderText1").textContent = "Geser jika sudah selesai antar";

        // // return;
        // document.getElementById("actions-step1").classList.add("hidden");
        // document
        //     .getElementById("actions-step2")
        //     .classList.remove("hidden");

        document
          .getElementById("section-title-restoran")
          .classList.add("hidden");
        document.getElementById("summary-pin-box").classList.add("hidden");
        document.getElementById("pin-step-1").classList.add("hidden");
        document.getElementById("pin-step-2").classList.remove("hidden");
        // setTimeout(() => {}, 1000);

        if (endMarker) endMarker.setMap(null);
        endMarker = new google.maps.Marker({
          position: dstLatLng,
          map,
          icon: {
            url: `${baseUrl}/images/4942358.png`,
            scaledSize: new google.maps.Size(50, 50),
          },
        });

        calcRoute(driverLatLng, dstLatLng);
      } else {
        resetSlidersFood();
        // kosongkan PIN
        pinInput.value = "";
        window.AndroidApp.hideKeyboard();
        // showModal("info", "Informasi", "PIN Salah");
        window.AndroidApp.showSnack(res.message);
        // window.AndroidApp.showSnack("PIN Salah");

        // delay kecil agar WebView stabil
        setTimeout(() => {
          pinInput.focus();
        }, 150);
      }
    })

    .catch((err) => {
      // alert("Gagal koneksi ke server");
      resetSliders();
      window.AndroidApp.hideKeyboard();
      // showModal("error", "Error", "Gagal koneksi ke server");
      window.AndroidApp.showSnack("Gagal koneksi ke server");
      // btn.disabled = false;
      // btn.textContent = "Kirim PIN Restoran";
    });
}

function startCountdown(buttonEl, label, duration, onFinish) {
  clearInterval(countdownTimer);
  clearTimeout(autoRejectTimer);

  countdown = duration;
  buttonEl.textContent = `${label} (${countdown})`;

  countdownTimer = setInterval(() => {
    countdown--;
    buttonEl.textContent = `${label} (${countdown})`;

    if (countdown <= 0) {
      clearInterval(countdownTimer);
    }
  }, 1000);

  autoRejectTimer = setTimeout(() => {
    clearInterval(countdownTimer);
    onFinish();
  }, duration * 1000);
}

/* ========== SLIDER ========== */

function startSlideFood(e, step) {
  isSliding = true;
  startX = e.touches[0].clientX;
}

function moveSlideFood(e, step) {
  if (!isSliding) return;

  const handle = document.getElementById(`handle${step}`);
  const cont = document.getElementById(`slider${step}`);

  let move = e.touches[0].clientX - startX;
  if (move < 0) move = 0;

  const max = cont.offsetWidth - handle.offsetWidth - 8;
  if (move > max) move = max;

  handle.style.left = move + "px";

  // ✅ INI YANG MEMBUAT BACKGROUND NGISI
  const percent = (move / max) * 100;
  cont.style.setProperty("--fill", percent + "%");
}

function endSlideFood(e, step) {
  isSliding = false;
  pinInput = document.getElementById("pin-input");
  const handle = document.getElementById(`handle${step}`);
  SliderBtn = document.getElementById(`slider${step}`);
  const max = SliderBtn.offsetWidth - handle.offsetWidth - 8;
  const current = parseInt(handle.style.left) || 0;

  if (current < max * 0.8) {
    resetSlidersFood();
    return;
  }
  if (OrderType == "food") {
    // 🔥 VALIDASI PIN SEBELUM LOCK SLIDER
    if (step === 1) {
      if (pinInput.value.length !== 4 || !/^\d{4}$/.test(pinInput.value)) {
        pinInput.blur();
        window.AndroidApp.showSnack("PIN harus 4 digit angka!");

        resetSlidersFood();

        // 🔥 FOCUS SETELAH RESET
        setTimeout(() => {
          pinInput.value = "";
          pinInput.focus();
        }, 300);

        return;
      }

      // ✅ BARU LOCK SLIDER
      handle.style.left = max + "px";
      SliderBtn.style.setProperty("--fill", "100%");
      SliderBtn.classList.add("slider-complete");

      sendPinRestaurant();
    } else if (step === 2) {
      handle.style.left = max + "px";
      SliderBtn.style.setProperty("--fill", "100%");
      SliderBtn.classList.add("slider-complete");

      window.AndroidApp.sendMessageToServerFromWebview(
        "order",
        "food",
        JSON.stringify({
          action: "completed",
          orderID,
          driverPhone,
          customerPhone,
        })
      );

      SliderBtn.textContent = "✅ Order Selesai!";

      setTimeout(() => {
        window.location.href = `${baseUrl}/driver`;
      }, 1000); // 500 ms (0.5 detik)
    }
  } else {
    if (step === 1) {
      if (!cekWSS()) {
        // showModal(
        //   "Warning",
        //   "Warning",
        //   "Ada kendala jaringan ke server. Silahkan coba lagi nanti."
        // );
        window.AndroidApp.showSnack(
          "Ada kendala jaringan ke server. Silahkan coba lagi"
        );
        resetSlidersFood();
        return;
      }

      

      statusOrderRide = "with_customer";
      // ✅ Sudah dengan customer
      SliderBtn.textContent = "✅ Sudah bersama customer";

      window.AndroidApp.sendMessageToServerFromWebview(
        "order",
        OrderType,
        JSON.stringify({
          action: "with_customer",
          orderID: orderID,
          driverPhone: driverPhone,
          customer_phone: customerPhone,
        })
      );

      // return;
      document.getElementById("section-title-restoran").classList.add("hidden");
      document.getElementById("summary-pin-box").classList.add("hidden");
      document.getElementById("pin-step-1").classList.add("hidden");
      document.getElementById("pin-step-2").classList.remove("hidden");
      // setTimeout(() => {}, 1000);

      const dstLatLng = new google.maps.LatLng(dstLat, dstLng);
      // 📌 Hapus marker tujuan lama jika ada
      if (endMarker) endMarker.setMap(null);

      // 📍 Tambahkan marker lokasi customer
      endMarker = new google.maps.Marker({
        position: dstLatLng,
        map,
        icon: {
          url: `${baseUrl}/images/4942358.png`,
          scaledSize: new google.maps.Size(40, 40),
        },
        title: "📍 Lokasi Customer",
      });

      // 🎯 Pusatkan peta ke lokasi customer
      // map.setCenter(dstLatLng);
      // map.setZoom(5); // zoom lebih dekat agar lokasi terlihat jelas
      // calculateRoute();
      calcRoute(driverLatLng, dstLatLng);
      // Tampilkan step 2 setelah 1 detik
      setTimeout(() => {
        // ✅ BARU LOCK SLIDER
        handle.style.left = max + "px";
        SliderBtn.style.setProperty("--fill", "100%");
        SliderBtn.classList.add("slider-complete");
      }, 1000);
    } else if (step === 2) {
      if (!cekWSS()) {
        // showModal(
        //   "Warning",
        //   "Warning",
        //   "Ada kendala jaringan ke server. Silahkan coba lagi nanti."
        // );
        window.AndroidApp.showSnack(
          "Ada kendala jaringan ke server. Silahkan coba lagi"
        );
        resetSlidersFood();
        return;
      }

      // ✅ BARU LOCK SLIDER
      handle.style.left = max + "px";
      SliderBtn.style.setProperty("--fill", "100%");
      SliderBtn.classList.add("slider-complete");

      statusOrderRide = null;
      // hideOrder();
      // ✅ Selesai antar
      SliderBtn.textContent = "✅ Order Selesai!";
      window.AndroidApp.sendMessageToServerFromWebview(
        "order",
        "ride",
        JSON.stringify({
          action: "completed",
          orderID: orderID,
          driverPhone: driverPhone,
          customer_phone: customerPhone,
        })
      );

      setTimeout(() => {
        location.reload();
      }, 1000); // 500 ms (0.5 detik)
    }
  }
}

function resetSlidersFood() {
  ["1", "2"].forEach((step) => {
    const handle = document.getElementById(`handle${step}`);
    SliderBtn = document.getElementById(`slider${step}`);
    const text = document.getElementById(`sliderText${step}`);

    handle.style.transition = "none";
    handle.style.left = "4px";

    SliderBtn.classList.remove("slider-complete", "filled");
    SliderBtn.style.setProperty("--fill", "0%");

    // 🔥 FORCE REPAINT (ANTI BUG WEBVIEW)
    void SliderBtn.offsetWidth;

    handle.style.transition = "";

    text.textContent =
      step === "1"
        ? "Geser jika sudah ambil"
        : "Geser jika sudah selesai antar";
  });
}
