// Ambil data JSON dari elemen #order-data
const el = document.getElementById("order-data");
const inputAwalClose = document.getElementById("btnCloseAwal");
const inputAkhirClose = document.getElementById("btnCloseAkhir");
const inputAwal = document.getElementById("lokasi_awal");
const inputAkhir = document.getElementById("lokasi_akhir");
const routeCard = document.getElementById("route-card");
const eta_text = document.getElementById("eta-text");
const startText = document.getElementById("start-text");
const endText = document.getElementById("end-text");
const distance = document.getElementById("distance-text");
const duration = document.getElementById("duration-text");
const biaya = document.getElementById("biaya-text");
const biayaAplikasi = document.getElementById("biaya-aplikasi-text");
const biayaTotal = document.getElementById("total-text");
const backBtn = document.getElementById("back-btn");
const orderBtn = document.getElementById("order-btn");
const distanceTextEl = document.getElementById("distance-to-customer");
const btnText = document.getElementById("btn-text");
const btnSpinner = document.getElementById("btn-spinner");
const statusTextEl = document.getElementById("driver-status-text");
let AG_SALDO;
let agSelectedMethod = "Tunai";
let idleTimeout = null;
let PickupSecondAddress = null;
let DestinationSecondAddress = null;

window.addEventListener("DOMContentLoaded", function () {
  AndroidApp.showBottomNav();
  loadGoogleMaps();
  waitUntilMapReady(() => ShowData());
  resizeMapHeight();

  function ShowData() {
    if (el) {
      const raw = el?.getAttribute("data-json");
      let obj = JSON.parse(raw || "{}");
      console.log("✅ Parsed:", obj);

      // jika data berupa array
      if (Array.isArray(obj)) {
        obj = obj[0] || {};
      }

      const orderID = obj?.order_id || "";
      const orderStatus = obj?.order_status || "";
      console.log("✅ OrderID:", orderID);

      if (orderID !== "") {
        if (btnCenterMaps) {
          btnCenterMaps.classList.add("hidden");
          // btnCenterMaps.classList.remove('hidden');
        }
        // Sembunyikan form input
        document
          .getElementById("location-wrapper")
          ?.style.setProperty("display", "none");
        document
          .getElementById("search-group")
          ?.style.setProperty("display", "none");
        document
          .getElementById("option-buttons")
          ?.style.setProperty("display", "none");

        // tombol kembali

        if (backBtn) {
          backBtn.classList.remove("hidden");
          backBtn.onclick = () => {
            window.location.href = `/alfaride`;
          };
        }

        pickupLatLng = new google.maps.LatLng(obj?.pickup_lat, obj?.pickup_lng);
        driverLatLng = new google.maps.LatLng(
          obj?.driver_loc_lat,
          obj?.driver_loc_lng
        );
        dstLatLng = new google.maps.LatLng(
          obj?.destination_lat,
          obj?.destination_lng
        );

        let start = null;
        let finish = null;
        if (orderStatus == "driver_to_customer") {
          statusOrderRide = "driver_to_customer";
          document.getElementById("trip-info").style.display = "none";
          document.getElementById("route-card").style.display = "block";
          document.getElementById("driver-info").style.display = "block";
          document.getElementById("driver-status-text").textContent =
            "Driver Menuju Lokasi Anda";
          start = driverLatLng;
          finish = pickupLatLng;
        } else if (orderStatus == "with_customer") {
          statusOrderRide = "with_customer";
          document.getElementById("trip-info").style.display = "none";
          document.getElementById("route-card").style.display = "block";
          document.getElementById("driver-info").style.display = "block";
          document.getElementById("driver-status-text").textContent =
            "Anda sedang bersama driver ke lokasi tujuan";
          start = pickupLatLng;
          finish = dstLatLng;
        } else if (orderStatus == "completed") {
          document.getElementById("trip-info").style.display = "none";
          document.getElementById("route-card").style.display = "block";
          document.getElementById("driver-info").style.display = "block";
          start = pickupLatLng;
          finish = dstLatLng;
          document.getElementById("driver-status-text").textContent =
            "Anda sudah tiba di tujuan.";
        } else if (orderStatus == "cancelled") {
          statusOrderRide = "cancelled";
          document.getElementById("trip-info").style.display = "block";
          document.getElementById("route-card").style.display = "none";
          document.getElementById("driver-info").style.display = "none";
          // document.getElementById("route-card").style.display = "none";
          // document.getElementById("driver-info").style.display = "none";
          ShowRouteInfo(
            obj?.pickup,
            obj?.destination,
            obj?.duration,
            obj?.distance,
            obj?.distance
          );
          start = pickupLatLng;
          finish = dstLatLng;
        }

        document.getElementById("driver-photo").src =
          obj?.photo ||
          "https://img.icons8.com/fluency/96/user-male-circle.png";
        document.getElementById("driver-name").textContent =
          obj?.driver_name || "Driver";
        document.getElementById("vehicle-brand").textContent =
          obj?.driver_tipe_kendaraan || "Motor";
        document.getElementById("vehicle-plate").textContent =
          obj?.driver_no_pol || "BA 1234 XY";
        document.getElementById("driver-rating-value").textContent =
          obj?.rating || "5.0";
        document.getElementById("start-text1").textContent = obj?.pickup;
        document.getElementById("end-text1").textContent = obj?.destination;
        const tarif = Number(obj?.tarif || 0);
        document.getElementById("tarif-text").textContent =
          "Rp " + tarif.toLocaleString("id-ID", { minimumFractionDigits: 0 });

        // alert(`${driver.driverLat}, ${driver.driverLng}`);
        // alert(`${pickupLat}, ${pickupLng}`);
        // Hapus marker lama
        if (endMarker) endMarker.setMap(null);
        endMarker = new google.maps.Marker({
          position: start,
          map,
          icon: {
            path: google.maps.SymbolPath.FORWARD_CLOSED_ARROW,
            scale: 5,
            fillColor: "#1565C0",
            fillOpacity: 1,
            strokeWeight: 1,
            rotation: 0,
            anchor: new google.maps.Point(0, 2.5),
          },
        });

        if (startMarker) startMarker.setMap(null);
        startMarker = new google.maps.Marker({
          position: finish,
          map,
          icon: {
            url: `${baseUrl}/images/4942358.png`,
            scaledSize: new google.maps.Size(50, 50),
          },
        });

        // alert(pickupLatLng);
        calcRoute(start, finish)
          .then(({ durationText, distanceM, distanceKm }) => {
            console.log("🕐 ETA:", durationText);
            console.log("📏 Jarak (m):", distanceM);
            console.log("📏 Jarak (km):", distanceKm);

            const distanceTextEl = document.getElementById(
              "distance-to-customer"
            );
            if (distanceTextEl) {
              distanceTextEl.textContent = `Jarak: ${distanceKm} km`;
            }

            const eta_text = document.getElementById("eta-text");
            if (eta_text) {
              if (orderStatus == "driver_to_customer") {
                eta_text.textContent = `Driver tiba dalam ${durationText}`;
                if (distanceM < 50) {
                  // 📍 Jika driver sudah < 50 meter dari lokasi customer
                  statusTextEl.textContent = "Driver Sudah Tiba di Lokasi Anda";
                } else {
                  // 📍 Jika masih dalam perjalanan
                  statusTextEl.textContent = "Driver Menuju Lokasi Anda";
                }
              } else if (orderStatus == "with_customer") {
                eta_text.textContent = `Sampai di lokasi tujuan dalam ${durationText}`;
              } else if (orderStatus == "completed") {
                eta_text.textContent = `Waktu ${durationText}`;
              }
            }
          })
          .catch((err) => console.error(err));

        // ✅ Resize map sesuai elemen lain

        resizeMapHeight();
      } else {
        console.warn("⚠️ Order ID kosong, driver card tidak akan muncul");
      }
    } else {
      activeInput = "lokasi_awal";
      pickupLat = Latitude;
      pickupLng = Longitude;

      autocompleteAwal = new google.maps.places.Autocomplete(inputAwal);
      autocompleteAkhir = new google.maps.places.Autocomplete(inputAkhir);

      autocompleteAwal.setFields(["name", "formatted_address", "geometry"]);
      autocompleteAkhir.setFields(["name", "formatted_address", "geometry"]);

      // const userPos = { lat: Latitude, lng: Longitude };
      const circle = new google.maps.Circle({
        center: userPos,
        radius: 5000,
      });

      if (autocompleteAwal) autocompleteAwal.setBounds(circle.getBounds());
      if (autocompleteAkhir) autocompleteAkhir.setBounds(circle.getBounds());

      if (startMarker) startMarker.setMap(null);
      startMarker = new google.maps.Marker({
        position: userPos,
        map,
        icon: {
          url: `${baseUrl}/images/6948631.png`,
          scaledSize: new google.maps.Size(40, 40),
        },
      });

      if (inputAwal) {
        startMarker.placeName = inputAwal.value;
      }

      map.setCenter(userPos);
      // calculateRoute();

      autocompleteAwal.addListener("place_changed", () => {
        autocompleteAwalFungsi();
        activeInput = null;
      });

      autocompleteAkhir.addListener("place_changed", () => {
        autocompleteAkhirFungsi();
        activeInput = null;
      });

      getNamaTempat();
    }
  }

  function ShowDriverFromOrder0(dt) {
    if (dt && dt !== "null" && dt !== "[]") {
      let obj = JSON.parse(dt);
      console.log("✅ Parsed:", obj);

      // jika data berupa array
      if (Array.isArray(obj)) {
        obj = obj[0] || {};
      }

      const orderID = obj?.order_id || "";
      console.log("✅ OrderID:", orderID);

      if (orderID !== "") {
        // Sembunyikan form input
        document
          .getElementById("location-wrapper")
          ?.style.setProperty("display", "none");
        document
          .getElementById("search-group")
          ?.style.setProperty("display", "none");
        document
          .getElementById("option-buttons")
          ?.style.setProperty("display", "none");
        document.getElementById("trip-info").style.display = "none";

        document.getElementById("route-card").style.display = "block";
        document.getElementById("driver-info").style.display = "block";

        if ((orderStatus = "diver_to_customer")) {
          statusTextEl.textContent = "Driver Menuju Lokasi Anda";
        } else if ((orderStatus = "with_customer")) {
          statusTextEl.textContent =
            "Anda sedang bersama driver ke lokasi tujuan";
        } else if ((orderStatus = "completed")) {
          statusTextEl.textContent = "Anda sudah tiba di tujuan.";
        }

        document.getElementById("driver-photo").src =
          obj?.photo ||
          "https://img.icons8.com/fluency/96/user-male-circle.png";
        document.getElementById("driver-name").textContent =
          obj?.driver_name || "Driver";
        document.getElementById("vehicle-brand").textContent =
          obj?.driver_tipe_kendaraan || "Motor";
        document.getElementById("vehicle-plate").textContent =
          obj?.driver_no_pol || "BA 1234 XY";
        document.getElementById("driver-rating-value").textContent =
          obj?.rating || "5.0";
        document.getElementById("start-text1").textContent = obj?.pickup;
        document.getElementById("end-text1").textContent = obj?.destination;
        document.getElementById("tarif-text").textContent =
          "Rp " + obj?.tarif.toLocaleString("id-ID");

        // tombol kembali
        const backBtn = document.getElementById("back-btn");
        if (backBtn) {
          backBtn.classList.remove("hidden");
          backBtn.onclick = () => {
            window.location.href = `/alfaride`;
          };
        }

        pickupLatLng = new google.maps.LatLng(obj?.pickup_lat, obj?.pickup_lng);
        driverLatLng = new google.maps.LatLng(
          obj?.driver_loc_lat,
          obj?.driver_loc_lng
        );
        dstLatLng = new google.maps.LatLng(
          obj?.destination_lat,
          obj?.destination_lng
        );
        alert(pickupLatLng);
        // alert(`${driver.driverLat}, ${driver.driverLng}`);
        // alert(`${pickupLat}, ${pickupLng}`);
        // Hapus marker lama

        if (endMarker) endMarker.setMap(null);
        endMarker = new google.maps.Marker({
          position: driverLatLng,
          map,
          icon: {
            path: google.maps.SymbolPath.FORWARD_CLOSED_ARROW,
            scale: 5,
            fillColor: "#1565C0",
            fillOpacity: 1,
            strokeWeight: 1,
            rotation: 0,
            anchor: new google.maps.Point(0, 2.5),
          },
        });

        if (startMarker) startMarker.setMap(null);
        startMarker = new google.maps.Marker({
          position: pickupLatLng,
          map,
          icon: {
            url: `${baseUrl}/images/4942358.png`,
            scaledSize: new google.maps.Size(50, 50),
          },
        });

        // alert(pickupLatLng);
        calcRoute(driverLatLng, pickupLatLng)
          .then(({ durationText, distanceM, distanceKm }) => {
            console.log("🕐 ETA:", durationText);
            console.log("📏 Jarak (m):", distanceM);
            console.log("📏 Jarak (km):", distanceKm);

            const eta_text = document.getElementById("eta-text");
            if (eta_text) {
              eta_text.textContent = `Driver tiba dalam ${durationText}`;
            }

            const distanceTextEl = document.getElementById(
              "distance-to-customer"
            );
            if (distanceTextEl) {
              distanceTextEl.textContent = `Jarak: ${distanceKm} km`;
            }

            if (distanceM < 50) {
              // 📍 Jika driver sudah < 50 meter dari lokasi customer
              statusTextEl.textContent = "Driver Sudah Tiba di Lokasi Anda";
            } else {
              // 📍 Jika masih dalam perjalanan
              statusTextEl.textContent = "Driver Menuju Lokasi Anda";
            }
          })
          .catch((err) => console.error(err));

        // ✅ Resize map sesuai elemen lain

        resizeMapHeight();
      } else {
        console.warn("⚠️ Order ID kosong, driver card tidak akan muncul");
      }
    } else {
      console.warn("⚠️ Data order kosong / tidak dikirim dari server");
    }
  }

  async function getNamaTempat() {
    const getLocation = await getCurrentLocationFetchOnly();
    const status = getLocation.status;

    if (status === "OK" && getLocation.results.length > 0) {
      const fullAddress = getLocation.results[0].formatted_address;
      // alert(fullAddress);

      const parts = fullAddress.split(",");

      // regex plus code (contoh: 39FQ+87M)
      const plusCodeRegex = /^[A-Z0-9]{4}\+[A-Z0-9]{2,}$/i;

      let shortAddress = parts[0].trim();

      // kalau alamat pertama adalah plus code → pakai alamat kedua
      if (plusCodeRegex.test(shortAddress) && parts.length > 1) {
        shortAddress = parts[1].trim();
      }

      // Ambil bagian pertama sebelum koma
      // const shortAddress = fullAddress.split(",")[0];

      if (locationText) locationText.textContent = shortAddress;
      if (locationText) {
        locationText.textContent = shortAddress;
        startMarker.placeName = shortAddress;
      }
      if (inputAwal) {
        // activeInput = "lokasi_awal";
        // inputAwal.value = shortAddress;
        inputAwal.value = "Lokasi saya";
        // activeInput.focus();
      }
    } else {
      // if (locationText)
      //     locationText.textContent = `Lat: ${Latitude}, Lon: ${Longitude}`;

      if (locationText) locationText.textContent = locationText.textContent;
    }
    try {
    } catch (err) {
      // console.error("Error geocoding:", err);
      NotifAndroidApp("Error geocoding", err);
      // if (locationText)
      //     locationText.textContent = `Lat: ${Latitude}, Lon: ${Longitude}`;
    }
  }

  // === Konfigurasi dari server ===
  // CI4: kirim saldo user ke view, misal $saldo berasal dari DB
  // const AG_SALDO = Number("<?= isset($saldo) ? (int) $saldo : 0 ?>") || 0;

  // Buka overlay (panggil dari onclick di kartu tarif)
  window.openPaymentOverlay = function () {
    if (orderBtn.textContent.trim() !== "Pesan Sekarang") return;

    const overlay = document.getElementById("payment-overlay");
    // set total dari #total-text
    const totalText = (
      document.getElementById("total-text")?.innerText || "Rp 0"
    ).trim();
    document.getElementById("ag-total-due").innerText = totalText;

    // set nominal di item Tunai & QRIS = total
    document.getElementById("ag-amount-cash").innerText = totalText;
    document.getElementById("ag-amount-qris").innerText = totalText;

    // set SALDO dari DB
    document.getElementById("ag-amount-saldo").innerText =
      formatRupiah(AG_SALDO);

    // validasi saldo vs total
    const totalNumber = parseRupiah(totalText);
    const saldoItem = document.getElementById("ag-item-saldo");

    const warnSaldo = document.getElementById("ag-warn-saldo");
    if (AG_SALDO < totalNumber) {
      saldoItem.classList.add("ag-insufficient");
      warnSaldo.style.display = "inline-block";
      document.getElementById("ag-confirm-btn").classList.remove("ag-disabled"); // tombol tetap aktif; validasi akhir saat pilih
    } else {
      saldoItem.classList.remove("ag-insufficient");
      warnSaldo.style.display = "none";
    }

    overlay.classList.add("ag-show");
    document.body.style.overflow = "hidden";
  };

  window.closePaymentOverlay = function () {
    document.getElementById("payment-overlay").classList.remove("ag-show");
    document.body.style.overflow = "";
  };

  // pilih metode

  window.selectPaymentAG = function (method) {
    agSelectedMethod = method;

    // highlight item aktif
    document.querySelectorAll(".ag-item").forEach((el) => {
      el.style.outline = "";
      el.style.background = "";
    });
    const current = document.querySelector(`.ag-item[data-method="${method}"]`);
    if (current) {
      current.style.outline = "2px solid rgba(22,160,133,.55)";
      current.style.background = "#f2fbf8";
    }
  };

  // konfirmasi pemilihan
  window.confirmPaymentAG = function () {
    if (!agSelectedMethod) {
      // pilih default ke tunai jika user langsung tekan
      agSelectedMethod = "Tunai";
    }

    // jika saldo terpilih tapi kurang
    if (agSelectedMethod === "Saldo") {
      const totalNumber = parseRupiah(
        (document.getElementById("total-text")?.innerText || "Rp 0").trim()
      );
      if (AG_SALDO < totalNumber) {
        // beri efek shake kecil
        const itemSaldo = document.getElementById("ag-item-saldo");
        itemSaldo.animate(
          [
            { transform: "translateX(0)" },
            { transform: "translateX(-6px)" },
            { transform: "translateX(6px)" },
            { transform: "translateX(0)" },
          ],
          { duration: 300, easing: "ease" }
        );
        return; // stop, tidak tutup overlay
      }
    }

    // Tulis pilihan ke kartu utama
    const target =
      document.getElementById("payment-method") ||
      document.getElementById("payment-method-main");
    if (target) target.innerText = agSelectedMethod;

    // (opsional) simpan ke variabel tersembunyi / kirim ke server
    // document.getElementById('payment_method_input').value = agSelectedMethod;

    closePaymentOverlay();
  };

  // util: parse/tulis rupiah
  function parseRupiah(str) {
    // ambil angka saja
    const num = (str || "").toString().replace(/[^0-9]/g, "");
    return Number(num || 0);
  }
  function formatRupiah(num) {
    try {
      const n = Number(num || 0);
      return "Rp " + n.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ".");
    } catch (e) {
      return "Rp 0";
    }
  }

  // ESC untuk tutup
  window.addEventListener("keydown", (e) => {
    if (e.key === "Escape") {
      const ov = document.getElementById("payment-overlay");
      if (ov && ov.classList.contains("ag-show")) closePaymentOverlay();
    }
  });

  // Integrasi dengan kartu tarif kamu:
  // ganti openPaymentPopup() lama → openPaymentOverlay()
  window.openPaymentPopup = openPaymentOverlay; // backward-compat jika sudah dipakai
});

if (inputAwal) {
  inputAwal.addEventListener("focus", () => {
    activeInput = "lokasi_awal";
    // Hapus marker lama
    if (startMarker) {
      startMarker.setMap(null);
      startMarker = null;
    }

    routeCard.style.display = "none"; // pastikan card tampil
    if (directionsRenderer) {
      directionsRenderer.setMap(null); // Menghapus garis rute
    }

    // alert("Input Awal Focus");
    if (inputAwal !== "") {
      inputAwal.value = ""; // kosongkan input
    }
    resizeMapHeight();
  });
}

if (inputAkhir) {
  inputAkhir.addEventListener("focus", () => {
    if (inputAkhir !== "") {
      inputAkhir.value = ""; // kosongkan input
    }
    activeInput = "lokasi_akhir";

    // Hapus marker lama
    if (endMarker) {
      endMarker.setMap(null);
      endMarker = null;
    }

    routeCard.style.display = "none"; // pastikan card tampil
    if (directionsRenderer) {
      directionsRenderer.setMap(null); // Menghapus garis rute
    }
    resizeMapHeight();
  });
}

function autocompleteAwalFungsi() {
  const place = autocompleteAwal.getPlace();
  if (!place.geometry) return;

  // Pilih nama tempat (lebih singkat) atau alamat kalau tidak ada nama
  const displayName = place.name || place.formatted_address;
  // window.AndroidApp.showSnack(displayName);

  // Set langsung ke input agar tampil nama tempat, bukan alamat panjang
  document.getElementById("lokasi_awal").value = displayName;

  const lat = place.geometry.location.lat();
  const lng = place.geometry.location.lng();

  window.AndroidApp.sendLocationToServerFromWebview(lat, lng);

  // 🔥 Hapus marker user location kalau ada
  if (userMarker) {
    userMarker.setMap(null);
    userMarker = null;
  }

  // Hapus marker lama
  if (startMarker) {
    startMarker.setMap(null);
    startMarker = null;
  }

  // Membuat marker start
  startMarker = new google.maps.Marker({
    position: place.geometry.location,
    map,
    icon: {
      url:`${baseUrl}/images/6948631.png`,
      scaledSize: new google.maps.Size(50, 50),
    },
  });

  // Simpan nama tempat di marker untuk ditampilkan di info rute
  startMarker.placeName = displayName;

  map.setCenter(place.geometry.location);
  // calculateRoute();

  const pos_pickup = startMarker.getPosition(); // LatLng object
  pickupLat = pos_pickup.lat();
  pickupLng = pos_pickup.lng();

  if (startMarker && endMarker) {
    calcRoute(startMarker.position, endMarker.position)
      .then(({ durationText, distanceM, distanceKm }) => {
        ShowRouteInfo(
          startMarker.placeName,
          endMarker.placeName,
          durationText,
          distanceM,
          distanceKm
        );
      })
      .catch((err) => console.error(err));
  }
}

function autocompleteAkhirFungsi() {
  // window.AndroidApp.showSnack("autocompleteAkhirFungsi");
  const place = autocompleteAkhir.getPlace();
  if (!place.geometry) return;

  // Pilih nama tempat (lebih singkat) atau alamat kalau tidak ada nama
  const displayName = place.name || place.formatted_address;
  // window.AndroidApp.showSnack(displayName);

  // Set langsung ke input agar tampil nama tempat, bukan alamat panjang
  inputAkhir.value = displayName;

  // 🔥 Hapus marker user location kalau ada
  if (userMarker) {
    userMarker.setMap(null);
    userMarker = null;
  }

  // Hapus marker lama
  if (endMarker) {
    endMarker.setMap(null);
    endMarker = null;
  }

  // Membuat marker start
  endMarker = new google.maps.Marker({
    position: place.geometry.location,
    map,
    icon: finishIcon,
  });

  // Simpan nama tempat di marker untuk ditampilkan di info rute
  endMarker.placeName = displayName;

  map.setCenter(place.geometry.location);

  const pos_dst = endMarker.getPosition(); // LatLng object
  dstLat = pos_dst.lat();
  dstLng = pos_dst.lng();
  // calculateRoute();
  if (startMarker && endMarker) {
    calcRoute(startMarker.position, endMarker.position)
      .then(({ durationText, distanceM, distanceKm }) => {
        ShowRouteInfo(
          startMarker.placeName,
          endMarker.placeName,
          durationText,
          distanceM,
          distanceKm
        );
      })
      .catch((err) => console.error(err));
  }
}
function ShowRouteInfo(start, end, durationText, distanceM, distanceKm) {
  // startText.textContent = startMarker.placeName;
  // endText.textContent = endMarker.placeName;
  startText.textContent = start;
  endText.textContent = end;
  distance.textContent = `${distanceKm} Km`;
  duration.textContent = durationText;
  const biaya = hitungOngkos(distanceKm);
  const biayaAplikasi = 1000;
  totalBiaya = biaya + biayaAplikasi;
  biayaTotal.textContent = "Rp " + totalBiaya.toLocaleString("id-ID");
  routeCard.style.display = "block"; // pastikan card tampil

  jarakKm = distanceM / 1000; // jarak dalam km

  // const totalBiaya = Math.round(biayaPerKm * jarakKm + biayaAplikasi);

  // Ganti kata
  // durationText = durationText;

  resizeMapHeight();
}

if (inputAwalClose) {
  inputAwalClose.addEventListener("click", () => {
    inputAwal.value = "";
    inputAwal.focus();

    // 🔥 Hapus marker user location kalau ada
    if (userMarker) {
      userMarker.setMap(null);
      userMarker = null;
    }

    // Hapus marker lama
    if (startMarker) {
      startMarker.setMap(null);
      startMarker = null;
    }

    if (directionsRenderer) {
      directionsRenderer.setMap(null); // Menghapus garis rute
    }
  });
}

if (inputAkhirClose) {
  inputAkhirClose.addEventListener("click", () => {
    inputAkhir.value = "";
    inputAkhir.focus();

    // 🔥 Hapus marker user location kalau ada
    if (userMarker) {
      userMarker.setMap(null);
      userMarker = null;
    }

    // Hapus marker lama
    if (endMarker) {
      endMarker.setMap(null);
      endMarker = null;
    }

    routeCard.style.display = "none"; // pastikan card tampil
    if (directionsRenderer) {
      directionsRenderer.setMap(null); // Menghapus garis rute
    }
  });
}

if (orderBtn) {
  let time = 3;
  let cancelTimer = null;
  let cancelTimeLeft = time;
  let isPendingCancel = false;

  orderBtn.onclick = null; // reset listener sebelumnya
  orderBtn.onclick = () => {
    if (!cekWSS()) {
      showModal(
        "Warning",
        "Warning",
        "Ada kendala jaringan ke server. Silahkan coba lagi nanti."
      );
      return;
    }

    document.getElementById("location-wrapper").classList.add("hidden");
    document.getElementById("search-group").classList.add("hidden");
    document.getElementById("option-buttons").classList.add("hidden");
    btnCenterMaps.classList.add("hidden");

    resizeMapHeight();

    // 📌 Jika tombol ditekan kedua kali saat countdown → Batalkan order
    if (isPendingCancel) {
      clearInterval(cancelTimer);
      isPendingCancel = false;
      cancelTimeLeft = time;

      // ✅ Reset tombol ke awal
      btnText.textContent = "Pesan Sekarang";
      btnSpinner.hidden = true;
      orderBtn.disabled = false;
      orderBtn.classList.remove("loading");

      document.getElementById("location-wrapper").classList.remove("hidden");

      // document.getElementById("location-wrapper")?.style.setProperty("display", "show");
      document.getElementById("search-group").classList.remove("hidden");
      document.getElementById("option-buttons").classList.remove("hidden");
      btnCenterMaps.classList.remove("hidden");

      resizeMapHeight();

      // alert("❌ Pesanan dibatalkan!");
      return;
    }

    // 📌 Pertama kali ditekan → masuk mode countdown batal
    isPendingCancel = true;
    cancelTimeLeft = time;
    btnText.textContent = `Batalkan... (${cancelTimeLeft})`;

    cancelTimer = setInterval(() => {
      cancelTimeLeft--;
      btnText.textContent = `Batalkan... (${cancelTimeLeft})`;

      // ⏱️ Jika sudah habis 5 detik → lanjut proses order
      if (cancelTimeLeft <= 0) {
        clearInterval(cancelTimer);
        isPendingCancel = false;

        // const token = localStorage.getItem('authToken');

        // fetch(`${urlAPI}api/order/new`, {
        //     method: "POST",
        //     headers: {
        //         "Content-Type": "application/json",
        //         "Authorization": `Bearer ${tokenAPI}`
        //     },
        //     body: JSON.stringify({
        //         order_type: "ride",
        //         customer_phone: phone,
        //         customer_name: "",
        //         pickup: startMarker.placeName || route.start_address,
        //         destination: endMarker.placeName,
        //         pickup_lat: pickupLat,
        //         pickup_lng: pickupLng,
        //         dst_lat: dstLat,
        //         dst_lng: dstLng,
        //         distance: jarakKm,
        //         duration: durationText,
        //         price: totalBiaya
        //     })

        // })
        //     .then(async res => {
        //         // alert("📩 Response Status: " + res.status);

        //         const text = await res.text();
        //         // alert("📨 Response Body:" + text);

        //         if (!res.ok) {
        //             throw new Error(`❌ Gagal kirim order: ${text}`);
        //         }
        //         return JSON.parse(text);
        //     })
        //     .then(data => {
        //         console.log("✅ Order berhasil dikirim:", data);
        //         // alert("🚀 Order berhasil dibuat!");
        //     })
        //     .catch(err => {
        //         console.error("⚠️ Terjadi kesalahan:", err);
        //         alert(`Gagal kirim order: ${err.message}`);
        //     });

        // ✅ Lanjut ke proses order asli

        window.AndroidApp.sendMessageToServerFromWebview(
          "order",
          "ride",
          JSON.stringify({
            action: "new",
            customer_phone: phone,
            lokasi_awal: startMarker.placeName || route.start_address,
            lokasi_awal_address : PickupSecondAddress,
            lokasi_akhir: endMarker.placeName,
            jarak: jarakKm,
            ongkos: biaya,
            biaya_aplikasi: biayaAplikasi,
            biaya_total: totalBiaya,
            waktu: durationText,
            pickup_lat: pickupLat,
            pickup_lng: pickupLng,
            dst_lat: dstLat,
            dst_lng: dstLng,
            payment_metode: agSelectedMethod,
          })
        );

        // ✅ Ubah tombol ke status "mencari driver"
        btnSpinner.hidden = false;
        orderBtn.classList.add("loading");
        btnText.textContent = "Mencari Driver...";
        orderBtn.disabled = true;
      }
    }, 1000);
  };
}

window.addEventListener("msgFromServer", function (e) {
  const data = e.detail;
  const msgType = data.action;
  const msg = data.message;

  // alert(msgType);
  if (msgType == "ride_accept") {
    // alert("ride_accept");
    statusOrderRide = "ride_accept";
    // Sembunyikan form pencarian
    document
      .getElementById("location-wrapper")
      ?.style.setProperty("display", "none");
    document
      .getElementById("search-group")
      ?.style.setProperty("display", "none");
    document
      .getElementById("option-buttons")
      ?.style.setProperty("display", "none");

    // Ubah card menjadi mode driver
    showDriverInfo(msg);
    // alert(message.customerLng);
    // alert("accept");
  } else if (msgType == "driver_to_customer") {
    statusOrderRide = "driver_to_customer";
    // alert("driver_to_customer");
  } else if (msgType == "with_customer") {
    statusOrderRide = "with_customer";

    if (startMarker) startMarker.setMap(null);
    startMarker = new google.maps.Marker({
      position: dstLatLng,
      map,
      icon: {
        url: `${baseUrl}/images/4942358.png`,
        scaledSize: new google.maps.Size(50, 50),
      },
    });

    calcRoute(driverLatLng, dstLatLng)
      .then(({ durationText, distanceM, distanceKm }) => {
        console.log("🕐 ETA:", durationText);
        console.log("📏 Jarak (m):", distanceM);
        console.log("📏 Jarak (km):", distanceKm);

        if (eta_text) {
          eta_text.textContent = `Tiba di tujuan dalam ${durationText}`;
        }

        if (distanceTextEl) {
          distanceTextEl.textContent = `Jarak: ${distanceKm} km`;
        }

        if (distanceM < 50) {
          // 📍 Jika driver sudah < 50 meter dari lokasi customer
          statusTextEl.textContent = "Anda sudah tiba di tujuan.";
        } else {
          // 📍 Jika masih dalam perjalanan
          statusTextEl.textContent = "Anda bersama driver menuju lokasi tujuan";
        }
      })
      .catch((err) => console.error(err));

    resizeMapHeight();
  } else if (msgType == "completed") {
    statusTextEl.textContent = "Anda sudah tiba di tujuan.";
    // alert(msg.order_id);
    window.location.href = `/driver/review?order=${msg.order_id}`;
  } else if (msgType == "ride_order_cancel") {
    // ✅ Reset tombol ke awal
    btnText.textContent = "Pesan Sekarang";
    btnSpinner.hidden = true;
    orderBtn.disabled = false;
    orderBtn.classList.remove("loading");

    document.getElementById("location-wrapper").classList.remove("hidden");

    // document.getElementById("location-wrapper")?.style.setProperty("display", "show");
    document.getElementById("search-group").classList.remove("hidden");
    document.getElementById("option-buttons").classList.remove("hidden");
    btnCenterMaps.classList.remove("hidden");
    resizeMapHeight();
  } else if (msgType == "ride_order_new") {
    // Simpan data order sementara sebelum redirect
    sessionStorage.setItem("pendingOrder", JSON.stringify(msg));

    // Jika bukan di /driver, redirect
    if (window.location.pathname !== "/driver") {
      window.location.href = "/driver/review?order=";
    } else {
      // Jika sudah di /driver langsung jalankan
      showOrder(msg);
    }
  } else if (msgType == "driver_location") {
    const lat = msg.driver_lat;
    const lng = msg.driver_lng;

    if (map && statusOrderRide != null) {
      const newPos = new google.maps.LatLng(lat, lng);
      if (!driverMarker) {
        driverMarker = new google.maps.Marker({
          position: newPos,
          map: map,
          icon: {
            path: google.maps.SymbolPath.FORWARD_CLOSED_ARROW,
            scale: 5,
            fillColor: "#1565C0",
            fillOpacity: 1,
            strokeWeight: 1,
            rotation: 0,
            anchor: new google.maps.Point(0, 2.5),
          },
          title: "📍 Lokasi Driver",
        });

        lastDriverPosition = newPos;
        updateRouteFirstThenMove(newPos); // langsung gambar rute pertama kali
        return;
      }

      updateDriverLocation(lat, lng);
    }
  } else if (msgType == "cek_data" && msg.user.saldo) {
    AG_SALDO = Number(msg.user.saldo);
  }
});
function updateDriverRatingUI(rating) {
  const ratingElement = document.getElementById("driver-rating-value");
  const container = document.querySelector(".driver-performance");
  const star = container.querySelector("i");

  // Pastikan nilai numerik
  rating = parseFloat(rating) || 0;
  ratingElement.textContent = rating.toFixed(1);

  // Default: belum ada rating
  let bgColor = "#f1f1f1";
  let starColor = "#999";
  let textColor = "#666";

  if (rating > 0) {
    if (rating >= 4.5) {
      bgColor = "#d4edda"; // hijau muda
      starColor = "#2e7d32"; // hijau tua
    } else if (rating >= 3.5) {
      bgColor = "#fff3cd"; // kuning lembut
      starColor = "#b58900"; // emas
    } else if (rating >= 2) {
      bgColor = "#ffe5b4"; // oranye lembut
      starColor = "#e67e22"; // oranye
    } else {
      bgColor = "#f8d7da"; // merah muda
      starColor = "#c0392b"; // merah tua
    }
  }

  // Terapkan style ke elemen
  // container.style.backgroundColor = bgColor;
  container.style.color = textColor;
  star.style.color = starColor;
  ratingElement.style.color = starColor;
}

// 🔹 Contoh pemanggilan
// Saat data driver diterima:
const driver = {
  driverRating: 4.6, // contoh data dari API
};

// Panggil fungsi update
updateDriverRatingUI(driver.driverRating);

function showDriverInfo(driver) {
  document.getElementById("trip-info").style.display = "none";
  const driverCard = document.getElementById("driver-info");
  driverCard.style.display = "block";

  if (backBtn) {
    backBtn.classList.remove("hidden");

    backBtn.onclick = () => {
      showLoading();
      window.location.href = `/alfaride`;
    };
  }

  if (btnCenterMaps) {
    btnCenterMaps.classList.add("hidden");
    // btnCenterMaps.classList.remove('hidden');
  }
  updateDriverRatingUI(driver.driverRating);
  document.getElementById("driver-photo").src =
    driver.photo || "https://img.icons8.com/fluency/96/user-male-circle.png";
  document.getElementById("driver-name").textContent =
    driver.driverName || "Driver";
  document.getElementById("vehicle-brand").textContent =
    driver.driverTipeKendaraan || "Motor";
  document.getElementById("vehicle-plate").textContent =
    driver.driverNoPol || "BA 1234 XY";
  // document.getElementById("driver-rating-value").textContent =
  //   driver.driverRating || "0";
  document.getElementById("start-text1").textContent = driver.pickup;
  document.getElementById("end-text1").textContent = driver.destination;
  document.getElementById("tarif-text").textContent =
    "Rp " + driver.price.toLocaleString("id-ID");

  pickupLatLng = new google.maps.LatLng(pickupLat, pickupLng);
  driverLatLng = new google.maps.LatLng(driver.driverLat, driver.driverLng);
  dstLatLng = new google.maps.LatLng(dstLat, dstLng);

  // alert(`${driver.driverLat}, ${driver.driverLng}`);
  // alert(`${pickupLat}, ${pickupLng}`);
  // Hapus marker lama

  if (endMarker) endMarker.setMap(null);
  endMarker = new google.maps.Marker({
    position: driverLatLng,
    map,
    icon: {
      path: google.maps.SymbolPath.FORWARD_CLOSED_ARROW,
      scale: 5,
      fillColor: "#1565C0",
      fillOpacity: 1,
      strokeWeight: 1,
      rotation: 0,
      anchor: new google.maps.Point(0, 2.5),
    },
  });

  if (startMarker) startMarker.setMap(null);
  startMarker = new google.maps.Marker({
    position: pickupLatLng,
    map,
    icon: {
      url: `${baseUrl}/images/4942358.png`,
      scaledSize: new google.maps.Size(50, 50),
    },
  });

  if (!startMarker || !endMarker) return;

  calcRoute(driverLatLng, pickupLatLng)
    .then(({ durationText, distanceM, distanceKm }) => {
      console.log("🕐 ETA:", durationText);
      console.log("📏 Jarak (m):", distanceM);
      console.log("📏 Jarak (km):", distanceKm);

      const eta_text = document.getElementById("eta-text");
      if (eta_text) {
        eta_text.textContent = `Driver tiba dalam ${durationText}`;
      }

      const distanceTextEl = document.getElementById("distance-to-customer");
      if (distanceTextEl) {
        distanceTextEl.textContent = `Jarak: ${distanceKm} km`;
      }

      const statusTextEl = document.getElementById("driver-status-text");
      if (distanceM < 50) {
        // 📍 Jika driver sudah < 50 meter dari lokasi customer
        statusTextEl.textContent = "Driver Sudah Tiba di Lokasi Anda";
      } else {
        // 📍 Jika masih dalam perjalanan
        statusTextEl.textContent = "Driver Menuju Lokasi Anda";
      }
    })
    .catch((err) => console.error(err));

  // ✅ Resize map sesuai elemen lain

  resizeMapHeight();
}
function calcRouteDriver(startPosition, endPosition) {
  return new Promise((resolve, reject) => {
    directionsService.route(
      {
        origin: startPosition,
        destination: endPosition,
        travelMode: google.maps.TravelMode.DRIVING,
      },
      (result, status) => {
        if (status === "OK") {
          const route = result.routes[0].legs[0];

          const waktu = route.duration.text
            .replace(/\bhours?\b/, "jam")
            .replace(/\bmins?\b/, "menit");

          let durationText = waktu;

          let distanceM = route.distance.value.toFixed(1);
          let distanceKm = (route.distance.value / 1000).toFixed(1);

          resolve({ durationText, distanceM, distanceKm });
        } else {
          reject("Gagal menghitung rute: " + status);
        }
      }
    );
  });
}
async function chooseCurrentLocation() {
  if (!activeInput)
    return showModal(
      "Warning",
      "Warning",
      "Silakan pilih input lokasi awal atau akhir dulu"
    );

  // const userPos = { lat: Latitude, lng: Longitude };
  // window.AndroidApp.showSnack(JSON.stringify(userPos));

  if (window.AndroidApp) {
    window.AndroidApp.requestLocation();
  }

  // ✅ tunggu hasil fetch
  const getLocation = await getCurrentLocationFetchOnly();

  const status = getLocation.status; // status ada langsung di root JSON
  // window.AndroidApp.showSnack(`Status: ${status}`);

  if (status === "OK" && getLocation.results.length > 0) {
    const fullAddress = getLocation.results[0].formatted_address;
    // window.AndroidApp.showSnack(`Alamat: ${fullAddress}`);

    // Ambil bagian pertama sebelum koma
    shortAddress = fullAddress.split(",")[0];

    if (locationText) {
      locationText.textContent = shortAddress;
    }

    if (activeInput === "lokasi_awal") {
      inputAwal.value = shortAddress;
      if (startMarker) startMarker.setMap(null);
      startMarker = new google.maps.Marker({
        position: { lat: Latitude, lng: Longitude },
        map,
        icon: {
          url: IconMarker("lokasi_awal"),
          scaledSize: new google.maps.Size(40, 40),
        },
      });
      startMarker.placeName = inputAwal.value;
      // inputAwal.focus();
    } else if (activeInput === "lokasi_akhir") {
      inputAkhir.value = shortAddress;
      if (endMarker) endMarker.setMap(null);
      endMarker = new google.maps.Marker({
        position: { lat: Latitude, lng: Longitude },
        map,
        icon: {
          url: IconMarker("lokasi_akhir"),
          scaledSize: new google.maps.Size(40, 40),
        },
      });
      endMarker.placeName = inputAkhir.value;
      // inputAkhir.focus();
    }
    map.setCenter({ lat: Latitude, lng: Longitude });
    // calculateRoute();
    if (startMarker && endMarker) {
      calcRoute(startMarker.position, endMarker.position)
        .then(({ durationText, distanceM, distanceKm }) => {
          ShowRouteInfo(
            startMarker.placeName,
            endMarker.placeName,
            durationText,
            distanceM,
            distanceKm
          );
        })
        .catch((err) => console.error(err));
    }

    activeInput = null;
  } else {
    locationText.textContent = `Lat: ${Latitude}, Lon: ${Longitude}`;
  }
}
function chooseFromMap() {
  // alert(activeInput);
  if (!activeInput) {
    // showFullscreenNotif("info", "Silakan pilih input lokasi awal atau akhir dulu");
    // Untuk info biasa
    showModal(
      "Warning",
      "Pilih lokasi",
      "Silakan pilih input lokasi awal atau akhir dulu"
    );
    return;
  }

  const initialCenter = map.getCenter();

  // buat marker sesuai input
  if (activeInput === "lokasi_awal") {
    if (startMarker) startMarker.setMap(null);
    startMarker = new google.maps.Marker({
      position: initialCenter,
      map: map,
      icon: {
        url: IconMarker("lokasi_awal"),
        scaledSize: new google.maps.Size(40, 40),
      },
    });
  } else if (activeInput === "lokasi_akhir") {
    if (endMarker) endMarker.setMap(null);
    endMarker = new google.maps.Marker({
      position: initialCenter,
      map: map,
      icon: {
        url: IconMarker("lokasi_akhir"),
        scaledSize: new google.maps.Size(40, 40),
      },
    });
  }

  // marker mengikuti center map
  google.maps.event.addListener(map, "center_changed", () => {
    const center = map.getCenter();
    if (activeInput === "lokasi_awal" && startMarker) {
      startMarker.setPosition(center);
    } else if (activeInput === "lokasi_akhir" && endMarker) {
      endMarker.setPosition(center);
    }
  });

  // ambil alamat saat map idle
  google.maps.event.addListener(map, "idle", () => {
    if (!activeInput) return;

    if (idleTimeout) clearTimeout(idleTimeout);

    idleTimeout = setTimeout(() => {
      const chosenLatLng = map.getCenter();
      const geocoder = new google.maps.Geocoder();

      const lat = chosenLatLng.lat();
      const lng = chosenLatLng.lng();

      window.AndroidApp.sendLocationToServerFromWebview(lat, lng);

      geocoder.geocode({ location: chosenLatLng }, (results, status) => {
        if (status === "OK" && results[0]) {
          const placeName = results[0].formatted_address;
          document.getElementById(activeInput).value = placeName;

          if (activeInput === "lokasi_awal" && startMarker) {
            startMarker.placeName = placeName;
          } else if (activeInput === "lokasi_akhir" && endMarker) {
            endMarker.placeName = placeName;
          }

          // hitung rute kalau dua marker sudah ada
          // calculateRoute();
          calcRoute(startMarker.position, endMarker.position)
            .then(({ durationText, distanceM, distanceKm }) => {
              ShowRouteInfo(
                startMarker.placeName,
                endMarker.placeName,
                durationText,
                distanceM,
                distanceKm
              );
            })
            .catch((err) => console.error(err));
          // reset setelah selesai pilih
          activeInput = null;
        }
      });
    }, 1000); // delay 2 detik setelah map berhenti digeser
  });
}
