document.addEventListener("DOMContentLoaded", () => {
  AndroidApp.hideBottomNav();
  const cart = {};
  const cartOverlay = document.getElementById("cartOverlay");

  document.querySelectorAll(".menu-card").forEach((card) => {
    const id = card.dataset.id;
    const name = card.dataset.name;
    const price = parseInt(card.dataset.price);
    const addBtn = card.querySelector(".menu-add-btn");
    const actionEl = card.querySelector(".menu-action");
    const qtyEl = card.querySelector(".menu-qty");
    const plusBtn = card.querySelector(".btn-plus");
    const minusBtn = card.querySelector(".btn-minus");
    const noteIcon = card.querySelector(".note-icon");
    const noteBox = card.querySelector(".menu-note textarea");

    let qty = 0;

    noteIcon.style.display = "none";

    addBtn.addEventListener("click", () => {
      qty = 1;
      addBtn.style.display = "none";
      actionEl.style.display = "flex";

      // ✅ tampilkan icon catatan dengan warna tema AlfaGo
      noteIcon.style.display = "inline-block";
      noteIcon.style.color = "#16a085";
      noteIcon.classList.add("visible"); // untuk animasi fade-in ringan

      updateCart();
    });

    plusBtn.addEventListener("click", () => {
      qty++;
      qtyEl.textContent = qty;
      updateCart();
    });

    minusBtn.addEventListener("click", () => {
      qty--;
      if (qty <= 0) {
        qty = 0;
        addBtn.style.display = "block";
        actionEl.style.display = "none";
        noteIcon.style.display = "none";
        noteBox.value = "";
        removeFromCart();
        card.querySelector(".menu-note").style.display = "none";
      } else {
        qtyEl.textContent = qty;
        updateCart();
      }
    });

    noteIcon.addEventListener("click", () => {
      const noteContainer = card.querySelector(".menu-note");
      noteContainer.style.display =
        noteContainer.style.display === "block" ? "none" : "block";
    });

    noteBox.addEventListener("input", function () {
      // 🟢 Auto-resize tinggi note
      this.style.height = "auto"; // reset dulu agar bisa shrink
      this.style.height = this.scrollHeight + "px"; // sesuaikan tinggi dengan isi

      updateCart(); // simpan isi ke cart
    });

    function updateCart() {
      const wrapper = document.querySelector(".menu-wrapper");
      const restaurant_id = wrapper.dataset.restaurantId;
      const restaurant_name = wrapper.dataset.restaurantName;

      cart[id] = {
        id,
        name,
        price,
        qty,
        note: noteBox.value.trim() || "",
      };

      localStorage.setItem(
        "cartData",
        JSON.stringify({
          restaurant_id,
          restaurant_name,
          items: Object.values(cart),
        })
      );
      renderOverlay();
    }

    function removeFromCart() {
      delete cart[id];
      renderOverlay();
      if (Object.keys(cart).length === 0) {
        localStorage.removeItem("cartData");
      }
    }
  });

  // 🔹 Render overlay dengan tampilan AlfaGo style

  function renderOverlay() {
    const items = Object.values(cart);
    const totalQty = items.reduce((sum, i) => sum + i.qty, 0);
    const totalPrice = items.reduce((sum, i) => sum + i.qty * i.price, 0);

    // 🟢 Buat overlay hanya sekali — tidak rebuild setiap kali
    if (!cartOverlay.dataset.initialized) {
      cartOverlay.className = "floating-cart-overlay";
      cartOverlay.innerHTML = `
      <div class="floating-cart-content">
        <div class="cart-info">
          <div class="cart-icon"><i class="fa-solid fa-basket-shopping"></i></div>
          <div class="cart-text">
            <strong>Lihat Pesanan</strong>
            <small><span class="cart-count">0 item</span> • Rp <span class="cart-total">0</span></small>
          </div>
        </div>
        <div class="cart-arrow">
          <i class="fa-solid fa-chevron-right"></i>
        </div>
      </div>
    `;
      cartOverlay.style.display = "block";
      cartOverlay.dataset.initialized = "true";
    }

    const countEl = cartOverlay.querySelector(".cart-count");
    const totalEl = cartOverlay.querySelector(".cart-total");

    if (totalQty > 0) {
      // 🔹 Update hanya teks, bukan seluruh HTML (no flicker)
      countEl.textContent = `${totalQty} item`;
      totalEl.textContent = totalPrice.toLocaleString();

      // 🔹 Tampilkan dengan animasi halus kalau belum muncul
      if (!cartOverlay.classList.contains("show")) {
        requestAnimationFrame(() => cartOverlay.classList.add("show"));
      }
    } else {
      // 🔹 Jika tidak ada item, sembunyikan halus
      cartOverlay.classList.remove("show");
      setTimeout(() => {
        cartOverlay.style.display = "none";
        cartOverlay.dataset.initialized = "";
      }, 300); // match CSS transition time
    }
  }

  // 🔹 klik → ke halaman checkout
  cartOverlay.addEventListener("click", () => {
    const wrapper = document.querySelector(".menu-wrapper");
    const restaurant_id = wrapper.dataset.restaurantId;
    const restaurant_name = wrapper.dataset.restaurantName;

    const saved = JSON.parse(localStorage.getItem("cartData") || "{}");

    if (!saved.items || saved.items.length === 0) return;

    window.location.href = "/alfafood/checkout";
  });

  // 🔹 restore cart dari localStorage
  // 🔹 restore cart dari localStorage (restore qty + note + icon + textarea)
  const savedCart = JSON.parse(localStorage.getItem("cartData") || "{}");
  const wrapper = document.querySelector(".menu-wrapper");
  const currentRestoId = wrapper.dataset.restaurantId;

  // Jika ada data tersimpan dan sesuai restoran sekarang
  if (
    savedCart.items &&
    savedCart.items.length > 0 &&
    parseInt(savedCart.restaurant_id) === parseInt(currentRestoId)
  ) {
    savedCart.items.forEach((item) => {
      const card = document.querySelector(`.menu-card[data-id="${item.id}"]`);
      if (card) {
        const addBtn = card.querySelector(".menu-add-btn");
        const actionEl = card.querySelector(".menu-action");
        const qtyEl = card.querySelector(".menu-qty");
        const noteIcon = card.querySelector(".note-icon");
        const noteContainer = card.querySelector(".menu-note");
        const noteBox = card.querySelector(".menu-note textarea");

        // ✅ tampilkan qty dan ganti tombol
        addBtn.style.display = "none";
        actionEl.style.display = "flex";
        qtyEl.textContent = item.qty;

        // ✅ jika ada catatan
        if (item.note && item.note.trim() !== "") {
          noteBox.value = item.note;
          noteIcon.style.display = "inline-block";
          noteIcon.style.color = "#16a085";
          noteIcon.classList.add("visible");
          noteContainer.style.display = "block";
          // 🧩 Auto-resize tinggi catatan setelah restore
          noteBox.style.height = "auto";
          noteBox.style.height = noteBox.scrollHeight + "px";
        } else {
          noteIcon.style.display = "inline-block";
          noteIcon.style.color = "#16a085";
          noteIcon.classList.add("visible");
        }

        // simpan ke cart aktif
        cart[item.id] = item;
      }
    });

    // render ulang overlay
    renderOverlay();
  }
});
