document.addEventListener("DOMContentLoaded", async () => {
   AndroidApp.showBottomNav();
  const container = document.getElementById("restaurants-list");
  const res = await fetch("<?= base_url('api/restaurants') ?>");
  const json = await res.json();
  container.innerHTML = "";

  json.data.forEach((resto) => {
    const card = document.createElement("div");
    card.className = "restaurant-card";
    card.innerHTML = `
            <div class="rating-badge">
                <i class="fa-solid fa-star"></i>
                <span>${resto.rating ?? "0.0"}</span>
                <small>(${resto.total_reviews ?? 0})</small>
            </div>
            <img src="${
              resto.image_url ||
              "https://img.icons8.com/ios-filled/100/ffffff/restaurant.png"
            }" alt="${resto.name}">
            <div class="info">
                <h4>${resto.name}</h4>
                <p>${resto.description ?? "Deskripsi tidak tersedia"}</p>
            </div>
        `;

    // 🟢 Klik -> buka halaman daftar menu restoran
    card.addEventListener("click", () => {
      window.location.href = `<?= base_url('restaurant') ?>/${resto.id}/menus`;
    });

    container.appendChild(card);
  });

});
