<?= $this->extend('layout/main') ?>
<?= $this->section('content') ?>

<style>
    body,
    html {
        margin: 0;
        padding: 0;
        height: 100%;
        background: linear-gradient(135deg, #16a085, #2980b9);
        font-family: "Poppins", sans-serif;
        color: #fff;
        overflow-x: hidden;
    }

    /* HEADER */

    /* === HEADER FIXED FULL WIDTH === */
    .header-wrapper {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        background: linear-gradient(135deg, #16a085, #2980b9);
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.15);
        z-index: 999;
    }

    .checkout-header-content {
        width: 90%;
        max-width: 1200px;
        margin: 0 auto;
        padding: 10px 0 14px 0;
        display: flex;
        align-items: center;
        justify-content: space-between;
    }

    /* === BACK ICON === */
    .back-icon {
        color: #fff;
        font-size: 1.3rem;
        cursor: pointer;
        background: rgba(255, 255, 255, 0.15);
        width: 36px;
        height: 36px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        text-decoration: none;
        /* ✅ tanpa garis bawah */
        transition: background 0.2s, transform 0.1s;
    }

    .back-icon:hover {
        background: rgba(255, 255, 255, 0.25);
    }

    .checkout-header h2 {
        font-size: 18px;
        font-weight: 600;
    }

    

    /* FORM SCREEN */
    .topup-screen {
        margin-top: 110px;
        /* konten lebih ke atas */
        display: flex;
        flex-direction: column;
        align-items: center;
        gap: 25px;
        padding: 0 20px;
        transition: 0.5s;
    }

    .topup-input {
        width: 100%;
        max-width: 400px;
        background: rgba(255, 255, 255, 0.15);
        padding: 20px;
        border-radius: 14px;
        backdrop-filter: blur(6px);
        box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
    }

    .topup-input label {
        font-size: 15px;
        font-weight: 600;
        margin-bottom: 10px;
        display: block;
    }

    .input-wrapper {
        position: relative;
    }

    .prefix {
        position: absolute;
        left: 12px;
        top: 50%;
        transform: translateY(-50%);
        font-weight: 700;
        font-size: 18px;
        color: #444;
    }

    .input-wrapper input {
        width: 100%;
        padding: 12px 12px 12px 45px;
        border-radius: 10px;
        border: none;
        font-size: 20px;
        font-weight: 600;
        background: #fff;
        outline: none;
        color: #333;
    }

    .topup-btn {
        background: #fff;
        color: #16a085;
        font-size: 17px;
        font-weight: 700;
        border: none;
        border-radius: 12px;
        padding: 14px;
        width: 100%;
        max-width: 400px;
        box-shadow: 0 3px 8px rgba(255, 255, 255, 0.2);
    }

    .topup-btn:hover {
        background: #f1f1f1;
    }

    /* QRIS VIEW */
    .qris-view {
        margin-top: 110px;
        display: flex;
        flex-direction: column;
        align-items: center;
        gap: 18px;
        padding: 0 20px;
        transition: 0.5s;
    }

    .qris-view img {
        width: 220px;
        height: 220px;
        background: #fff;
        border-radius: 12px;
        padding: 12px;
        box-shadow: 0 3px 12px rgba(0, 0, 0, 0.25);
    }

    .qris-amount {
        font-size: 22px;
        font-weight: 700;
    }

    .countdown {
        color: #ffeb3b;
        font-size: 14px;
    }

    .btn-back {
        background: #fff;
        color: #16a085;
        padding: 12px 16px;
        border-radius: 10px;
        border: none;
        font-size: 15px;
        font-weight: 600;
    }

    .hidden {
        opacity: 0;
        transform: translateY(20px);
        pointer-events: none;
    }

    .topup-input label {
        font-size: 16px;
        font-weight: 600;
        text-align: center;
        /* 🔥 bikin teks center */
        width: 100%;
    }
</style>


<div class="header-wrapper">
    <div class="checkout-header-content">
        <a href="javascript:void(0)" id="backToMenu" class="back-icon">
            <i class="fa-solid fa-arrow-left"></i>
        </a>

        <div class="checkout-header">
            <h2><i class="fa-solid fa-wallet"></i> Top Up Saldo</h2>

        </div>

        <div style="width:36px;"></div> <!-- spacer agar judul tetap center -->
    </div>
</div>

<!-- === FORM VIEW === -->
<div id="form-screen" class="topup-screen">

    <div class="topup-input">
        <label for="nominal">Masukkan Nominal</label>
        <div class="input-wrapper">
            <span class="prefix">Rp</span>
            <input type="text" id="nominal" inputmode="numeric" placeholder="0">
        </div>
    </div>

    <button class="topup-btn" onclick="prosesTopup()">Proses Top Up</button>
</div>

<!-- === QRIS VIEW === -->
<div id="qris-screen" class="qris-view hidden">
    <p>Scan QRIS berikut untuk menyelesaikan pembayaran:</p>
    <img id="qrisImage" src="" alt="QRIS">
    <div class="qris-amount" id="qrisAmount">Rp 0</div>
    <div class="countdown" id="countdown">Berlaku selama 10 menit</div>
    <button class="btn-back" onclick="backToForm()">Kembali</button>
</div>

<!-- include library (CDN) -->
<script src="https://cdn.jsdelivr.net/npm/qrcode/build/qrcode.min.js"></script>
<script src="<?= base_url('js/topup.js') ?>"></script>

<?= $this->endSection() ?>