<?= $this->extend('layout/main') ?>
<?= $this->section('content') ?>

<!-- Font & Icon -->
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600&display=swap" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

<style>
    :root {
        --primary: #007bff;
        --secondary: #0056b3;
        --bg: #f5f8ff;
        --text-dark: #1c1c1c;
        --white: #ffffff;
        --gold: #FFD700;
    }

    * {
        box-sizing: border-box;
        margin: 0;
        padding: 0;
    }

    body {
        font-family: "Poppins", sans-serif;
        background: linear-gradient(160deg, var(--primary) 40%, var(--bg) 40%);
        color: var(--text-dark);
        min-height: 100vh;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        padding: 5px;
    }

    .review-wrapper {
        max-width: 700px;
        width: 100%;
        background: var(--white);
        border-radius: 25px;
        box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
        padding: 40px 30px;
        animation: fadeIn 0.5s ease;
    }

    @keyframes fadeIn {
        from {
            opacity: 0;
            transform: translateY(15px);
        }

        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    .driver-section {
        text-align: center;
        margin-bottom: 30px;
    }

    .driver-photo-wrapper {
        display: flex;
        justify-content: center;
        align-items: center;
        background: linear-gradient(145deg, var(--primary), var(--secondary));
        border-radius: 50%;
        width: 60px;
        height: 60px;
        margin: 0 auto 15px;
        box-shadow: 0 10px 25px rgba(0, 0, 0, 0.2);
    }

    .driver-photo {
        width: 70px;
        height: 70px;
        border-radius: 50%;
        object-fit: cover;
        border: 4px solid #fff;
        box-shadow: 0 0 15px rgba(0, 123, 255, 0.4);
    }

    .driver-photo-wrapper i {
        font-size: 3rem;
        color: #fff;
        opacity: 0.95;
    }

    .driver-name {
        font-size: 1.6em;
        font-weight: 600;
        color: var(--primary);
    }

    /* ===== Trip Info (Rute Jemput - Tujuan) ===== */
    .trip-info {
        display: flex;
        justify-content: center;
        margin: 30px 0;
        width: 100%;
    }

    .trip-info,
    textarea {
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
    }

    .route-card {
        position: relative;
        background: linear-gradient(135deg, #f8faff, #eef5ff);
        border-radius: 14px;
        box-shadow: 0 6px 18px rgba(0, 0, 0, 0.08);
        padding: 20px 25px;
        display: flex;
        flex-direction: column;
        gap: 20px;
        width: 100%;
    }

    /* 🗓️ Bagian Tanggal Transaksi */
    .route-date {
        text-align: center;
        font-size: 0.95rem;
        color: #444;
        font-weight: 500;
        /* background: rgba(0, 123, 255, 0.08); */
        border-radius: 10px;
        padding: 10px 16px;
        /* box-shadow: 0 2px 6px rgba(0, 0, 0, 0.05); */
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 8px;
        width: fit-content;
        margin: 0 auto 10px auto;
        /* Center horizontal + sedikit jarak bawah */
        transition: all 0.3s ease;
        opacity: 0;
        animation: fadeIn 0.6s ease forwards;
    }

    .route-date i {
        color: var(--primary);
        font-size: 1rem;
    }

    /* Tambah ikon jam */
    .route-date .time-icon {
        color: var(--secondary);
        margin-left: 4px;
    }

    .route-details {
        display: flex;
        flex-direction: column;
        justify-content: space-between;
        gap: 15px;
        width: 100%;
    }

    .route-details .label {
        font-size: 0.8rem;
        color: #888;
        font-weight: 500;
        letter-spacing: 0.5px;
        margin-bottom: 2px;
    }

    .route-details .location {
        font-size: 1rem;
        font-weight: 600;
        color: #333;
        line-height: 1.3em;
        word-wrap: break-word;
    }

    /* ===== Rating Section ===== */
    .rating {
        display: flex;
        justify-content: center;
        gap: 10px;
        margin: 15px 0 25px;
    }

    .star {
        font-size: 2.2em;
        color: #ccc;
        cursor: pointer;
        transition: 0.2s;
    }

    .star.active {
        color: var(--gold);
        transform: scale(1.1);
    }

    /* ===== Ulasan ===== */
    textarea {
        width: 100%;
        max-width: 100%;
        height: 130px;
        resize: none;
        border-radius: 12px;
        border: 1px solid #ddd;
        padding: 15px;
        font-size: 1em;
        font-family: inherit;
        outline: none;
        transition: border 0.2s;
        box-sizing: border-box;
    }

    textarea:focus {
        border-color: var(--primary);
    }

    button {
        margin-top: 25px;
        background: var(--primary);
        color: var(--white);
        border: none;
        padding: 14px 40px;
        border-radius: 12px;
        cursor: pointer;
        font-size: 1.1em;
        font-weight: 500;
        transition: 0.25s;
        width: 100%;
    }

    button:hover {
        background: var(--secondary);
    }

    .thanks {
        display: none;
        text-align: center;
        margin-top: 20px;
        color: #28a745;
        font-weight: 500;
        font-size: 1.1em;
    }

    @media (max-width: 480px) {
        .route-card {
            padding: 18px;
            gap: 14px;
        }

        .route-details .location {
            font-size: 0.95rem;
        }
    }

    @keyframes fadeIn {
        from {
            opacity: 0;
            transform: translateY(-6px);
        }

        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    /* 🚫 Catatan pembatalan */
    /* ==== 🚫 Tampilan Order Dibatalkan ==== */
    .cancel-wrapper {
        text-align: center;
        margin-top: 20px;
        padding: 40px 20px;
        border-radius: 20px;
        background: linear-gradient(145deg, #fff, #f9f9f9);
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
        animation: fadeInCancel 0.6s ease forwards;
    }

    .cancel-icon {
        font-size: 70px;
        color: #e74c3c;
        margin-bottom: 15px;
        animation: pulseIcon 1.8s infinite ease-in-out;
    }

    .cancel-wrapper h2 {
        font-size: 1.6rem;
        color: #e74c3c;
        font-weight: 700;
        margin-bottom: 8px;
    }

    .cancel-wrapper p {
        font-size: 0.95rem;
        color: #555;
        margin-bottom: 25px;
    }

    .cancel-btn {
        display: inline-flex;
        align-items: center;
        gap: 8px;
        background: var(--primary);
        color: white;
        text-decoration: none;
        padding: 12px 25px;
        border-radius: 10px;
        font-weight: 500;
        font-size: 1rem;
        transition: background 0.3s ease, transform 0.2s ease;
    }

    .cancel-btn:hover {
        background: var(--secondary);
        transform: translateY(-2px);
    }

    /* ✨ Animasi icon */
    @keyframes pulseIcon {
        0% {
            transform: scale(1);
            opacity: 1;
        }

        50% {
            transform: scale(1.1);
            opacity: 0.85;
        }

        100% {
            transform: scale(1);
            opacity: 1;
        }
    }

    @keyframes fadeInCancel {
        from {
            opacity: 0;
            transform: translateY(10px);
        }

        to {
            opacity: 1;
            transform: translateY(0);
        }
    }


    /* ==== Compact Order ID (Rata Tengah & Presisi Tanpa Efek Klik) ==== */
    .order-id-compact {
        display: inline-flex;
        align-items: center;
        justify-content: center;
        gap: 5px;
        background: rgba(0, 123, 255, 0.08);
        border-radius: 8px;
        padding: 4px 10px;
        font-size: 0.8rem;
        color: #333;
        margin-top: 6px;
        line-height: 1;
        vertical-align: middle;
    }

    .order-id-text {
        font-family: "Courier New", monospace;
        font-weight: 600;
        color: var(--primary);
        display: flex;
        align-items: center;
        letter-spacing: 0.3px;
    }

    /* 📋 Tombol Copy — tanpa efek tekan */
    .copy-mini-btn {
        display: inline-flex;
        align-items: center;
        justify-content: center;
        color: var(--primary);
        cursor: pointer;
        padding: 0;
        margin: 0;
        height: 16px;
        width: 16px;
        position: relative;
        top: 1px;
        font-size: 0.78rem;
        transition: color 0.25s ease;
        user-select: none;
        -webkit-tap-highlight-color: transparent;
        /* ✅ Tidak ada efek biru di mobile */
    }

    .copy-mini-btn:hover {
        color: var(--secondary);
    }

    .copy-mini-btn:active {
        color: var(--secondary);
        transform: none;
    }


    /* Hilangkan fokus/klik efek outline */
    .copy-mini-btn:focus,
    .copy-mini-btn:active {
        outline: none;
        transform: none;
        box-shadow: none;
    }

    /* Feedback “Disalin!” */
    .copy-feedback {
        display: none;
        font-size: 0.75rem;
        color: #28a745;
        font-weight: 500;
        margin-left: 3px;
        animation: fadeInCopy 0.3s ease;
    }

    @keyframes fadeInCopy {
        from {
            opacity: 0;
            transform: translateY(-3px);
        }

        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    button:disabled,
    .disabled-btn {
        background: #ccc !important;
        color: #666 !important;
        cursor: not-allowed;
        box-shadow: none !important;
    }
</style>

<body>
    <div class="review-wrapper">
        <div class="driver-section">
            <div class="driver-photo-wrapper">
                <?php if (!empty($driver_photo)) : ?>
                    <img src="<?= esc($driver_photo) ?>" alt="Driver" class="driver-photo">
                <?php else : ?>
                    <i class="fa-solid fa-user-circle"></i>
                <?php endif; ?>
            </div>
            <div class="driver-name"><?= esc($driver_name ?? 'Nama Driver') ?></div>

            <!-- 🆔 Compact Order ID (rata tengah dengan tombol) -->
            <div class="order-id-compact">
                <span class="order-id-text">#<?= esc($order_id ?? 'UNKNOWN') ?></span>
                <span class="copy-mini-btn" id="copyOrderIdBtn" title="Salin Order ID">
                    <i class="fa-solid fa-copy"></i>
                </span>
                <span class="copy-feedback" id="copyFeedback">Disalin!</span>
            </div>
        </div>

        <!-- Trip Info -->
        <div class="trip-info">
            <div class="route-card">

                <!-- 🗓️ Tanggal Transaksi (Dengan Ikon Jam) -->
                <div class="route-date">
                    <i class="fa-solid fa-calendar-day"></i>
                    <?= date('d M Y', strtotime($created_at ?? date('Y-m-d H:i:s'))) ?>
                    <i class="fa-solid fa-circle fa-2xs" style="font-size:6px;color:#777;"></i>
                    <i class="fa-regular fa-clock time-icon"></i>
                    <?= date('H:i', strtotime($created_at ?? date('Y-m-d H:i:s'))) ?> WIB
                </div>

                <!-- Detail Jemput & Tujuan -->
                <div class="route-details">
                    <div class="pickup">
                        <div class="label"><i class="fa-solid fa-location-dot" style="color:#1abc9c"></i> Jemput</div>
                        <div class="location"><?= esc($pickup ?? 'Lokasi Jemput') ?></div>
                    </div>

                    <div class="destination">
                        <div class="label"><i class="fa-solid fa-map-marker-alt" style="color:#e74c3c"></i> Tujuan</div>
                        <div class="location"><?= esc($destination ?? 'Tujuan Akhir') ?></div>
                    </div>
                </div>
            </div>
        </div>



        <?php if (!empty($review)): ?>
            <!-- ✅ Sudah di-review -->
            <div class="rating readonly">
                <?php for ($i = 1; $i <= 5; $i++): ?>
                    <span class="star <?= ($i <= $review['rating']) ? 'active' : '' ?>">★</span>
                <?php endfor; ?>
            </div>

            <div class="review-text" style="text-align:center; margin-top:10px;">
                <p><strong>Ulasan kamu:</strong></p>
                <p style="font-style:italic; color:#555;">"<?= esc($review['ulasan']) ?>"</p>
                <p style="margin-top:10px; color:green; font-weight:600;">✅ Terima kasih! Kamu sudah memberikan ulasan.</p>
            </div>

        <?php else: ?>
            <?php if (!$isCancelled): ?>
                <!-- ⭐ Hanya tampil kalau tidak cancelled -->
                <div class="rating" id="rating">
                    <span class="star" data-value="1">★</span>
                    <span class="star" data-value="2">★</span>
                    <span class="star" data-value="3">★</span>
                    <span class="star" data-value="4">★</span>
                    <span class="star" data-value="5">★</span>
                </div>


                <form id="reviewForm" method="post" action="<?= base_url('driver/submitReview') ?>">
                    <input type="hidden" name="order_id" value="<?= esc($order_id ?? '') ?>">
                    <input type="hidden" name="driver_phone" value="<?= esc($driver_phone ?? '') ?>">
                    <input type="hidden" name="rating" id="ratingInput" value="0">

                    <textarea name="ulasan" placeholder="Ceritakan pengalamanmu bersama driver ini..." required></textarea>

                    <button type="submit">Kirim Ulasan</button>
                    <div class="thanks" id="thanksMessage">Terima kasih atas ulasanmu 🙏</div>
                </form>
            <?php else: ?>
                <!-- 🚫 Jika dibatalkan -->
                <div class="cancel-wrapper">
                    <div class="cancel-icon">
                        <i class="fa-solid fa-ban"></i>
                    </div>
                    <h2>Order Dibatalkan</h2>
                    <p>Transaksi ini telah dibatalkan oleh pengguna atau sistem.</p>

                </div>

            <?php endif; ?>
        <?php endif; ?>


    </div>
    <script src="<?= base_url('js/review.js') ?>"></script>
    <?= $this->endSection() ?>