<?= $this->extend('layout/main') ?>
<?= $this->section('content') ?>

<style>
    body {
        margin: 0;
        padding: 0;
        font-family: "Poppins", sans-serif;
        background: linear-gradient(135deg, #16a085, #2980b9);
        color: #fff;
        min-height: 100vh;
        overflow-x: hidden;

    }

    .dashboard-container {
        width: 98%;
        padding-top: 130px;
        /* height: calc(100vh - 80px); */
        overflow-y: auto;
        /* konten akan bisa scroll */
        overflow-x: hidden;

    }



    @keyframes fadeIn {
        from {
            opacity: 0;
            transform: translateY(18px);
        }

        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    /* HEADER */
    .title-header {
        font-size: 2.2rem;
        font-weight: 700;
        letter-spacing: 1px;
        margin-bottom: 4px;
        text-shadow: 0 3px 10px rgba(0, 0, 0, 0.35);
    }

    .subtitle {
        opacity: 0.9;
        margin-bottom: 25px;
        font-size: 1rem;
    }

    /* GRID */
    .grid {
        display: grid;
        grid-template-columns: repeat(auto-fit, minmax(260px, 1fr));
        gap: 20px;
    }

    /* CARD PREMIUM FINAL */
    .card {
        background: rgba(255, 255, 255, 0.16);
        border: 1px solid rgba(255, 255, 255, 0.25);
        backdrop-filter: blur(14px);

        padding: 10px;
        border-radius: 18px;
        cursor: pointer;
        color: #fff;
        transition: 0.25s ease;
    }

    .card:hover {
        background: rgba(255, 255, 255, 0.26);
        transform: translateY(-4px);
        box-shadow: 0 6px 20px rgba(0, 0, 0, 0.22);
    }

    /* HEADER CARD (icon + title) */
    .card-header {
        display: flex;
        align-items: center;
        gap: 14px;
        margin-bottom: 10px;
        background: transparent;
        padding-left: 0px;
    }

    .card-icon {
        width: 52px;
        height: 52px;
        border-radius: 14px;

        background: rgba(255, 255, 255, 0.35);
        border: 1px solid rgba(255, 255, 255, 0.45);

        display: flex;
        justify-content: center;
        align-items: center;

        font-size: 26px;
        color: #0d3d53;
    }

    .card-title {
        font-size: 1.1rem;
        font-weight: 700;
        margin-bottom: 2px;
    }

    .card-desc {
        font-size: 0.82rem;
        opacity: 0.85;
    }

    /* STATISTIK DI BAWAH */
    .card-stats {
        margin-top: 8px;
        padding-left: 4px;
    }

    .card-stats.two-col {
        display: grid;
        grid-template-columns: 1fr 1fr;
        /* bagi 2 kolom */
        column-gap: 12px;
        row-gap: 6px;
    }

    .stat-item {
        display: flex;
        align-items: center;
        gap: 6px;
        font-size: 0.78rem;
    }


    .stat-icon {
        font-size: 0.8rem;
        opacity: 0.82;
    }

    /* ORDER SECTION */
    .orders-section {
        margin-top: 45px;
    }

    .orders-title {
        font-size: 1.6rem;
        font-weight: 700;
        margin-bottom: 18px;
        text-shadow: 0 3px 10px rgba(0, 0, 0, 0.3);
    }

    .order-box {
        background: rgba(255, 255, 255, 0.18);
        border: 1px solid rgba(255, 255, 255, 0.25);
        backdrop-filter: blur(12px);

        padding: 16px 20px;
        margin-bottom: 12px;
        border-left: 5px solid #0c3f52;
        border-radius: 12px;
    }

    .btn-action {
        margin-top: 10px;
        padding: 10px 12px;
        background: rgba(12, 63, 82, 0.92);
        border-radius: 8px;
        border: none;
        color: #fff;
        font-size: 0.82rem;
        cursor: pointer;
        transition: 0.25s;
    }

    .btn-action:hover {
        background: rgba(12, 63, 82, 1);
        transform: translateY(-2px);
    }

    /* === HEADER FIXED FULL WIDTH === */
    .header-wrapper {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        background: linear-gradient(135deg, #16a085, #2980b9);
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.15);
        z-index: 999;
    }

    .checkout-header-content {
        width: 90%;
        max-width: 1200px;
        margin: 0 auto;

        padding: 10px 0 14px 0;

        display: flex;
        justify-content: center;
        /* ⭐ CENTER */
        align-items: center;
    }

    .checkout-header {
        text-align: center;
        /* ⭐ Agar h2 dan small center */
    }



    /* === BACK ICON === */
    .back-icon {
        color: #fff;
        font-size: 1.3rem;
        cursor: pointer;
        background: rgba(255, 255, 255, 0.15);
        width: 36px;
        height: 36px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        text-decoration: none;
        /* ✅ tanpa garis bawah */
        transition: background 0.2s, transform 0.1s;
    }

    .back-icon:hover {
        background: rgba(255, 255, 255, 0.3);
    }

    .back-icon:active {
        transform: scale(0.9);
    }


    /* ==== TOGGLE TOKO ==== */
    .store-toggle {
        height: 58px;
        width: 90px;
        padding: 0 16px;

        display: flex;
        align-items: center;
        justify-content: center;
        gap: 8px;

        background: rgba(0, 0, 0, 0.35);
        /* ⭐ lebih gelap → paling jelas */
        border: 1px solid rgba(255, 255, 255, 0.45);
        backdrop-filter: blur(12px);

        border-radius: 14px;
        color: #fff;
        font-size: 1rem;
        font-weight: 600;
        cursor: pointer;
        transition: 0.25s ease;
    }

    .store-toggle:hover {
        background: rgba(0, 0, 0, 0.5);
        /* ⭐ lebih pekat saat hover */
        transform: translateY(-2px);
    }

    .store-toggle i {
        font-size: 1.25rem;
        /* ⭐ icon diperbesar */
        color: inherit;
    }

    /* ===== STATUS OPEN ===== */
    .store-open {
        border-left: 6px solid #32ff7e;
        /* ⭐ hijau neon fresh */
        color: #32ff7e !important;
        /* teks lebih tajam */
        text-shadow: 0 0 4px rgba(50, 255, 126, 0.6);
    }

    /* ===== STATUS CLOSED ===== */
    .store-closed {
        border-left: 6px solid #ff4d4d;
        /* ⭐ merah cerah */
        color: #ff4d4d !important;
        text-shadow: 0 0 4px rgba(255, 77, 77, 0.6);
    }


    .header-left {
        display: flex;
        flex-direction: column;
    }

    .checkout-header-content {
        width: 90%;
        max-width: 1200px;
        margin: 0 auto;

        padding: 0px 0 14px 0;

        display: flex;
        justify-content: space-between;
        /* ⭐ kiri - kanan */
        align-items: center;
    }

    /* perkecil toggle biar proporsional di header */
    /* .store-toggle {
        padding: 8px 14px;
        font-size: 0.9rem;
        margin: 0;
    } */

    .header-flex {
        display: flex;
        align-items: center;
        justify-content: space-between;
        padding: 14px 0;
    }

    .logo-title-wrap {
        display: flex;
        align-items: center;
        gap: 14px;
    }

    .resto-logo {
        width: 55px;
        height: 55px;
        border-radius: 14px;
        object-fit: cover;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.25);
    }

    .title-wrap h2 {
        padding: 0;
        margin: 0;
        font-size: 1.5rem;
    }

    .title-wrap small {
        opacity: 0.85;
        font-size: 0.9rem;
    }



    /* Fallback icon box */
    .fallback-icon {
        width: 58px;
        height: 58px;
        border-radius: 14px;
        background: rgba(255, 255, 255, 0.25);
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .fallback-icon i {
        font-size: 26px;
        color: #ffffff;
    }

    .auto-on {
        border-left: 6px solid #ffd32a;
        color: #ffd32a !important;
        text-shadow: 0 0 4px rgba(255, 211, 42, 0.6);
    }

    .auto-off {
        border-left: 6px solid #aaaaaa;
        color: #ffffff;
        opacity: 0.85;
    }

    /* ===== TOGGLE BAR DI BAWAH NAMA ===== */
    .toggle-row {
        margin-top: 6px;
        display: flex;
        gap: 8px;
        flex-wrap: wrap;
    }

    /* toggle versi compact */
    .toggle-compact {
        display: inline-flex;
        align-items: center;
        gap: 6px;

        padding: 5px 10px;
        font-size: 0.75rem;
        font-weight: 600;

        background: rgba(0, 0, 0, 0.35);
        border: 1px solid rgba(255, 255, 255, 0.35);
        border-radius: 10px;

        cursor: pointer;
        transition: 0.2s ease;
    }

    .toggle-compact i {
        font-size: 0.9rem;
    }

    .toggle-compact:hover {
        background: rgba(0, 0, 0, 0.5);
        transform: translateY(-1px);
    }

    /* STATUS OPEN */
    .toggle-compact.store-open {
        border-left: 4px solid #32ff7e;
        color: #32ff7e;
    }

    /* STATUS CLOSED */
    .toggle-compact.store-closed {
        border-left: 4px solid #ff4d4d;
        color: #ff4d4d;
    }

    /* AUTO ON */
    .toggle-compact.auto-on {
        border-left: 4px solid #ffd32a;
        color: #ffd32a;
    }

    /* AUTO OFF */
    .toggle-compact.auto-off {
        border-left: 4px solid #aaaaaa;
        color: #ffffff;
        opacity: 0.85;
    }

    .logo-title-wrap {
        display: flex;
        align-items: stretch;
        /* 🔑 bikin tinggi sama */
        gap: 14px;
    }

    /* logo mengikuti tinggi title-wrap */
    .resto-logo,
    .fallback-icon {
        width: auto;
        height: 100%;
        aspect-ratio: 1 / 1;
        /* tetap kotak */
        max-height: 72px;
        /* batas aman */
        min-height: 48px;
        /* jangan terlalu kecil */
        border-radius: 14px;
        object-fit: cover;
    }
</style>


<div class="header-wrapper">
    <div class="checkout-header-content header-flex">

        <div class="logo-title-wrap">
            <?php if (!empty($restaurant['logo_url'])): ?>
                <img src="<?= esc($restaurant['logo_url']) ?>" class="resto-logo" alt="Logo Restoran">
            <?php else: ?>
                <div class="resto-logo fallback-icon">
                    <i class="fa-solid fa-store"></i>
                </div>
            <?php endif; ?>


            <div class="title-wrap">
                <h2>Dashboard Restoran</h2>
                <small id="restaurantName">
                    <?= isset($restaurant['name']) ? esc($restaurant['name']) : 'Restoran Anda' ?>
                </small>

                <!-- 🔥 TOGGLE ROW (BARU) -->
                <div class="toggle-row">
                    <div id="storeToggle"
                        class="toggle-compact"
                        onclick="toggleStore()">
                        <i class="fa-solid fa-toggle-on"></i>
                        <span>Buka</span>
                    </div>

                    <div id="autoAcceptToggle"
                        class="toggle-compact"
                        onclick="toggleAutoAccept()">
                        <i class="fa-solid fa-bolt"></i>
                        <span>Auto OFF</span>
                    </div>
                </div>
            </div>

        </div>



    </div>
</div>




<div class="dashboard-container">

    <!-- <div class="title-header">Dashboard Restoran</div> -->
    <!-- <div class="subtitle">Kontrol penuh atas restoran Anda — menu, order, rating, dan pendapatan.</div> -->

    <!-- GRID MENU -->
    <div class="grid">

        <!-- CARD PESANAN MASUK -->
        <div class="card" onclick="window.location.href='/restaurant_order'">

            <div class="card-header">
                <div class="card-icon"><i class="fa-solid fa-bag-shopping"></i></div>

                <div>
                    <div class="card-title">Pesanan Masuk</div>
                    <div class="card-desc">Kelola order terbaru.</div>
                </div>
            </div>

            <div class="card-stats two-col">
                <div class="stat-item"><i class="fa-solid fa-inbox stat-icon"></i> Masuk: <strong id="statMasuk">0</strong></div>
                <div class="stat-item"><i class="fa-solid fa-rotate stat-icon"></i> Diproses: <strong id="statProses">0</strong></div>
                <div class="stat-item"><i class="fa-solid fa-motorcycle stat-icon"></i> Menunggu Driver: <strong id="statWait">0</strong></div>
                <div class="stat-item"><i class="fa-solid fa-location-arrow stat-icon"></i> Diantar: <strong id="statDeliver">0</strong></div>
                <div class="stat-item"><i class="fa-solid fa-check-circle stat-icon"></i> Selesai: <strong id="statDone">0</strong></div>
                <div class="stat-item"><i class="fa-solid fa-xmark-circle stat-icon"></i> Batal: <strong id="statCancel">0</strong></div>
            </div>



        </div>

        <!-- CARD MENU -->
        <div class="card" onclick="window.location.href='/restaurant_menu?restaurant_id=<?= $restaurant_id ?>'">

            <div class="card-header">
                <div class="card-icon"><i class="fa-solid fa-utensils"></i></div>

                <div>
                    <div class="card-title">Kelola Menu</div>
                    <div class="card-desc">Atur daftar menu & stok.</div>
                </div>
            </div>

            <div class="card-stats">
                <div class="stat-item">
                    <i class="fa-solid fa-list stat-icon"></i>
                    Total Menu: <strong><?= $menu_total ?></strong>
                </div>

                <div class="stat-item">
                    <i class="fa-solid fa-check stat-icon"></i>
                    Tersedia: <strong><?= $menu_available ?></strong>
                </div>

                <div class="stat-item">
                    <i class="fa-solid fa-ban stat-icon"></i>
                    Habis: <strong><?= $menu_not_available ?></strong>
                </div>
            </div>


        </div>

        <!-- CARD PENDAPATAN -->
        <div class="card" onclick="window.location.href='/restaurant/income'">

            <div class="card-header">
                <div class="card-icon"><i class="fa-solid fa-coins"></i></div>

                <div>
                    <div class="card-title">Pendapatan</div>
                    <div class="card-desc">Laporan pemasukan harian.</div>
                </div>
            </div>

            <div class="card-stats">
                <div class="stat-item"><i class="fa-solid fa-calendar-day stat-icon"></i> Hari Ini: <strong id="statIncomeToday">Rp 0</strong></div>
            </div>

        </div>

        <!-- CARD RATING -->
        <div class="card" onclick="window.location.href='/restaurant/rating'">

            <div class="card-header">
                <div class="card-icon"><i class="fa-solid fa-star"></i></div>

                <div>
                    <div class="card-title">Rating</div>
                    <div class="card-desc">Review & kepuasan pelanggan.</div>
                </div>
            </div>

            <div class="card-stats">
                <div class="stat-item"><i class="fa-solid fa-star-half-stroke stat-icon"></i> Rating: <strong id="statRating"><?= $rating ?></strong></div>
                <div class="stat-item"><i class="fa-solid fa-comment stat-icon"></i> Review: <strong id="statReview"><?= $review ?></strong></div>
            </div>

        </div>

    </div>


    <!-- ORDER LIST -->
    <!-- <div class="orders-section">
        <div class="orders-title">Pesanan Terbaru</div>

        <div id="orderList">
            <div class="order-box">
                <strong>#INV123456</strong> — Ayam Geprek + Es Teh
                <div class="order-status">Status: <span style="color:#f1c40f;">Menunggu Konfirmasi</span></div>
                <button class="btn-action">Terima</button>
            </div>
        </div>
    </div> -->

</div>

<script>
    let autoAccept = <?= (int)$auto_bid_resto ?> === 1;

    const RESTAURANT_ID = "<?= $restaurant_id ?>";

    // alert(PHONE);
    // Contoh data (nanti kamu ganti dengan data asli)
    const dashboardStats = {
        masuk: 12,
        proses: 4,
        wait: 2,
        deliver: 3,
        menuTotal: 40,
        menuHabis: 6,
        incomeToday: 175000,
        rating: 4.7,
        review: 122,
        done: 12
    };

    statMasuk.textContent = dashboardStats.masuk;
    statProses.textContent = dashboardStats.proses;
    statWait.textContent = dashboardStats.wait;
    statDeliver.textContent = dashboardStats.deliver;
    statDone.textContent = dashboardStats.done;


    // statMenuTotal.textContent = dashboardStats.menuTotal;
    // statMenuHabis.textContent = dashboardStats.menuHabis;

    statIncomeToday.textContent = "Rp " + dashboardStats.incomeToday.toLocaleString();

    // statRating.textContent = dashboardStats.rating.toFixed(1);
    // statReview.textContent = dashboardStats.review;

    let storeOpen = <?= $open ?> == 1 ? true : false;



    async function toggleStore0() {
        storeOpen = !storeOpen;

        const el = document.getElementById("storeToggle");

        // Update tampilan
        if (storeOpen) {
            el.classList.remove("store-closed");
            el.classList.add("store-open");
            el.innerHTML = `<i class="fa-solid fa-toggle-on"></i> Buka`;
        } else {
            el.classList.remove("store-open");
            el.classList.add("store-closed");
            el.innerHTML = `<i class="fa-solid fa-toggle-off"></i> Tutup`;
        }

        // 🔥 Kirim ke server
        let form = new FormData();
        form.append("restaurant_id", RESTAURANT_ID);

        let res = await fetch("/restaurant/toggle_store", {
            method: "POST",
            body: form
        });

        let json = await res.json();

        if (!json.success) {
            alert("Gagal update status restoran!");
        }
    }
    async function toggleStore() {

        const el = document.getElementById("storeToggle");

        // Simpan nilai sebelum diubah (untuk rollback kalau gagal)
        const previousStoreOpen = storeOpen;

        // Persiapkan nilai baru
        const newStatus = !storeOpen;

        // 🔥 Kirim ke server dulu
        let form = new FormData();
        form.append("restaurant_id", RESTAURANT_ID);

        let res = await fetch("/restaurant/toggle_store", {
            method: "POST",
            body: form
        });

        let json = await res.json();

        // ❌ GAGAL
        if (!json.success) {
            alert("Gagal update status restoran!");
            return;
        }

        // ✔ BERHASIL → update variabel dan tampilan
        storeOpen = json.newStatus === 1 ? true : false;

        if (storeOpen) {
            el.classList.remove("store-closed");
            el.classList.add("store-open");
            el.innerHTML = `<i class="fa-solid fa-toggle-on"></i> Buka`;
            AndroidApp.updateServiceRole("Restoran Buka");
            window.AndroidApp.showSnack("Restoran Buka");
        } else {
            el.classList.remove("store-open");
            el.classList.add("store-closed");
            el.innerHTML = `<i class="fa-solid fa-toggle-off"></i> Tutup`;
            AndroidApp.updateServiceRole("Restoran Tutup");
            window.AndroidApp.showSnack("Restoran Tutup");
        }
    }
    async function toggleAutoAccept() {
        const el = document.getElementById("autoAcceptToggle");

        const res = await fetch("/restaurant/toggle_auto_accept", {
            method: "POST",
            headers: {
                "Content-Type": "application/json"
            }
        });

        const json = await res.json();

        if (!json.success) {
            alert(json.message || "Gagal mengubah Auto Terima");
            return;
        }

        autoAccept = json.newStatus === 1;

        // update UI
        if (autoAccept) {
            el.classList.remove("auto-off");
            el.classList.add("auto-on");
            el.innerHTML = `<i class="fa-solid fa-bolt"></i><span>Auto ON</span>`;
            window.AndroidApp.showSnack("Auto Terima Aktif");
        } else {
            el.classList.remove("auto-on");
            el.classList.add("auto-off");
            el.innerHTML = `<i class="fa-solid fa-bolt"></i><span>Auto OFF</span>`;
            window.AndroidApp.showSnack("Auto Terima Nonaktif");
        }
    }

    document.addEventListener("DOMContentLoaded", () => {
        AndroidApp.showBottomNav();
        const el = document.getElementById("storeToggle");

        if (storeOpen) {
            el.classList.add("store-open");
            el.classList.remove("store-closed");
            el.innerHTML = `<i class="fa-solid fa-toggle-on"></i> Buka`;
        } else {
            el.classList.add("store-closed");
            el.classList.remove("store-open");
            el.innerHTML = `<i class="fa-solid fa-toggle-off"></i> Tutup`;
        }

        const autoEl = document.getElementById("autoAcceptToggle");

        if (autoAccept) {
            autoEl.classList.add("auto-on");
            autoEl.innerHTML = `<i class="fa-solid fa-bolt"></i> Auto ON`;
        } else {
            autoEl.classList.add("auto-off");
            autoEl.innerHTML = `<i class="fa-solid fa-bolt"></i> Auto OFF`;
        }

    });
</script>

<?= $this->endSection() ?>