<?= $this->extend('layout/main') ?>
<?= $this->section('content') ?>

<style>
    body {
        margin: 0;
        padding: 0;
        overflow: hidden;
        font-family: "Poppins", sans-serif;
        background: linear-gradient(135deg, #0b202e, #133b4c, #1d5b74);
        height: 100vh;
        color: #fff;
    }

    .success-page {
        width: 100%;
        height: 100vh;
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        position: relative;
        text-align: center;
        animation: fadeIn 1.2s ease-out forwards;
    }

    @keyframes fadeIn {
        0% {
            opacity: 0;
            transform: translateY(50px);
        }

        100% {
            opacity: 1;
            transform: translateY(0);
        }
    }

    .success-circle {
        width: 120px;
        height: 120px;
        border-radius: 50%;
        background: rgba(255, 255, 255, 0.15);
        backdrop-filter: blur(4px);
        display: flex;
        align-items: center;
        justify-content: center;
        animation: pop 0.9s ease-out;
    }

    .success-circle i {
        font-size: 60px;
        color: #00e676;
        /* Hijau premium */
    }

    @keyframes pop {
        0% {
            transform: scale(0.3);
            opacity: 0;
        }

        70% {
            transform: scale(1.15);
            opacity: 1;
        }

        100% {
            transform: scale(1);
        }
    }

    .title {
        font-size: 2.4rem;
        margin-top: 20px;
        font-weight: 700;
        letter-spacing: 1px;
        animation: slideUp 1.1s ease-out 0.2s both;
    }

    .subtitle {
        margin-top: 12px;
        font-size: 1.15rem;
        max-width: 480px;
        opacity: 0.88;
        line-height: 1.6;
        animation: slideUp 1.1s ease-out 0.4s both;
    }

    @keyframes slideUp {
        0% {
            opacity: 0;
            transform: translateY(40px);
        }

        100% {
            opacity: 1;
            transform: translateY(0);
        }
    }

    .btn-next {
        margin-top: 40px;
        padding: 14px 26px;
        background: #1abc9c;
        border: none;
        border-radius: 12px;
        font-size: 1.15rem;
        font-weight: 600;
        cursor: pointer;
        color: #fff;
        transition: 0.25s;
        animation: slideUp 1.2s ease-out 0.8s both;
        box-shadow: 0px 6px 14px rgba(0, 0, 0, 0.25);
    }

    .btn-next:hover {
        background: #16a085;
        transform: translateY(-2px);
    }

    #confettiCanvas {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        pointer-events: none;
        z-index: 999;
    }
</style>

<canvas id="confettiCanvas"></canvas>

<div class="success-page">
    <div class="success-circle">
        <i class="fa-solid fa-check"></i>
    </div>

    <div class="title">Data Berhasil Dikirim!</div>

    <div class="subtitle">
        Terima kasih telah mendaftarkan restoran Anda di <strong>AlfaGo</strong>.<br>
        Data Anda sudah kami terima dan sedang melalui proses <strong>verifikasi</strong> oleh tim kami.<br>
        Anda akan mendapatkan notifikasi ketika restoran Anda resmi aktif dan dapat menggunakan semua fitur.
    </div>

    <button class="btn-next" id="btnNext">
        Kembali ke Menu Utama <i class="fa-solid fa-arrow-right"></i>
    </button>
</div>

<script>
    window.AndroidApp.hideBottomNav();

    document.getElementById("btnNext").addEventListener("click", () => {
        window.AndroidApp.saveRole("alfafood", `${baseUrl}/alfafood`);
    });

    // === Confetti Animation ===
    const confetti = document.getElementById("confettiCanvas");
    const ctx = confetti.getContext("2d");
    let pieces = [];
    let numberOfPieces = 120;

    confetti.width = window.innerWidth;
    confetti.height = window.innerHeight;

    window.addEventListener("resize", function() {
        confetti.width = window.innerWidth;
        confetti.height = window.innerHeight;
    });

    function randomColor() {
        const colors = ["#2ecc71", "#f1c40f", "#e67e22", "#e74c3c", "#3498db"];
        return colors[Math.floor(Math.random() * colors.length)];
    }

    function createPieces() {
        for (let i = 0; i < numberOfPieces; i++) {
            pieces.push({
                x: Math.random() * confetti.width,
                y: Math.random() * confetti.height - confetti.height,
                w: 10,
                h: 15,
                speed: (Math.random() * 3) + 2,
                color: randomColor(),
                swing: Math.random() * 2,
                rotation: Math.random() * 360
            });
        }
    }

    function drawPieces() {
        ctx.clearRect(0, 0, confetti.width, confetti.height);

        pieces.forEach((p, index) => {
            p.y += p.speed;
            p.x += Math.sin(p.y * 0.02) * p.swing;

            if (p.y > confetti.height) {
                pieces[index] = {
                    x: Math.random() * confetti.width,
                    y: -20,
                    w: p.w,
                    h: p.h,
                    speed: p.speed,
                    color: p.color,
                    swing: p.swing,
                };
            }

            ctx.save();
            ctx.fillStyle = p.color;
            ctx.translate(p.x + p.w / 2, p.y + p.h / 2);
            ctx.rotate((p.rotation++ * Math.PI) / 180);
            ctx.fillRect(-p.w / 2, -p.h / 2, p.w, p.h);
            ctx.restore();
        });

        requestAnimationFrame(drawPieces);
    }

    // createPieces();
    // drawPieces();
</script>

<?= $this->endSection() ?>