<?= $this->extend('layout/main') ?>
<?= $this->section('content') ?>

<style>
    body {
        margin: 0;
        padding: 0;
        background: linear-gradient(135deg, #16a085, #2980b9);
        font-family: "Poppins", sans-serif;
        color: #fff;
        min-height: 100vh;
    }

    .header-title {
        width: 100%;
        text-align: center;
        padding: 40px 10px 20px;
    }

    .header-title h1 {
        font-size: 2.4rem;
        font-weight: 700;
        margin: 0;
    }

    .header-title p {
        font-size: 1rem;
        opacity: 0.9;
        margin-top: 6px;
    }

    /* FORM CONTAINER */
    .form-wrapper {
        width: 100%;
        max-width: 700px;
        margin: 0 auto;
        padding: 100px 20px 60px;
    }

    .form-group {
        margin-bottom: 18px;
    }

    .form-label {
        font-size: 0.95rem;
        font-weight: 600;
        margin-bottom: 6px;
        display: block;
        color: #f0f0f0;
    }

    .input-icon {
        position: relative;
    }

    .input-icon i {
        position: absolute;
        top: 50%;
        transform: translateY(-50%);
        left: 12px;
        font-size: 1rem;
        color: #16a085;
    }

    .form-control {
        width: 100%;
        padding: 12px 0px 12px 20px;
        border-radius: 10px;
        border: none;
        font-size: 0.95rem;
        outline: none;
        color: #333;
    }

    .form-control:focus {
        box-shadow: 0 0 8px rgba(255, 255, 255, 0.4);
    }

    textarea.form-control {
        padding-left: 14px !important;
    }

    /* UPLOAD AREA */
    .upload-area {
        border: 2px dashed rgba(255, 255, 255, 0.7);
        padding: 20px;
        text-align: center;
        border-radius: 12px;
        cursor: pointer;
        transition: 0.25s;
    }

    .upload-area:hover {
        background: rgba(255, 255, 255, 0.1);
        border-color: #fff;
    }

    #previewImageLogo {
        width: 95%;
        height: 95%;
        border-radius: 14px;
        object-fit: cover;
        display: none;
        /* margin-top: 12px; */
        /* border: 3px solid rgba(255, 255, 255, 0.8); */
    }

    /* SUBMIT BUTTON */
    .btn-submit {
        width: 100%;
        background: #fff;
        color: #16a085;
        padding: 14px;
        font-size: 1.1rem;
        font-weight: 700;
        border: none;
        border-radius: 14px;
        cursor: pointer;
        margin-top: 10px;
        transition: 0.25s;
        box-shadow: 0 8px 20px rgba(0, 0, 0, 0.2);
    }

    .btn-submit:hover {
        background: #f1f1f1;
        transform: translateY(-2px);
    }

    /* === HEADER FIXED FULL WIDTH === */
    .header-wrapper {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        background: linear-gradient(135deg, #16a085, #2980b9);
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.15);
        z-index: 999;
    }

    .checkout-header-content {
        width: 90%;
        max-width: 1200px;
        margin: 0 auto;
        padding: 10px 0 14px 0;
        display: flex;
        align-items: center;
        justify-content: space-between;
    }

    /* === BACK ICON === */
    .back-icon {
        color: #fff;
        font-size: 1.3rem;
        cursor: pointer;
        background: rgba(255, 255, 255, 0.15);
        width: 36px;
        height: 36px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        text-decoration: none;
        /* ✅ tanpa garis bawah */
        transition: background 0.2s, transform 0.1s;
    }

    .back-icon:hover {
        background: rgba(255, 255, 255, 0.3);
    }

    .back-icon:active {
        transform: scale(0.9);
    }

    .input-disabled {
        background: #e0e0e0 !important;
        color: #777 !important;
        cursor: not-allowed !important;
    }

    /* UPLOAD IMAGE */
    .upload-box {
        border: 2px dashed rgba(255, 255, 255, 0.38);
        padding: 5px;
        text-align: center;
        border-radius: 14px;
        cursor: pointer;
        transition: 0.25s;

        width: 100%;
        /* max-width: 450px; */

        /* Responsive fixed box */
        aspect-ratio: 16 / 10;
        /* 🔥 Tidak akan melar */
        overflow: hidden;

        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;

        position: relative;
    }

    .upload-box:hover {
        background: rgba(255, 255, 255, 0.1);
    }

    #previewImage {
        width: 100%;
        height: 100%;
        object-fit: cover;
        border-radius: 14px;
        display: none;
    }


    .location-btn-group {
        display: flex;
        gap: 8px;
        margin-top: 10px;
    }

    .loc-btn {
        flex: 1;
        padding: 10px 12px;
        background: #f1f1f1;
        border: 1px solid #ccc;
        border-radius: 8px;
        font-size: 0.9rem;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 6px;
        transition: 0.2s;
    }

    .loc-btn i {
        color: #16a085;
    }

    .loc-btn:hover {
        background: #e8e8e8;
        border-color: #16a085;
    }

    .mapSelectContainer {
        width: 100%;
        height: 0;
        overflow: hidden;
        border-radius: 12px;
        position: relative;
        transition: height 0.3s ease;
    }

    /* Saat map dibuka, border muncul & map ikut ukurannya */
    .map-border.show .mapSelectContainer {
        height: 300px;
        /* tinggi map disini */
    }

    #selectMap {
        width: 100%;
        height: 100%;
        /* mengikuti mapSelectContainer */
    }



    /* wrapper absolute di dalam container */
    .marker-wrapper {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        pointer-events: none;
    }

    /* marker fixed diletakkan di marker-wrapper */
    .fixed-center-marker {
        position: absolute;
        top: 50%;
        left: 50%;
        width: 40px;
        height: 40px;
        transform: translate(-50%, -100%);
        pointer-events: none;
        z-index: 99;
    }

    .map-border {
        border: none;
        border-radius: 12px;
        padding: 0;
        margin-top: 0;
        transition: 0.25s ease;
    }

    .map-border.show {
        border: 2px solid #16a085;
        margin-top: 12px;
        /* ✔ jarak muncul hanya saat map dibuka */
    }

    .upload-box.disabled {
        opacity: 0.5;
        cursor: not-allowed !important;
    }


    .upload-box.auto-size {
        position: relative;
        border: 2px dashed #fff;
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        overflow: hidden;
        cursor: pointer;
    }

    /* .previewImageLogo {
        width: 100%;
        height: 100%;
        object-fit: cover;
    } */
</style>

<link href="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.6.1/cropper.min.css" rel="stylesheet">
<script src="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.6.1/cropper.min.js"></script>

<div class="header-wrapper">
    <div class="checkout-header-content">
        <a href="javascript:void(0)" id="backToMenu" class="back-icon">
            <i class="fa-solid fa-arrow-left"></i>
        </a>

        <div class="checkout-header">
            <h2>Pendaftaran Restoran</h2>
            <!-- <small id="restaurantName">Bergabung menjadi Mitra AlfaGo dan mulai menerima pesanan pelanggan</small> -->
        </div>

        <div style="width:36px;"></div> <!-- spacer agar judul tetap center -->
    </div>
</div>

<div class="form-wrapper">
    <form id="formRegister" action="/alfafood/register/save" method="POST" enctype="multipart/form-data">

        <div class="form-group">
            <label class="form-label">Nama Restoran</label>
            <div class="input-icon">
                <!-- <i class="fa-solid fa-utensils"></i> -->
                <input type="text" class="form-control" name="resto_name" required>
            </div>
        </div>

        <div class="form-group">

            <?php if (empty(isset($user['nik_url']))): ?>
                <label class="form-label">Nama Pemilik (Nama harus sesuai KTP)</label>
            <?php else: ?>
                <label class="form-label">Nama Pemilik</label>
            <?php endif; ?>

            <div class="input-icon">
                <!-- <i class="fa-solid fa-user"></i> -->
                <input type="text"
                    class="form-control <?= !empty($user['nik_url']) ? 'input-disabled' : '' ?>"
                    name="owner_name"
                    value="<?= !empty($user['nik_url']) ? esc($user['nama']) : '' ?>"
                    <?= !empty($user['nik_url']) ? 'readonly' : '' ?>
                    required>
            </div>
        </div>

        <div class="form-group <?= !empty($user['nik_url']) ? 'hidden' : '' ?>">
            <label class="form-label">NIK</label>
            <div class="input-icon">
                <!-- <i class="fa-solid fa-utensils"></i> -->
                <!-- <input type="number" class="form-control" name="nik" required> -->
                <input type="number"
                    class="form-control <?= !empty($user['nik_url']) ? 'input-disabled' : '' ?>"
                    name="nik"
                    value="<?= !empty($user['nik_url']) ? esc($user['nik']) : '' ?>"
                    <?= !empty($user['nik_url']) ? 'readonly' : '' ?>
                    required>
            </div>
        </div>

        <div class="form-group <?= !empty($user['nik_url']) ? 'hidden' : '' ?>">
            <label class="form-label">Foto KTP</label>

            <div class="upload-box <?= !empty($user['nik_url']) ? 'disabled' : '' ?>" data-input="menuImage">
                <div class="uploadIcon" id="uploadIcon">
                    <i class=" fa-solid fa-image" style="font-size:2.2rem; opacity:0.8;"></i>
                    <div style="margin-top:6px;">Klik untuk upload KTP</div>
                </div>

                <img class="previewImage previewImg" id="previewImage">
                <div class="uploadError upload-error-text">Ukuran foto maksimal 1 MB</div>
            </div>

            <input type="file" id="menuImage" name="imageKTP"
                data-width="250" data-height="150"
                accept="image/*" style="display:none;">
        </div>




        <!-- Upload KTP -->
        <!-- <div class="form-group">
                <label class="form-label">KTP</label>
                <div class="upload-area" onclick="document.getElementById('logoInput').click()">
                    <i class="fa-solid fa-cloud-arrow-up" style="font-size: 2rem;"></i><br>
                    Upload KTP
                </div>
                <input type="file" id="ktpInput" name="ktp" accept="image/*" style="display:none;">
                <img id="previewLogo">
            </div> -->

        <div class="form-group <?= !empty($user['nik_url']) ? 'hidden' : '' ?>">
            <label class="form-label">Alamat Lengkap (Sesuai KTP)</label>
            <!-- <textarea class="form-control" name="address" rows="2" required></textarea> -->
            <input type="textarea"
                class="form-control <?= !empty($user['nik_url']) ? 'input-disabled' : '' ?>"
                name="address"
                value="<?= !empty($user['nik_url']) ? esc($user['alamat']) : '' ?>"
                <?= !empty($user['nik_url']) ? 'readonly' : '' ?>
                required>
        </div>

        <div class="form-group">
            <label class="form-label">Kategori Restoran</label>
            <select class="form-control" name="category" required>
                <option value="">-- Pilih Kategori --</option>
                <option value="Makanan">Makanan</option>
                <option value="Minuman">Minuman</option>
                <option value="Cemilan">Cemilan</option>
                <option value="Kopi">Kopi</option>
            </select>
        </div>

        <div class="form-group">
            <label class="form-label">Deskripsi Restoran</label>
            <textarea class="form-control" name="description" rows="3" required></textarea>
        </div>

        <div class="form-group">
            <label class="form-label">Alamat Restaurant</label>
            <textarea class="form-control" name="address_restaurant" rows="2" required></textarea>
        </div>

        <!-- <div class="form-group">
            <label class="form-label">Nomor WhatsApp</label>
            <div class="input-icon">
                <i class="fa-brands fa-whatsapp"></i>
                <input type="text" class="form-control" name="whatsapp" placeholder="08xxxxxx" required>
            </div>
        </div> -->

        <div class="form-group">
            <label class="form-label">Email Restoran</label>
            <div class="input-icon">
                <!-- <i class="fa-solid fa-envelope"></i> -->
                <input type="email" class="form-control" name="email" required>
            </div>
        </div>
        <!-- 
        <div class="form-group">
            <label class="form-label">Password Akun</label>
            <div class="input-icon">
                <i class="fa-solid fa-lock"></i>
                <input type="password" class="form-control" name="password" required>
            </div>
        </div> -->
        <div class="form-group">
            <div class="checkout-section">
                <label class="form-label">Lokasi Restoran</label>
                <input class="form-control" type="text" id="location" placeholder="Masukkan alamat restaurant Anda">

                <!-- Tombol Lokasi -->
                <div class="location-btn-group">
                    <button type="button" class="loc-btn" id="btnMyLocation">
                        <i class="fa-solid fa-location-crosshairs"></i> Lokasi Saya
                    </button>

                    <button type="button" class="loc-btn" id="btnPickFromMap">
                        <i class="fa-solid fa-map"></i> Pilih dari maps
                    </button>
                </div>

                <!-- MAP CONTAINER -->
                <div class="map-border">
                    <div id="mapSelectContainer" class="mapSelectContainer">
                        <div class="marker-wrapper"></div>
                        <div id="selectMap"></div>
                    </div>
                </div>

            </div>
        </div>

        <!-- Upload logo -->
        <!-- <div class="form-group">
            <label class="form-label">Logo Restoran</label>
            <div class="upload-area" onclick="document.getElementById('logoInput').click()">
                <i class="fa-solid fa-cloud-arrow-up" style="font-size: 2rem;"></i><br>
                Upload Logo Restoran
            </div>
            <input type="file" id="logoInput" name="logo" accept="image/*" style="display:none;">
            <img id="previewLogo">
        </div> -->

        <div class="form-group">
            <label class="form-label">Logo Restoran</label>

            <div class="upload-box auto-size" data-input="menuImageLogo">
                <div class="uploadIcon" id="uploadIcon">
                    <i class="fa-solid fa-image" style="font-size:2.2rem; opacity:0.8;"></i>
                    <div style="margin-top:6px;">Klik untuk upload Logo Restoran</div>
                </div>

                <img class="previewImageLogo previewImg" id="previewImageLogo">
                <div class="uploadError upload-error-text">Ukuran foto maksimal 1 MB</div>
            </div>

            <input type="file" id="menuImageLogo" name="logo"
                data-width="150" data-height="150"
                accept="image/*" style="display:none;">
        </div>


        <button type="submit" class="btn-submit">
            <i class="fa-solid fa-paper-plane"></i> Daftarkan Restoran
        </button>
    </form>
</div>

<script>
    document.querySelectorAll(".upload-box.auto-size").forEach(box => {
        const inputId = box.dataset.input;
        const input = document.getElementById(inputId);

        if (input) {
            const w = parseInt(input.dataset.width) || 200;
            const h = parseInt(input.dataset.height) || 200;

            box.style.width = w + "px";
            box.style.height = h + "px";
        }
    });

    document.addEventListener("DOMContentLoaded", () => {

        <?php if (!empty($user['nik_url'])): ?>
            const preview = document.getElementById('previewImage');
            const uploadIcon = document.getElementById('uploadIcon');

            preview.src = "<?= esc($user['nik_url']) ?>";
            preview.style.display = "block";
            uploadIcon.style.display = "none";

            preview.style.pointerEvents = "none";
            preview.setAttribute("draggable", "false");

        <?php endif; ?>
        // window.AndroidApp.hideBottomNav();
        const backBtn = document.getElementById("backToMenu");


        backBtn.addEventListener("click", () => {
            window.location.href = `/role`;
        });

        // Submit Form AJAX
        document.getElementById("formRegister").addEventListener("submit", function(e) {
            e.preventDefault();

            const form = e.target;
            const formData = new FormData(form);

            formData.append("phone", phone);
            formData.append("loc_lat", loc_lat_resturant);
            formData.append("loc_lng", loc_lng_resturant);

            // Tambahkan hanya jika ada gambar hasil crop
            if (window.finalBlob) {
                Object.keys(window.finalBlob).forEach(id => {
                    formData.append(id, window.finalBlob[id], id + ".jpg");
                });
            }

            showLoading("Registrasi...");

            fetch(form.action, {
                    method: "POST",
                    body: formData,
                })
                .then(res => res.json())
                .then(data => {
                    hideLoading();

                    if (data.success) {
                        window.location.href = data.redirect;
                    } else {
                        showModal("info", "Informasi", data.msg || "Registrasi gagal");
                    }
                })
                .catch(err => {
                    hideLoading();
                    showModal("error", "Error", "Terjadi kesalahan server");
                });
        });

       


        // LOKASI RESTAURANT
        loadGoogleMaps();
        waitUntilMapReady(() => getNamaTempat());

        let loc_lat_resturant = null;
        let loc_lng_resturant = null;
        async function getNamaTempat() {
            try {
                if (typeof google === "undefined") {
                    console.warn("Google Maps belum siap.");
                    return;
                }

                const getLocation = await getCurrentLocationFetchOnly();
                const status = getLocation.status;

                // ambil lat/lng dari global (di-set sebelumnya)
                lat = typeof Latitude !== "undefined" ? Latitude : null;
                lng = typeof Longitude !== "undefined" ? Longitude : null;

                loc_lat_resturant = lat;
                loc_lng_resturant = lng;

                // alert(`lat: ${loc_lat_resturant}, lng: ${loc_lng_resturant}`)

                // safety: kalau belum ada lokasi restoran, minta load dulu
                if (typeof window.restaurantLat === "undefined" || typeof window.restaurantLng === "undefined") {
                    console.warn("Lokasi restoran belum tersedia (window.restaurantLat / restaurantLng).");
                    // kamu bisa panggil loadRestaurantLocation() di luar fungsi ini sebelum memanggil getNamaTempat
                }

                const dstLatLng = lat !== null && lng !== null ? new google.maps.LatLng(lat, lng) : null;
                const pickupLatLng = (typeof window.restaurantLat !== "undefined" && typeof window.restaurantLng !== "undefined") ?
                    new google.maps.LatLng(window.restaurantLat, window.restaurantLng) :
                    null;

                // ========================
                // Autocomplete (buat sekali saja)
                // ========================
                if (typeof deliveryAddress === "undefined" || !deliveryAddress) {
                    console.warn("Elemen input alamat (deliveryAddress) tidak ditemukan.");
                } else {
                    // jika belum ada autocomplete global, buat; kalau sudah ada, update bounds saja
                    const acOptions = {
                        types: ["geocode"],
                        componentRestrictions: {
                            country: "id"
                        },

                        // 🔥 PENTING: Prioritaskan pencarian dari lokasi user
                        locationBias: {
                            lat: lat,
                            lng: lng
                        }
                    };

                    if (!window._alfa_autocomplete) {
                        window._alfa_autocomplete = new google.maps.places.Autocomplete(deliveryAddress);
                        window._alfa_autocomplete.setFields(["name", "formatted_address", "geometry"]);


                        window._alfa_autocomplete.addListener("place_changed", function() {
                            const place = window._alfa_autocomplete.getPlace();
                            if (!place || !place.geometry) {
                                console.warn("Lokasi tidak valid (place.geometry kosong).");
                                return;
                            }

                            // update posisi tujuan dari pilihan user
                            lat = place.geometry.location.lat();
                            lng = place.geometry.location.lng();

                            loc_lat_resturant = lat;
                            loc_lng_resturant = lng;

                            // Pilih nama tempat (lebih singkat) atau alamat kalau tidak ada nama
                            const displayName = place.name || place.formatted_address;
                            deliveryAddress.value = displayName;



                            // tampilkan alamat lengkap ke input
                            // deliveryAddress.value = place.formatted_address || deliveryAddress.value;


                            // hitung ulang ongkos: start = restoran, end = pilihan user
                            if (pickupLatLng) {
                                const tujuanBaru = new google.maps.LatLng(lat, lng);
                                // Geser map ke lokasi saya

                                if (selectMapIdleListener) {
                                    google.maps.event.removeListener(selectMapIdleListener);
                                    selectMapIdleListener = null;
                                }


                                selectMap.panTo(tujuanBaru);
                                // calcAndUpdateCosts(pickupLatLng, tujuanBaru).catch(err => console.error(err));
                            }

                        });
                    }

                    //Set bounds berdasarkan circle 5km dari user (kalau ada)
                    if (dstLatLng && window._alfa_autocomplete) {
                        const circle = new google.maps.Circle({
                            center: dstLatLng,
                            radius: 5000
                        });
                        window._alfa_autocomplete.setBounds(circle.getBounds());
                    }
                }

                // jika Google mengembalikan alamat awal, isi input
                if (status === "OK" && getLocation.results && getLocation.results.length > 0) {
                    const fullAddress = getLocation.results[0].formatted_address;
                    const shortAddress = fullAddress.split(",")[0];
                    if (deliveryAddress) deliveryAddress.value = shortAddress;
                }

                // hitung ongkir awal (start restoran -> tujuan user)
                if (pickupLatLng && dstLatLng) {
                    // await calcAndUpdateCosts(pickupLatLng, dstLatLng);
                }
            } catch (err) {
                console.error("getNamaTempat error:", err);
                NotifAndroidApp && NotifAndroidApp("Error geocoding", err);
            }
        }
        const deliveryAddress = document.getElementById("location")
        if (deliveryAddress) {
            deliveryAddress.addEventListener("focus", () => {
                deliveryAddress.value = ""; // kosongkan input
            });
        }

        document.getElementById("btnMyLocation").addEventListener("click", chooseCurrentLocation);


        // 📍 Tombol Lokasi Saya
        async function chooseCurrentLocation() {
            const loc = await getCurrentLocationFetchOnly();
            if (!loc || loc.status !== "OK") {
                alert("Gagal mendapatkan lokasi!");
                return;
            }

            const full = loc.results[0].formatted_address;
            deliveryAddress.value = full.split(",")[0];

            lat = Latitude;
            lng = Longitude;

            loc_lat_resturant = lat;
            loc_lng_resturant = lng;

            // update biaya pengiriman
            const tujuan = new google.maps.LatLng(lat, lng);
            const pickup = new google.maps.LatLng(window.restaurantLat, window.restaurantLng);

            // calcAndUpdateCosts(pickup, tujuan);

            if (selectMapIdleListener) {
                google.maps.event.removeListener(selectMapIdleListener);
                selectMapIdleListener = null;
            }

            if (selectMap) selectMap.panTo(tujuan);

        }

        document.getElementById("btnPickFromMap").addEventListener("click", chooseFromMap);

        // let selectMap;
        let selectMarker;

        // ===========================
        // 📍 Pilih dari peta
        // ===========================
        function chooseFromMap() {
            const container = document.getElementById("mapSelectContainer");
            const wrapper = document.querySelector(".map-border");
            const btnPick = document.getElementById("btnPickFromMap");

            // Jika sudah terbuka → tutup
            if (container.classList.contains("show")) {
                wrapper.classList.remove("show");
                hideSelectMap();
                return;
            }

            // Jika sudah terbuka → tutup
            if (container.classList.contains("show")) {
                wrapper.classList.remove("show");
                container.classList.remove("show");

                btnPick.innerHTML = `<i class="fa-solid fa-map"></i> Pilih dari Maps`;

                hideSelectMap();
                return;
            }

            // Jika ditutup → buka
            container.classList.add("show");
            wrapper.classList.add("show");

            btnPick.innerHTML = `<i class="fa-solid fa-xmark"></i> Tutup Maps`;

            if (!selectMap) {
                initSelectMap();
            } else {
                if (!fixedCenterMarker) {
                    fixedCenterMarker = document.createElement("img");
                    fixedCenterMarker.src = "https://maps.google.com/mapfiles/ms/icons/red-dot.png";
                    fixedCenterMarker.className = "fixed-center-marker";
                    container.appendChild(fixedCenterMarker);
                }

                if (!selectMapIdleListener) {
                    attachIdleListener();
                }
            }
        }

        function attachIdleListener() {
            selectMapIdleListener = selectMap.addListener("idle", () => {
                const center = selectMap.getCenter();
                if (!center) return;

                const latlng = {
                    lat: center.lat(),
                    lng: center.lng()
                };

                lat = latlng.lat;
                lng = latlng.lng;

                loc_lat_resturant = lat;
                loc_lng_resturant = lng;

                // Reverse geocode
                const g = new google.maps.Geocoder();
                g.geocode({
                    location: latlng
                }, (results, status) => {
                    if (status === "OK" && results[0]) {
                        const full = results[0].formatted_address;
                        const parts = full.split(",");

                        const firstPart = parts[0].trim();
                        const secondPart = parts[1] ? parts[1].trim() : full;

                        deliveryAddress.value = firstPart.includes("+") ? secondPart : firstPart;
                    }
                });

                // Hitung ongkos kirim
                const pickup = new google.maps.LatLng(window.restaurantLat, window.restaurantLng);
                // calcAndUpdateCosts(pickup, new google.maps.LatLng(lat, lng));
            });
        }

        // ===========================
        // 🗺 Inisialisasi Map Pilih Lokasi
        // ===========================

        // let fixedCenterMarker = null;
        // let selectMap = null;

        let fixedCenterMarker = null;
        let selectMap = null;
        let selectMapIdleListener = null;

        function hideSelectMap() {
            const container = document.getElementById("mapSelectContainer");
            const wrapper = document.querySelector(".map-border");

            wrapper.classList.remove("show");
            container.classList.remove("show");

            if (fixedCenterMarker) {
                fixedCenterMarker.remove();
                fixedCenterMarker = null;
            }

            if (selectMapIdleListener) {
                google.maps.event.removeListener(selectMapIdleListener);
                selectMapIdleListener = null;
            }

            document.getElementById("btnPickFromMap").innerHTML =
                `<i class="fa-solid fa-map"></i> Pilih dari maps`;

        }

        function initSelectMap() {
            selectMap = new google.maps.Map(document.getElementById("selectMap"), {
                center: {
                    lat: Latitude,
                    lng: Longitude
                },
                zoom: 16,
                disableDefaultUI: true,
                gestureHandling: "greedy"
            });

            // Buat marker fixed
            fixedCenterMarker = document.createElement("img");
            fixedCenterMarker.src = "https://maps.google.com/mapfiles/ms/icons/red-dot.png";
            fixedCenterMarker.className = "fixed-center-marker";
            document.querySelector(".marker-wrapper").appendChild(fixedCenterMarker);

            // Listener idle pertama kali
            attachIdleListener();

            // 🔥 Aktifkan idle listener kembali kalau map digeser
            selectMap.addListener("dragstart", () => {
                if (!selectMapIdleListener) {
                    attachIdleListener();
                    console.log("Idle listener aktif lagi setelah dragstart");
                }
            });
        }
    });
</script>

<?= $this->endSection() ?>