    <?= $this->extend('layout/main') ?>
    <?= $this->section('content') ?>

    <style>
        body {
            margin: 0;
            padding: 0;
            font-family: "Poppins", sans-serif;
            background: linear-gradient(135deg, #16a085, #2980b9);
            color: #fff;
            min-height: 100vh;
            overflow-x: hidden;
        }

        .orders-container {
            width: 92%;
            max-width: 1200px;
            animation: fadeIn 0.6s ease-out;
            padding-top: 160px;
            min-height: calc(100vh - 100px);
            padding-bottom: 40px;
            margin: 0 auto;
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: translateY(10px);
            }

            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .order-card {
            background: rgba(255, 255, 255, 0.15);
            border-radius: 14px;
            border: 1px solid rgba(255, 255, 255, 0.25);
            backdrop-filter: blur(12px);
            padding: 18px 20px;
            margin-bottom: 18px;
            transition: 0.2s;
            display: none;
        }

        .order-card:hover {
            background: rgba(255, 255, 255, 0.25);
            transform: translateY(-3px);
        }

        .order-top {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            gap: 10px;
        }

        .order-id {
            font-size: 1.1rem;
            font-weight: 700;
        }

        .order-date {
            font-size: 0.78rem;
            opacity: 0.85;
            margin-top: 2px;
        }

        .order-status {
            padding: 5px 10px;
            border-radius: 8px;
            font-size: 0.8rem;
            font-weight: 600;
            color: #fff;
            white-space: nowrap;
            display: inline-block;
        }

        .s-wait {
            background: #f1c40f;
        }

        .s-process {
            background: #3498db;
        }

        .s-driver {
            background: #8e44ad;
        }

        .s-deliver {
            background: #16a085;
        }

        .s-done {
            background: #2ecc71;
        }

        .s-cancel {
            background: #e74c3c;
            /* merah */
        }


        .order-detail {
            font-size: 0.9rem;
            color: #f8f9fa;
            margin-bottom: 15px;
        }

        .btn-order {
            border: none;
            padding: 9px 14px;
            font-size: 0.85rem;
            border-radius: 8px;
            cursor: pointer;
            font-weight: 600;
        }

        .btn-primary {
            background: #0c3f52;
            color: #fff;
        }

        .btn-primary:hover {
            background: #0a2d3c;
        }

        .bottom-row {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-top: 8px;
        }

        .header-wrapper {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            background: linear-gradient(135deg, #16a085, #2980b9);
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.15);
            z-index: 999;
        }

        .checkout-header-content {
            width: 90%;
            max-width: 1200px;
            margin: 0 auto;
            padding: 10px 0 14px;
            display: flex;
            justify-content: center;
            align-items: center;
            text-align: center;
        }

        .order-items-wrapper {
            border-top: 1px dashed rgba(255, 255, 255, 0.35);
            border-bottom: 1px dashed rgba(255, 255, 255, 0.35);
            padding: 10px 0;
            margin: 10px 0;
        }

        .order-items-title {
            font-weight: 700;
            font-size: 0.9rem;
            margin-bottom: 6px;
            color: #ffe082;
        }

        .order-items-list li {
            margin-bottom: 6px;
        }

        .total-price b {
            color: #ffeb3b;
        }


        /* ========= CARD DONE MODE MINI ========= */
        .order-card.done-card {
            cursor: pointer;
            transition: background 0.2s, transform 0.2s, max-height 0.25s ease;
        }

        /* collapsed = tampilan kecil */
        .order-card.done-card.collapsed {
            padding: 10px 14px;
            background: rgba(46, 204, 113, 0.18);
            border-color: rgba(46, 204, 113, 0.6);
        }

        .order-card.done-card.collapsed:hover {
            background: rgba(46, 204, 113, 0.28);
            transform: translateY(-1px);
        }

        /* sembunyikan bagian bawah */
        .order-card.done-card.collapsed .order-extra {
            display: none;
        }

        /* kecilkan teks header */
        .order-card.done-card.collapsed .order-id {
            font-size: 0.95rem;
        }

        .order-card.done-card.collapsed .order-date {
            font-size: 0.75rem;
        }

        .order-card.done-card.collapsed .order-status {
            font-size: 0.75rem;
            padding: 3px 8px;
        }

        /* total mini */
        .small-total {
            display: none;
            font-size: 0.78rem;
            margin-top: 4px;
            opacity: 0.95;
        }

        .order-card.done-card.collapsed .small-total {
            display: block;
        }

        /* expanded kembali normal */
        .order-card.done-card.expanded .order-extra {
            display: block;
        }

        .pin-info {
            margin-top: 6px;
            font-size: 1rem;
            font-weight: 600;
        }

        .pin-info span {
            font-size: 1.2rem;
        }

        /* STATUS SEARCHING (Mencari Driver) */
        .s-search {
            background: #9b59b6;
            position: relative;
            padding-left: 24px;
        }

        /* SPINNER kecil */
        .s-search::before {
            content: "";
            width: 10px;
            height: 10px;
            border: 2px solid rgba(255, 255, 255, 0.7);
            border-top-color: transparent;
            border-radius: 50%;
            position: absolute;
            left: 8px;
            top: 50%;
            transform: translateY(-50%);
            animation: spin 0.9s linear infinite;
        }

        /* Animasi spin */
        @keyframes spin {
            from {
                transform: translateY(-50%) rotate(0deg);
            }

            to {
                transform: translateY(-50%) rotate(360deg);
            }
        }

        /* Efek kedip halus */
        .s-search {
            animation: searchingPulse 1.4s ease-in-out infinite alternate;
        }

        @keyframes searchingPulse {
            from {
                opacity: 0.9;
            }

            to {
                opacity: 1;
            }
        }



        .simple-tabs {
            display: grid;
            grid-template-columns: repeat(5, 1fr);
            gap: 6px;
            padding: 8px 12px 12px;
            background: transparent;
        }


        .simple-tabs .tab {
            border: none;
            padding: 8px 4px;
            border-radius: 10px;
            font-size: 0.75rem;
            font-weight: 600;
            background: rgba(255, 255, 255, 0.2);
            color: #fff;
            cursor: pointer;
            transition: 0.2s;
            text-align: center;

            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            gap: 2px;
        }

        .tab-title {
            font-size: 0.75rem;
            line-height: 1;
        }

        .tab-count {
            font-size: 0.85rem;
            font-weight: 700;
            opacity: 0.9;
        }

        .simple-tabs .tab.active {
            background: #fff;
            color: #0c3f52;
        }

        .simple-tabs .tab.active .tab-count {
            color: #0c3f52;
        }

        .btn-reject {
            background: #e74c3c;
            color: #fff;
        }

        .btn-reject:hover {
            background: #c0392b;
        }

        .btn-cancel {
            background: #f39c12;
            color: #fff;
        }

        .btn-cancel:hover {
            background: #d68910;
        }
    </style>


    <!-- HEADER -->
    <div class="header-wrapper">
        <div class="checkout-header-content">
            <div class="checkout-header">
                <h2>Daftar Pesanan</h2>
                <small>Kelola semua pesanan restoran Anda dengan mudah dan cepat.</small>
            </div>
        </div>

        <!-- ✅ TAB DI DALAM HEADER -->
        <div class="order-tabs simple-tabs">
            <button class="tab active" data-status="new">
                <span class="tab-title">Baru</span>
                <span class="tab-count" data-count="new">0</span>
            </button>

            <button class="tab" data-status="driver">
                <span class="tab-title">Driver</span>
                <span class="tab-count" data-count="driver">0</span>
            </button>

            <button class="tab" data-status="deliver">
                <span class="tab-title">Antar</span>
                <span class="tab-count" data-count="deliver">0</span>
            </button>

            <button class="tab" data-status="completed">
                <span class="tab-title">Selesai</span>
                <span class="tab-count" data-count="completed">0</span>
            </button>

            <button class="tab" data-status="cancelled">
                <span class="tab-title">Batal</span>
                <span class="tab-count" data-count="cancelled">0</span>
            </button>
        </div>

    </div>


    <!-- CONTENT -->
    <div class="orders-container" id="orderContainer">

        <?php
        $statusMap = [
            "new"        => ["label" => "Menunggu Konfirmasi", "class" => "s-wait"],
            "process"    => ["label" => "Diproses", "class" => "s-process"],
            "searching"  => ["label" => "Mencari Driver", "class" => "s-search"], // ⭐ baris ini
            "driver"     => ["label" => "Menunggu Driver", "class" => "s-driver"],
            "deliver"    => ["label" => "Sedang Diantar", "class" => "s-deliver"],
            "completed"  => ["label" => "Selesai", "class" => "s-done"],
            "cancelled"  => ["label" => "Dibatalkan", "class" => "s-cancel"]
        ];


        ?>

        <?php foreach ($orders as $order): ?>

            <?php
            $status     = $statusMap[$order["status"]];
            $isDone     = $order["status"] === "completed";
            $isCancelled = $order["status"] === "cancelled";

            $totalItems = array_sum(array_column($order["items"], "qty"));
            ?>

            <div class="order-card 
    <?= ($order["status"] === "completed" || $order["status"] === "cancelled") ? 'done-card collapsed' : '' ?>"
                id="order-<?= $order['order_id'] ?>"
                data-status="<?= $order['status'] ?>"
                data-time="<?= strtotime($order['created_at']) ?>">



                <!-- TOP -->
                <div class="order-top">
                    <div>
                        <div class="order-id">#<?= $order["order_id"] ?></div>
                        <div class="order-date">
                            <?= date("d M Y — H:i", strtotime($order["datetime"])) ?>
                        </div>

                        <div class="order-detail">
                            <b>Customer:</b> <?= $order["customer_name"] ?><br>

                            <?php if (!in_array($order["status"], ["new", "process"]) && $order["driver_name"]): ?>
                                <b>Driver:</b> <?= $order["driver_name"] ?>
                            <?php endif; ?>
                        </div>

                    </div>

                    <div style="text-align:right;">
                        <div class="order-status <?= $status["class"] ?>">
                            <?= $status["label"] ?>
                        </div>

                        <?php if ($order["status"] === "driver" && $order["pin_code"]): ?>
                            <div class="pin-info">
                                <b>PIN:</b> <span style="font-size:1.2rem"><?= $order["pin_code"] ?></span>
                            </div>
                        <?php endif; ?>


                        <div class="small-total">Total: Rp <?= number_format($order["price"]) ?></div>
                    </div>
                </div>

                <!-- EXTRA -->
                <div class="order-extra">

                    <div class="order-detail">
                        <div class="order-items-title">
                            List Pesanan (<?= $totalItems ?> item):
                        </div>

                        <div class="order-items-wrapper">
                            <ul class="order-items-list">
                                <?php foreach ($order["items"] as $item): ?>
                                    <li>
                                        <?= $item["name"] ?> ×<?= $item["qty"] ?>

                                        <?php if (trim($item["note"]) !== ""): ?>
                                            <div style="margin-left:10px; font-size:0.85rem;">
                                                <i>Catatan:</i>
                                                <div style="margin-left:10px;">
                                                    <?php foreach (explode("\n", $item["note"]) as $line): ?>
                                                        • <?= $line ?><br>
                                                    <?php endforeach; ?>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                        </div>
                    </div>

                    <div class="order-detail">
                        <div class="bottom-row">
                            <div class="total-price">
                                <b>Total: Rp <?= number_format($order["price"]) ?></b>
                            </div>

                            <div class="action-button">

                                <?php if ($order["status"] === "new"): ?>

                                    <div style="display:flex; gap:8px;">
                                        <button class="btn-order btn-primary"
                                            data-action="accept"
                                            data-id="<?= $order["order_id"] ?>"
                                            data-timer="60">
                                            Terima
                                        </button>

                                        <button class="btn-order btn-reject"
                                            data-action="reject"
                                            data-id="<?= $order["order_id"] ?>">
                                            Tolak
                                        </button>
                                    </div>

                                <?php elseif ($order["status"] === "process"): ?>

                                    <div style="display:flex; gap:8px;">
                                        <button class="btn-order btn-primary"
                                            data-action="ready"
                                            data-id="<?= $order["order_id"] ?>">
                                            Tandai Siap
                                        </button>

                                        <button class="btn-order btn-cancel"
                                            data-action="cancel"
                                            data-id="<?= $order["order_id"] ?>">
                                            Batal
                                        </button>
                                    </div>
                                <?php elseif ($order["status"] === "deliver"): ?>
                                    <button class="btn-order btn-primary">Selesaikan</button>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>

                </div>
            </div>

        <?php endforeach; ?>

    </div>


    <!-- JS untuk expand/collapse -->
    <script>
        let AutoBidRestoran = 0;
        let userDataReady = false;

        window.addEventListener("msgFromServer", function(e) {
            const data = e.detail;
            const msgType = data.action;
            const msg = data.message;

            // alert(msgType);

            if (msgType == "cek_data") {
                if (msgType == "cek_data") {
                    AutoBidRestoran = data.message.user.auto_bid_resto;
                    userDataReady = true;
                }

            }

        });
        document.addEventListener("click", e => {
            const card = e.target.closest(".order-card.done-card");
            if (!card) return;
            card.classList.toggle("collapsed");
        });


        function renderOrder(order) {
            const template = document.getElementById("orderCardTemplate");
            const container = document.getElementById("orderContainer");

            const clone = template.content.cloneNode(true);
            const card = clone.querySelector(".order-card");

            // Tanggal
            const dt = new Date(order.datetime);
            clone.querySelector(".order-id").textContent = "#" + order.id;
            clone.querySelector(".order-date").textContent =
                dt.toLocaleDateString("id-ID") + " — " +
                dt.toLocaleTimeString("id-ID", {
                    hour: "2-digit",
                    minute: "2-digit"
                });

            // Customer
            clone.querySelector(".customer-name").textContent = order.customer_name;

            // Driver (hanya tampil jika bukan new/process)
            clone.querySelector(".driver-info").innerHTML =
                (!["new", "process"].includes(order.status) && order.driver_name) ?
                `<b>Driver:</b> ${order.driver_name}` :
                "";

            // Status
            const st = statusMap[order.status];
            const statusEl = clone.querySelector(".order-status");
            statusEl.textContent = st.label;
            statusEl.classList.add(st.class);

            // PIN jika status driver
            if (order.status === "driver" && order.pin_code) {
                clone.querySelector(".pin-info").innerHTML =
                    `<b>PIN:</b> <span style="font-size:1.2rem">${order.pin_code}</span>`;
            }

            // Items
            const ul = clone.querySelector(".order-items-list");
            order.items.forEach(i => {
                const li = document.createElement("li");
                li.innerHTML = `${i.name} ×${i.qty}`;

                if (i.note.trim()) {
                    li.innerHTML += `
                    <div style="margin-left:10px; font-size:0.85rem;">
                        <i>Catatan:</i>
                        <div style="margin-left:10px;">
                            ${i.note.split("\n").map(n => "• " + n).join("<br>")}
                        </div>
                    </div>`;
                }

                ul.appendChild(li);
            });

            // Title items
            clone.querySelector(".order-items-title").textContent =
                `List Pesanan (${order.items.reduce((a, b) => a + b.qty, 0)} item):`;

            // Harga
            const totalStr = `Total: Rp ${order.price.toLocaleString()}`;
            clone.querySelector(".total-price").innerHTML = `<b>${totalStr}</b>`;
            clone.querySelector(".small-total").textContent = totalStr;

            // Buttons
            const btn = clone.querySelector(".action-button");
            if (order.status === "new") btn.innerHTML = `<button class="btn-order btn-primary">Terima</button>`;
            if (order.status === "process") btn.innerHTML = `<button class="btn-order btn-primary">Tandai Siap</button>`;
            if (order.status === "deliver") btn.innerHTML = `<button class="btn-order btn-primary">Selesaikan</button>`;

            // Jika selesai → collapse
            if (order.status === "completed") {
                card.classList.add("done-card", "collapsed");
            }

            // TAMBAHKAN ORDER BARU DI PALING ATAS
            container.prepend(clone);

            updateTabCounts();
        }

        function waitForUserData(callback) {
            const interval = setInterval(() => {
                if (userDataReady) {
                    clearInterval(interval);
                    callback();
                }
            }, 100);
        }


        AndroidApp.showBottomNav();

        document.addEventListener("DOMContentLoaded", () => {
            waitForUserData(() => {

                const acceptButtons = document.querySelectorAll('button[data-action="accept"]');

                acceptButtons.forEach((btn) => {
                    const orderId = btn.dataset.id;


                    // Ambil timestamp timer dari localStorage
                    const savedTime = localStorage.getItem("order_timer_" + orderId);

                    if (savedTime) {
                        const elapsed = Math.floor((Date.now() - savedTime) / 1000);
                        const remaining = 60 - elapsed;

                        if (remaining <= 0) {
                            // Timer sudah habis → langsung auto accept
                            autoAccept(orderId, btn);
                        } else {
                            startAutoAcceptTimer(orderId, btn, remaining);
                        }
                    } else {
                        // Timer belum ada → mulai baru
                        startAutoAcceptTimer(orderId, btn, 60);
                    }
                });


                const tabs = document.querySelectorAll(".simple-tabs .tab");
                const cards = document.querySelectorAll(".order-card");


                function filterByStatus(status) {
                    const container = document.querySelector(".orders-container");
                    const cards = Array.from(document.querySelectorAll(".order-card"));

                    // TAB BARU (NEW + PROCESS DENGAN SORT KHUSUS)
                    if (status === "new") {

                        const newOrders = cards
                            .filter(c => c.dataset.status === "new")
                            // NEW → paling terbaru
                            .sort((a, b) => b.dataset.time - a.dataset.time);

                        const processOrders = cards
                            .filter(c => c.dataset.status === "process")
                            // PROCESS → paling awal
                            .sort((a, b) => a.dataset.time - b.dataset.time);

                        const searchingOrders = cards
                            .filter(c => c.dataset.status === "searching")
                            // SEARCHING → urut waktu normal
                            .sort((a, b) => a.dataset.time - b.dataset.time);

                        // sembunyikan semua dulu
                        cards.forEach(c => c.style.display = "none");

                        // gabungkan urutan
                        [...newOrders, ...processOrders, ...searchingOrders].forEach(card => {
                            card.style.display = "block";
                            container.appendChild(card);
                        });

                        return;
                    }


                    // TAB DRIVER
                    if (status === "driver") {
                        cards.forEach(card => {
                            const s = card.dataset.status;
                            card.style.display = (s === "driver") ? "block" : "none";
                        });
                        return;
                    }

                    // TAB LAIN (1:1)
                    cards.forEach(card => {
                        card.style.display = (card.dataset.status === status) ? "block" : "none";
                    });
                }

                // klik tab
                tabs.forEach(tab => {
                    tab.addEventListener("click", () => {
                        const status = tab.dataset.status;

                        // aktifkan tab
                        tabs.forEach(t => t.classList.remove("active"));
                        tab.classList.add("active");

                        // filter data
                        filterByStatus(status);
                    });
                });

                /* ==========================
                   🔥 DEFAULT SAAT LOAD
                   ========================== */

                // cari tab BARU
                const defaultTab = document.querySelector('.simple-tabs .tab[data-status="new"]');

                if (defaultTab) {
                    // set active
                    tabs.forEach(t => t.classList.remove("active"));
                    defaultTab.classList.add("active");

                    // tampilkan hanya data BARU
                    filterByStatus("new");
                }

            });

        });

        const autoTimers = {}; // simpan timer untuk setiap order

        function startAutoAcceptTimer(orderId, btn, duration = 10) {

            if (AutoBidRestoran == 1) {
                let timeLeft = duration;
                // Jika timer pertama kali dibuat → simpan timestamp
                if (!localStorage.getItem("order_timer_" + orderId)) {
                    localStorage.setItem("order_timer_" + orderId, Date.now());
                }
                btn.textContent = `Terima (${timeLeft})`;

                autoTimers[orderId] = setInterval(() => {
                    timeLeft--;
                    btn.textContent = `Terima (${timeLeft})`;

                    // User menekan tombol → stop auto accept
                    if (btn.dataset.clicked === "true") {
                        clearInterval(autoTimers[orderId]);
                        localStorage.removeItem("order_timer_" + orderId);
                        return;
                    }

                    // Waktu habis → auto accept
                    if (timeLeft <= 0) {
                        clearInterval(autoTimers[orderId]);
                        localStorage.removeItem("order_timer_" + orderId);
                        autoAccept(orderId, btn);
                    }
                }, 1000);
            }
        }


        // Fungsi auto accept
        async function autoAccept(orderId, btn) {
            console.log("🟢 AUTO ACCEPT order:", orderId);

            btn.disabled = true;
            btn.textContent = "Menerima...";

            await acceptOrder(orderId, btn);
        }


        // Fungsi manual accept (dipanggil dari tombol)
        document.addEventListener("click", async (e) => {
            const btn = e.target.closest(".btn-order");

            if (!btn) return;
            if (btn.dataset.action !== "accept") return;

            const orderId = btn.dataset.id;
            btn.dataset.clicked = "true"; // hentikan countdown

            btn.disabled = true;
            btn.textContent = "Menerima...";

            await acceptOrder(orderId, btn);
        });


        // Fungsi kirim request ke backend
        async function acceptOrder(orderId, btn) {

            try {
                const res = await fetch("/restaurant/order/accept", {
                    method: "POST",
                    headers: {
                        "Content-Type": "application/json"
                    },
                    body: JSON.stringify({
                        id: orderId
                    })
                });

                const json = await res.json();

                if (!json.success) {
                    alert(json.message || "Gagal menerima pesanan");
                    btn.disabled = false;
                    btn.textContent = "Terima";
                    return;
                }
                window.AndroidApp.stopOrderSound();
                updateOrderStatus(orderId, "process");

            } catch (err) {
                alert("Koneksi error!");
                btn.disabled = false;
                btn.textContent = "Terima";
            }
        }


        // UPDATE UI setelah diterima
        function updateOrderStatus(orderId, newStatus) {
            const card = document.getElementById(`order-${orderId}`);
            if (!card) return;

            const statusMap = {
                "new": {
                    label: "Menunggu Konfirmasi",
                    class: "s-wait"
                },
                "process": {
                    label: "Diproses",
                    class: "s-process"
                },
                "searching": {
                    label: "Mencari Driver",
                    class: "s-search"
                }, // ⭐ baris ini
                "driver": {
                    label: "Menunggu Driver",
                    class: "s-driver"
                },
                "deliver": {
                    label: "Sedang Diantar",
                    class: "s-deliver"
                },
                "completed": {
                    label: "Selesai",
                    class: "s-done"
                },
                "cancelled": {
                    label: "Dibatalkan",
                    class: "s-cancel"
                }
            };



            const badge = card.querySelector(".order-status");
            badge.textContent = statusMap[newStatus].label;
            badge.className = "order-status " + statusMap[newStatus].class;

            // Ganti tombol jadi "Tandai Siap"
            const btnArea = card.querySelector(".action-button");
            btnArea.innerHTML = `
            <button class="btn-order btn-primary" data-action="ready" data-id="${orderId}">
                Tandai Siap
            </button>
            
        `;
            window.location.href = `${baseUrl}/restaurant_order`;
        }


        document.addEventListener("click", async (e) => {
            const btn = e.target.closest(".btn-order");
            if (!btn) return;

            const action = btn.dataset.action;
            const orderId = btn.dataset.id;

            if (!action || !orderId) return;

            if (action === "ready") {
                btn.disabled = true;
                btn.textContent = "Memproses...";
                await setOrderReady(orderId, btn);
            }
        });

        async function setOrderReady(orderId, btn) {
            try {
                const res = await fetch("/restaurant/order/ready", {
                    method: "POST",
                    headers: {
                        "Content-Type": "application/json"
                    },
                    body: JSON.stringify({
                        id: orderId
                    })
                });

                const json = await res.json();

                if (!json.success) {
                    alert(json.message || "Gagal mengubah status");
                    btn.disabled = false;
                    btn.textContent = "Tandai Siap";
                    return;
                }

                updateOrderStatusToDriver(orderId, json.pin_code);


            } catch (err) {
                alert("Koneksi error!");
                btn.disabled = false;
                btn.textContent = "Tandai Siap";
            }
        }

        function updateOrderStatusToDriver0(orderId) {
            const card = document.getElementById(`order-${orderId}`);
            if (!card) return;

            const badge = card.querySelector(".order-status");
            badge.textContent = "Menunggu Driver";
            badge.className = "order-status s-driver";

            // Ganti tombol jadi "Selesaikan"
            const btnArea = card.querySelector(".action-button");
            btnArea.innerHTML = `
            <button class="btn-order btn-primary" data-action="deliver" data-id="${orderId}">
                Selesaikan
            </button>
        `;
            updateTabCounts();
        }

        function updateOrderStatusToDriver(orderId, pinCode = null) {
            const card = document.getElementById(`order-${orderId}`);
            if (!card) return;

            // Update badge status menjadi "Mencari Driver"
            const badge = card.querySelector(".order-status");
            badge.textContent = "Mencari Driver";
            badge.className = "order-status s-search";

            // Hilangkan tombol
            const btnArea = card.querySelector(".action-button");
            btnArea.innerHTML = "";

            // Hapus PIN jika mode mencari driver (PIN hanya muncul ketika driver menerima)
            let pinWrapper = card.querySelector(".pin-info");
            if (pinWrapper) pinWrapper.remove();
        }

        window.addEventListener("msgFromServer", function(e) {
            const data = e.detail;
            const msgType = data.action;
            const msg = data.message;

            if (msgType == "cek_data") {
                UserData = msg.user;
            } else if (msgType == "food_accept" || msgType == "pin_valid" || msgType == "completed" || msgType == "food_order_cancel") {
                // window.location.reload();
                window.location.href = `${baseUrl}/restaurant_order`;
            }
        });

        function updateTabCounts() {
            const cards = document.querySelectorAll(".order-card");

            const counts = {
                new: 0,
                driver: 0,
                deliver: 0,
                completed: 0,
                cancelled: 0
            };

            cards.forEach(card => {
                const status = card.dataset.status;

                // TAB BARU = new + process
                if (status === "new" || status === "process" || status === "searching") {
                    counts.new++;
                } else if (status === "driver") {
                    counts.driver++;
                } else if (counts.hasOwnProperty(status)) {
                    counts[status]++;
                }
            });

            document.querySelectorAll(".tab-count").forEach(el => {
                const key = el.dataset.count;
                el.textContent = counts[key] ?? 0;
            });
        }

        updateTabCounts();

        document.addEventListener("click", async (e) => {
            const btn = e.target.closest(".btn-order");
            if (!btn) return;

            const action = btn.dataset.action;
            const orderId = btn.dataset.id;

            if (action === "cancel") {
                if (!confirm("Batalkan pesanan ini?")) return;

                btn.disabled = true;
                btn.textContent = "Membatalkan...";

                try {
                    const res = await fetch("/restaurant/order/cancel", {
                        method: "POST",
                        headers: {
                            "Content-Type": "application/json"
                        },
                        body: JSON.stringify({
                            id: orderId
                        })
                    });

                    const json = await res.json();

                    if (!json.success) {
                        alert(json.message || "Gagal membatalkan pesanan");
                        btn.disabled = false;
                        btn.textContent = "Batal";
                        return;
                    }

                    updateOrderStatus(orderId, "cancelled");

                } catch (err) {
                    alert("Koneksi error!");
                    btn.disabled = false;
                    btn.textContent = "Batal";
                }
            }
        });
    </script>



    <?= $this->endSection() ?>