<?= $this->extend('layout/main') ?>
<?= $this->section('content') ?>

<style>
    body {
        margin: 0;
        padding: 0;
        font-family: "Poppins", sans-serif;
        background: linear-gradient(135deg, #16a085, #2980b9);
        color: #fff;
        min-height: 100vh;
        overflow-x: hidden;
    }



    /* CONTAINER – MULAI DARI ATAS */
    .menu-container {
        width: 95%;
        padding-top: 90px;
        min-height: calc(100vh - 100px);
        /* agar mulai dari atas */
        overflow-y: auto;
        overflow-x: hidden;
    }


    /* BUTTON TAMBAH MENU */
    .btn-add {
        background: rgba(255, 255, 255, 0.18);
        border: 1px solid rgba(255, 255, 255, 0.35);
        padding: 10px 14px;
        border-radius: 12px;
        color: #fff;
        font-weight: 600;
        cursor: pointer;
        display: inline-flex;
        align-items: center;
        gap: 8px;
        transition: 0.25s;
        margin-bottom: 18px;
        font-size: 0.85rem;
    }

    .btn-add:hover {
        background: rgba(255, 255, 255, 0.28);
        transform: translateY(-2px);
    }

    /* GRID MENU */
    .menu-grid {
        display: flex;
        flex-direction: column;
        gap: 14px;
    }


    /* CARD MENU — COMPACT */
    .menu-card {
        display: flex;
        gap: 12px;

        background: rgba(255, 255, 255, 0.12);
        border: 1px solid rgba(255, 255, 255, 0.25);
        border-radius: 14px;
        backdrop-filter: blur(12px);
        padding: 10px;

        cursor: pointer;
        transition: 0.25s;
    }


    /* .menu-card:hover {
        background: rgba(255, 255, 255, 0.22);
        transform: translateY(-3px);
    } */

    /* .menu-img {
        width: 100%;
        height: 90px;
        object-fit: cover;
        border-radius: 10px;
        margin-bottom: 6px;
    } */
    /* 
    .menu-info {
        flex: 1;
        display: flex;
        flex-direction: column;
    }
 */

    .menu-img {
        width: 90px;
        height: 90px;
        aspect-ratio: 1/1;
        object-fit: cover;
        border-radius: 10px;
        flex-shrink: 0;
    }



    .menu-info {
        flex: 1;
        display: flex;
        flex-direction: column;
        justify-content: space-between;
    }

    .menu-name {
        font-size: 0.95rem;
        font-weight: 700;
        margin-bottom: 4px;
        line-height: 1.25;
        color: #fff;
    }

    .menu-price {
        font-size: 0.85rem;
        font-weight: 600;
        color: #f1f1f1;
        margin-bottom: 6px;
    }

    /* Toggle row berada di kiri */
    .status-row {
        margin-top: 6px;
        display: flex;
        justify-content: flex-start;
        align-items: center;
    }

    /* Chip toggle lebih proporsional */
    .status-toggle {
        display: inline-flex;
        align-items: center;
        gap: 6px;

        padding: 5px 10px;
        font-size: 0.75rem;
        font-weight: 600;

        border-radius: 8px;
        cursor: pointer;
        border: 1px solid rgba(255, 255, 255, 0.25);
        backdrop-filter: blur(8px);

        transition: 0.25s ease;
    }

    /* Warna lebih kalem */
    .status-on {
        background: rgba(46, 204, 113, 0.15);
        border-left: 4px solid #2ecc71;
        color: #b7ffd3;
    }

    .status-off-toggle {
        background: rgba(231, 76, 60, 0.15);
        border-left: 4px solid #e74c3c;
        color: #ffc3c3;
    }

    .status-toggle i {
        font-size: 1rem;
    }


    /* === HEADER FIXED FULL WIDTH === */
    .header-wrapper {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        background: linear-gradient(135deg, #16a085, #2980b9);
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.15);
        z-index: 999;
    }

    .checkout-header-content {
        width: 90%;
        max-width: 1200px;
        margin: 0 auto;
        padding: 10px 0 14px 0;
        display: flex;
        align-items: center;
        justify-content: space-between;
    }

    /* === BACK ICON === */
    .back-icon {
        color: #fff;
        font-size: 1.3rem;
        cursor: pointer;
        background: rgba(255, 255, 255, 0.15);
        width: 36px;
        height: 36px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        text-decoration: none;
        /* ✅ tanpa garis bawah */
        transition: background 0.2s, transform 0.1s;
    }

    .back-icon:hover {
        background: rgba(255, 255, 255, 0.3);
    }

    .back-icon:active {
        transform: scale(0.9);
    }

    /* === HEADER TENGAH === */
    .checkout-header {
        flex: 1;
        text-align: center;
        color: #fff;
    }

    .checkout-header h2 {
        margin: 0;
        font-size: 1.5rem;
        font-weight: 700;
    }

    .add-icon {
        color: #fff;
        font-size: 1.3rem;
        cursor: pointer;
        background: rgba(255, 255, 255, 0.15);
        width: 36px;
        height: 36px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        transition: background 0.2s, transform 0.1s;
        text-decoration: none;
    }

    .add-icon:hover {
        background: rgba(255, 255, 255, 0.3);
    }

    .add-icon:active {
        transform: scale(0.9);
    }


    .status-btn {
        padding: 6px 12px;
        font-size: 0.78rem;
        font-weight: 700;
        border-radius: 8px;
        border: none;
        cursor: pointer;
        transition: 0.25s;
        color: #fff;
    }

    .status-available {
        background: #2ecc71;
        box-shadow: 0 0 6px rgba(46, 204, 113, 0.4);
    }

    .status-off {
        background: #e74c3c;
        box-shadow: 0 0 6px rgba(231, 76, 60, 0.4);
    }

    .status-row {
        margin-top: 4px;
        display: flex;
        align-items: center;
        justify-content: flex-start;
        /* pindah ke kiri */
        gap: 10px;
    }


    .status-text {
        font-size: 0.78rem;
        font-weight: 700;
    }

    .txt-available {
        color: #2ecc71;
    }

    .txt-off {
        color: #ff5252;
    }


    .status-toggle {
        display: inline-flex;
        align-items: center;
        gap: 8px;

        padding: 6px 12px;

        border-radius: 10px;
        font-size: 0.8rem;
        font-weight: 600;

        cursor: pointer;
        user-select: none;

        transition: 0.25s ease;
        backdrop-filter: blur(12px);

        border: 1px solid rgba(255, 255, 255, 0.22);
    }

    /* --- AVAILABLE (Soft Green) --- */
    .status-on {
        background: rgba(52, 211, 153, 0.18);
        /* green-400 transparency */
        color: #A7F3D0;
        /* green-200 text */
        border-left: 4px solid #34D399;
        /* green-400 */
    }

    /* --- OFF (Soft Red) --- */
    .status-off-toggle {
        background: rgba(248, 113, 113, 0.18);
        /* red-400 transparency */
        color: #FECACA;
        /* red-200 text */
        border-left: 4px solid #F87171;
        /* red-400 */
    }

    .status-toggle i {
        font-size: 1.05rem;
        opacity: 0.9;
    }
</style>

<div class="header-wrapper">
    <div class="checkout-header-content">

        <!-- Tombol Back -->
        <a href="javascript:void(0)" id="backToMenu" class="back-icon">
            <i class="fa-solid fa-arrow-left"></i>
        </a>

        <!-- Title -->
        <div class="checkout-header">
            <h2>Daftar Menu Restoran</h2>
            <small>Kelola semua menu makanan & minuman Anda.</small>
        </div>

        <!-- Tombol Tambah Menu (ikon saja) -->
        <a href="/restaurant_menu_add?restaurant_id=<?= $restaurant_id ?>"
            class="add-icon">
            <i class="fa-solid fa-plus"></i>
        </a>

    </div>
</div>


<div class="menu-container">

    <!-- BUTTON TAMBAH MENU -->
    <!-- <button class="btn-add" onclick="window.location.href='/restaurant_menu_add?restaurant_id=<?= $restaurant_id ?>'">
        <i class="fa-solid fa-circle-plus"></i> Tambah Menu Baru
    </button> -->

    <!-- GRID -->
    <div class="menu-grid">

        <?php foreach ($menus as $menu): ?>
            <div class="menu-card" onclick="editMenu(<?= $menu['id'] ?>)">

                <img
                    src="<?= !empty($menu['image_url']) ? esc($menu['image_url']) : 'https://img.icons8.com/ios-filled/100/ffffff/restaurant.png' ?>"
                    class="menu-img"
                    onerror="this.onerror=null; this.src='https://img.icons8.com/ios-filled/100/ffffff/restaurant.png'">


                <div class="menu-info">
                    <div>
                        <div class="menu-name"><?= esc($menu['name']) ?></div>
                        <div class="menu-price">Rp <?= number_format($menu['price'], 0, ',', '.') ?></div>
                    </div>

                    <div class="status-row" onclick="event.stopPropagation()">
                        <div class="status-toggle <?= $menu['available'] ? 'status-on' : 'status-off-toggle' ?>"
                            onclick="toggleStatus(<?= $menu['id'] ?>, this)">
                            <i class="fa-solid <?= $menu['available'] ? 'fa-toggle-on' : 'fa-toggle-off' ?>"></i>
                            <span><?= $menu['available'] ? 'Tersedia' : 'Habis' ?></span>
                        </div>
                    </div>
                </div>


            </div>

        <?php endforeach; ?>

    </div>

</div>


<script>
    document.getElementById("backToMenu").addEventListener("click", () => {
        window.location.href = "/restaurant";
    });

    // ============================
    // UPDATE STATUS LEWAT API
    // ============================
    async function toggleStatus0(menuId, el) {
        let active = el.checked ? 1 : 0;

        try {
            await fetch(`/restaurant/ToggleMenuStatus/${menuId}`, {
                method: "POST"
            });

            // Ubah badge warna langsung (real-time)
            let card = el.closest(".menu-card");
            let badge = card.querySelector(".badge");

            if (active == 1) {
                badge.classList.remove("badge-off");
                badge.classList.add("badge-active");
                badge.innerText = "Tersedia";
            } else {
                badge.classList.remove("badge-active");
                badge.classList.add("badge-off");
                badge.innerText = "Habis";
            }

            // Refresh halaman setelah 300ms
            setTimeout(() => {
                location.reload();
            }, 300);

        } catch (err) {
            console.log(err);
        }
    }

    async function toggleStatus1(menuId, el) {

        let res = await fetch(`/restaurant/ToggleMenuStatus/${menuId}`, {
            method: "POST"
        });

        let json = await res.json();

        if (!json.success) {
            alert("Gagal mengubah status!");
            return;
        }

        let isActive = json.available == 1;

        let row = el.closest(".status-row");
        let txt = row.querySelector(".status-text");

        if (isActive) {
            txt.classList.remove("txt-off");
            txt.classList.add("txt-available");
            txt.innerText = "Tersedia";
        } else {
            txt.classList.remove("txt-available");
            txt.classList.add("txt-off");
            txt.innerText = "Habis";
        }

        // Refresh halaman setelah 300ms
        setTimeout(() => {
            location.reload();
        }, 300);
    }

    async function toggleStatus(menuId, el) {

        let res = await fetch(`/restaurant/ToggleMenuStatus/${menuId}`, {
            method: "POST"
        });

        let json = await res.json();

        if (!json.success) {
            alert("Gagal mengubah status!");
            return;
        }

        let active = json.available == 1;

        // Ubah UI
        if (active) {
            el.classList.remove("status-off-toggle");
            el.classList.add("status-on");

            el.querySelector("i").classList.remove("fa-toggle-off");
            el.querySelector("i").classList.add("fa-toggle-on");

            el.querySelector("span").innerText = "Tersedia";

        } else {
            el.classList.remove("status-on");
            el.classList.add("status-off-toggle");

            el.querySelector("i").classList.remove("fa-toggle-on");
            el.querySelector("i").classList.add("fa-toggle-off");

            el.querySelector("span").innerText = "Habis";
        }

        // Refresh halaman setelah 300ms
        setTimeout(() => {
            location.reload();
        }, 300);
    }


    function editMenu(menuId) {
        window.location.href =
            `/restaurant_menu_add?menu_id=${menuId}&restaurant_id=<?= $restaurant_id ?>`;
    }
</script>

<?= $this->endSection() ?>