<?= $this->extend('layout/main') ?>
<?= $this->section('content') ?>

<link href="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.6.1/cropper.min.css" rel="stylesheet">
<script src="https://cdnjs.cloudflare.com/ajax/libs/cropperjs/1.6.1/cropper.min.js"></script>


<style>
    body {
        margin: 0;
        padding: 0;
        font-family: "Poppins", sans-serif;
        background: linear-gradient(135deg, #16a085, #2980b9);
        color: #fff;
        min-height: 100vh;
        overflow-x: hidden;
    }

    /* CONTAINER FULL SCREEN */
    .menu-container {
        width: 95%;
        padding-top: 110px;
        min-height: calc(100vh - 100px);
        overflow-y: auto;
        overflow-x: hidden;
    }

    .form-group {
        margin-bottom: 20px;
    }

    .form-label {
        font-size: 1rem;
        font-weight: 600;
        margin-bottom: 6px;
        display: block;
        color: #eaf7ff;
    }

    /* INPUT STYLE */
    .form-input,
    .form-select,
    .form-textarea {
        width: 100%;
        padding: 12px 14px;
        border-radius: 12px;
        border: 1px solid rgba(255, 255, 255, 0.3);
        background: rgba(255, 255, 255, 0.18);
        color: #fff;
        font-size: 1rem;
        outline: none;
    }

    .form-textarea {
        height: 90px;
        resize: none;
    }

    /* UPLOAD IMAGE */
    .upload-box {
        border: 2px dashed rgba(255, 255, 255, 0.38);
        padding: 25px 14px;
        text-align: center;
        border-radius: 14px;
        cursor: pointer;
        transition: 0.25s;
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        min-height: 170px;
        position: relative;
    }

    .upload-box:hover {
        background: rgba(255, 255, 255, 0.1);
    }

    #previewImage {
        width: 200px;
        height: 200px;
        object-fit: cover;
        border-radius: 14px;
        display: none;
        margin: 0 auto;
    }

    /* SWITCH MODERN */
    .switch-wrapper {
        display: flex;
        align-items: center;
        gap: 14px;
        margin-top: 8px;
    }

    .switch input {
        display: none;
    }

    .switch-btn {
        width: 60px;
        height: 32px;
        background: #c62828;
        border-radius: 20px;
        position: relative;
        cursor: pointer;
        transition: 0.25s ease;
        box-shadow: inset 0 0 6px rgba(0, 0, 0, 0.4);
    }

    .switch-btn::before {
        content: "";
        width: 26px;
        height: 26px;
        background: #fff;
        border-radius: 50%;
        position: absolute;
        top: 3px;
        left: 4px;
        transition: 0.25s ease;
        box-shadow: 0 2px 6px rgba(0, 0, 0, 0.35);
    }

    .switch input:checked+.switch-btn {
        background: #00e676;
        box-shadow: 0 0 10px #00ff80;
    }

    .switch input:checked+.switch-btn::before {
        transform: translateX(28px);
    }

    .switch-text {
        font-size: 1rem;
        font-weight: 600;
        letter-spacing: 0.3px;
    }

    /* BUTTON */
    .btn-save {
        width: 100%;
        padding: 13px;
        background: #0c3f52;
        border: none;
        border-radius: 12px;
        color: #fff;
        font-size: 1.05rem;
        font-weight: 600;
        cursor: pointer;
        transition: 0.25s;
        margin-top: 15px;
    }

    .btn-save:hover {
        background: #082e3c;
        transform: translateY(-2px);
    }

    /* === HEADER FIXED FULL WIDTH === */
    .header-wrapper {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        background: linear-gradient(135deg, #16a085, #2980b9);
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.15);
        z-index: 999;
    }

    .checkout-header-content {
        width: 90%;
        max-width: 1200px;
        margin: 0 auto;
        padding: 10px 0 14px 0;
        display: flex;
        align-items: center;
        justify-content: space-between;
    }

    /* === BACK ICON === */
    .back-icon {
        color: #fff;
        font-size: 1.3rem;
        cursor: pointer;
        background: rgba(255, 255, 255, 0.15);
        width: 36px;
        height: 36px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        text-decoration: none;
        transition: background 0.2s, transform 0.1s;
    }

    .back-icon:hover {
        background: rgba(255, 255, 255, 0.3);
    }

    .back-icon:active {
        transform: scale(0.9);
    }

    .delete-icon {
        color: #fff;
        font-size: 1.3rem;
        cursor: pointer;
        background: rgba(255, 0, 0, 0.35);
        width: 36px;
        height: 36px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        text-decoration: none;
        transition: background 0.2s, transform 0.1s;
    }

    .delete-icon:hover {
        background: rgba(255, 0, 0, 0.55);
    }

    .delete-icon:active {
        transform: scale(0.9);
    }


    /* === HEADER TENGAH === */
    .checkout-header {
        flex: 1;
        text-align: center;
        color: #fff;
    }

    .checkout-header h2 {
        margin: 0;
        font-size: 1.5rem;
        font-weight: 700;
    }

    /* SWITCH KECIL (SAMA DENGAN HALAMAN DAFTAR MENU) */
    .switch-small {
        display: inline-flex;
        align-items: center;
        cursor: pointer;
    }

    .switch-small input {
        display: none;
    }

    .toggle-btn {
        width: 40px;
        height: 20px;
        background: #ff5252;
        border-radius: 20px;
        position: relative;
        transition: 0.25s;
    }

    .toggle-btn::before {
        content: "";
        width: 16px;
        height: 16px;
        background: #fff;
        border-radius: 50%;
        position: absolute;
        top: 2px;
        left: 2px;
        transition: 0.25s;
    }

    .switch-small input:checked+.toggle-btn {
        background: #00e676;
    }

    .switch-small input:checked+.toggle-btn::before {
        transform: translateX(20px);
    }




    .topup-input {
        display: flex;
        flex-direction: column;
        width: 80%;
        max-width: 360px;
        gap: 15px;


        font-size: 1rem;
        font-weight: 600;
        margin-bottom: 6px;
        display: block;
        color: #eaf7ff;
    }

    .topup-input label {
        font-size: 16px;
        font-weight: 600;
    }

    .topup-input input {
        padding: 15px;
        border-radius: 10px;
        border: none;
        font-size: 18px;
        outline: none;
        text-align: right;
        color: #333;
    }

    .input-wrapper {
        position: relative;
        width: 100%;

        font-size: 1rem;
        font-weight: 600;
        margin-bottom: 6px;
        display: block;
        color: #eaf7ff;
    }

    .input-wrapper .prefix {
        position: absolute;
        left: 15px;
        top: 50%;
        transform: translateY(-50%);
        color: #eaf7ff;
        font-weight: 600;
        font-size: 1rem;
        pointer-events: none;
        z-index: 2;
        /* Tambahkan ini */
    }

    .input-wrapper input {
        width: 100%;
        padding: 14px 15px 14px 45px;
        /* ruang kiri untuk "Rp" */
        border-radius: 10px;
        border: none;
        font-size: 1rem;
        font-weight: 600;
        outline: none;
        text-align: left;
        color: #eaf7ff;
        /* background: rgba(255, 255, 255, 0.95); */
        /* sedikit transparan */
        box-shadow: 0 3px 8px rgba(0, 0, 0, 0.15);
        transition: transform 0.2s ease;
        position: relative;
        z-index: 1;
        /* agar di bawah prefix */
    }
</style>

<?php
$isEdit = isset($menu);
$menuEmpty = session()->getFlashdata('menu_empty');
?>




<div class="header-wrapper">
    <div class="checkout-header-content">
        <a href="javascript:void(0)" id="backToMenu" class="back-icon">
            <i class="fa-solid fa-arrow-left"></i>
        </a>

        <div class="checkout-header">
            <h2><?= $isEdit ? 'Edit Menu' : 'Tambah Menu Baru' ?></h2>
            <small><?= $isEdit ? 'Update informasi menu Anda.' : 'Masukkan informasi lengkap menu baru.' ?></small>
        </div>
        <?php if ($isEdit): ?>
            <a href="javascript:void(0)" id="deleteMenuBtn" class="delete-icon">
                <i class="fa-solid fa-trash"></i>
            </a>
        <?php else: ?>
            <div style="width:36px;"></div>
        <?php endif; ?>

    </div>
</div>


<div class="menu-container">

    <!-- FOTO MENU -->
    <!-- <div class="form-group">
        <label class="form-label">Foto Menu</label>

        <div class="upload-box" onclick="document.getElementById('menuImage').click()">
            <div id="uploadIcon">
                <i class="fa-solid fa-image" style="font-size:2.2rem; opacity:0.8;"></i>
                <div style="margin-top:6px;">Klik untuk upload gambar</div>
            </div>

            <img id="previewImage">
            <div id="uploadError" class="upload-error-text">Ukuran foto maksimal 1 MB</div>
        </div>

        <input type="file" id="menuImage" name="image" accept="image/*" style="display:none;">
    </div> -->

    <div class="form-group upload-container">
        <label class="form-label">Foto Menu</label>

        <div class="upload-box" data-input="menuImage">
            <div class="uploadIcon" id="uploadIcon">
                <i class=" fa-solid fa-image" style="font-size:2.2rem; opacity:0.8;"></i>
                <div style="margin-top:6px;">Klik untuk upload gambar</div>
            </div>

            <img class="previewImage previewImg" id="previewImage">
            <div class="uploadError upload-error-text">Ukuran foto maksimal 1 MB</div>
        </div>

        <input type="file" id="menuImage" name="image"
            data-width="200" data-height="200"
            accept="image/*" style="display:none;">
    </div>


    <!-- NAMA MENU -->
    <div class="form-group">
        <label class="form-label">Nama Menu</label>
        <input
            class="form-input"
            type="text"
            name="name"
            value="<?= $isEdit ? esc($menu['name']) : '' ?>">
    </div>

    <!-- KATEGORI -->
    <div class="form-group">
        <label class="form-label">Kategori</label>
        <select class="form-select" name="category">
            <option value="">Pilih Kategori</option>
            <option value="Makanan" <?= $isEdit && $menu['category'] === 'Makanan' ? 'selected' : '' ?>>Makanan</option>
            <option value="Minuman" <?= $isEdit && $menu['category'] === 'Minuman' ? 'selected' : '' ?>>Minuman</option>
            <option value="Cemilan" <?= $isEdit && $menu['category'] === 'Cemilan' ? 'selected' : '' ?>>Cemilan</option>
            <option value="Paket Hemat" <?= $isEdit && $menu['category'] === 'Paket Hemat' ? 'selected' : '' ?>>Paket Hemat</option>
        </select>
    </div>

    <!-- HARGA -->
    <div class="form-group">
        <!-- <label class="form-label">Harga Menu</label>
        <input
            id="harga"
            class="form-input"
            type="number"
            name="price"
            value="<?= $isEdit ? $menu['price'] : '' ?>">

        <div class="form-label">
            <label class="form-label">Harga Menu</label>
            <div class="form-label">
                <span class="prefix">Rp</span>
                <input type="number" class="form-input" id="harga" inputmode="numeric" placeholder="0">
            </div>
        </div> -->

        <div class="form-label">
            <label>Harga Menu</label>
            <div class="input-wrapper">
                <span class="prefix">Rp</span>
                <input class="form-input" id="harga" inputmode="numeric" placeholder="0" name="price" value="<?= $isEdit ? $menu['price'] : '' ?>">
            </div>
        </div>
    </div>



    <!-- DESKRIPSI -->
    <div class="form-group">
        <label class="form-label">Deskripsi</label>
        <textarea
            class="form-textarea"
            name="description"
            placeholder="Contoh: Pedas level 5, sambal terpisah."><?= $isEdit ? esc($menu['description']) : '' ?></textarea>
    </div>

    <!-- STATUS -->
    <div class="form-group">
        <label class="form-label">Status Menu</label>
        <div class="switch-wrapper">
            <label class="switch-small">
                <input
                    type="checkbox"
                    id="menuActive"
                    name="active"
                    <?= $isEdit ? ($menu['available'] ? 'checked' : '') : 'checked' ?>>
                <span class="toggle-btn"></span>
            </label>
            <span class="switch-text" id="statusText">
                <?= $isEdit ? ($menu['available'] ? 'Aktif' : 'Nonaktif') : 'Aktif' ?>
            </span>
        </div>
    </div>

    <button class="btn-save"><?= $isEdit ? 'Update Menu' : 'Simpan Menu' ?></button>
</div>

<script>
    const backBtn = document.getElementById("backToMenu");
    const menuEmpty = <?= $menuEmpty ? 'true' : 'false' ?>;
    const restaurantId = "<?= $restaurant_id ?>";
    token = "<?= $token ?>";
    phone = "<?= $phone ?>";
    const isEdit = <?= $isEdit ? 'true' : 'false' ?>;
    const nominalInput = document.getElementById("harga");

    // Format harga saat halaman pertama kali dibuka
    document.addEventListener("DOMContentLoaded", () => {
        if (nominalInput.value) {
            let raw = nominalInput.value.replace(/\D/g, "");
            nominalInput.value = formatRupiah(raw);
        }
    });


    backBtn.addEventListener("click", () => {
        if (menuEmpty) {
            window.location.href = "/restaurant";
        } else {
            window.location.href = `/restaurant_menu?restaurant_id=${restaurantId}`;
        }
    });

    const menuActive = document.getElementById("menuActive");
    const statusText = document.getElementById("statusText");

    menuActive.addEventListener("change", () => {
        statusText.textContent = menuActive.checked ? "Aktif" : "Nonaktif";
    });

    // Jika EDIT dan sudah ada image_url → tampilkan di preview
    <?php if ($isEdit && !empty($menu['image_url'])): ?>
        document.addEventListener("DOMContentLoaded", () => {
            const preview = document.getElementById('previewImage');
            const uploadIcon = document.getElementById('uploadIcon');

            preview.src = "<?= esc($menu['image_url']) ?>";
            preview.style.display = "block";
            uploadIcon.style.display = "none";
        });
    <?php endif; ?>

    document.querySelector(".btn-save").addEventListener("click", async () => {
        showLoading();
        const hargaMenu = getNominalNumber(nominalInput);
        const formData = new FormData();

        // image: pakai hasil crop kalau ada, kalau tidak pakai file asli (kalau ada)
        // Tambahkan hanya jika ada gambar hasil crop
        if (window.finalBlob) {
            Object.keys(window.finalBlob).forEach(id => {
                formData.append(id, window.finalBlob[id], id + ".jpg");
            });
        }

        formData.append("name", document.querySelector("input[name='name']").value);
        formData.append("category", document.querySelector("select[name='category']").value);
        formData.append("price", hargaMenu);
        formData.append("description", document.querySelector("textarea[name='description']").value);
        formData.append("available", document.getElementById("menuActive").checked ? 1 : 0);
        formData.append("restaurant_id", restaurantId);
       

        // kalau edit, kirim menu_id
        if (isEdit) {
            formData.append("menu_id", "<?= $isEdit ? $menu['id'] : '' ?>");
        }

        const addUrl = `/restaurant_menu_add?restaurant_id=${restaurantId}&token=${token}&phone=${phone}`;
        const updateUrl = "/restaurant_menu_update";
        const url = isEdit ? updateUrl : addUrl;

        let res = await fetch(url, {
            method: "POST",
            body: formData
        });

        let resJson = await res.json();
        hideLoading();

        if (resJson.success) {
            window.location.href = `/restaurant_menu?restaurant_id=${restaurantId}&token=${token}&phone=${phone}`;
        } else {
            alert("Gagal menyimpan menu");
        }
    });



    <?php if ($isEdit): ?>
        document.getElementById("deleteMenuBtn").addEventListener("click", async () => {

            if (!confirm("Yakin ingin menghapus menu ini?")) return;

            showLoading();

            const menuId = "<?= $menu['id'] ?>";

            let res = await fetch(`/restaurant_menu_delete/${menuId}`, {
                method: "DELETE"
            });

            let resJson = await res.json();
            hideLoading();

            if (resJson.success) {
                alert("Menu berhasil dihapus.");
                window.location.href = `/restaurant_menu?restaurant_id=${restaurantId}&token=${token}&phone=${phone}`;
            } else {
                alert("Gagal menghapus menu.");
            }
        });
    <?php endif; ?>



    nominalInput.addEventListener("input", function(e) {
        // Hapus semua karakter non-digit
        let value = e.target.value.replace(/\D/g, "");

        // Cegah nilai lebih dari 12 digit (bisa ubah sesuai kebutuhan)
        if (value.length > 12) value = value.slice(0, 12);

        // Format ke Rupiah
        e.target.value = formatRupiah(value);
    });
</script>

<?= $this->endSection() ?>