<?= $this->extend('layout/main') ?>
<?= $this->section('content') ?>

<style>
    body {
        margin: 0;
        padding: 0;
        height: 100vh;
        background: linear-gradient(135deg, #16a085, #2980b9);
        display: flex;
        justify-content: center;
        align-items: center;
        font-family: 'Segoe UI', sans-serif;
        color: #fff;
        text-align: center;
    }

    .register-container {
        width: 100%;
        max-width: 400px;
        padding: 30px 20px;
    }

    .logo {
        width: 120px;
        margin-bottom: 20px;
    }

    h2 {
        font-weight: 700;
        margin-bottom: 25px;
    }

    label {
        display: block;
        text-align: left;
        font-weight: 500;
        margin-bottom: 6px;
        font-size: 14px;
    }

    .form-control {
        border-radius: 12px;
        border: none;
        padding: 14px;
        margin-bottom: 20px;
        font-size: 16px;
    }

    .form-control:focus {
        box-shadow: 0 0 8px rgba(255, 255, 255, 0.6);
        transform: scale(1.02);
    }

    .btn-register {
        width: 100%;
        border-radius: 30px;
        padding: 14px;
        font-weight: 600;
        font-size: 16px;
        background: #fff;
        color: #27ae60;
        border: none;
        transition: 0.3s;
    }

    .btn-register:hover {
        background: #f1f1f1;
        color: #16a085;
    }

    .link-login {
        display: block;
        margin-top: 20px;
        font-size: 14px;
        color: #fff;
        text-decoration: underline;
    }
</style>


<div class="register-container">
    <img src="<?= base_url('images/alfago.png'); ?>" alt="AlfaGo Logo" class="logo">

    <h2>Buat Akun Baru</h2>

    <form id="formRegister" action="<?= base_url('auth/registerPost') ?>" method="post">
        <?= csrf_field() ?>

        <div class="mb-3 text-start">
            <label for="name">Nama</label>
            <input type="text" id="name" name="name" class="form-control" required style="text-transform: uppercase">
        </div>

        <button type="submit" class="btn btn-register">Daftar</button>
    </form>

    <a href="<?= base_url('/login') ?>" class="link-login">Sudah punya akun? Login</a>
</div>

<?= $this->endSection() ?>