<?= $this->extend('layout/main') ?>
<?= $this->section('content') ?>

<style>
    /* === GLOBAL === */
    body {
        margin: 0;
        padding: 0;
        min-height: 100vh;
        font-family: "Poppins", sans-serif;
        background: linear-gradient(135deg, #1abc9c, #2980b9);
        color: #fff;
        overflow-y: auto;
        /* ✅ Bisa scroll */
    }

    .profile-container {
        /* max-width: 480px; */
        width: 100%;
        margin: 0 auto;
        padding: 30px 20px 100px;
        box-sizing: border-box;
    }

    /* === HEADER PROFIL === */
    .profile-header {
        display: flex;
        flex-direction: column;
        align-items: center;
        margin-bottom: 25px;
        text-align: center;
    }

    .profile-photo {
        width: 50px;
        height: 50px;
        border-radius: 50%;
        border: 4px solid rgba(255, 255, 255, 0.9);
        object-fit: cover;
        box-shadow: 0 4px 15px rgba(0, 0, 0, 0.3);
        margin-bottom: 15px;
    }

    .profile-placeholder {
        width: 70px;
        height: 70px;
        border-radius: 50%;
        background: rgba(255, 255, 255, 0.9);
        color: #1abc9c;
        display: flex;
        justify-content: center;
        align-items: center;
        font-size: 50px;
        margin-bottom: 15px;
        box-shadow: 0 4px 15px rgba(0, 0, 0, 0.3);
    }

    .profile-name {
        font-size: 1.8rem;
        font-weight: 700;
        margin-bottom: 5px;
    }

    .profile-phone {
        opacity: 0.9;
        font-size: 1rem;
        color: #ecf0f1;
    }

    /* === SALDO CARD (Versi Compact) === */
    .saldo-card {
        display: flex;
        justify-content: space-between;
        align-items: center;
        background: rgba(255, 255, 255, 0.15);
        backdrop-filter: blur(8px);
        border-radius: 14px;
        padding: 15px 18px;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
        margin-bottom: 25px;
        transition: transform 0.3s ease, background 0.3s;
    }

    .saldo-card:hover {
        transform: translateY(-2px);
        background: rgba(255, 255, 255, 0.2);
    }

    .saldo-info {
        display: flex;
        align-items: center;
        gap: 12px;
    }

    .saldo-icon {
        background: rgba(255, 255, 255, 0.2);
        width: 45px;
        height: 45px;
        border-radius: 50%;
        display: flex;
        justify-content: center;
        align-items: center;
        font-size: 20px;
        color: #fff;
        box-shadow: inset 0 0 8px rgba(255, 255, 255, 0.3);
    }

    .saldo-text {
        text-align: left;
    }

    .saldo-label {
        font-size: 13px;
        opacity: 0.9;
        margin-bottom: 3px;
    }

    .saldo-amount {
        font-size: 20px;
        font-weight: 700;
        color: #fff;
    }

    /* Tombol Top Up versi compact */
    .btn-topup {
        background: #f1c40f;
        color: #333;
        border: none;
        padding: 9px 18px;
        border-radius: 25px;
        font-weight: 600;
        font-size: 14px;
        cursor: pointer;
        transition: all 0.3s ease;
        flex-shrink: 0;
    }

    .btn-topup:hover {
        background: #f39c12;
        color: #fff;
        transform: translateY(-2px);
    }

    /* === SECTION DATA === */
    .section-header {
        text-align: left;
        font-size: 1.2rem;
        font-weight: 600;
        margin: 25px 0 10px;
        padding-left: 5px;
    }

    .info-section {
        background: rgba(255, 255, 255, 0.1);
        backdrop-filter: blur(6px);
        border-radius: 14px;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
        overflow: hidden;
    }

    .info-item {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 14px 18px;
        font-size: 1rem;
        color: #fff;
        border-bottom: 1px solid rgba(255, 255, 255, 0.15);
        transition: background 0.25s;
    }

    .info-item:last-child {
        border-bottom: none;
    }

    .info-item:hover {
        background: rgba(255, 255, 255, 0.15);
    }

    .info-left {
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .info-left i {
        font-size: 18px;
        opacity: 0.9;
        width: 25px;
        text-align: center;
    }

    .info-arrow {
        opacity: 0.6;
    }

    /* === LOGOUT BUTTON === */
    .logout-btn {
        margin-top: 40px;
        width: 100%;
        max-width: 480px;
        background: #e74c3c;
        color: #fff;
        padding: 14px;
        border: none;
        border-radius: 30px;
        font-weight: 700;
        font-size: 16px;
        cursor: pointer;
        transition: background 0.3s ease, transform 0.2s ease;
        box-shadow: 0 4px 10px rgba(0, 0, 0, 0.2);
    }

    .logout-btn:hover {
        background: #c0392b;
        transform: scale(1.03);
    }

    /* === RESPONSIVE === */
    @media (max-width: 480px) {
        .saldo-card {
            padding: 18px 15px;
        }

        .saldo-amount {
            font-size: 24px;
        }

        .btn-topup {
            padding: 9px 22px;
            font-size: 14px;
        }
    }

    .saldo-amount {
        font-size: 22px;
        font-weight: 700;
        color: #fff;
        transition: color 0.3s ease;
    }

    .saldo-empty {
        color: #ff0000ff;
        /* merah lembut */
    }



    .driver-performance-badge {
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 15px;
        border-radius: 14px;
        padding: 10px 20px;
        margin-top: 12px;
        box-shadow: 0 3px 8px rgba(0, 0, 0, 0.1);
        font-size: 1rem;
        flex-wrap: wrap;
        transition: all 0.3s ease;
        text-align: center;
    }

    .driver-performance-badge:hover {
        transform: scale(1.02);
    }

    /* ⭐ Bagian Rating */
    .rating-left {
        display: flex;
        align-items: center;
        gap: 6px;
        font-weight: 600;
        --star-color: #b58900;
        /* default */
    }

    .rating-left i,
    .rating-left .rating-value,
    .rating-left .rating-sub {
        color: var(--star-color);
        font-size: 1.1rem;
        line-height: 1;
        font-weight: 600;
    }


    /* Garis pemisah */
    .divider {
        width: 2px;
        height: 22px;
        background: rgba(0, 0, 0, 0.1);
        border-radius: 2px;
    }

    /* Bagian Order dan Ulasan */
    .order-right {
        display: flex;
        align-items: center;
        gap: 8px;
        font-weight: 500;
        color: #333;
        flex-wrap: wrap;
        justify-content: center;
    }

    .order-right .review-count {
        font-size: 0.9rem;
        color: #666;
    }

    /* Item dengan toggle */
    .toggle-item {
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    /* Switch */
    .switch {
        position: relative;
        width: 46px;
        height: 22px;
        flex-shrink: 0;
    }

    .switch input {
        opacity: 0;
        width: 0;
        height: 0;
    }

    .switch .slider {
        position: absolute;
        inset: 0;
        background-color: rgba(255, 255, 255, 0.4);
        border-radius: 30px;
        transition: 0.3s;
    }

    .switch .slider:before {
        content: "";
        position: absolute;
        height: 17px;
        width: 17px;
        left: 3px;
        bottom: 3px;
        background: white;
        border-radius: 50%;
        transition: 0.3s;
    }

    .switch input:checked+.slider {
        background-color: #27ae60;
    }

    .switch input:checked+.slider:before {
        transform: translateX(20px);
    }
</style>

<div class="profile-container">
    <!-- HEADER PROFIL -->
    <div class="profile-header">
        <?php if (!empty($user['photo'])): ?>
            <img src="<?= esc($user['photo']) ?>" alt="Foto Profil" class="profile-photo">
        <?php else: ?>
            <div class="profile-placeholder"><i class="fa-solid fa-user"></i></div>
        <?php endif; ?>

        <div class="profile-name"><?= esc($user['nama'] ?? 'Nama Pengguna') ?></div>
        <div class="profile-phone hidden"><?= esc($user['phone'] ?? '+62xxxx') ?></div>
        <?php if ($role === 'driver'): ?>
            <?php
            $rating = floatval($user['avg_rating_driver'] ?? 0);
            $totalReview = intval($user['total_review'] ?? 0);
            $completedOrders = intval($user['driver_order_completed'] ?? 0);

            // 🎨 Warna dinamis berdasar rating
            $bgColor = '#f1f1f1';
            $starColor = '#999';
            $textColor = '#333';

            if ($rating >= 4.5) {
                $bgColor = '#e8f5e9';  // hijau lembut
                $starColor = '#2e7d32';
            } elseif ($rating >= 3.5) {
                $bgColor = '#fff8e1';  // kuning lembut
                $starColor = '#b58900';
            } elseif ($rating >= 2) {
                $bgColor = '#fff3e0';  // oranye lembut
                $starColor = '#e67e22';
            } elseif ($rating > 0) {
                $bgColor = '#fdecea';  // merah muda
                $starColor = '#c0392b';
            }

            $ratingText = ($rating > 0)
                ? number_format($rating, 1) . ' / 5.0'
                : 'Belum ada rating';
            ?>

            <!-- ⭐ BADGE RATING TERPADU -->
            <div class="driver-performance-badge" style="background: <?= $bgColor ?>;">
                <!-- Kiri: Rating -->
                <div class="rating-left" style="--star-color: <?= $starColor ?>;">
                    <i class="fa-solid fa-star"></i>
                    <span class="rating-value"><?= ($rating > 0) ? number_format($rating, 1) : '0.0' ?></span>
                    <span class="rating-sub">/ 5.0</span>
                </div>


                <!-- Tengah: Divider -->
                <!-- <div class="divider"></div> -->

                <!-- Kanan: Order & Ulasan -->
                <div class="order-right">
                    <i class="fa-solid fa-check-circle" style="color: <?= $starColor ?>;"></i>
                    <span>
                        <strong><?= $completedOrders ?></strong> order selesai
                    </span>
                    <span class="review-count">
                        • <?= $totalReview ?> ulasan
                    </span>
                </div>
            </div>
        <?php endif; ?>
    </div>

    <!-- SALDO CARD -->
    <div class="section-header">Saldo</div>
    <div class="saldo-card">
        <div class="saldo-info">
            <div class="saldo-icon">
                <i class="fa-solid fa-wallet"></i>
            </div>
            <div class="saldo-text">
                <div class="saldo-label">Saldo Kamu</div>
                <div class="saldo-amount <?= ($user['saldo'] ?? 0) <= 0 ? 'saldo-empty' : '' ?>">
                    Rp <?= number_format($user['saldo'] ?? 0, 0, ',', '.') ?>
                </div>
            </div>

        </div>
        <button class="btn-topup" onclick="goTopup()">
            <i class="fa-solid fa-plus"></i> Top Up
        </button>
    </div>


    <!-- DATA USER -->
    <div class="section-header">Informasi Akun</div>
    <div class="info-section">

        <div class="info-item" onclick="editPhone()">
            <div class="info-left">
                <i class="fa-solid fa-phone"></i>
                <span><?= esc($user['phone'] ?? '+62xxxx') ?></span>
            </div>
            <i class="fa-solid fa-chevron-right info-arrow"></i>
        </div>

        <div class="info-item" onclick="editRole()">
            <div class="info-left">
                <i class="fa-solid fa-user-tag"></i>
                <span>Role : <?= strtoupper(esc($user['role'] ?? 'role')) ?></span>
            </div>
            <i class="fa-solid fa-chevron-right info-arrow"></i>
        </div>

        <div class="info-item">
            <div class="info-left">
                <i class="fa-solid fa-calendar"></i>
                <span>Bergabung : <?= isset($user['created_at'])
                                        ? date('d-m-Y', strtotime($user['created_at']))
                                        : date('d-m-Y') ?></span>
            </div>
        </div>
    </div>

    <!-- PENGATURAN -->
    <div class="section-header">Pengaturan</div>
    <div class="info-section">

        <div class="info-item toggle-item">
            <div class="info-left">
                <i class="fa-solid fa-lightbulb"></i>
                <span>Layar selalu hidup</span>
            </div>

            <label class="switch">
                <input type="checkbox" id="keepScreenCheckbox">
                <span class="slider"></span>
            </label>
        </div>

    </div>

    <button class="logout-btn" onclick="logout()">
        <i class="fa-solid fa-right-from-bracket"></i> Logout
    </button>

</div>

<script src="<?= base_url('js/profile.js') ?>"></script>

<?= $this->endSection() ?>