<?= $this->extend('layout/main') ?>
<?= $this->section('content') ?>

<style>
    body {
        margin: 0;
        padding: 0;
        background: linear-gradient(135deg, #16a085, #2980b9);
        color: #fff;
        height: 100vh;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        font-family: 'Segoe UI', sans-serif;
        text-align: center;
    }

    .logo {
        width: 140px;
        margin-bottom: 20px;
    }

    h2 {
        font-weight: 700;
        margin-bottom: 10px;
    }

    p {
        font-size: 15px;
        margin-bottom: 30px;
    }

    .otp-inputs {
        display: flex;
        justify-content: center;
        gap: 12px;
        margin-bottom: 25px;
    }

    .otp-inputs input {
        width: 50px;
        height: 60px;
        text-align: center;
        font-size: 22px;
        border-radius: 10px;
        border: none;
        outline: none;
        transition: 0.3s;
    }

    .otp-inputs input:focus {
        transform: scale(1.1);
        box-shadow: 0px 0px 10px rgba(255, 255, 255, 0.6);
    }

    .btn-verify {
        width: 200px;
        border-radius: 30px;
        padding: 12px;
        font-weight: 600;
        background: #fff;
        color: #27ae60;
        border: none;
        transition: 0.3s;
    }

    .btn-verify:hover {
        background: #f1f1f1;
        color: #16a085;
    }

    .resend {
        font-size: 14px;
        margin-top: 20px;
    }

    .resend a {
        color: #fff;
        font-weight: 600;
        text-decoration: none;
    }

    .resend a.disabled {
        pointer-events: none;
        color: #ccc;
        text-decoration: none;
    }

    .resend a.change-number {
        display: inline-block;
        margin-top: 10px;
        font-size: 14px;
        font-weight: 600;
        color: #ffeb3b;
        text-decoration: none;
    }

    .resend a.change-number:hover {
        color: #fff176;
    }
</style>

<?php $phone = session()->get('phone'); ?>

<img src="<?= base_url('images/alfago.png'); ?>" alt="AlfaGo Logo" class="logo">

<h2>Verifikasi OTP</h2>
<p>Kode OTP telah dikirim ke no WhatsApp <br><b><?= esc($phone) ?></b></p>

<form action="<?= base_url('auth/verifyOtp') ?>" method="post" id="otpForm" novalidate>
    <?= csrf_field() ?>
    <input type="hidden" name="phone" value="<?= esc($phone) ?>">

    <div class="otp-inputs">
        <input type="tel" maxlength="1" name="otp[]" pattern="[0-9]+" inputmode="numeric" required>
        <input type="tel" maxlength="1" name="otp[]" pattern="[0-9]+" inputmode="numeric" required>
        <input type="tel" maxlength="1" name="otp[]" pattern="[0-9]+" inputmode="numeric" required>
        <input type="tel" maxlength="1" name="otp[]" pattern="[0-9]+" inputmode="numeric" required>
        <input type="tel" maxlength="1" name="otp[]" pattern="[0-9]+" inputmode="numeric" required>
        <input type="tel" maxlength="1" name="otp[]" pattern="[0-9]+" inputmode="numeric" required>
    </div>
    <input type="hidden" name="role" value="">
    <button hidden type="submit" class="btn btn-verify">Verifikasi</button>
</form>


<div class="resend">
    <!-- <span id="countdown">Kirim ulang dalam 60 detik</span><br> -->
    <a href="#" id="resendLink" class="disabled">Kirim ulang (60)</a><br>
    <a href="<?= base_url('login') ?>" class="change-number">Ganti No WhatsApp</a>
</div>

<script src="<?= base_url('js/otp.js') ?>"></script>

<?= $this->endSection() ?>