<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1">
    <link href="<?= base_url('css/style.css'); ?>" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" /> -->
    <meta name="base-url" content="<?= rtrim(env('app.baseURL'), '/') ?>">

    <style>
        /* ===== Layout Utama ===== */
        body {
            margin: 0;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f2f2f2;
            padding-bottom: 70px;
        }

        /* ===== Halaman ===== */
        .page-content {
            max-width: 600px;
            margin: 0 auto;
            padding: 15px;
        }

        /* ===== Bottom Navigation ===== */
        .bottom-nav {
            position: fixed;
            bottom: 0;
            left: 50%;
            transform: translateX(-50%);
            width: 100%;
            /* max-width: 600px; */
            background: linear-gradient(135deg, #16a085, #2980b9);
            display: flex;
            justify-content: space-around;
            align-items: center;
            padding: 8px 0;
            border-top-left-radius: 15px;
            border-top-right-radius: 15px;
            box-shadow: 0 -3px 10px rgba(0, 0, 0, 0.15);
            z-index: 100;
        }

        .bottom-nav a {
            text-decoration: none;
            color: #fff;
            text-align: center;
            font-size: 12px;
            display: flex;
            flex-direction: column;
            align-items: center;
            transition: 0.3s;
        }

        /* ✅ Ikon seragam */
        .bottom-nav a i {
            font-size: 26px;
            width: 32px;
            height: 32px;
            margin-bottom: 3px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #fff;
            transition: 0.3s;
        }

        .bottom-nav a.active,
        .bottom-nav a.active i {
            color: #ffeb3b;
        }

        .bottom-nav a:hover i {
            transform: scale(1.1);
        }

        /* ===== Header ===== */
        .header-fixed {
            position: sticky;
            top: 0;
            left: 50%;
            transform: translateX(-50%);
            width: 100%;
            max-width: 600px;
            background: #fff;
            padding: 10px 15px;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
            border-bottom-left-radius: 15px;
            border-bottom-right-radius: 15px;
            z-index: 50;
        }

        .header-fixed h1 {
            margin: 0;
            font-size: 22px;
            color: #27ae60;
            font-weight: 700;
            text-align: center;
        }

        /* === CARD TOTAL ORDER AKTIF === */
        .active-order-summary {
            position: fixed;
            bottom: 72px;
            left: 50%;
            transform: translateX(-50%);
            width: 95%;
            background: linear-gradient(135deg, #16a085, #2980b9);
            color: #fff;
            border-radius: 14px;
            padding: 12px 16px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            box-shadow: 0 6px 16px rgba(0, 0, 0, 0.2);
            z-index: 1100;
            animation: fadeInUp 0.4s ease;
            cursor: pointer;
        }

        /* Kiri: ikon + teks */
        .summary-left {
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .summary-icon {
            width: 42px;
            height: 42px;
            border-radius: 12px;
            background: rgba(255, 255, 255, 0.2);
            display: flex;
            justify-content: center;
            align-items: center;
            font-size: 20px;
            backdrop-filter: blur(4px);
        }

        .summary-text {
            display: flex;
            flex-direction: column;
            line-height: 1.2;
        }

        .summary-title {
            font-size: 15px;
            font-weight: 600;
            color: #fff;
        }

        .summary-subtitle {
            font-size: 12px;
            color: rgba(255, 255, 255, 0.85);
        }

        /* Kanan: jumlah order */
        .summary-right {
            display: flex;
            align-items: center;
            justify-content: center;
            background: #fbc02d;
            color: #333;
            font-weight: bold;
            font-size: 20px;
            border-radius: 10px;
            min-width: 48px;
            height: 36px;
            box-shadow: inset 0 0 6px rgba(255, 255, 255, 0.2);
            padding: 0 12px;
        }

        .hidden {
            display: none !important;
        }

        /* Animasi */
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translate(-50%, 15px);
            }

            to {
                opacity: 1;
                transform: translate(-50%, 0);
            }
        }

        /* ===== Wrapper Icon Sidebar ===== */
        .icon-wrapper {
            position: relative;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            width: 32px;
            height: 32px;
        }

        /* ===== Badge Order ===== */
        .order-badge {
            position: absolute;
            top: 0px;
            right: 0px;
            background: #e74c3c;
            color: #fff;
            font-size: 9px;
            /* 🔹 Lebih kecil dari sebelumnya */
            font-weight: 600;
            padding: 1px 4px;
            /* 🔹 Padding lebih ramping */
            border-radius: 50%;
            min-width: 14px;
            /* 🔹 Ukuran minimum lebih kecil */
            height: 14px;
            /* 🔹 Tinggi lebih rendah */
            display: flex;
            justify-content: center;
            align-items: center;
            box-shadow: 0 0 0 1.5px #fff;
            /* 🔹 Outline lebih halus */
            transform: scale(0);
            opacity: 0;
            transition: all 0.3s ease;
        }

        /* Saat tampil */
        .order-badge:not(.hidden) {
            transform: scale(1);
            opacity: 1;
        }


        .order-badge.hidden {
            display: none;
        }

        .cropper-modal-container {
            display: none;
            position: fixed;
            inset: 0;
            background: rgba(0, 0, 0, 0.8);
            z-index: 99999;
            justify-content: center;
            align-items: center;
            padding: 20px;
        }

        .cropper-modal-container img {
            display: block;
            max-width: 100%;
            max-height: 100%;
            object-fit: contain;
        }

        .cropper-wrap-box,
        .cropper-canvas,
        .cropper-container {
            width: 100%;
            max-width: 100%;
            height: 100%;
            background: transparent;
            border-radius: 12px;
            overflow: hidden;
        }

        .upload-error {
            border-color: #ff4444 !important;
            background: rgba(255, 0, 0, 0.18) !important;
        }

        .upload-error-text {
            color: #ffcccc;
            font-size: 0.85rem;
            margin-top: 6px;
            display: none;
        }

        #cropModal {
            display: none;
            position: fixed;
            inset: 0;
            background: rgba(0, 0, 0, 0.8);
            z-index: 99999;
            justify-content: center;
            align-items: center;
            padding: 20px;
        }

        .crop-box {
            width: 100%;
            max-width: 350px;
            height: 350px;
            background: #111;
            border-radius: 12px;
            overflow: hidden;
        }

        #cropImage {
            display: block;
            max-width: 100%;
            max-height: 100%;
            object-fit: contain;
        }

        .crop-btn {
            flex: 1;
            padding: 10px 0;
            border: none;
            border-radius: 10px;
            font-size: 1rem;
            font-weight: 600;
            cursor: pointer;
            transition: .2s;
        }

        .crop-btn.small {
            background: #f2f2f2;
            border: 1px solid #ccc;
            color: #333;
        }

        .crop-btn.small:hover {
            background: #e5e5e5;
        }

        .crop-btn.apply {
            background: #16a085;
            color: #fff;
        }

        .crop-btn.apply:hover {
            background: #138d75;
        }

        .crop-btn.cancel {
            background: #c0392b;
            color: #fff;
        }

        .crop-btn.cancel:hover {
            background: #a93226;
        }
    </style>
</head>

<body>

    <!-- Modal Crop -->
    <div id="cropModal" style="
    position: fixed;
    top:0; left:0;
    width:100%; height:100%;
    background: rgba(0,0,0,.85);
    display:none;
    justify-content:center;
    align-items:center;
    z-index:99999;
">

        <div style="
        width:95%;
        max-width:380px;
        background:#fff;
        padding:12px;
        border-radius:14px;
        display:flex;
        flex-direction:column;
        gap:12px;
    ">

            <!-- Image -->
            <div style="width:100%; text-align:center;">
                <img id="cropImage" style="
                width:100%;
                max-height:300px;
                object-fit:contain;
                border-radius:10px;
            ">
            </div>

            <!-- Rotate & Zoom Buttons -->
            <div style="
            display:flex;
            justify-content:space-between;
            gap:10px;
        ">

                <button onclick="rotateLeft()" class="crop-btn small">↺</button>
                <button onclick="rotateRight()" class="crop-btn small">↻</button>
                <button onclick="zoomIn()" class="crop-btn small">＋</button>
                <button onclick="zoomOut()" class="crop-btn small">－</button>

            </div>

            <!-- Big Buttons -->
            <button onclick="applyCrop()" class="crop-btn apply">
                ✔ Gunakan Hasil Crop
            </button>

            <button onclick="closeCrop()" class="crop-btn cancel">
                ✖ Batal
            </button>

        </div>

    </div>

    <?php if (!isset($showNavbar) || $showNavbar): ?>
        <!-- bottom nav -->
        <div hidden class="bottom-nav" id="bottom-nav">
            <a href="/driver" class="sidebar-url nav-item ">
                <i class="fa-solid fa-motorcycle"></i>
                <span>Driver</span>
            </a>

            <a href="/alfafood" class="sidebar-url nav-item">
                <i class="fa-solid fa-utensils"></i>
                <span>Food</span>
            </a>
            <a href="/alfaride" class="sidebar-url nav-item">
                <i class="fa-solid fa-motorcycle"></i>
                <span>Ride</span>
            </a>
            <a id="order" href="/order" class="sidebar-url nav-item ">
                <div class="icon-wrapper">
                    <i class="fa-solid fa-box"></i>
                    <span id="order-badge" class="order-badge hidden">0</span>
                </div>
                <span>Order</span>
            </a>

            <a href="/profile" class="sidebar-url nav-item ">
                <i class="fa-solid fa-user"></i>
                <span>Profile</span>
            </a>
        </div>
    <?php endif; ?>

    <div id="fullscreenNotif" class="fullscreen-notif">
        <h2>⏳ Coming Soon</h2>
        <p>Kami sedang mempersiapkan fitur terbaik untuk Anda.
            Nantikan pembaruan berikutnya hanya di <b>Alfa Go</b>.
        </p>
    </div>

    <!-- Content -->
    <div class="page-content" id="page-container">
        <?= $this->renderSection('content') ?>
    </div>

    <!-- Modal Global -->
    <div id="appModal" class="modal-overlay">
        <div class="modal-box">
            <div class="modal-actions">
                <div id="modalIcon" class="modal-icon info">
                    <i class="fa-solid fa-info-circle"></i>
                </div>

                <h2 id="modalTitle">Info</h2>
            </div>
            <div class="modal-divider"></div>
            <p id="modalMessage">Ini adalah pesan modal yang panjang.</p>
            <div class="modal-actions1">
                <button id="modalCancel">Batal</button>
                <button id="modalOk">OK</button>
            </div>
        </div>
    </div>



    <!-- Loading Overlay Global -->
    <div id="globalLoading" class="loading-overlay">
        <div class="loading-spinner"></div>
        <p>Memproses...</p>
    </div>





    <!-- Map tetap hidup di background -->
    <!-- <div id="map-container">
        <div id="map" class="map"></div>
    </div> -->

    </script>

    <script src="<?= base_url('js/script.js') ?>"></script>
    <script src="https://kit.fontawesome.com/079ee4568e.js" crossorigin="anonymous"></script>
    <!-- <script>
        const badge = document.getElementById("order-badge");
        const order = document.getElementById("order");
        let _orderStatus = null;


        window.UserData = function (data) {
            try {
                const _data = (typeof data === "string") ? JSON.parse(data) : data;
                const role = _data.role;
                const orderStatus = _data.order_status;

                if (role == "customer" && orderStatus == "2") {
                    // activeOrderTotal.textContent = "3";
                    // order.classList.remove("hidden");
                    // badge.textContent = "3";
                    // badge.classList.remove("hidden");
                } else {
                    // order.classList.add("hidden");
                    badge.classList.add("hidden");
                }

            } catch (e) {
                console.error("❌ Gagal parsing data:", e);
            }
        };  
    </script> -->


</body>
<script>
    if ("serviceWorker" in navigator) {
        // navigator.serviceWorker.register("/service-worker.js");
    }
</script>


</html>