<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Akses Dibatasi - Alfa Go</title>
    <style>
        :root {
            --primary1: #16a085;
            --primary2: #2980b9;
            --primary3: #1abc9c;
            --primary4: #1565c0;
        }

        * {
            box-sizing: border-box;
            -webkit-tap-highlight-color: transparent;
        }

        body {
            margin: 0;
            padding: 0;
            height: 100vh;
            background: linear-gradient(-45deg, var(--primary1), var(--primary2), var(--primary3), var(--primary4));
            background-size: 400% 400%;
            animation: gradientMove 10s ease infinite;
            display: flex;
            justify-content: center;
            align-items: center;
            font-family: "Poppins", "Segoe UI", sans-serif;
            overflow: hidden;
            text-align: center;
        }

        @keyframes gradientMove {
            0% {
                background-position: 0% 50%;
            }

            50% {
                background-position: 100% 50%;
            }

            100% {
                background-position: 0% 50%;
            }
        }

        .card {
            background: rgba(255, 255, 255, 0.15);
            backdrop-filter: blur(15px);
            border: 1px solid rgba(255, 255, 255, 0.25);
            border-radius: 20px;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.25);
            text-align: center;
            padding: 40px 25px;
            width: 90%;
            max-width: 380px;
            color: #fff;
            animation: fadeInUp 0.8s ease forwards;
            opacity: 0;
        }

        @keyframes fadeInUp {
            from {
                transform: translateY(50px);
                opacity: 0;
            }

            to {
                transform: translateY(0);
                opacity: 1;
            }
        }

        .logo {
            width: 90px;
            height: 90px;
            border-radius: 50%;
            background: linear-gradient(135deg, var(--primary1), var(--primary2));
            display: flex;
            justify-content: center;
            align-items: center;
            margin: 0 auto 20px;
            color: #fff;
            font-size: 42px;
            box-shadow: 0 0 20px rgba(255, 255, 255, 0.2);
            animation: pulse 2.5s infinite;
        }

        @keyframes pulse {
            0% {
                transform: scale(1);
                box-shadow: 0 0 0 0 rgba(22, 160, 133, 0.5);
            }

            70% {
                transform: scale(1.05);
                box-shadow: 0 0 0 15px rgba(22, 160, 133, 0);
            }

            100% {
                transform: scale(1);
                box-shadow: 0 0 0 0 rgba(22, 160, 133, 0);
            }
        }

        h1 {
            font-size: 22px;
            margin: 12px 0 8px;
            color: #fff;
            text-shadow: 0 2px 5px rgba(0, 0, 0, 0.3);
        }

        p {
            font-size: 15px;
            color: #f1f1f1;
            margin: 10px 0 25px;
            line-height: 1.6;
        }

        .app-btn {
            display: inline-block;
            background: linear-gradient(135deg, var(--primary1), var(--primary2));
            color: #fff;
            font-weight: 600;
            padding: 12px 22px;
            border-radius: 12px;
            text-decoration: none;
            font-size: 16px;
            letter-spacing: 0.5px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
            transition: all 0.3s ease;
            opacity: 1 !important;
            visibility: visible !important;
            z-index: 100;
            position: relative;
        }

        .app-btn:hover {
            background: linear-gradient(135deg, #1abc9c, #3498db);
            transform: translateY(-3px);
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.25);
        }

        .app-btn:active {
            transform: scale(0.97);
        }

        footer {
            position: absolute;
            bottom: 15px;
            font-size: 13px;
            color: #e0f7fa;
            opacity: 0.9;
            text-align: center;
            width: 100%;
        }

        /* 📱 Responsive: tampilan di HP */
        @media (max-width: 480px) {
            .card {
                padding: 30px 18px;
                border-radius: 16px;
            }

            .logo {
                width: 70px;
                height: 70px;
                font-size: 30px;
                margin-bottom: 16px;
            }

            h1 {
                font-size: 19px;
            }

            p {
                font-size: 14px;
                margin-bottom: 20px;
            }

            .app-btn {
                padding: 10px 18px;
                font-size: 14px;
            }

            footer {
                font-size: 12px;
            }
        }

        /* 🕶️ Mode Gelap (untuk WebView dark mode) */
        @media (prefers-color-scheme: dark) {
            body {
                background: linear-gradient(-45deg, #0f766e, #1e3a8a, #0f766e, #1e3a8a);
            }

            .card {
                background: rgba(0, 0, 0, 0.25);
                color: #fff;
            }

            footer {
                color: #b2dfdb;
            }
        }
    </style>
</head>

<body>
    <div class="card">
        <div class="logo">🚫</div>
        <h1>Akses Dibatasi</h1>
        <p>
            Website ini hanya dapat diakses melalui aplikasi <b>Alfa Go</b>.<br />
            Silakan buka kembali melalui aplikasi resmi kami.
        </p>
        <a class="app-btn" href="https://play.google.com/store/apps/details?id=net.alfateknologi.alfago">
            Buka di Aplikasi Alfa Go
        </a>
    </div>

    <footer>© 2025 Alfa Teknologi • Alfa Go</footer>
</body>

</html>