<?= $this->extend('layout/main') ?>
<?= $this->section('content') ?>

<style>
    body,
    html {
        margin: 0;
        padding: 0;
        height: 100%;
        background: #fff7ef;
        font-family: Arial;
        overflow: hidden;
        overflow-y: auto;
    }

    /* HEADER */
    .food-header {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        background: linear-gradient(135deg, #e67e22, #d35400);
        padding: 16px;
        color: #fff;
        font-size: 20px;
        font-weight: bold;
        display: flex;
        gap: 10px;
        z-index: 500;

    }

    .food-content {
        position: absolute;
        top: 100px;
        /* bottom: 140px; */
        left: 0;
        right: 0;
        overflow-y: auto;
        padding: 20px;
        padding-bottom: 50px;
    }


    .section-title {
        font-size: 14px;
        font-weight: bold;
        color: #d35400;
        margin-top: 20px;
        margin-bottom: 8px;
    }





    .two-col {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 12px;
    }

    .col-box {
        background: #fff;
        padding: 12px;
        border-radius: 10px;
        box-shadow: 0 2px 6px rgba(0, 0, 0, 0.08);
    }

    .info-title {
        font-weight: bold;
        color: #d35400;
        margin-bottom: 4px;
    }

    /* SUMMARY */
    .summary-box {
        background: #fff;
        padding: 16px;
        border-radius: 14px;
        margin-bottom: 20px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    }

    .summary-row {
        display: flex;
        justify-content: space-between;
        margin-bottom: 6px;
    }

    .summary-value {
        font-size: 20px;
        font-weight: bold;
        color: #d35400;
    }

    /* ITEMS */
    .item-box {
        background: #fff;
        border-radius: 12px;
        padding: 14px;
        box-shadow: 0 2px 6px rgba(0, 0, 0, 0.08);
    }

    .item-separator {
        border-bottom: 1px solid #eee;
        margin: 12px 0;
    }

    /* PIN */
    #pin-box {
        margin-top: 20px;
        background: #fff3e0;
        padding: 14px;
        border-radius: 10px;
        /* border-left: 4px solid #e67e22; */
    }

    #pin-input {
        width: 100%;
        padding: 10px;
        font-size: 22px;
        text-align: center;
        border-radius: 10px;
        border: 1px solid #ccc;
        letter-spacing: 4px;
    }

    /* ACTION BUTTONS */
    .food-actions {
        position: fixed;
        bottom: 0;
        width: 100%;
        background: #fff;
        padding: 14px;
        display: flex;
        gap: 10px;
        box-shadow: 0 -3px 10px rgba(0, 0, 0, 0.15);
        display: flex;
        align-items: center;
    }

    .nav-btn {
        background: linear-gradient(135deg, #3498db, #2980b9);
        color: #fff;
        font-weight: 600;
        font-size: 16px;
        /* padding: 12px 20px; */
        /* ✅ Padding seimbang */
        border-radius: 10px;
        flex: 0;
        /* ✅ Tidak memaksa melebar */
        border: none;
        cursor: pointer;
        transition: 0.3s;
        width: auto;
        /* ✅ Lebarnya menyesuaikan isi */
        min-width: 50px;
        /* ✅ Supaya tidak terlalu kecil */
        text-align: center;
    }




    .nav-btn:hover {
        background: linear-gradient(135deg, #2980b9, #1c5d99);
    }

    .nav-btn.vertical {
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        /* width: 70px; */
        /* height: 70px; */
        border: none;
        border-radius: 6px;
        background: #2196f3;
        color: #fff;
        font-size: 12px;
        font-weight: 600;
        gap: 4px;
        cursor: pointer;
        transition: transform 0.2s, background 0.3s;
    }

    .nav-btn.vertical:hover {
        background: #1976d2;
        transform: scale(1.05);
    }

    .nav-btn.vertical i {
        padding-top: 7px;
        font-size: 14px;
    }

    .btn {
        flex: 1;
        padding: 14px;
        border: none;
        border-radius: 10px;
        font-size: 16px;
        font-weight: bold;
    }

    .btn.reject {
        background: #e74c3c;
        color: #fff;
    }

    .btn.accept {
        background: #27ae60;
        color: #fff;
    }

    /* SLIDER */
    .slider-container {
        flex: 2;
        position: relative;
        background: #ecf0f1;
        border-radius: 30px;
        height: 48px;
        display: flex;
        align-items: center;
        justify-content: center;
        overflow: hidden;
        cursor: grab;
        user-select: none;
        touch-action: pan-x;


        background: linear-gradient(90deg,
                #27ae60 0%,
                #27ae60 var(--fill, 0%),
                #ecf0f1 var(--fill, 0%),
                #ecf0f1 100%);
    }


    .slider-handle {
        position: absolute;
        left: 4px;
        top: 4px;
        width: 40px;
        height: 40px;
        border-radius: 50%;
        background: linear-gradient(135deg, #e67e22, #d35400);
        display: flex;
        align-items: center;
        justify-content: center;
        color: #fff;
    }


    .slider-container.filled {
        background: linear-gradient(90deg,
                #27ae60 0%,
                #27ae60 var(--fill, 0%),
                #ecf0f1 var(--fill, 0%),
                #ecf0f1 100%);
    }


    .slider-complete {
        background: #27ae60 !important;
    }

    .header-icon,
    .header-title {
        display: flex;
        align-items: center;
    }

    .header-title {
        font-size: 20px;
        font-weight: bold;
    }

    /* === HEADER FIXED FULL WIDTH === */
    .header-wrapper {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        background: #d35400;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.15);
        z-index: 9999;
        color: white;
    }

    .checkout-header-content {
        width: 90%;
        max-width: 1200px;
        margin: 0 auto;
        padding: 10px 0 14px 0;
        display: flex;
        align-items: center;
        justify-content: space-between;
    }

    /* === BACK ICON === */
    .back-icon {
        color: #fff;
        font-size: 1.3rem;
        cursor: pointer;
        background: rgba(255, 255, 255, 0.15);
        width: 36px;
        height: 36px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        text-decoration: none;
        /* ✅ tanpa garis bawah */
        transition: background 0.2s, transform 0.1s;
    }

    .back-icon:hover {
        background: rgba(255, 255, 255, 0.3);
    }

    .back-icon:active {
        transform: scale(0.9);
    }

    .pin-slider {
        margin-top: 16px;
        padding: 12px;
        background: #fff;
        border-radius: 14px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, .08);

        display: flex;
        flex-direction: column;
        gap: 14px;
    }

    .pin-step {
        display: flex;
        gap: 10px;
        align-items: center;
    }

    input,
    textarea {
        position: relative;
        z-index: 1;
    }

    .slider-complete {
        background: #27ae60 !important;
    }
</style>

<?php if (!empty($order)): ?>
    <div id="food-order-data"
        data-order='<?= json_encode($order, JSON_HEX_TAG | JSON_HEX_APOS | JSON_HEX_QUOT | JSON_HEX_AMP | JSON_UNESCAPED_UNICODE) ?>'>
    </div>
<?php endif; ?>

<?php if (!empty($user)): ?>
    <div id="user-data"
        data-user='<?= json_encode($user, JSON_HEX_TAG | JSON_HEX_APOS | JSON_HEX_QUOT | JSON_HEX_AMP | JSON_UNESCAPED_UNICODE) ?>'>
    </div>
<?php endif; ?>

<div class="header-wrapper">
    <div class="checkout-header-content">
        <a href="javascript:void(0)" id="backToMenu" class="back-icon hidden">
            <i class="fa-solid fa-arrow-left"></i>
        </a>

        <div class="checkout-header">
            <h2>Pesanan Makanan Baru</h2>

        </div>

        <div style="width:36px;"></div> <!-- spacer agar judul tetap center -->
    </div>
</div>
<!-- ================= HEADER ================= -->




<!-- ================= MAIN CONTENT ================= -->
<div class="food-content">

    <div class="summary-box">
        <div class="summary-row">
            <div class="summary-label">Order ID</div>
            <div class="summary-value" id="order-id"><?= esc($order['order_id'] ?? "-") ?></div>
        </div>

        <div class="summary-row">
            <div class="summary-label">Total Harga</div>
            <div class="summary-value" id="total-price"><?= esc(rupiah($order['price'] ?? 0)) ?></div>
        </div>

        <div class="summary-row">
            <div class="summary-label">Metode Pembayaran</div>
            <div class="summary-value" id="payment-method">
                <?= strtoupper(esc($order['payment_method'] ?? "-")) ?>
            </div>

        </div>
    </div>

    <!-- INFORMASI -->
    <div class="section-title">Informasi</div>

    <div class="two-col">
        <div class="col-box">
            <div class="info-title"><i class="fa-solid fa-user"></i> Customer</div>
            <div id="cust-name"><?= esc($order['customer_name'] ?? "-") ?></div>
        </div>

        <div class="col-box">
            <div class="info-title"><i class="fa-solid fa-store"></i> Restoran</div>
            <div id="resto-name"><?= esc($order['restaurant_name'] ?? "-") ?></div>
        </div>
    </div>

    <!-- ITEM PESANAN -->
    <div class="section-title">
        Item Pesanan (<span id="total-item-count">0</span> total)
    </div>

    <div id="food-items-list"></div>

    <!-- PIN -->
    <div id="pin-box" class="hidden">
        <label>Masukkan PIN Restoran</label>
        <input id="pin-input" type="number" maxlength="4"
            oninput="this.value=this.value.slice(0,4);">

        <!-- 🔑 Tombol Kirim PIN -->
        <!-- <button id="btn-send-pin"
            style="
            margin-top:12px;
            width:100%;
            padding:12px;
            border:none;
            border-radius:10px;
            background:#e67e22;
            color:white;
            font-size:16px;
            font-weight:bold;
        "
            onclick="sendPinRestaurant()">
            Kirim PIN Restoran
        </button> -->
    </div>

    <!-- === SLIDER SETELAH PIN (SCROLLABLE) === -->
    <div id="pin-slider-wrapper" class="pin-slider hidden">

        <!-- STEP 1 -->
        <div id="pin-step-1" class="pin-step">

            <button class="nav-btn vertical" onclick="openPickup()">
                <i class="fa-solid fa-location-arrow"></i>
                <span>Maps</span>
            </button>

            <div class="slider-container" id="slider1"
                ontouchstart="startSlide(event,1)"
                ontouchmove="moveSlide(event,1)"
                ontouchend="endSlide(event,1)">
                <div class="slider-handle" id="handle1">
                    <i class="fa-solid fa-arrow-right"></i>
                </div>
                <span class="slider-text" id="sliderText1">
                    Geser jika sudah ambil
                </span>
            </div>

        </div>

        <!-- STEP 2 -->
        <div id="pin-step-2" class="pin-step hidden">

            <button class="nav-btn vertical" onclick="openDestination()">
                <i class="fa-solid fa-location-arrow"></i>
                <span>Maps</span>
            </button>

            <div class="slider-container" id="slider2"
                ontouchstart="startSlide(event,2)"
                ontouchmove="moveSlide(event,2)"
                ontouchend="endSlide(event,2)">
                <div class="slider-handle" id="handle2">
                    <i class="fa-solid fa-flag-checkered"></i>
                </div>
                <span class="slider-text" id="sliderText2">
                    Geser jika sudah selesai antar
                </span>
            </div>

        </div>

    </div>


</div>


<!-- ================= DEFAULT ACTION ================= -->
<div class="food-actions hidden" id="actions-default">
    <button id="btnReject" class="btn reject" onclick="rejectFood()">Tolak</button>
    <button id="btnAccept" class="btn accept" onclick="acceptFood()">Terima</button>
</div>

<!-- STEP 1 -->
<!-- <div class="food-actions hidden" id="actions-step1">
    <button class="nav-btn vertical" onclick="openPickup()">
        <i class="fa-solid fa-location-arrow"></i>
        <span>Maps</span>
    </button>




    <div class="slider-container" id="slider1"
        ontouchstart="startSlide(event,1)"
        ontouchmove="moveSlide(event,1)"
        ontouchend="endSlide(event,1)">
        <div class="slider-handle" id="handle1"><i class="fa-solid fa-arrow-right"></i></div>
        Geser jika sudah ambil
    </div>
</div> -->

<!-- Step 1: Navigasi + Geser sudah dengan customer -->
<!-- <div class="food-actions hidden" id="actions-step1">
    <button id="btn-nav-pickup" class="nav-btn vertical">
        <i class="fa-solid fa-location-arrow"></i>
        <span>Maps</span>
    </button>

    <div class="slider-container" id="slider1" ontouchstart="startSlide(event, 1)"
        ontouchmove="moveSlide(event, 1)" ontouchend="endSlide(event, 1)">
        <div class="slider-handle" id="handle1">
            <i class="fa-solid fa-arrow-right"></i>
        </div>
        <span class="slider-text" id="sliderText1">Geser jika sudah ambil</span>
    </div>
</div> -->

<!-- STEP 2 -->
<!-- <div class="food-actions hidden" id="actions-step2">
    <button class="nav-btn vertical" onclick="openPickup()">
        <i class="fa-solid fa-location-arrow"></i>
        <span>Maps</span>
    </button>


    <div class="slider-container" id="slider2"
        ontouchstart="startSlide(event,2)"
        ontouchmove="moveSlide(event,2)"
        ontouchend="endSlide(event,2)">
        <div class="slider-handle" id="handle2"><i class="fa-solid fa-flag-checkered"></i></div>
        Geser jika selesai antar
    </div>
</div> -->



<!-- Step 2: Geser selesai antar -->
<!-- <div class="food-actions hidden" id="actions-step2">
    <button id="btn-nav-dst" class="nav-btn vertical">
        <i class="fa-solid fa-location-arrow"></i>
        <span>Maps</span>
    </button>

    <div class="slider-container" id="slider2" ontouchstart="startSlide(event, 2)"
        ontouchmove="moveSlide(event, 2)" ontouchend="endSlide(event, 2)">
        <div class="slider-handle" id="handle2">
            <i class="fa-solid fa-flag-checkered"></i>
        </div>
        <span class="slider-text" id="sliderText2">Geser jika sudah selesai antar</span>
    </div>
</div> -->


<script>
    let countdownTimer = null;
    let countdown = 5;

    const backBtn = document.getElementById("backToMenu");
    backBtn.addEventListener("click", () => {
        window.location.href = `/driver`;
    });
    /* ========== BULLET NOTE FORMAT ========== */
    function formatNote(note) {
        if (!note) return "";
        let lines = note.split(/\r?\n/);
        return lines.map(l => "• " + l.trim()).join("<br>");
    }

    /* ========== GABUNG ITEM SAMA ========== */
    function mergeItems(items) {
        let grouped = {};

        items.forEach(it => {
            let key = it.name.trim().toLowerCase();

            if (!grouped[key]) {
                grouped[key] = {
                    name: it.name,
                    qty: parseInt(it.qty),
                    note: it.note || ""
                };
            } else {
                grouped[key].qty += parseInt(it.qty);

                // gabungkan note bila berbeda
                if (it.note && !grouped[key].note.includes(it.note)) {
                    grouped[key].note += "\n" + it.note;
                }
            }
        });

        return Object.values(grouped);
    }

    /* ========== RENDER ITEMS ========== */
    function renderItems(items) {
        let merged = mergeItems(items);
        let list = document.getElementById("food-items-list");

        document.getElementById("total-item-count").textContent = merged.length;

        let html = `<div class="item-box">`;

        merged.forEach((it, i) => {
            html += `
            <div>
                <b>${it.name} × ${it.qty}</b><br>
                ${it.note ? `<small>${formatNote(it.note)}</small>` : ""}
            </div>
        `;

            if (i < merged.length - 1)
                html += `<div class="item-separator"></div>`;
        });

        html += `</div>`;

        list.innerHTML = html;
    }

    /* ========== LOAD DATA ========== */
    document.addEventListener("DOMContentLoaded", () => {
        const el = document.getElementById("food-order-data");
        if (!el) return;

        const userEl = document.getElementById("user-data");

        let user = null;
        if (userEl) {
            user = JSON.parse(userEl.dataset.user);
        }

        // ambil nilai auto_bid_driver
        const autoBidDriver = user?.auto_bid_driver ?? 0;




        let order = JSON.parse(el.dataset.order);




        // document.getElementById("cust-name").textContent = autoBidDriver;
        // document.getElementById("resto-name").textContent = order.restaurant_name;
        // document.getElementById("payment-method").textContent = order.payment_method.toUpperCase();
        // document.getElementById("total-price").textContent = "Rp " + Number(order.price).toLocaleString("id-ID");
        // document.getElementById("order-id").textContent = `#${order.order_id}`;


        renderItems(order.items);
        // alert(order)
        window.orderID = order.order_id;
        window.driverPhone = order.driver_phone;
        window.customerPhone = order.customer_phone;

        const OrderStatus = order.status;

        if (OrderStatus == "new" || OrderStatus == "searching") {
            document.getElementById("actions-default").classList.remove("hidden");
            // startRejectCountdown(); // 🔥 Mulai countdown tombol
            if (autoBidDriver == 1) {
                startAutoAccept();
            } else {
                startAutoReject(); // 🔥 Mulai timer auto reject
            }

        } else if (OrderStatus == "driver") {
            stopRejectCountdown();
            stopAutoReject(); // hentikan tim
            document.getElementById("actions-default").classList.add("hidden");
            document.getElementById("pin-slider-wrapper").classList.remove("hidden");
            document.getElementById("pin-box").classList.remove("hidden");
            window.AndroidApp.stopOrderSound();
        } else if (OrderStatus == "deliver") {
            document.getElementById("pin-slider-wrapper").classList.remove("hidden");
            document.getElementById("pin-step-1").classList.add("hidden");
            document.getElementById("pin-step-2").classList.remove("hidden");
        }

    });

    /* ========== SLIDER ========== */
    let isSliding = false,
        startX = 0;

    function startSlide(e, step) {
        isSliding = true;
        startX = e.touches[0].clientX;
    }

    function moveSlide0(e, step) {
        if (!isSliding) return;
        const handle = document.getElementById(`handle${step}`);
        const cont = document.getElementById(`slider${step}`);

        let move = e.touches[0].clientX - startX;
        if (move < 0) move = 0;

        const max = cont.offsetWidth - handle.offsetWidth - 8;
        if (move > max) move = max;

        handle.style.left = move + "px";
        cont.style.setProperty("--fill", (move / max * 100) + "%");
    }

    function moveSlide(e, step) {
        if (!isSliding) return;

        const handle = document.getElementById(`handle${step}`);
        const cont = document.getElementById(`slider${step}`);

        let move = e.touches[0].clientX - startX;
        if (move < 0) move = 0;

        const max = cont.offsetWidth - handle.offsetWidth - 8;
        if (move > max) move = max;

        handle.style.left = move + "px";

        // ✅ INI YANG MEMBUAT BACKGROUND NGISI
        const percent = (move / max) * 100;
        cont.style.setProperty("--fill", percent + "%");
    }


    function endSlide(e, step) {
        isSliding = false;
        const handle = document.getElementById(`handle${step}`);
        const cont = document.getElementById(`slider${step}`);
        const max = cont.offsetWidth - handle.offsetWidth - 8;
        const current = parseInt(handle.style.left) || 0;

        if (current < max * 0.8) {
            handle.style.left = "4px";
            cont.style.setProperty("--fill", "0%");
            return;
        }

        handle.style.left = max + "px";
        cont.classList.add("slider-complete");

        // if (step === 1) validatePIN();
        // else completeDelivery();


        if (step === 1) {
            if (!cekWSS()) {
                showModal(
                    "Warning",
                    "Warning",
                    "Ada kendala jaringan ke server. Silahkan coba lagi nanti."
                );
                resetSliders();
                return;
            }

            sendPinRestaurant();


        } else if (step === 2) {
            if (!cekWSS()) {
                showModal(
                    "Warning",
                    "Warning",
                    "Ada kendala jaringan ke server. Silahkan coba lagi nanti."
                );
                resetSliders();
                return;
            }
            // statusOrderRide = null;
            // hideOrder();
            // ✅ Selesai antar
            document.getElementById("sliderText2").textContent = "✅ Order Selesai!";
            window.AndroidApp.sendMessageToServerFromWebview(
                "order",
                "food",
                JSON.stringify({
                    action: "completed",
                    orderID: orderID,
                    driverPhone: driverPhone,
                    customerPhone
                })
            );

            resetSliders();
            // showLoading();
            // location.reload();
            window.location.href = `${baseUrl}/driver`;
        }

        handle.style.left = max + "px";
        cont.style.setProperty("--fill", "100%");
        cont.classList.add("slider-complete");

    }

    function resetSliders() {
        ["1", "2"].forEach((step) => {
            const handle = document.getElementById(`handle${step}`);
            const container = document.getElementById(`slider${step}`);
            const text = document.getElementById(`sliderText${step}`);
            handle.style.left = "4px";
            container.style.setProperty("--fill", "0%");
            container.classList.remove("filled", "slider-complete");
            text.textContent =
                step === "1" ?
                "Geser jika sudah ambil" :
                "Geser jika sudah selesai antar";
        });
    }

    /* ========== ACTION BUTTON ========== */
    function rejectFood() {
        stopAllTimers()
        // stopRejectCountdown();
        stopAutoReject(); // hentikan tim
        window.AndroidApp.sendMessageToServerFromWebview("order", "food",
            JSON.stringify({
                action: "reject",
                orderID,
                driverPhone
            }));
        window.AndroidApp.stopOrderSound();
        window.location.href = `${baseUrl}/driver`;
    }

    function acceptFood() {
        stopAllTimers()
        // stopRejectCountdown();
        stopAutoReject(); // hentikan tim
        document.getElementById("actions-default").classList.add("hidden");
        document.getElementById("pin-slider-wrapper").classList.remove("hidden");
        document.getElementById("pin-box").classList.remove("hidden");
        window.AndroidApp.stopOrderSound();
        window.AndroidApp.sendMessageToServerFromWebview("order", "food",
            JSON.stringify({
                action: "accept",
                orderID,
                driverPhone,
                customerPhone
            }));
    }

    function validatePIN() {
        const pin = document.getElementById("pin-input").value;
        if (pin.length !== 4) {
            showModal("Info", "Info", "PIN harus 4 digit!")
            // alert("PIN harus 4 digit!");
            return;
        }

        window.AndroidApp.sendMessageToServerFromWebview("order", "food",
            JSON.stringify({
                action: "deliver",
                orderID,
                driverPhone,
                pin
            }));
    }

    function completeDelivery() {
        window.AndroidApp.sendMessageToServerFromWebview("order", "food",
            JSON.stringify({
                action: "completed",
                orderID,
                driverPhone
            }));
    }

    /* ================= AUTO REJECT 10 DETIK ================= */
    let autoRejectTimer = null;
    const AUTO_REJECT_TIME = 10000; // 10 detik



    function stopAutoReject() {
        if (autoRejectTimer) {
            clearTimeout(autoRejectTimer);
            autoRejectTimer = null;
        }
    }

    function startRejectCountdown0() {

        const rejectBtn = document.querySelector(".btn.reject");

        rejectBtn.textContent = `Tolak (${countdown})`;

        countdownTimer = setInterval(() => {
            countdown--;

            rejectBtn.textContent = `Tolak (${countdown})`;

            if (countdown <= 0) {
                clearInterval(countdownTimer);
            }
        }, 1000);
    }

    function stopRejectCountdown() {
        clearInterval(countdownTimer);
        const rejectBtn = document.querySelector(".btn.reject");
        rejectBtn.textContent = "Tolak";
        const acceptBtn = document.querySelector(".btn.accept");
        acceptBtn.textContent = "Terima";
    }

    function startAutoReject() {
        const rejectBtn = document.getElementById("btnReject");
        if (!rejectBtn) return;

        startCountdown(rejectBtn, "Tolak", countdown, () => {
            rejectFood();           
        });
    }


    function startAutoAccept() {
        const acceptBtn = document.getElementById("btnAccept");
        if (!acceptBtn) return;

        startCountdown(acceptBtn, "Terima", countdown, () => {
            acceptFood();
        });
    }

    function stopAllTimers() {
        clearInterval(countdownTimer);
        clearTimeout(autoRejectTimer);
    }


    function sendPinRestaurant() {
        const pin = document.getElementById("pin-input").value;

        if (pin.length !== 4) {
            // alert("PIN harus 4 digit!");
            resetSliders();
            showModal(
                "Info",
                "Info",
                "PIN harus 4 digit!"
            );
            return;
        }

        // disable tombol biar tidak spam
        // const btn = document.getElementById("btn-send-pin");
        // btn.disabled = true;
        // btn.textContent = "Memeriksa PIN...";

        fetch(`${baseUrl}/restaurant/order/check-pin`, {
                method: "POST",
                headers: {
                    "Content-Type": "application/json"
                },
                body: JSON.stringify({
                    order_id: orderID,
                    pin: pin,
                    driver_phone: driverPhone
                })
            })
            .then(res => res.json())
            .then(res => {
                if (res.status === true) {

                    window.AndroidApp.sendMessageToServerFromWebview(
                        "order",
                        "food",
                        JSON.stringify({
                            action: "deliver",
                            orderID,
                            driverPhone,
                            customerPhone
                        })
                    );

                    // statusOrderRide = "Mengantar Pesanan.";
                    // ✅ Sudah dengan customer
                    // document.getElementById("sliderText1").textContent = "Geser jika sudah selesai antar";

                    // // return;
                    // document.getElementById("actions-step1").classList.add("hidden");
                    // document
                    //     .getElementById("actions-step2")
                    //     .classList.remove("hidden");

                    document.getElementById("pin-box").classList.add("hidden");

                    document.getElementById("pin-step-1").classList.add("hidden");
                    document.getElementById("pin-step-2").classList.remove("hidden");
                    // setTimeout(() => {}, 1000);

                } else {
                    resetSliders();
                    showModal("info", "Informasi", "PIN Salah");
                    // btn.disabled = false;
                    // btn.textContent = "Kirim PIN Restoran";
                }
            })

            .catch(err => {
                // alert("Gagal koneksi ke server");
                resetSliders();
                showModal("error", "Error", "Gagal koneksi ke server");
                // btn.disabled = false;
                // btn.textContent = "Kirim PIN Restoran";
            });
    }


    function startCountdown(buttonEl, label, duration, onFinish) {
        clearInterval(countdownTimer);
        clearTimeout(autoRejectTimer);

        countdown = duration;
        buttonEl.textContent = `${label} (${countdown})`;

        countdownTimer = setInterval(() => {
            countdown--;
            buttonEl.textContent = `${label} (${countdown})`;

            if (countdown <= 0) {
                clearInterval(countdownTimer);
            }
        }, 1000);

        autoRejectTimer = setTimeout(() => {
            clearInterval(countdownTimer);
            onFinish();
        }, duration * 1000);
    }
</script>

<?= $this->endSection() ?>