<?= $this->extend('layout/main') ?>
<?= $this->section('content') ?>

<style>
    body,
    html {
        /* margin: 0; */
        /* padding: 0; */
        /* height: 100%; */
        font-family: Arial, sans-serif;
        background-color: #e8f5e9;
    }

    .search-restaurant-wrapper {
        position: fixed;
        top: 0;
        left: 50%;
        transform: translateX(-50%);
        z-index: 100;
        width: 100%;
        /* max-width: 600px; */
        background: linear-gradient(135deg, #16a085, #2980b9);
        color: #fff;
        padding: 20px 15px;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.2);
        border-bottom-left-radius: 15px;
        border-bottom-right-radius: 15px;
        display: flex;
        flex-direction: column;
        gap: 10px;
        height: 60px;
    }

    .location-wrapper {
        padding-top: 30px;
        display: flex;
        align-items: center;
        gap: 10px;
        font-size: 14px;
        color: #fff;
    }

    .location-wrapper i {
        color: #ffeb3b;
    }

    .location-text {
        flex: 1;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
    }

    .search-group {
        display: flex;
        flex-direction: column;
        gap: 10px;
    }

    .search-group input {
        width: 100%;
        padding: 12px 15px;
        border-radius: 10px;
        border: none;
        outline: none;
        box-shadow: none;
        background: #e8f5e9;
        color: #000;
        font-size: 14px;
    }

    /* .search-group input::placeholder {
        color: rgba(39, 174, 96, 0.7);
    } */

    #map {
        width: 100%;
        height: 100%;
        position: absolute;
        top: 0;
        left: 0;
        /* z-index: 1; */
        /* height: calc(100vh - 40px); */
        /* margin-top: 300px; */
        /* padding-bottom: 950px; */
        /* min-height: calc(100vh - 300px); */
    }

    .input-wrapper {
        position: relative;
        width: 100%;
    }

    .input-wrapper input {
        width: 100%;
        padding: 12px 40px;
        /* space untuk ikon kiri & kanan */
        border-radius: 10px;
        border: none;
        outline: none;
        font-size: 14px;
    }

    .left-icon {
        position: absolute;
        left: 12px;
        top: 50%;
        transform: translateY(-50%);
        color: #2a6572ff;
        pointer-events: none;
    }

    .right-icon {
        position: absolute;
        right: 12px;
        top: 50%;
        transform: translateY(-50%);
        color: #2a6572ff;
        cursor: pointer;
        font-size: 12px;
    }

    /* --- Redesain Route Card --- */
    .route-card {
        background: #ffffffcc;
        backdrop-filter: blur(12px);
        border-radius: 16px 16px 0 0;
        box-shadow: 0 4px 25px rgba(0, 0, 0, 0.15);
        padding: 15px;
        width: 100%;
        position: fixed;
        bottom: 0;
        left: 50%;
        transform: translateX(-50%);
        z-index: 2;

        /* 🔥 penting */
        height: 270px;
        /* default */
        transition: height 0.25s ease;
        touch-action: none;
        /* overflow-y: auto; */
    }


    .route-card h3 {
        margin: 0 0 10px 0;
        font-size: 16px;
        font-weight: 700;
        color: #2e7d32;
        display: flex;
        align-items: center;
        gap: 8px;
    }

    .balance-section {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 15px;
    }

    .balance-info .label {
        font-size: 14px;
        color: #555;
        font-weight: 500;
    }

    .balance-info .amount {
        font-size: 22px;
        font-weight: 700;
        color: #16a085;
    }

    .btn-topup {
        background: linear-gradient(135deg, #16a085, #2980b9);
        color: #fff;
        border: none;
        border-radius: 10px;
        padding: 10px 14px;
        display: flex;
        align-items: center;
        gap: 6px;
        font-size: 14px;
        cursor: pointer;
        box-shadow: 0 3px 8px rgba(0, 0, 0, 0.2);
        transition: transform 0.2s ease;
    }

    .btn-topup:hover {
        transform: translateY(-2px);
    }

    .info-grid {
        display: flex;
        justify-content: space-between;
        gap: 10px;
    }

    .info-box {
        flex: 1;
        background: #f4f9f5;
        border-radius: 10px;
        padding: 12px 15px;
        display: flex;
        align-items: center;
        gap: 10px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
    }

    .info-box .icon {
        font-size: 20px;
        color: #16a085;
    }

    .info-box .label {
        font-size: 13px;
        color: #666;
    }

    .info-box .value {
        font-size: 16px;
        font-weight: 600;
        color: #2e7d32;
    }

    .fab-btn {
        position: fixed;
        /* Ganti top → bottom supaya tombol berada di bawah */
        /* bottom: calc(70px + 240px); */
        bottom: 275px;
        /* 70px untuk jarak dari bottom-nav, +90px kira-kira tinggi route-card */
        right: 10px;
        /* jarak dari kanan */
        z-index: 300;
        width: 45px;
        height: 45px;
        border-radius: 50%;
        border: none;
        background: linear-gradient(135deg, #16a085, #2980b9);
        color: #fff;
        cursor: pointer;
        display: flex;
        justify-content: center;
        align-items: center;
        box-shadow: 0 4px 10px rgba(0, 0, 0, 0.3);
        transition: all 0.2s ease;
        font-size: 22px;
    }

    /* .fab-btn:hover {
        background: #1abc9c;
        transform: translateY(-2px);
    } */

    .option-buttons {
        display: flex;
        justify-content: space-between;
        align-items: center;
        gap: 10px;
        margin-top: 10px;
    }

    .option-btn {
        padding: 10px 16px;
        border: none;
        border-radius: 8px;
        font-size: 14px;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 6px;
        transition: all 0.3s ease;
        font-weight: 500;
        white-space: nowrap;
        color: #fff;
        box-shadow: 0 4px 10px rgba(0, 0, 0, 0.2);
    }

    /* Pilih dari peta */
    .option-btn.pilih {
        background: linear-gradient(135deg, #1abc9c, #16a085);
    }

    .option-btn.pilih:hover {
        background: linear-gradient(135deg, #16a085, #0e6655);
    }

    /* Lokasi saya */
    .option-btn.lokasi {
        background: linear-gradient(135deg, #3498db, #2980b9);
    }

    .option-btn.lokasi:hover {
        background: linear-gradient(135deg, #2980b9, #1c5d99);
    }




    .service-status {
        display: flex;
        flex-direction: column;
        gap: 10px;
    }

    .service-switch {
        display: flex;
        align-items: center;
        gap: 10px;
    }

    /* Switch style */
    .switch {
        position: relative;
        display: inline-block;
        width: 30px;
        height: 18px;
    }

    .switch input {
        opacity: 0;
        width: 0;
        height: 0;
    }

    .slider {
        position: absolute;
        cursor: pointer;
        inset: 0;
        background-color: #ccc;
        transition: .3s;
        border-radius: 14px;
    }

    .slider:before {
        position: absolute;
        content: "";
        height: 12px;
        width: 12px;
        left: 3px;
        bottom: 3px;
        background-color: white;
        transition: .3s;
        border-radius: 50%;
    }

    input:checked+.slider {
        background-color: #16a085;
    }

    input:checked+.slider:before {
        transform: translateX(12px);
    }


    .divider {
        border: none;
        height: 1px;
        background: #eee;
        margin: 15px 0;
    }

    .driver-info .info-item {
        display: flex;
        justify-content: space-between;
        padding: 8px 0;
        font-size: 15px;
    }

    .driver-info .label {
        color: #555;
    }

    .driver-info .value {
        font-weight: 600;
        color: #16a085;
    }

    /* Container utama */
    .page-content {
        display: flex;
        flex-direction: column;
        justify-content: center;
        /* ✅ Pusatkan vertikal */
        align-items: center;
        /* ✅ Pusatkan horizontal */
        min-height: calc(100vh - 60px);
        /* 60px = tinggi bottom-nav */
        padding: 120px 15px 280px;
        /* ✅ Jarak: atas 120px (untuk header), bawah 280px (untuk route-card & bottom-nav) */
        box-sizing: border-box;
    }


    /* Hilangkan logo & teks bawaan Google Maps */
    .gm-style-cc,
    .gmnoprint,
    .gmnoprint.gm-style-cc,
    .gm-style-cc+div {
        display: none !important;
    }

    /* Hilangkan tombol keyboard shortcuts */
    .gmnoprint[style*="z-index"] {
        display: none !important;
    }

    /* Hilangkan watermark kecil di pojok */
    a[href^="https://maps.google.com/maps"] {
        display: none !important;
    }

    /* Floating Driver Count (kiri bawah di atas route-card) */
    .driver-floating {
        position: fixed;
        left: 15px;
        bottom: calc(70px + 245px);
        /* 70px = tinggi bottom nav, 100px = jarak di atas route-card */
        z-index: 500;
        background: linear-gradient(135deg, #16a085, #2980b9);
        color: #fff;
        display: flex;
        align-items: center;
        gap: 8px;
        padding: 10px 16px;
        border-radius: 30px;
        font-size: 14px;
        font-weight: 600;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.25);
        cursor: pointer;
        transition: all 0.3s ease;
    }

    /* .driver-floating:hover {
        background: linear-gradient(135deg, #1abc9c, #3498db);
        transform: translateY(-2px);
    }

    .driver-floating i {
        font-size: 20px;
    } */



    /* Overlay */
    .order-overlay {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(0, 0, 0, 0.3);
        opacity: 0;
        visibility: hidden;
        transition: opacity 0.3s;
        z-index: 900;
    }

    .order-overlay.show {
        opacity: 1;
        visibility: visible;
    }

    /* Card */
    .order-card {
        position: fixed;
        left: 50%;
        bottom: -500px;
        /* awal tersembunyi */
        transform: translateX(-50%) scale(0.95);
        width: 100%;
        /* max-width: 420px; */
        background: #fff;
        border-radius: 16px 16px 0px 0px;
        box-shadow: 0 8px 30px rgba(0, 0, 0, 0.25);
        transition: bottom 0.4s cubic-bezier(0.25, 1.25, 0.5, 1), transform 0.4s;
        opacity: 0;
        z-index: 1000;
    }

    .order-card.show {
        bottom: 0px;
        transform: translateX(-50%) scale(1);
        opacity: 1;
    }

    .order-header {
        background: linear-gradient(135deg, #e67e22, #d35400);
        color: #fff;
        padding: 14px 20px;
        border-radius: 16px;
        font-size: 18px;
        font-weight: bold;

        /* 🔥 PUSATKAN ISI */
        display: flex;
        align-items: center;
        /* vertikal tengah */
        justify-content: center;
        /* horizontal tengah */
        gap: 8px;
        /* jarak icon & teks */
        text-align: center;
        margin: 0;
    }


    .order-body {
        padding: 16px 20px;
    }

    .order-location,
    .order-meta-row {
        display: grid;
        grid-template-columns: 28px 1fr;
        /* kolom kiri tetap 28px */
        align-items: center;
        margin-bottom: 8px;
    }

    /* Kolom kiri (untuk dot / icon / garis) */
    .icon-col {
        width: 28px;
        display: flex;
        justify-content: center;
        align-items: center;
    }

    /* Penumpang (ikon bulat) */
    .passenger-dot {
        background: #1565C0;
        /* biru AlfaGo */
        color: #fff;
        width: 28px;
        height: 28px;
        border-radius: 50%;
        display: flex;
        justify-content: center;
        align-items: center;
        font-size: 14px;
    }

    /* Dot pickup & destination kecil tapi center */
    .dot {
        background: #4CAF50;
        width: 14px;
        height: 14px;
        border-radius: 50%;
    }

    .dot.destination {
        background: #F44336;
    }

    /* Garis vertikal */
    .line {
        width: 2px;
        height: 24px;
        background: #B0BEC5;
        justify-self: center;
        position: relative;
    }

    .line::after {
        content: "";
        position: absolute;
        bottom: -6px;
        left: 50%;
        transform: translateX(-50%);
        border-left: 5px solid transparent;
        border-right: 5px solid transparent;
        border-top: 6px solid #B0BEC5;
    }

    /* Teks */
    .location-text {
        font-size: 16px;
        color: #333;
    }

    .passenger .location-text {
        font-weight: 600;
        color: #1565C0;
        padding-left: 10px;
    }

    /* Bagian jarak & waktu */
    .order-meta {
        margin-top: 10px;
    }

    .order-meta-row i {
        color: #1565C0;
        font-size: 14px;
    }

    .order-price {
        margin-top: 12px;
        font-size: 20px;
        font-weight: bold;
        color: #1565C0;
    }

    .countdown {
        margin-top: 8px;
        font-size: 14px;
        color: #666;
    }


    /* Tombol */
    .order-actions {
        display: flex;
        justify-content: space-between;
        padding: 14px 20px 20px;
        gap: 10px;
    }

    .btn {
        flex: 1;
        padding: 12px 18px;
        border: none;
        border-radius: 8px;
        font-size: 16px;
        cursor: pointer;
    }

    .btn.reject {
        background: #f01e1eff;
        /* background: linear-gradient(135deg, #16a085, #f01e1eff); */
        color: #fff;
    }

    /* .btn.reject:hover {
        background: #90A4AE;
    } */

    .btn.accept {
        color: #fff;
    }

    /* .btn.accept:hover {
        background: #43A047;
    } */

    .order-meta {
        display: flex;
        justify-content: space-between;
        margin-top: 10px;
        font-size: 14px;
        color: #555;
    }

    .order-meta i {
        margin-right: 6px;
        color: #1565C0;
        /* biru AlfaGo */
    }


    /* Bagian ongkos */
    .order-fare {
        text-align: center;
        /* padding: 16px 10px 10px; */
        padding-bottom: 10px;
    }

    .order-fare .fare-label {
        font-size: 14px;
        color: #555;
    }

    .order-fare .fare-price {
        font-size: 28px;
        font-weight: bold;
        color: #1565C0;
        /* biru AlfaGo */
        margin-top: 4px;
    }


    /* ✅ Tombol Navigasi */
    .nav-btn {
        background: linear-gradient(135deg, #3498db, #2980b9);
        color: #fff;
        font-weight: 600;
        font-size: 16px;
        /* padding: 12px 20px; */
        /* ✅ Padding seimbang */
        border-radius: 10px;
        flex: 0;
        /* ✅ Tidak memaksa melebar */
        border: none;
        cursor: pointer;
        transition: 0.3s;
        width: auto;
        /* ✅ Lebarnya menyesuaikan isi */
        min-width: 50px;
        /* ✅ Supaya tidak terlalu kecil */
        text-align: center;
    }




    .nav-btn:hover {
        background: linear-gradient(135deg, #2980b9, #1c5d99);
    }

    /* ✅ Slider Button */
    /* ✅ Efek warna penuh dari kiri */
    /* Efek isi warna penuh dari kiri */
    .slider-container {
        flex: 2;
        position: relative;
        background: #ecf0f1;
        border-radius: 30px;
        height: 48px;
        display: flex;
        align-items: center;
        justify-content: center;
        overflow: hidden;
        cursor: grab;
        user-select: none;
        touch-action: pan-x;
        transition: background 0.3s ease;
    }

    .slider-container.filled {
        background: linear-gradient(90deg, var(--fill-color, #27ae60) 0%, var(--fill-color, #27ae60) var(--fill, 0%), #ecf0f1 var(--fill, 0%), #ecf0f1 100%);
    }

    /* Warna untuk slider step 2 */
    #sliderBtn2.filled {
        --fill-color: #e67e22;
        /* oranye */
    }



    .slider-text {
        font-size: 14px;
        color: #555;
        font-weight: 500;
        z-index: 1;
        pointer-events: none;
    }

    .slider-handle {
        position: absolute;
        left: 4px;
        top: 4px;
        width: 40px;
        height: 40px;
        background: linear-gradient(135deg, #16a085, #27ae60);
        border-radius: 50%;
        display: flex;
        justify-content: center;
        align-items: center;
        color: #fff;
        font-size: 18px;
        /* transition: left 0.3s; */
    }

    .slider-complete {
        background: #27ae60 !important;
        color: #fff;
    }

    .hidden {
        display: none !important;
    }

    /* Step 2 Slider - warna oranye */
    /* Step 2 Slider - warna oranye */
    #sliderBtn2 {
        --fill-color: #e67e22;
        /* ✅ atur warna oranye di sini */
        background: #ffe9e0;
        /* warna default saat belum digeser */
    }

    #sliderBtn2.filled {
        background: linear-gradient(90deg, var(--fill-color) 0%, var(--fill-color) var(--fill, 0%), #ffe9e0 var(--fill, 0%), #ffe9e0 100%);
    }


    #sliderHandle2 {
        background: linear-gradient(135deg, #e67e22, #d35400);
    }

    #sliderBtn2.slider-complete {
        background: #27ae60 !important;
    }

    #sliderBtn2 .slider-text {
        color: #b74c00;
    }

    .nav-btn.vertical {
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
        /* width: 70px; */
        /* height: 70px; */
        border: none;
        border-radius: 8px;
        background: #2196f3;
        color: #fff;
        font-size: 12px;
        font-weight: 600;
        gap: 4px;
        cursor: pointer;
        transition: transform 0.2s, background 0.3s;
    }

    .nav-btn.vertical:hover {
        background: #1976d2;
        transform: scale(1.05);
    }

    .nav-btn.vertical i {
        padding-top: 5px;
        font-size: 16px;
    }

    .balance-info .label {
        display: flex;
        align-items: center;
        gap: 8px;
        font-size: 14px;
        color: #444;
        font-weight: 600;
    }

    .balance-info .label i {
        color: #16a085;
        font-size: 18px;
    }

    .balance-info .amount {
        font-size: 22px;
        font-weight: 700;
        color: #16a085;
        margin-top: 4px;
    }

    .btn-topup {
        display: inline-flex;
        align-items: center;
        justify-content: center;
        gap: 6px;
        background: linear-gradient(135deg, #16a085, #2980b9);
        color: #fff;
        border: none;
        border-radius: 10px;
        padding: 10px 16px;
        font-size: 14px;
        font-weight: 600;
        text-decoration: none;
        /* penting untuk hilangkan garis bawah */
        cursor: pointer;
        transition: transform 0.2s ease, box-shadow 0.2s;
    }

    .btn-topup:hover {
        transform: translateY(-2px);
        box-shadow: 0 3px 10px rgba(0, 0, 0, 0.2);
    }

    /* === Metode Pembayaran === */
    .order-payment {
        margin-top: 10px;
        margin-bottom: 20px;
        background: #f7fdf9;
        border-radius: 10px;
        padding: 10px 14px;
        display: flex;
        justify-content: space-between;
        align-items: center;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    }

    .order-payment .payment-label {
        font-size: 14px;
        font-weight: 600;
        color: #16a085;
        display: flex;
        align-items: center;
        gap: 6px;
    }

    .order-payment .payment-method {
        font-size: 15px;
        font-weight: 700;
        color: #2c3e50;
        text-transform: uppercase;
    }

    /* Warna tambahan */
    .payment-method.cash {
        color: #e67e22;
        /* oranye untuk tunai */
    }

    .payment-method.saldo {
        color: #27ae60;
        /* hijau untuk saldo */
    }

    #food-order-card .fare-price {
        color: #d35400;
    }

    #food-order-card .payment-method {
        color: #c0392b;
    }

    /* ============================= */
    /* AUTO ACCEPT - WARNA KHUSUS */
    /* ============================= */

    /* OFF */
    .switch.auto-accept .slider {
        background-color: #ffcc80;
    }

    /* knob */
    .switch.auto-accept .slider:before {
        background-color: #fff;
    }

    /* ON */
    .switch.auto-accept input:checked+.slider {
        background-color: #e67e22;
        animation: pulse-orange 1.2s infinite;
    }

    /* ON - knob geser (FIXED) */
    .switch.auto-accept input:checked+.slider:before {
        transform: translateX(12px);
    }

    /* HEADER MODE LAYANAN */
    .service-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    /* AUTO ACCEPT BOX (KANAN) */
    .auto-accept-box {
        display: flex;
        align-items: center;
        gap: 8px;
        font-size: 14px;
        font-weight: 600;
        color: #e67e22;
    }

    /* ITEM RIDE / FOOD */
    .service-item {
        display: flex;
        align-items: center;
        gap: 10px;
    }

    /* ICON */
    .service-icon {
        font-size: 18px;
        color: #16a085;
    }

    /* LABEL */
    .service-label {
        min-width: 40px;
        font-weight: 600;
        color: #333;
    }

    /* ===== ROUTE CARD STATES ===== */
    .route-card {
        touch-action: none;
    }

    /* Mode collapsed (default) */
    .route-card.collapsed {
        height: 240px;
    }

    /* Mode expanded (full screen) */
    .route-card.expanded {
        height: calc(100vh - 20px);
        /* hampir full layar */
        border-radius: 16px 16px 0 0;
    }

    .drag-handle {
        width: 40px;
        height: 5px;
        background: #ccc;
        border-radius: 10px;
        margin: 0 auto 2px;
    }

    .food-content {
        position: absolute;
        top: 0px;
        /* tinggi order-header */
        bottom: 80px;
        /* tinggi tombol action */
        left: 0;
        right: 0;

        overflow-y: auto;
        -webkit-overflow-scrolling: touch;

        padding: 0px 15px;
    }



    .section-title {
        font-size: 14px;
        font-weight: bold;
        margin-top: 20px;
        margin-bottom: 8px;
    }

    .two-col {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 12px;
    }

    .col-box {
        background: #fff;
        padding: 12px;
        border-radius: 10px;
        box-shadow: 0 2px 6px rgba(0, 0, 0, 0.08);
    }

    .info-title {
        font-weight: bold;
        color: #d35400;
        margin-bottom: 4px;
    }

    /* SUMMARY */
    .summary-box {
        background: #fff;
        padding: 16px;
        border-radius: 14px;
        margin-bottom: 20px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);
    }

    .summary-row {
        display: flex;
        justify-content: space-between;
        margin-bottom: 6px;
    }

    .summary-value {
        font-size: 16px;
        font-weight: bold;
    }

    /* ACTION BUTTONS */
    .food-actions {
        position: fixed;
        bottom: 0;
        width: 100%;
        background: #fff;
        padding: 14px;
        /* display: flex; */
        gap: 10px;
        /* box-shadow: 0 -3px 10px rgba(0, 0, 0, 0.15); */
        display: flex;
        align-items: center;
        z-index: 9999;
    }

    /* ITEMS */
    .item-box {
        background: #fff;
        border-radius: 12px;
        padding: 14px;
        box-shadow: 0 2px 6px rgba(0, 0, 0, 0.08);
    }

    .item-separator {
        border-bottom: 1px solid #eee;
        margin: 12px 0;
    }

    /* PIN */
    #pin-box {
        margin-top: 20px;
        background: #fff3e0;
        padding: 14px;
        border-radius: 10px;
        /* border-left: 4px solid #e67e22; */
    }

    #pin-input {
        width: 100%;
        padding: 10px;
        font-size: 16px;
        text-align: center;
        border-radius: 10px;
        border: 1px solid #ccc;
        letter-spacing: 4px;
    }

    /* Default: content TIDAK bisa scroll */
    .route-content {
        height: calc(100% - 20px);
        overflow-y: hidden;
    }

    /* Aktifkan scroll HANYA jika card expanded */
    .route-card.can-scroll .route-content {
        overflow-y: auto;
        -webkit-overflow-scrolling: touch;
    }

    .route-card.small {
        height: 240px;
    }

    .route-card.medium {
        height: 60vh;
    }

    .route-card.large {
        height: calc(100vh - 20px);
    }

    /* === HEADER FIXED FULL WIDTH === */
    .header-wrapper {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.15);
        z-index: 999;
    }

    /* DEFAULT (food) */
    .header-wrapper.food {
        background: linear-gradient(135deg, #e67e22, #d35400);
    }

    /* RIDE */
    .header-wrapper.ride {
        background: linear-gradient(135deg, #16a085, #2980b9);
    }

    .header-wrapper.food~* .btn.accept {
        background: linear-gradient(135deg, #e67e22, #d35400);
    }

    /* RIDE */
    .header-wrapper.ride~* .btn.accept {
        background: linear-gradient(135deg, #16a085, #2980b9);
    }

    /* FOOD */
    .header-wrapper.food~* .section-title {
        color: #d35400;
    }

    /* RIDE */
    .header-wrapper.ride~* .section-title {
        color: #16a085;
    }

    /* FOOD */
    .header-wrapper.food~* .summary-value {
        color: #d35400;
    }

    /* RIDE */
    .header-wrapper.ride~* .summary-value {
        color: #16a085;
    }


    /* Aksen */
    .header-wrapper.food~* .info-address i {
        color: #d35400;
    }


    .header-wrapper.ride~* .info-address i {
        color: #16a085;
    }


    .checkout-header-content {
        position: relative;
        width: 90%;
        max-width: 1200px;
        margin: 0 auto;
        padding: 10px 0 14px;
        height: 48px;
    }

    /* Wrapper flex */
    .header-flex {
        display: flex;
        align-items: center;
        justify-content: space-between;
    }

    /* Judul BENAR-BENAR tengah */
    .checkout-header {
        position: static !important;
        transform: none !important;
        text-align: left;
    }

    .checkout-header h2 {
        display: flex;
        align-items: center;
        gap: 8px;
        font-size: 18px;
        font-weight: 600;
        color: #fff;
        margin: 0;
    }

    /* Order ID kanan */
    .header-right {
        font-size: 14px;
        font-weight: 700;
        color: #fff;
        background: rgba(255, 255, 255, 0.2);
        padding: 6px 10px;
        border-radius: 8px;
        white-space: nowrap;
    }

    /* === BACK ICON === */
    .back-icon {
        color: #fff;
        font-size: 1.3rem;
        cursor: pointer;
        background: rgba(255, 255, 255, 0.15);
        width: 36px;
        height: 36px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        text-decoration: none;
        /* ✅ tanpa garis bawah */
        transition: background 0.2s, transform 0.1s;
    }



    .pin-slider {
        position: fixed;
        left: 0;
        right: 0;
        /* ⬅️ WAJIB */
        bottom: 0;

        width: auto;
        /* biarkan browser hitung */
        background: #fff;
        padding: 14px;

        display: flex;
        flex-direction: column;
        gap: 10px;

        z-index: 9999;
    }



    .pin-step {
        width: 100%;
        display: flex;
        align-items: center;
        gap: 12px;
    }


    input,
    textarea {
        position: relative;
        z-index: 1;
    }

    .slider-complete {
        background: #27ae60 !important;
    }

    /* === PIN ROW === */
    .pin-row {
        display: flex;
        align-items: center;
        justify-content: space-between;
        gap: 12px;
    }

    /* Label kiri */
    .pin-row .summary-label {
        font-weight: 600;
        color: #333;
    }

    /* Input PIN kanan */
    .pin-input {
        width: 900px;
        /* 🔥 pas untuk 4 digit */
        max-width: 90px;
        padding: 10px 12px;

        font-size: 22px;
        font-weight: 700;
        text-align: center;
        letter-spacing: 6px;

        border-radius: 12px;
        border: 2px solid #e67e22;
        background: #fff;

        outline: none;
    }

    /* Fokus */
    .pin-input:focus {
        border-color: #d35400;
        box-shadow: 0 0 0 3px rgba(230, 126, 34, 0.25);
    }

    .info-box {
        background: #fff;
        border-radius: 14px;
        padding: 14px 16px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.08);

        display: flex;
        flex-direction: column;
        align-items: flex-start;
        /* 🔥 RATA KIRI */
        text-align: left;
        /* 🔥 RATA KIRI */
        gap: 6px;
    }

    /* NAMA */
    .info-name {
        width: 100%;
        font-size: 16px;
        font-weight: 700;
        color: #2c3e50;
        text-align: left;
        /* 🔥 RATA KIRI */
    }

    /* ALAMAT */
    .info-address {
        width: 100%;
        display: flex;
        align-items: flex-start;
        justify-content: flex-start;
        /* 🔥 RATA KIRI */
        gap: 6px;

        font-size: 13px;
        color: #666;
        line-height: 1.4;
        text-align: left;
        /* 🔥 RATA KIRI */
    }

    .info-address span {
        text-align: left;
    }

    .info-address i {
        font-size: 13px;
        margin-top: 2px;
    }

    /* INFO GRID - ICON KIRI, TEXT KANAN */
    .info-grid .info-box {
        flex-direction: row;
        /* icon kiri, teks kanan */
        align-items: center;
        gap: 12px;
        margin-bottom: 14px;
        /* 🔥 atur jarak di sini */
    }

    /* ICON */
    .info-grid .info-box .icon {
        background: #e8f5e9;
        border-radius: 50%;
        width: 36px;
        height: 36px;
        display: flex;
        align-items: center;
        justify-content: center;
    }


    /* TEXT WRAPPER */
    .info-grid .info-box .text {
        display: flex;
        flex-direction: column;
        align-items: flex-start;
    }

    /* LABEL */
    .info-grid .info-box .label {
        font-size: 13px;
        color: #666;
        font-weight: 500;
    }

    /* VALUE (ANGKA) */
    .info-grid .info-box .value {
        font-size: 17px;
        /* 🔥 sama dengan icon */
        font-weight: 700;
        color: #2e7d32;
        line-height: 1.1;
    }

    /* === SALDO CARD: KIRI - KANAN === */
    .info-box.saldo-card.horizontal {
        display: flex;
        align-items: center;
        justify-content: space-between;
        /* 🔥 kiri & kanan ujung */
        width: 100%;
    }

    /* KIRI (ICON + TEXT) */
    .info-box.saldo-card .saldo-left {
        display: flex;
        align-items: center;
        gap: 12px;
    }

    /* ICON */
    .info-box.saldo-card .icon {
        width: 36px;
        height: 36px;
        border-radius: 50%;
        background: #e8f5e9;
        display: flex;
        align-items: center;
        justify-content: center;
        color: #16a085;
        font-size: 18px;
        flex-shrink: 0;
    }

    /* TEXT */
    .info-box.saldo-card .text {
        display: flex;
        flex-direction: column;
        align-items: flex-start;
    }

    /* LABEL */
    .info-box.saldo-card .label {
        font-size: 13px;
        color: #666;
        font-weight: 600;
    }

    /* VALUE */
    .info-box.saldo-card .value {
        font-size: 17px;
        font-weight: 800;
        color: #16a085;
        line-height: 1.1;
    }

    /* TOP UP BUTTON (KANAN) */
    .info-box.saldo-card .btn-topup.mini {
        margin-left: auto;
        /* 🔥 paksa ke kanan */
        padding: 6px 14px;
        font-size: 14px;
        font-weight: 700;
        border-radius: 999px;
        white-space: nowrap;
    }

    /* === SERVICE SWITCH: AUTO ACCEPT DI KANAN === */
    .info-box .service-switch {
        display: flex;
        align-items: center;
        gap: 14px;
    }

    /* Ride & Food tetap rapat kiri */
    .info-box .service-item {
        display: flex;
        align-items: center;
        gap: 8px;
    }

    /* Auto accept dorong ke kanan */
    .info-box .auto-accept-box {
        margin-left: auto;
        /* 🔥 kunci ke kanan */
        display: flex;
        align-items: center;
        gap: 8px;
    }

    .info-box .service-switch {
        justify-content: flex-start;
    }

    /* ============================= */
    /* FIX AUTO ACCEPT KE KANAN */
    /* ============================= */

    /* service-switch HARUS full width */
    .info-box.saldo-card .service-switch {
        display: flex;
        align-items: center;
        gap: 14px;
        width: 100%;
        /* 🔥 KUNCI */
    }

    /* auto accept dorong ke kanan */
    .info-box.saldo-card .auto-accept-box {
        margin-left: auto;
        /* 🔥 KUNCI */
        display: flex;
        align-items: center;
        gap: 8px;
    }

    /* ============================= */
    /* MODE LAYANAN - MENYATU KE ATAS */
    /* ============================= */

    

    /* Header Mode Layanan */
    .service-header {
        width: calc(100% + 32px);
        /* 🔥 tembus padding kiri-kanan */
        margin-left: -16px;
        margin-right: -16px;
        margin-top: -14px;
        /* 🔥 tarik ke atas card */

        background: linear-gradient(135deg, #16a085, #2980b9);
        color: #fff;

        padding: 12px 16px;
        border-radius: 14px 14px 0 0;
        /* 🔥 hanya atas */

        display: flex;
        align-items: center;
        justify-content: space-between;
    }

    /* Judul */
    .service-header h3 {
        margin: 0;
        font-size: 14px;
        font-weight: 700;
        display: flex;
        align-items: center;
        gap: 8px;
        color: #fff;
    }
</style>

<?php if (!empty($order)): ?>
    <div id="order-data"
        data-order='<?= json_encode($order, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES) ?>'>
    </div>
<?php endif; ?>



<?php if (!empty($user)): ?>
    <div id="user-data"
        data-user='<?= json_encode($user, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES) ?>'>
    </div>
<?php endif; ?>
<div class="search-restaurant-wrapper hidden" id="search-restaurant-wrapper"></div>

<div class="header-wrapper hidden" id="header-wrapper">
    <div class="checkout-header-content header-flex">

        <!-- KIRI -->
        <div class="checkout-header">
            <h2>
                <i id="order-icon" class="fa-solid fa-burger"></i>
                <span id="order-title-text">Pesanan Makanan Baru</span>
            </h2>
        </div>

        <!-- KANAN -->
        <div class="header-right">
            <?= esc($order['order_id'] ?? "-") ?>
        </div>

    </div>
</div>


<div id="route-card" class="route-card">
    <!-- <div class="drag-handle"></div> -->

    <div id="driver-info" class="hidden">
        <!-- Status Layanan -->
        <div class="service-status">

            <!-- HEADER -->
            <div class="service-header">
                <h3>
                    <i class="fa-solid fa-sliders"></i>
                    Mode Layanan
                </h3>

                <!-- AUTO ACCEPT (KANAN) -->

            </div>

            <div class="info-grid">

                <!-- SALDO CARD -->
                <div class="info-box saldo-card horizontal">
                    <!-- BODY -->
                    <div class="service-switch">
                        <div class="service-item">
                            <i class="fa-solid fa-motorcycle service-icon"></i>
                            <span class="service-label">Ride</span>
                            <label class="switch">
                                <input type="checkbox" id="rideToggle" onclick="toggleDriverRide()"
                                    <?= checked($user['driver_ride'] ?? null) ?>>
                                <span class="slider"></span>
                            </label>
                        </div>

                        <div class="service-item">
                            <i class="fa-solid fa-burger service-icon"></i>
                            <span class="service-label">Food</span>
                            <label class="switch">
                                <input type="checkbox" id="foodToggle" onclick="toggleDriverFood()"
                                    <?= checked($user['driver_food'] ?? null) ?>>
                                <span class="slider"></span>
                            </label>
                        </div>

                        <div class="auto-accept-box ">
                            <i class="fa-solid fa-bolt"></i>
                            <label class="switch auto-accept">
                                <input
                                    type="checkbox"
                                    id="autoAcceptToggle"
                                    onchange="toggleAutoBid(this)"
                                    <?= checked($user['auto_bid_driver'] ?? null) ?>>
                                <span class="slider"></span>
                            </label>
                        </div>
                    </div>
                </div>


            </div>



        </div>


        <!-- Saldo & Info Driver -->
        <div class="driver-stats">
            <div class="info-grid">

                <!-- SALDO CARD -->
                <div class="info-box saldo-card horizontal">
                    <!-- KIRI -->
                    <div class="saldo-left">
                        <i class="fa-solid fa-wallet icon"></i>
                        <div class="text">
                            <div class="label">Saldo</div>
                            <div class="value" id="driverBalance">
                                <?= rupiah($user['saldo'] ?? 0) ?>
                            </div>
                        </div>
                    </div>

                    <!-- KANAN -->
                    <a href="/topup" class="btn-topup mini">
                        <i class="fa-solid fa-plus"></i>
                        Top Up
                    </a>
                </div>



            </div>


            <div class="info-grid">
                <div class="info-box">
                    <i class="fa-solid fa-wallet icon"></i>
                    <div class="text">
                        <div class="label">Pendapatan Hari Ini</div>
                        <div class="value" id="todayIncome"> <?= rupiah($riwayat_driver['total_pendapatan'] ?? 0) ?></div>
                    </div>
                </div>
                <div class="info-box">
                    <i class="fa-solid fa-list-check icon"></i>
                    <div class="text">
                        <div class="label">Order Selesai</div>
                        <div class="value" id="orderCompleted"><?= $riwayat_driver['total_order'] ?? 0 ?></div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- === FOOD ORDER CARD === -->



    <div class="food-content hidden" id="food-order-card">
        <!-- INFORMASI -->
        <div id="section-title-restoran" class="section-title hidden">PIN Restoran</div>

        <div id="summary-pin-box" class="summary-box hidden">
            <div class="summary-row pin-row">
                <div class="summary-label">PIN</div>

                <input
                    id="pin-input"
                    class="pin-input"
                    type="tel"
                    inputmode="numeric"
                    maxlength="4"
                    placeholder="••••"
                    oninput="this.value=this.value.replace(/[^0-9]/g,'').slice(0,4);">
            </div>
        </div>

        <!-- INFORMASI -->
        <div class="section-title">Informasi</div>

        <div class="summary-box">
            <div class="summary-row">
                <div class="summary-label">Total Harga</div>
                <div class="summary-value" id="total-price"><?= esc(rupiah($order['price'] ?? $order['tarif'] ?? 0)) ?></div>
            </div>

            <div class="summary-row">
                <div class="summary-label">Metode Pembayaran</div>
                <div class="summary-value" id="payment-method">
                    <?= strtoupper(esc($order['payment_method'] ?? $order['payment_metode'] ?? "-")) ?>
                </div>

            </div>
        </div>

        <div class="info-section customer">
            <div class="section-title">
                Customer
            </div>

            <div class="info-box">
                <!-- NAMA (ATAS) -->
                <div class="info-name">
                    <?= esc($order['customer_name'] ?? "-") ?>
                </div>

                <!-- ALAMAT (BAWAH) -->
                <div class="info-address" id="info-address-customer">
                    <i class="fa-solid fa-location-dot"></i>
                    <span><?= esc($order['destination_address'] ?? "-") ?></span>
                </div>
            </div>
        </div>

        <div class="info-section restaurant" id="info-section-restaurant">
            <div class="section-title" id="section-title-restaurant">
                Restoran
            </div>

            <div class="info-box">
                <!-- NAMA (ATAS) -->
                <div class="info-name" id="restaurant-name">
                    <?= esc($order['restaurant_name'] ?? "-") ?>
                </div>

                <!-- ALAMAT (BAWAH) -->
                <div class="info-address">
                    <i class="fa-solid fa-location-dot"></i>
                    <span><?= esc($order['pickup_address'] ?? "-") ?></span>
                </div>
            </div>
        </div>

        <div class="info-section hidden" id="info-section-destination">
            <div class="section-title">
                Tujuan
            </div>

            <div class="info-box">
                <!-- NAMA (ATAS) -->
                <div class="info-name">
                    <?= esc($order['destination'] ?? "-") ?>
                </div>

                <!-- ALAMAT (BAWAH) -->
                <div class="info-address" id="info-address-customer">
                    <i class="fa-solid fa-location-dot"></i>
                    <span><?= esc($order['destination_address'] ?? "-") ?></span>
                </div>
            </div>
        </div>



        <!-- <div class="two-col">
            <div class="col-box">
                <div class="info-title"><i class="fa-solid fa-user"></i> Customer</div>
                <div id="cust-name"><?= esc($order['customer_name'] ?? "-") ?></div>
            </div>

            <div class="col-box">
                <div class="info-title"><i class="fa-solid fa-store"></i> Restoran</div>
                <div id="resto-name"><?= esc($order['restaurant_name'] ?? "-") ?></div>
            </div>
        </div> -->

        <!-- ITEM PESANAN -->
        <div class="section-title" id="section-title-items">
            Item Pesanan (<span id="total-item-count">0</span> total)
        </div>

        <div id="food-items-list"></div>


    </div>
</div>
<!-- ================= DEFAULT ACTION ================= -->
<div class="food-actions hidden" id="actions-default">
    <button class="btn reject" id="btnReject" onclick="rejectOrder()">Tolak</button>
    <button class="btn accept" id="btnAccept" onclick="acceptOrder()">Terima</button>
</div>

<!-- === SLIDER SETELAH PIN (SCROLLABLE) === -->
<div id="pin-slider-wrapper" class="pin-slider hidden">

    <!-- STEP 1 -->
    <div id="pin-step-1" class="pin-step">

        <button id="btn-nav-pickup-food" class="nav-btn vertical">
            <i class="fa-solid fa-location-arrow"></i>
            <span>Maps</span>
        </button>

        <div class="slider-container" id="slider1"
            ontouchstart="startSlideFood(event,1)"
            ontouchmove="moveSlideFood(event,1)"
            ontouchend="endSlideFood(event,1)">
            <div class="slider-handle" id="handle1">
                <i class="fa-solid fa-arrow-right"></i>
            </div>
            <span class="slider-text" id="sliderText1">
                Geser jika sudah ambil
            </span>
        </div>

    </div>

    <!-- STEP 2 -->
    <div id="pin-step-2" class="pin-step hidden">

        <button id="btn-nav-dst-food" class="nav-btn vertical">
            <i class="fa-solid fa-location-arrow"></i>
            <span>Maps</span>
        </button>

        <div class="slider-container" id="slider2"
            ontouchstart="startSlideFood(event,2)"
            ontouchmove="moveSlideFood(event,2)"
            ontouchend="endSlideFood(event,2)">
            <div class="slider-handle" id="handle2">
                <i class="fa-solid fa-flag-checkered"></i>
            </div>
            <span class="slider-text" id="sliderText2">
                Geser jika sudah selesai antar
            </span>
        </div>

    </div>

</div>


<div id="map" class="map"></div>

<button id="center-btn" class="fab-btn" title="Pusatkan Lokasi">
    <i class="fa-solid fa-crosshairs"></i>
</button>

<!-- Floating jumlah driver -->
<div hidden class="driver-floating" id="driverFloating">
    <i class="fa-solid fa-motorcycle"></i>
    <span id="driverCount">0 Driver</span>
</div>


<!-- === ORDER CARD === -->
<div id="order-card" class="order-card hidden">
    <!-- Progress Bar -->
    <div class="progress-container">
        <div id="progress-bar" class="progress-bar"></div>
    </div>

    <div id="order-header" class="order-header">
        <i class="fa-solid fa-motorcycle"></i>
        <span id="order-title"> Pesanan Baru</span>
    </div>


    <div class="order-body">

        <!-- Tarif -->
        <div class="order-fare">
            <div class="fare-label">Tarif</div>
            <div class="fare-price" id="price">Rp 0</div>
        </div>

        <!-- Metode Pembayaran -->
        <div class="order-payment">
            <div class="payment-label"><i class="fa-solid fa-credit-card"></i> Metode Pembayaran</div>
            <div class="payment-method" id="paymentMethod">Tunai</div>
        </div>

        <!-- Penumpang -->
        <div class="order-location passenger">
            <div class="icon-col">
                <div class="passenger-dot"><i class="fa-solid fa-user"></i></div>
            </div>
            <div class="location-text" id="passenger-name">Penumpang</div>
        </div>

        <!-- Pickup -->
        <div class="order-location">
            <div class="icon-col">
                <div class="dot pickup"></div>
            </div>
            <div class="location-text" id="pickup">Pickup</div>
        </div>

        <!-- Garis vertikal -->
        <div class="order-location">
            <div class="icon-col">
                <div class="line"></div>
            </div>
            <div></div>
        </div>

        <!-- Destination -->
        <div class="order-location">
            <div class="icon-col">
                <div class="dot destination"></div>
            </div>
            <div class="location-text" id="destination">Destination</div>
        </div>

        <!-- Jarak -->
        <div class="order-meta-row">
            <div class="icon-col"><i class="fa-solid fa-road"></i></div>
            <div><span id="distance">0 km</span></div>

            <div class="icon-col"><i class="fa-solid fa-clock"></i></div>
            <div><span id="duration">0</span></div>
        </div>


    </div>



    <!-- Step 1: Navigasi + Geser sudah dengan customer -->
    <div class="order-actions accepted hidden" id="order-actions-accepted">
        <button id="btn-nav-pickup" class="nav-btn vertical">
            <i class="fa-solid fa-location-arrow"></i>
            <span>Maps</span>
        </button>

        <div class="slider-container" id="sliderBtn1" ontouchstart="startSlide(event, 1)"
            ontouchmove="moveSlide(event, 1)" ontouchend="endSlide(event, 1)">
            <div class="slider-handle" id="sliderHandle1">
                <i class="fa-solid fa-arrow-right"></i>
            </div>
            <span class="slider-text" id="sliderText1">Geser jika sudah dengan customer</span>
        </div>
    </div>

    <!-- Step 2: Geser selesai antar -->
    <div class="order-actions completed-step hidden" id="order-actions-complete">
        <button id="btn-nav-dst" class="nav-btn vertical">
            <i class="fa-solid fa-location-arrow"></i>
            <span>Maps</span>
        </button>

        <div class="slider-container" id="sliderBtn2" ontouchstart="startSlide(event, 2)"
            ontouchmove="moveSlide(event, 2)" ontouchend="endSlide(event, 2)">
            <div class="slider-handle" id="sliderHandle2">
                <i class="fa-solid fa-flag-checkered"></i>
            </div>
            <span class="slider-text" id="sliderText2">Geser jika sudah selesai antar</span>
        </div>
    </div>


</div>




<script src="<?= base_url('js/driver.js') ?>"></script>

<?= $this->endSection() ?>