<?= $this->extend('layout/main') ?>
<?= $this->section('content') ?>

<style>
    body {
        background: linear-gradient(135deg, #16a085, #2980b9);
        min-height: 100vh;
        display: flex;
        align-items: center;
        justify-content: center;
        font-family: 'Poppins', sans-serif;
    }

    .dashboard-container {
        text-align: center;
        width: 100%;
        max-width: 420px;
        padding: 20px;
    }

    .logo {
        width: 90px;
        height: 90px;
        margin-bottom: 15px;
    }

    .dashboard-title {
        color: #fff;
        font-size: 24px;
        margin-bottom: 30px;
        font-weight: 600;
    }

    .card-option {
        border: none;
        border-radius: 18px;
        box-shadow: 0 6px 20px rgba(0, 0, 0, 0.15);
        transition: all 0.3s ease;
        margin-bottom: 20px;
        cursor: pointer;
    }

    /* .card-option:hover {
        transform: translateY(-5px);
        box-shadow: 0 12px 25px rgba(0, 0, 0, 0.2);
    } */


    .card-option i {
        font-size: 36px;
        margin-bottom: 12px;
        color: #fff;
    }

    .card-body {
        background: #2c3e50;
        border-radius: 18px;
        padding: 10px;
    }

    .card-title {
        color: #fff;
        font-size: 18px;
        font-weight: 600;
    }

    .tagline {
        font-size: 14px;
        color: #ecf0f1;
        margin-top: 5px;
    }

    .logo {
        width: 160px;
        /* lebih lebar */
        height: auto;
        /* biar proporsional */
        margin-bottom: 20px;
    }


    .profile-card {
        background: linear-gradient(145deg, #2c3e50, #34495e);
        border-radius: 20px;
        padding: 25px;
        color: #ecf0f1;
        box-shadow: 0 8px 25px rgba(0, 0, 0, 0.25);
        text-align: center;
    }

    .profile-header {
        margin-bottom: 20px;
    }

    .profile-icon {
        font-size: 60px;
        color: #1abc9c;
        margin-bottom: 10px;
    }

    .profile-name {
        font-size: 20px;
        font-weight: 600;
        margin: 0;
    }

    .profile-role {
        font-size: 14px;
        color: #bdc3c7;
        margin: 5px 0 0;
    }

    .profile-body {
        margin-top: 15px;
        text-align: left;
    }

    .info-item {
        display: flex;
        align-items: center;
        margin-bottom: 10px;
        font-size: 15px;
    }

    .info-item i {
        margin-right: 10px;
        color: #1abc9c;
        font-size: 16px;
    }

    .dashboard-subtitle {
        color: #ecf0f1;
        font-size: 16px;
        margin-bottom: 25px;
        font-weight: 400;
        font-style: italic;
    }

    .toast-notification {
        position: fixed;
        bottom: 20px;
        left: 50%;
        transform: translateX(-50%);
        z-index: 1055;
    }

    .toast-message {
        background: rgba(44, 62, 80, 0.95);
        color: #fff;
        padding: 12px 20px;
        border-radius: 12px;
        margin-top: 10px;
        font-size: 14px;
        box-shadow: 0 6px 15px rgba(0, 0, 0, 0.3);
        animation: fadeInUp 0.5s, fadeOut 0.5s 2.5s;
    }

    @keyframes fadeInUp {
        from {
            opacity: 0;
            transform: translate(-50%, 20px);
        }

        to {
            opacity: 1;
            transform: translate(-50%, 0);
        }
    }

    @keyframes fadeOut {
        from {
            opacity: 1;
        }

        to {
            opacity: 0;
        }
    }

    /* LOGOUT */
    .logout-card {
        border: none;
        border-radius: 18px;
        box-shadow: 0 6px 20px rgba(0, 0, 0, 0.15);
        transition: all 0.3s ease;
        margin-top: 20px;
        cursor: pointer;
    }

    /* .logout-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 12px 25px rgba(0, 0, 0, 0.25);
    } */

    .logout-card .card-body {
        background: #e74c3c;
        /* merah elegan */
        border-radius: 18px;
        padding: 10px;
    }

    .logout-card i {
        font-size: 32px;
        margin-bottom: 10px;
        color: #fff;
    }

    .logout-card .card-title {
        color: #fff;
        font-size: 18px;
        font-weight: 600;
    }
</style>


<div class="dashboard-container">
    <!-- ✅ Logo di atas tengah -->
    <img src="<?= base_url('images/alfago.png') ?>" alt="AlfaGo Logo" class="logo">


    <h1 class="dashboard-title">Selamat Datang di AlfaGo</h1>
    <p class="dashboard-subtitle">Silakan tentukan mode penggunaan aplikasi</p>

    <!-- Customer -->
    <div onclick="chooseRole('customer')" class="card card-option">
        <div class="card-body">
            <i class="fas fa-user"></i>
            <h5 class="card-title">Customer</h5>
            <div class="tagline">Pesan layanan dengan mudah</div>
        </div>
    </div>

    <!-- Driver -->
    <div onclick="chooseRole('driver')" class="card card-option">
        <div class="card-body">
            <i class="fas fa-motorcycle"></i>
            <h5 class="card-title">Driver</h5>
            <div class="tagline">Ambil order dan dapatkan penghasilan</div>
        </div>
    </div>

    <!-- Toko -->
    <div onclick="chooseRole('restaurant')" class="card card-option">
        <div class="card-body">
            <i class="fas fa-store"></i>
            <h5 class="card-title">Restaurant</h5>
            <div class="tagline">Kelola produk dan penjualan</div>
        </div>
    </div>

    <!-- Logout -->
    <div onclick="logout()" class="card logout-card">
        <div class="card-body">
            <i class="fas fa-sign-out-alt"></i>
            <h5 class="card-title">Logout</h5>
            <div class="tagline">Keluar dari aplikasi</div>
        </div>
    </div>

</div>



<div id="toastContainer" class="toast-notification"></div>

<script src="<?= base_url('js/dashboard.js') ?>"></script>

<?= $this->endSection() ?>