<?= $this->extend('layout/main') ?>
<?= $this->section('content') ?>

<style>
    .card-option-customer {
        background: linear-gradient(145deg, #27ae60, #2ecc71);
        color: #fff;
        border-radius: 25px;
        padding: 40px 20px;
        text-align: center;
        cursor: pointer;
        transition: all 0.4s ease;
        box-shadow: 0 8px 20px rgba(0, 0, 0, 0.1);
        display: flex;
        flex-direction: column;
        align-items: center;
        justify-content: center;
    }

    .card-option-customer:hover {
        transform: translateY(-8px) scale(1.05);
        box-shadow: 0 15px 35px rgba(0, 0, 0, 0.2);
        background: linear-gradient(145deg, #16a085, #27ae60);
    }

    .card-option-customer img {
        width: 80px;
        height: 80px;
        margin-bottom: 20px;
        object-fit: contain;
    }

    .card-option-customer h3 {
        font-size: 20px;
        font-weight: 700;
        letter-spacing: 0.5px;
        margin: 0;
    }

    @media (max-width: 480px) {
        .card-option-customer {
            padding: 30px 15px;
        }

        .card-option-customer img {
            width: 60px;
            height: 60px;
            margin-bottom: 15px;
        }

        .card-option-customer h3 {
            font-size: 18px;
        }
    }
</style>

<h1 class="text-center text-success mb-5" style="font-weight:800; letter-spacing:1px;">AlfaGo Customer</h1>

<div class="row justify-content-center g-4">
    <div class="col-6 col-md-4">
        <a href="<?= base_url('alfaride') ?>" style="text-decoration:none">
            <div class="card-option-customer">
                <!-- Ganti ikon AlfaRide menjadi sepeda motor -->
                <img src="https://img.icons8.com/ios-filled/100/ffffff/motorcycle.png" alt="AlfaRide">
                <h3>AlfaRide</h3>
            </div>
        </a>
    </div>
    <div class="col-6 col-md-4">
        <a href="<?= base_url('alfafood') ?>" style="text-decoration:none">
            <div class="card-option-customer">
                <img src="https://img.icons8.com/ios-filled/100/ffffff/meal.png" alt="AlfaFood">
                <h3>AlfaFood</h3>
            </div>
        </a>
    </div>
</div>

<?= $this->endSection() ?>