<?= $this->extend('layout/main') ?>
<?= $this->section('content') ?>

<style>
    body,
    html {
        margin: 0;
        padding: 0;
        height: 100%;
        font-family: Arial, sans-serif;
        background-color: #e8f5e9;
    }

    .search-restaurant-wrapper {
        position: fixed;
        top: 0;
        left: 50%;
        transform: translateX(-50%);
        z-index: 100;
        width: 100%;
        max-width: 600px;
        background: linear-gradient(135deg, #16a085, #2980b9);
        color: #fff;
        padding: 20px 15px;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.2);
        border-bottom-left-radius: 15px;
        border-bottom-right-radius: 15px;
        display: flex;
        flex-direction: column;
        gap: 10px;

    }

    .location-wrapper {
        padding-top: 30px;
        display: flex;
        align-items: center;
        gap: 10px;
        font-size: 14px;
        color: #fff;
    }

    .location-wrapper i {
        color: #ffeb3b;
    }

    .location-text {
        flex: 1;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
    }

    .search-group {
        display: flex;
        flex-direction: column;
        gap: 10px;
    }

    .search-group input {
        width: 100%;
        padding: 12px 15px;
        border-radius: 10px;
        border: none;
        outline: none;
        box-shadow: none;
        background: #e8f5e9;
        color: #000;
        font-size: 14px;
    }

    /* .search-group input::placeholder {
        color: rgba(39, 174, 96, 0.7);
    } */

    /* Map full screen minus header */
    #map {
        width: 100%;
        height: 100%;
        position: absolute;
        top: 0;
        left: 0;
        z-index: 1;
        /* padding-bottom: 950px; */
    }

    .input-wrapper {
        position: relative;
        width: 100%;
    }

    .input-wrapper input {
        width: 100%;
        padding: 12px 40px;
        /* space untuk ikon kiri & kanan */
        border-radius: 10px;
        border: none;
        outline: none;
        font-size: 14px;
    }

    .left-icon {
        position: absolute;
        left: 12px;
        top: 50%;
        transform: translateY(-50%);
        color: #2a6572ff;
        pointer-events: none;
    }

    .right-icon {
        position: absolute;
        right: 12px;
        top: 50%;
        transform: translateY(-50%);
        color: #2a6572ff;
        cursor: pointer;
        font-size: 12px;
    }

    /* Card info rute di atas bottom navigation */
    .route-card {
        position: fixed;
        bottom: 70px;
        /* jarak dari bottom nav */
        left: 50%;
        transform: translateX(-50%);
        background: #ffffffcc;
        backdrop-filter: blur(10px);
        border-radius: 12px;
        padding: 15px 20px;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.2);
        max-width: 600px;
        width: 90%;
        font-size: 14px;
        z-index: 200;
        transition: all 0.3s ease;
    }

    .fab-btn {
        position: fixed;
        top: 260px;
        /* jarak dari atas, sesuaikan dengan tinggi tombol lokasi saya */
        right: 15px;
        /* jarak dari kanan */
        z-index: 300;
        width: 40px;
        height: 40px;
        border-radius: 50%;
        border: none;
        background: linear-gradient(135deg, #16a085, #2980b9);
        color: #fff;
        cursor: pointer;
        display: flex;
        justify-content: center;
        align-items: center;
        box-shadow: 0 4px 10px rgba(0, 0, 0, 0.3);
        transition: all 0.2s ease;
        font-size: 20px;
    }

    .fab-btn:hover {
        background: #1abc9c;
        transform: translateY(-2px);
    }




    .option-buttons {
        display: flex;
        justify-content: space-between;
        align-items: center;
        gap: 10px;
        margin-top: 10px;
    }

    .option-btn {
        padding: 10px 16px;
        border: none;
        border-radius: 8px;
        font-size: 14px;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 6px;
        transition: all 0.3s ease;
        font-weight: 500;
        white-space: nowrap;
        color: #fff;
        box-shadow: 0 4px 10px rgba(0, 0, 0, 0.2);
    }

    /* Pilih dari peta */
    .option-btn.pilih {
        background: linear-gradient(135deg, #1abc9c, #16a085);
    }

    .option-btn.pilih:hover {
        background: linear-gradient(135deg, #16a085, #0e6655);
    }

    /* Lokasi saya */
    .option-btn.lokasi {
        background: linear-gradient(135deg, #3498db, #2980b9);
    }

    .option-btn.lokasi:hover {
        background: linear-gradient(135deg, #2980b9, #1c5d99);
    }


    .autocomplete-suggestions {
        list-style: none;
        margin: 0;
        padding: 0;
        border: 1px solid #ddd;
        max-height: 200px;
        overflow-y: auto;
        background: #fff;
        position: absolute;
        z-index: 1000;
        width: 90%;
        color: #000000ff;
    }

    .autocomplete-suggestions li {
        padding: 8px;
        cursor: pointer;
    }

    .autocomplete-suggestions li:hover {
        background-color: #eee;
    }
</style>

<div class="search-restaurant-wrapper">
    <div class="location-wrapper">
        <i class="fa-solid fa-location-dot"></i>
        <span class="location-text" id="current-location">Mengambil lokasi...</span>
    </div>
    <div class="search-group">
        <div id="containerLokasiAwal" class="input-wrapper">
            <i class="fa-solid fa-map-marker-alt left-icon"></i>
            <input id="lokasi_awal" type="text" placeholder="Lokasi jemput...">
            <i id="btnCloseAwal" class="fa-solid fa-x right-icon"></i>
            <ul id="suggestions_awal"></ul>

        </div>

        <div class="input-wrapper">
            <i class="fa-solid fa-flag-checkered left-icon"></i>
            <input id="lokasi_akhir" type="text" placeholder="Lokasi tujuan...">
            <i id="btnCloseAkhir" class="fa-solid fa-x right-icon"></i>

        </div>
    </div>


    <div class="option-buttons">
        <button class="option-btn pilih" onclick="chooseFromMap()">
            <i class="fa-solid fa-map"></i> Pilih dari Peta
        </button>
        <button class="option-btn lokasi" onclick="chooseCurrentLocation()">
            <i class="fa-solid fa-location-crosshairs"></i> Lokasi Saya
        </button>
    </div>
</div>





<div id="map"></div>
<!-- Card info rute -->
<div id="route-card" class="route-card" style="display: none" ;>
    <div id="route-info">Menghitung rute...</div>
</div>
<button id="center-btn" class="fab-btn" title="Pusatkan Lokasi">
    <i class="fa-solid fa-crosshairs"></i>

</button>


<script
    src="https://maps.googleapis.com/maps/api/js?key=AIzaSyDsFlGo6S8RGU7JV72iBMolPzrJNKgfk-M&libraries=places&callback=initMap"
    async defer></script>
<script>
    let map, startMarker, endMarker, directionsService, directionsRenderer;

    function initMap() {
        const center = {
            lat: -6.175392,
            lng: 106.827153
        };

        map = new google.maps.Map(document.getElementById("map"), {
            center,
            zoom: 15,
            disableDefaultUI: true
        });

        directionsService = new google.maps.DirectionsService();
        directionsRenderer = new google.maps.DirectionsRenderer({
            map: map,
            suppressMarkers: true
        });

        const inputAwal = document.getElementById("lokasi_awal");
        const inputAkhir = document.getElementById("lokasi_akhir");
        const suggestionsAwal = document.getElementById("suggestions_awal");
        const suggestionsAkhir = document.getElementById("suggestions_akhir");
        const btnCloseAwal = document.getElementById("btnCloseAwal");
        const btnCloseAkhir = document.getElementById("btnCloseAkhir");
        const routeCard = document.getElementById("route-card");

        const service = new google.maps.places.AutocompleteService();

        // ======== Custom Autocomplete Awal ========
        inputAwal.addEventListener("input", () => {
            const query = inputAwal.value;
            suggestionsAwal.innerHTML = "";
            if (!query) return;

            service.getPlacePredictions({
                    input: query,
                    componentRestrictions: {
                        country: "ID"
                    }
                },
                (predictions, status) => {
                    if (status !== google.maps.places.PlacesServiceStatus.OK || !predictions) return;

                    predictions.forEach(pred => {
                        const li = document.createElement("li");
                        li.textContent = pred.description;
                        li.addEventListener("click", () => {
                            inputAwal.value = pred.description;
                            suggestionsAwal.innerHTML = "";

                            const placesService = new google.maps.places.PlacesService(map);
                            placesService.getDetails({
                                placeId: pred.place_id
                            }, (place, status) => {
                                if (status !== google.maps.places.PlacesServiceStatus.OK || !place.geometry) return;

                                if (startMarker) startMarker.setMap(null);
                                startMarker = new google.maps.Marker({
                                    position: place.geometry.location,
                                    map,
                                });
                                map.setCenter(place.geometry.location);
                                calculateRoute();
                            });
                        });
                        suggestionsAwal.appendChild(li);
                    });
                }
            );
        });

        // ======== Custom Autocomplete Akhir ========
        inputAkhir.addEventListener("input", () => {
            const query = inputAkhir.value;
            suggestionsAkhir.innerHTML = "";
            if (!query) return;

            service.getPlacePredictions({
                    input: query,
                    componentRestrictions: {
                        country: "ID"
                    }
                },
                (predictions, status) => {
                    if (status !== google.maps.places.PlacesServiceStatus.OK || !predictions) return;

                    predictions.forEach(pred => {
                        const li = document.createElement("li");
                        li.textContent = pred.description;
                        li.addEventListener("click", () => {
                            inputAkhir.value = pred.description;
                            suggestionsAkhir.innerHTML = "";

                            const placesService = new google.maps.places.PlacesService(map);
                            placesService.getDetails({
                                placeId: pred.place_id
                            }, (place, status) => {
                                if (status !== google.maps.places.PlacesServiceStatus.OK || !place.geometry) return;

                                if (endMarker) endMarker.setMap(null);
                                endMarker = new google.maps.Marker({
                                    position: place.geometry.location,
                                    map,
                                });
                                map.setCenter(place.geometry.location);
                                calculateRoute();
                            });
                        });
                        suggestionsAkhir.appendChild(li);
                    });
                }
            );
        });

        // ======== Tombol Clear ========
        btnCloseAwal.addEventListener("click", () => {
            inputAwal.value = "";
            if (startMarker) startMarker.setMap(null);
            startMarker = null;
            clearRoute();
        });

        btnCloseAkhir.addEventListener("click", () => {
            inputAkhir.value = "";
            if (endMarker) endMarker.setMap(null);
            endMarker = null;
            clearRoute();
        });

        // ======== Hitung Rute ========
        function calculateRoute() {
            if (!startMarker || !endMarker) return;
            directionsService.route({
                    origin: startMarker.getPosition(),
                    destination: endMarker.getPosition(),
                    travelMode: 'DRIVING'
                },
                (response, status) => {
                    if (status === 'OK') {
                        directionsRenderer.setDirections(response);
                        routeCard.style.display = "block";
                    }
                }
            );
        }

        function clearRoute() {
            directionsRenderer.setMap(null);
            routeCard.style.display = "none";
        }
    }
    // let map, userMarker, startMarker, endMarker, directionsService, directionsRenderer, autocompleteAwal, autocompleteAkhir;


    function initMap0() {
        const center = {
            lat: -6.175392,
            lng: 106.827153
        };

        map = new google.maps.Map(document.getElementById("map"), {
            center: center,
            zoom: 15,
            disableDefaultUI: true,
            zoomControl: false,
            streetViewControl: false,
            fullscreenControl: false,
            mapTypeControl: false,
            rotateControl: false,
            scaleControl: false,
            clickableIcons: false
        });

        getCurrentLocation();

        // Icon custom start (misal bendera hijau)
        const startIcon = {
            url: `${baseUrl}/images/marker_start.png`, // ganti URL dengan icon kamu
            scaledSize: new google.maps.Size(40, 40), // ukuran icon
            anchor: new google.maps.Point(20, 40) // titik anchor di bawah icon
        };

        // Icon custom finish (misal bendera merah)
        const finishIcon = {
            url: `${baseUrl}/images/marker_finish.png`, // ganti URL dengan icon kamu
            scaledSize: new google.maps.Size(40, 40),
            anchor: new google.maps.Point(20, 40)
        };

        directionsService = new google.maps.DirectionsService();
        directionsRenderer = new google.maps.DirectionsRenderer({
            map: map,
            suppressMarkers: true // Mencegah marker otomatis dari DirectionsRenderer
        });

        const inputAwal = document.getElementById("lokasi_awal");
        const inputAkhir = document.getElementById("lokasi_akhir");

        // const containerAwal = document.getElementById("containerLokasiAwal");

        // autocompleteAwal = new google.maps.places.Autocomplete(inputAwal);
        // autocompleteAkhir = new google.maps.places.Autocomplete(inputAkhir);

        // autocompleteAwal.setFields(["name", "formatted_address", "geometry"]);
        // autocompleteAkhir.setFields(["name", "formatted_address", "geometry"]);
        // autocompleteAwal = new google.maps.places.PlaceAutocompleteElement(inputAwal);
        // autocompleteAwal.setFields(["name", "formatted_address", "geometry"]);


        // Cek apakah element ditemukan
        // const inputAwal = document.getElementById("lokasi_awal");
        const suggestionsList = document.getElementById("suggestions");



        // Buat PlaceAutocompleteElement
        const autocompleteAwal = new google.maps.places.PlaceAutocompleteElement({
            inputElement: inputAwal,
            componentRestrictions: {
                country: "id"
            }
        });

        // Setiap kali user mengetik
        inputAwal.addEventListener("input", async () => {
            const query = inputAwal.value;
            if (!query) {
                suggestionsList.innerHTML = "";
                return;
            }

            // Dapatkan suggestions
            const results = await autocompleteAwal.queryAutocomplete({
                input: query
            });

            // Tampilkan di list
            suggestionsList.innerHTML = "";
            results.forEach(place => {
                const li = document.createElement("li");
                li.textContent = place.displayName;
                li.style.padding = "8px";
                li.style.cursor = "pointer";

                li.addEventListener("click", async () => {
                    // Pilih place
                    await place.fetchFields({
                        fields: ["displayName", "formattedAddress", "location"]
                    });

                    // Set input dan hapus dropdown
                    inputAwal.value = place.displayName;
                    suggestionsList.innerHTML = "";

                    // Set marker
                    if (startMarker) startMarker.setMap(null);
                    startMarker = new google.maps.Marker({
                        position: place.location,
                        map: map
                    });

                    map.setCenter(place.location);
                });

                suggestionsList.appendChild(li);
            });
        });

        return;
        // const autocompleteAkhir = new google.maps.places.PlaceAutocompleteElement({
        //     input: inputAkhir,
        //     options: {
        //         fields: ["name", "formatted_address", "geometry"]
        //     }
        // });

        // autocomplete.addListener("place_changed", () => {
        //     const place = autocomplete.getPlace();
        //     console.log(place);
        // });

        // return;

        autocompleteAwal.addListener("place_changed", () => {
            autocompleteAwalFungsi();
        });

        function autocompleteAwalFungsi() {
            const place = autocompleteAwal.getPlace();
            if (!place.geometry) return;

            // Pilih nama tempat (lebih singkat) atau alamat kalau tidak ada nama
            const displayName = place.name || place.formatted_address;

            // Set langsung ke input agar tampil nama tempat, bukan alamat panjang
            document.getElementById("lokasi_awal").value = displayName;


            // 🔥 Hapus marker user location kalau ada
            if (userMarker) {
                userMarker.setMap(null);
                userMarker = null;
            }


            // Hapus marker lama
            if (startMarker) {
                startMarker.setMap(null);
                startMarker = null;
            }

            // Membuat marker start
            startMarker = new google.maps.Marker({
                position: place.geometry.location,
                map: map,
                icon: startIcon
            });

            // Simpan nama tempat di marker untuk ditampilkan di info rute
            startMarker.placeName = displayName;

            map.setCenter(place.geometry.location);
            calculateRoute();
        }


        autocompleteAkhir.addListener("place_changed", () => {
            autocompleteAkhirFungsi();
        });

        function autocompleteAkhirFungsi() {
            const place = autocompleteAkhir.getPlace();
            if (!place.geometry) return;

            // Pilih nama tempat (lebih singkat) atau alamat kalau tidak ada nama
            const displayName = place.name || place.formatted_address;

            // Set langsung ke input agar tampil nama tempat, bukan alamat panjang
            document.getElementById("lokasi_akhir").value = displayName;


            // 🔥 Hapus marker user location kalau ada
            if (userMarker) {
                userMarker.setMap(null);
                userMarker = null;
            }


            // Hapus marker lama
            if (endMarker) {
                endMarker.setMap(null);
                endMarker = null;
            }

            // Membuat marker start
            endMarker = new google.maps.Marker({
                position: place.geometry.location,
                map: map,
                icon: finishIcon
            });

            // Simpan nama tempat di marker untuk ditampilkan di info rute
            endMarker.placeName = displayName;

            map.setCenter(place.geometry.location);
            calculateRoute();
        }

        const inputAwalClose = document.getElementById("btnCloseAwal");
        const inputAkhirClose = document.getElementById("btnCloseAkhir");
        const routeCard = document.getElementById("route-card");

        inputAwalClose.addEventListener("click", () => {
            inputAwal.value = "";
            inputAwal.focus();


            // 🔥 Hapus marker user location kalau ada
            if (userMarker) {
                userMarker.setMap(null);
                userMarker = null;
            }


            // Hapus marker lama
            if (startMarker) {
                startMarker.setMap(null);
                startMarker = null;
            }
        });

        inputAkhirClose.addEventListener("click", () => {
            inputAkhir.value = "";
            inputAkhir.focus();


            // 🔥 Hapus marker user location kalau ada
            if (userMarker) {
                userMarker.setMap(null);
                userMarker = null;
            }


            // Hapus marker lama
            if (endMarker) {
                endMarker.setMap(null);
                endMarker = null;
            }


            routeCard.style.display = "none"; // pastikan card tampil
            if (directionsRenderer) {
                directionsRenderer.setMap(null); // Menghapus garis rute
            }
        });


    }



    // getCurrentLocation();
    function getCurrentLocation() {
        if (!navigator.geolocation) return;
        navigator.geolocation.getCurrentPosition(pos => {
            const {
                latitude,
                longitude
            } = pos.coords;
            const userPos = {
                lat: latitude,
                lng: longitude
            };

            // Hapus user marker lama jika ada
            if (userMarker) {
                userMarker.setMap(null);
                userMarker = null;
            }

            // Marker posisi user dengan warna BIRU
            userMarker = new google.maps.Marker({
                position: userPos,
                map: map,
                title: "Posisi Anda",
                icon: {
                    url: `${baseUrl}/images/blue-dot.png`,
                    scaledSize: new google.maps.Size(40, 40)
                }
            });

            map.setCenter(userPos);

            const circle = new google.maps.Circle({
                center: userPos,
                radius: 5000
            });

            if (autocompleteAwal) autocompleteAwal.setBounds(circle.getBounds());
            if (autocompleteAkhir) autocompleteAkhir.setBounds(circle.getBounds());

            fetch(`
                                https: //maps.googleapis.com/maps/api/geocode/json?latlng=${latitude},${longitude}&key=AIzaSyDsFlGo6S8RGU7JV72iBMolPzrJNKgfk-M`)
                .then(res => res.json())
                .then(data => {
                    if (data.status === "OK" && data.results.length > 0) {
                        document.getElementById("current-location").textContent = data.results[0].formatted_address;
                    } else {
                        document.getElementById("current-location").textContent = `Lat: ${latitude}, Lng: ${longitude}`;
                    }
                });
        });
    }

    function getCurrentLocation1() {
        if (!navigator.geolocation) {
            document.getElementById("current-location").textContent = "Geolocation tidak didukung";
            return;
        }

        navigator.geolocation.getCurrentPosition(
            pos => {
                const {
                    latitude,
                    longitude
                } = pos.coords;
                const userPos = {
                    lat: latitude,
                    lng: longitude
                };

                // Tampilkan koordinat sementara dulu
                document.getElementById("current-location").textContent =
                    `Lat: ${latitude.toFixed(5)}, Lng: ${longitude.toFixed(5)}`;

                // Hapus user marker lama jika ada
                if (userMarker) userMarker.setMap(null);

                // Marker posisi user dengan warna BIRU
                userMarker = new google.maps.Marker({
                    position: userPos,
                    map: map,
                    title: "Posisi Anda",
                    icon: {
                        url: "https://alfago.alfateknologi.net/images/blue-dot.png",
                        scaledSize: new google.maps.Size(40, 40)
                    }
                });

                map.setCenter(userPos);

                const circle = new google.maps.Circle({
                    center: userPos,
                    radius: 5000
                });

                if (autocompleteAwal) autocompleteAwal.setBounds(circle.getBounds());
                if (autocompleteAkhir) autocompleteAkhir.setBounds(circle.getBounds());

                // Fetch alamat lengkap di background
                fetch(`https://maps.googleapis.com/maps/api/geocode/json?latlng=${latitude},${longitude}&key=AIzaSyDsFlGo6S8RGU7JV72iBMolPzrJNKgfk-M`)
                    .then(res => res.json())
                    .then(data => {
                        if (data.status === "OK" && data.results.length > 0) {
                            document.getElementById("current-location").textContent = data.results[0].formatted_address;
                        }
                    })
                    .catch(err => console.error("Gagal fetch alamat:", err));
            },
            err => {
                console.error("Error geolocation:", err);
                document.getElementById("current-location").textContent = "Tidak bisa mendapatkan lokasi";
            }, {
                enableHighAccuracy: true,
                timeout: 10000,
                maximumAge: 0
            }
        );
    }


    function calculateRoute() {
        if (!startMarker || !endMarker) return;

        directionsService.route({
                origin: startMarker.getPosition(),
                destination: endMarker.getPosition(),
                travelMode: google.maps.TravelMode.DRIVING
            },
            (result, status) => {

                if (status === "OK") {
                    directionsRenderer.setDirections(result);
                    const route = result.routes[0].legs[0];

                    const routeCard = document.getElementById("route-card");

                    // 🔥 Atur zoom otomatis agar seluruh rute terlihat
                    const bounds = new google.maps.LatLngBounds();
                    bounds.extend(startMarker.getPosition());
                    bounds.extend(endMarker.getPosition());
                    map.fitBounds(bounds);

                    // Contoh biaya
                    const biayaPerKm = 5000; // ongkos per km (Rp)
                    const biayaAplikasi = 2000; // biaya aplikasi tetap (Rp)
                    const jarakKm = route.distance.value / 1000; // jarak dalam km

                    const totalBiaya = Math.round(biayaPerKm * jarakKm + biayaAplikasi);

                    // Update card info rute + tombol order full-width
                    document.getElementById("route-info").innerHTML = `
  <div style="font-weight:bold; margin-bottom:5px;">📊 Info Perjalanan</div>
  <div>🚩 Awal: ${startMarker.placeName || route.start_address}</div>
  <div>🏁 Tujuan: ${endMarker.placeName || route.end_address}</div>
  <div>🛣️ Jarak: ${route.distance.text}</div>
  <div>⏱️ Durasi: ${route.duration.text}</div>
  <div>💰 Ongkos: Rp ${Math.round(biayaPerKm * jarakKm).toLocaleString()}</div>
  <div>📱 Biaya Aplikasi: Rp ${(Math.round(biayaPerKm * jarakKm) * 0.2).toLocaleString()}</div>
  <div style="font-weight:bold; margin-top:10px;">Total: Rp ${totalBiaya.toLocaleString()}</div>

  <!-- Tombol order full-width -->
  <button id="order-btn" style="
    width: 100%; 
    padding: 12px; 
    margin-top: 15px; 
    background-color: #27ae60; 
    color: #fff; 
    border: none; 
    border-radius: 10px; 
    font-size: 16px; 
    font-weight: bold; 
    cursor: pointer;
  ">
    Pesan Sekarang
  </button>
`;

                    // Event klik tombol order
                    document.getElementById("order-btn").addEventListener("click", () => {
                        alert("Pesanan dikonfirmasi! Total: Rp " + totalBiaya.toLocaleString());
                        // Bisa ditambahkan logic untuk API order di sini
                    });

                    routeCard.style.display = "block"; // pastikan card tampil
                } else {
                    document.getElementById("route-info").innerHTML =
                        `Gagal menghitung rute: ${status}`;
                    routeCard.style.display = "block";
                }
            }
        );
    }


    // Fungsi untuk custom marker dengan SVG (opsional)
    function createCustomMarker(color, letter) {
        return {
            path: "M0-48c-9.8 0-17.7 7.8-17.7 17.4 0 15.5 17.7 30.6 17.7 30.6s17.7-15.4 17.7-30.6c0-9.6-7.9-17.4-17.7-17.4z",
            fillColor: color,
            fillOpacity: 1,
            strokeColor: "#000",
            strokeWeight: 1,
            scale: 1,
            label: {
                text: letter,
                color: "white",
                fontWeight: "bold",
                fontSize: "12px"
            }
        };
    }

    document.getElementById("center-btn").addEventListener("click", () => {
        if (userMarker && map) {
            map.setCenter(userMarker.getPosition());
            map.setZoom(15);
        }
    });

    let activeInput = null; // menyimpan input mana yang terakhir dipilih (awal / akhir)

    // track input aktif
    document.getElementById("lokasi_awal").addEventListener("focus", () => activeInput = "lokasi_awal");
    document.getElementById("lokasi_akhir").addEventListener("focus", () => activeInput = "lokasi_akhir");

    function chooseCurrentLocation() {
        if (!activeInput) return showFullscreenNotif("info", "Silakan pilih input lokasi awal atau akhir dulu");

        if (!navigator.geolocation) return showFullscreenNotif("info", "Geolocation tidak didukung");

        navigator.geolocation.getCurrentPosition((pos) => {
            const loc = {
                lat: pos.coords.latitude,
                lng: pos.coords.longitude
            };

            if (activeInput === "lokasi_awal") {
                document.getElementById("lokasi_awal").value = "Lokasi saya";
                if (startMarker) startMarker.setMap(null);
                startMarker = new google.maps.Marker({
                    position: loc,
                    map: map,
                    icon: {
                        url: "https://alfago.alfateknologi.net/images/marker_start.png",
                        scaledSize: new google.maps.Size(40, 40)
                    }
                });
                map.setCenter(loc);
            } else {
                document.getElementById("lokasi_akhir").value = "Lokasi saya";
                if (endMarker) endMarker.setMap(null);
                endMarker = new google.maps.Marker({
                    position: loc,
                    map: map,
                    icon: {
                        url: "https://alfago.alfateknologi.net/images/marker_finish.png",
                        scaledSize: new google.maps.Size(40, 40)
                    }
                });
                map.setCenter(loc);
            }

            calculateRoute();
        });
    }



    // dipanggil saat klik tombol "Pilih dari Peta"
    function chooseFromMap() {
        if (!activeInput) return showFullscreenNotif("info", "Silakan pilih input lokasi awal atau akhir dulu");
        console.log(activeInput);
        // activeInput = inputId;
        // alert("👉 Silakan klik di peta untuk memilih lokasi " + (inputId === "lokasi_awal" ? "Awal" : "Akhir"));
        map.addListener("click", (e) => {
            const latLng = e.latLng;

            const geocoder = new google.maps.Geocoder();
            geocoder.geocode({
                location: latLng
            }, (results, status) => {
                if (status === "OK" && results[0]) {
                    const placeName = results[0].formatted_address;

                    document.getElementById(activeInput).value = placeName;

                    // 🔥 Hapus marker user location kalau ada
                    if (userMarker) {
                        userMarker.setMap(null);
                        userMarker = null;
                    }

                    if (activeInput === "lokasi_awal") {
                        if (startMarker) startMarker.setMap(null);
                        startMarker = new google.maps.Marker({
                            position: latLng,
                            map: map,
                            icon: {
                                url: "https://alfago.alfateknologi.net/images/marker_start.png",
                                scaledSize: new google.maps.Size(40, 40)
                            }
                        });
                        startMarker.placeName = placeName;
                    } else {
                        if (endMarker) endMarker.setMap(null);
                        endMarker = new google.maps.Marker({
                            position: latLng,
                            map: map,
                            icon: {
                                url: "https://alfago.alfateknologi.net/images/marker_finish.png",
                                scaledSize: new google.maps.Size(40, 40)
                            }
                        });
                        endMarker.placeName = placeName;
                    }

                    map.setCenter(latLng);
                    calculateRoute();
                }
            });
        });
    }
</script>

<?= $this->endSection() ?>