<?= $this->extend('layout/main') ?>
<?= $this->section('content') ?>

<style>
    body,
    html {
        margin: 0;
        padding: 0;
        height: 100%;
        font-family: Arial, sans-serif;
        background-color: #e8f5e9;
    }

    .search-restaurant-wrapper {
        position: fixed;
        top: 0;
        left: 50%;
        transform: translateX(-50%);
        z-index: 100;
        width: 100%;
        /* max-width: 600px; */
        background: linear-gradient(135deg, #16a085, #2980b9);
        color: #fff;
        padding: 20px 15px;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.2);
        border-bottom-left-radius: 15px;
        border-bottom-right-radius: 15px;
        display: flex;
        flex-direction: column;
        gap: 10px;

    }

    .location-wrapper {
        padding-top: 30px;
        display: flex;
        align-items: center;
        gap: 10px;
        font-size: 14px;
        color: #fff;
    }

    .location-wrapper i {
        color: #ffeb3b;
    }

    .location-text {
        flex: 1;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
    }

    .search-group {
        display: flex;
        flex-direction: column;
        gap: 10px;
    }

    .search-group input {
        width: 100%;
        padding: 12px 15px;
        border-radius: 10px;
        border: none;
        outline: none;
        box-shadow: none;
        background: #e8f5e9;
        color: #000;
        font-size: 14px;
    }

    /* .search-group input::placeholder {
        color: rgba(39, 174, 96, 0.7);
    } */

    /* Map full screen minus header */
    #map {
        width: 100%;
        height: 100%;
        position: absolute;
        top: 0;
        left: 0;
        /* z-index: 1; */
        /* height: calc(100vh - 40px); */
        /* margin-top: 300px; */
        /* padding-bottom: 950px; */
        /* min-height: calc(100vh - 300px); */
    }

    .input-wrapper {
        position: relative;
        width: 100%;
    }

    .input-wrapper input {
        width: 100%;
        padding: 12px 40px;
        /* space untuk ikon kiri & kanan */
        border-radius: 10px;
        border: none;
        outline: none;
        font-size: 14px;
    }

    .left-icon {
        position: absolute;
        left: 12px;
        top: 50%;
        transform: translateY(-50%);
        color: #2a6572ff;
        pointer-events: none;
    }

    .right-icon {
        position: absolute;
        right: 12px;
        top: 50%;
        transform: translateY(-50%);
        color: #2a6572ff;
        cursor: pointer;
        font-size: 12px;
    }

    /* Card info rute di atas bottom navigation */
    .route-card {
        position: relative;
        bottom: 0px;
        /* jarak dari bottom nav */
        left: 50%;
        transform: translateX(-50%);
        background: #ffffffcc;
        backdrop-filter: blur(10px);
        border-radius: 12px 12px 0 0;
        padding: 15px 20px;
        /* padding-bottom: 60px; */
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.2);
        /* max-width: 600px; */
        width: 100%;
        font-size: 14px;
        height: auto;
        /* z-index: 200; */
        transition: all 0.3s ease;
        position: absolute;

    }


    .fab-btn {
        position: fixed;
        top: 255px;
        /* jarak dari atas, sesuaikan dengan tinggi tombol lokasi saya */
        right: 10px;
        /* jarak dari kanan */
        z-index: 300;
        width: 40px;
        height: 40px;
        border-radius: 50%;
        border: none;
        background: linear-gradient(135deg, #16a085, #2980b9);
        color: #fff;
        cursor: pointer;
        display: flex;
        justify-content: center;
        align-items: center;
        box-shadow: 0 4px 10px rgba(0, 0, 0, 0.3);
        transition: all 0.2s ease;
        font-size: 20px;
    }

    .fab-btn:hover {
        background: #1abc9c;
        transform: translateY(-2px);
    }

    .option-buttons {
        display: flex;
        justify-content: space-between;
        align-items: center;
        gap: 10px;
        margin-top: 10px;
    }

    .option-btn {
        padding: 10px 16px;
        border: none;
        border-radius: 8px;
        font-size: 14px;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 6px;
        transition: all 0.3s ease;
        font-weight: 500;
        white-space: nowrap;
        color: #fff;
        box-shadow: 0 4px 10px rgba(0, 0, 0, 0.2);
    }

    /* Pilih dari peta */
    .option-btn.pilih {
        background: linear-gradient(135deg, #1abc9c, #16a085);
    }

    .option-btn.pilih:hover {
        background: linear-gradient(135deg, #16a085, #0e6655);
    }

    /* Lokasi saya */
    .option-btn.lokasi {
        background: linear-gradient(135deg, #3498db, #2980b9);
    }

    .option-btn.lokasi:hover {
        background: linear-gradient(135deg, #2980b9, #1c5d99);
    }

    /* Floating Driver Count (kiri bawah di atas route-card) */
    .driver-floating {
        position: fixed;
        left: 10px;
        top: calc(70px + 185px);
        /* 70px = tinggi bottom nav, 100px = jarak di atas route-card */
        z-index: 500;
        background: linear-gradient(135deg, #16a085, #2980b9);
        color: #fff;
        display: flex;
        align-items: center;
        gap: 8px;
        padding: 10px 16px;
        border-radius: 30px;
        font-size: 14px;
        font-weight: 600;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.25);
        cursor: pointer;
        transition: all 0.3s ease;
    }


    .order-btn {
        position: relative;
        width: 100%;
        padding: 14px;
        margin-top: 15px;
        background: linear-gradient(135deg, #16a085, #2980b9);
        color: #fff;
        border: none;
        border-radius: 10px;
        font-size: 16px;
        font-weight: bold;
        cursor: pointer;
        overflow: hidden;
        transition: background 0.3s ease, transform 0.2s ease;
        display: inline-flex;
        align-items: center;
        justify-content: center;
    }

    .order-btn:active {
        transform: scale(0.98);
    }

    /* Spinner */
    .btn-spinner {
        width: 20px;
        height: 20px;
        border: 3px solid rgba(255, 255, 255, 0.3);
        border-top: 3px solid #fff;
        border-radius: 50%;
        animation: spin 1s linear infinite;
        margin-left: 8px;
        opacity: 0;
        transform: scale(0);
        transition: opacity 0.2s, transform 0.2s;
    }

    @keyframes spin {
        0% {
            transform: rotate(0deg);
        }

        100% {
            transform: rotate(360deg);
        }
    }

    /* Mode loading */
    .loading {
        background: linear-gradient(135deg, #0f766e, #1e3a8a);
    }

    .loading .btn-spinner {
        opacity: 1;
        transform: scale(1);
    }




    .trip-info-title {
        font-weight: bold;
        font-size: 18px;
        color: #1565C0;
        margin-bottom: 8px;
        display: flex;
        align-items: center;
    }

    .trip-item {
        margin-bottom: 6px;
        font-size: 14px;
    }

    .trip-total {
        margin-top: 10px;
        font-weight: bold;
        font-size: 18px;
        color: #16a085;
    }

    /* === HEADER STATUS === */
    .driver-header {
        display: flex;
        align-items: center;
        margin-bottom: 14px;
    }

    .driver-status-pulse {
        width: 12px;
        height: 12px;
        background: #16a085;
        border-radius: 50%;
        margin-right: 8px;
        animation: pulse 1.5s infinite;
    }

    .driver-status-text {
        font-weight: 600;
        color: #16a085;
        font-size: 15px;
    }

    /* === PROFILE SECTION === */
    .driver-profile {
        display: flex;
        align-items: flex-start;
        /* 🔥 sebelumnya center, ubah jadi flex-start */
        gap: 12px;
        margin-bottom: 12px;
    }

    /* Foto + Bintang */
    .driver-photo-wrap {
        display: flex;
        flex-direction: column;
        align-items: center;
        min-width: 64px;
    }

    .driver-photo {
        width: 56px;
        height: 56px;
        border-radius: 50%;
        object-fit: cover;
        border: 3px solid #16a085;
    }

    .driver-performance {
        display: inline-flex;
        align-items: center;
        justify-content: center;
        gap: 6px;
        border-radius: 10px;
        padding: 6px 10px;
        font-weight: 500;
        font-size: 0.9rem;
        /* box-shadow: 0 2px 6px rgba(0, 0, 0, 0.1); */
        transition: background 0.3s ease, color 0.3s ease;
    }

    .driver-performance i {
        font-size: 1rem;
        transition: transform 0.3s ease, color 0.3s ease;
    }

    .driver-performance:hover i {
        transform: scale(1.1);
    }

    /* Detail Driver */
    .driver-details {
        flex: 1;
        display: flex;
        flex-direction: column;
        justify-content: flex-start;
        /* 🔥 pastikan konten di atas */
    }

    .driver-name {
        font-weight: bold;
        font-size: 16px;
        color: #1565C0;
    }

    .driver-phone {
        font-size: 14px;
        color: #555;
        margin: 2px 0 6px 0;
    }

    .vehicle-info {
        font-size: 14px;
        color: #333;
    }

    /* Tombol Chat */
    .chat-driver {
        display: flex;
        align-items: center;
    }

    .chat-driver a {
        display: inline-flex;
        justify-content: center;
        align-items: center;
        width: 46px;
        height: 46px;
        border-radius: 50%;
        background: #25D366;
        color: #fff;
        font-size: 22px;
        text-decoration: none;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.2);
        transition: background 0.3s, transform 0.2s;
    }

    .chat-driver a:hover {
        background: #1ebe5b;
        transform: scale(1.05);
    }

    /* ETA INFO */
    .eta-info {
        display: flex;
        flex-direction: column;
        /* 👉 atur atas-bawah */
        align-items: flex-start;
        gap: 4px;
        margin-top: 10px;
    }

    .eta-info .eta-text,
    .eta-info .distance-text {
        display: flex;
        align-items: flex-start;
        /* 🔧 awalnya center, ubah ke flex-start */
        gap: 6px;
        font-size: 15px;
        color: #333;
    }

    .eta-info .eta-text span,
    .eta-info .distance-text span {
        display: inline-block;
        text-align: left;
        white-space: normal;
        /* pastikan teks bisa membungkus */
        word-break: break-word;
        /* teks panjang tetap membungkus */
    }


    .eta-info i {
        color: #1565C0;
        font-size: 16px;
    }


    /* ANIMASI */
    @keyframes pulse {
        0% {
            transform: scale(1);
            opacity: 1;
        }

        50% {
            transform: scale(1.3);
            opacity: 0.5;
        }

        100% {
            transform: scale(1);
            opacity: 1;
        }
    }

    @keyframes fadeBlink {
        0% {
            opacity: 1;
        }

        100% {
            opacity: 0.6;
        }
    }

    /* 🔥 Garis putus-putus */
    .eta-divider {
        width: 100%;
        border-top: 1px dashed #bbb;
        margin: 6px 0;
    }

    .info-section {
        /* display: flex; */
        justify-content: space-between;
        align-items: center;
        margin-top: 8px;
        padding: 10px 12px;
        background: #f9f9f9;
        border-radius: 8px;
        border: 1px solid #e0e0e0;
        width: 100%;
    }

    .tarif-section {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-top: 8px;
        padding: 10px 12px;
        background: #f9f9f9;
        border-radius: 8px;
        border: 1px solid #e0e0e0;
        width: 100%;
    }

    .payment-method {
        display: flex;
        align-items: center;
        gap: 6px;
        font-size: 14px;
        font-weight: 600;
        color: #555;
    }

    .payment-method i {
        color: #2e7d32;
        /* hijau untuk saldo/tunai */
    }

    .tarif-text {
        display: flex;
        align-items: center;
        gap: 6px;
        font-size: 16px;
        font-weight: bold;
        color: #1565C0;
        /* biru untuk tarif */
    }

    .tarif-text i {
        color: #1565C0;
    }



    /* Overlay */
    .overlay {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(0, 0, 0, 0.6);
        display: none;
        justify-content: center;
        align-items: center;
        z-index: 9999;
    }

    /* Popup Box */
    .popup {
        background: #fff;
        padding: 25px 20px;
        border-radius: 16px;
        width: 90%;
        max-width: 360px;
        text-align: center;
        animation: popupFade 0.3s ease;
    }

    .popup h3 {
        margin-bottom: 20px;
        font-size: 20px;
    }

    .payment-options {
        display: flex;
        flex-direction: column;
        gap: 12px;
    }

    .option {
        padding: 12px;
        border: 2px solid #e0e0e0;
        border-radius: 12px;
        font-size: 18px;
        cursor: pointer;
        transition: 0.2s;
        display: flex;
        justify-content: center;
        align-items: center;
        gap: 10px;
    }

    .option:hover {
        background: #007bff;
        color: #fff;
        border-color: #007bff;
    }

    .close-btn {
        margin-top: 20px;
        background: #ccc;
        border: none;
        padding: 10px 20px;
        border-radius: 8px;
        cursor: pointer;
        transition: 0.2s;
    }

    .close-btn:hover {
        background: #999;
    }

    @keyframes popupFade {
        from {
            opacity: 0;
            transform: translateY(-20px);
        }

        to {
            opacity: 1;
            transform: translateY(0);
        }
    }


    /* === Alfa Go Overlay === */
    .ag-overlay {
        position: fixed;
        inset: 0;
        display: none;
        z-index: 9999;
    }

    .ag-overlay.ag-show {
        display: block;
    }

    .ag-backdrop {
        position: absolute;
        inset: 0;
        background: rgba(0, 0, 0, .55);
        backdrop-filter: blur(2px);
        animation: agFade .25s ease both;
    }

    /* Bottom sheet */
    .ag-sheet {
        position: absolute;
        left: 0;
        right: 0;
        bottom: 0;
        background: #fff;
        border-top-left-radius: 16px;
        border-top-right-radius: 16px;
        box-shadow: 0 -10px 30px rgba(0, 0, 0, .25);
        transform: translateY(100%);
        animation: agSlideUp .3s ease forwards;
        max-width: 640px;
        margin: 0 auto;
    }

    .ag-handle {
        width: 44px;
        height: 5px;
        border-radius: 5px;
        margin: 10px auto 0;
        background: #e0e0e0;
    }

    .ag-header {
        display: flex;
        align-items: center;
        justify-content: space-between;
        padding: 10px 16px 8px 16px;
        background: linear-gradient(135deg, #16a085, #2980b9);
        color: #fff;
        border-top-left-radius: 16px;
        border-top-right-radius: 16px;
    }

    .ag-title {
        display: flex;
        gap: 10px;
        align-items: center;
        font-weight: 700;
    }

    .ag-close {
        background: transparent;
        border: 0;
        color: #fff;
        font-size: 18px;
        cursor: pointer;
    }

    .ag-summary {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 12px 16px;
        background: #f4faf7;
        border-bottom: 1px dashed #cfeae2;
    }

    .ag-summary-left {
        display: flex;
        gap: 8px;
        align-items: center;
        color: #2a6572;
        font-weight: 600;
    }

    .ag-summary-right {
        font-weight: 800;
        color: #1565C0;
    }

    .ag-list {
        padding: 8px 8px 0 8px;
    }

    .ag-item {
        width: 100%;
        border: 0;
        background: #fff;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: space-between;
        padding: 12px;
        border-radius: 12px;
        margin: 8px 8px;
        box-shadow: 0 3px 10px rgba(0, 0, 0, .06);
        transition: transform .1s ease, box-shadow .2s ease, background .2s;
    }

    .ag-item:hover {
        transform: translateY(-1px);
        box-shadow: 0 6px 16px rgba(0, 0, 0, .12);
        background: #f9fffd;
    }

    .ag-left {
        display: flex;
        gap: 12px;
        align-items: center;
    }

    .ag-icon {
        width: 40px;
        height: 40px;
        border-radius: 12px;
        display: grid;
        place-items: center;
        color: #fff;
        background: linear-gradient(135deg, #16a085, #2980b9);
        box-shadow: 0 4px 10px rgba(0, 0, 0, .15);
    }

    .ag-icon.ag-cash {
        background: linear-gradient(135deg, #1abc9c, #16a085);
    }

    .ag-icon.ag-qris {
        background: linear-gradient(135deg, #2980b9, #1565C0);
    }

    .ag-icon.ag-saldo {
        background: linear-gradient(135deg, #f39c12, #e67e22);
    }

    .ag-text .ag-label {
        text-align: left;
        font-weight: 700;
        color: #18434a;
    }

    .ag-text .ag-sub {
        font-size: 12px;
        color: #6b7f85;
    }

    .ag-right {
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .ag-amount {
        font-weight: 700;
        color: #0e4aa6;
    }

    .ag-chevron {
        color: #9db3bf;
    }

    .ag-warn {
        color: #e74c3c;
    }

    .ag-footer {
        position: sticky;
        bottom: 0;
        padding: 12px 16px 18px;
        background: #fff;
        border-top: 1px solid #f0f0f0;
    }

    .ag-confirm {
        width: 100%;
        padding: 12px 14px;
        border: 0;
        border-radius: 10px;
        font-weight: 800;
        color: #fff;
        cursor: pointer;
        background: linear-gradient(135deg, #16a085, #2980b9);
        box-shadow: 0 6px 18px rgba(22, 160, 133, .35);
        transition: transform .08s ease, filter .2s ease;
    }

    .ag-confirm:active {
        transform: translateY(1px) scale(.995);
    }

    .ag-confirm.ag-disabled {
        filter: grayscale(0.4) brightness(0.85);
        cursor: not-allowed;
    }

    /* Animations */
    @keyframes agFade {
        from {
            opacity: 0
        }

        to {
            opacity: 1
        }
    }

    @keyframes agSlideUp {
        from {
            transform: translateY(100%);
        }

        to {
            transform: translateY(0);
        }
    }

    /* Small screens */
    @media (max-width: 420px) {
        .ag-amount {
            font-size: 14px;
        }

        .ag-sub {
            display: none;
        }
    }




    .back-btn {
        top: 50px;
        position: fixed;
        /* bottom: 20px; */
        left: 15px;
        width: 40px;
        height: 40px;
        background: #fff;
        color: #333;
        border: none;
        border-radius: 50%;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
        font-size: 20px;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: center;
        transition: all 0.25s ease;
        z-index: 1000;
    }

    .back-btn:hover {
        background: #f4f4f4;
        transform: scale(1.05);
    }

    .back-btn:active {
        transform: scale(0.95);
    }
</style>

<!-- Simpan data di elemen tersembunyi -->
<?php if (!empty($data)): ?>
    <div id="order-data"
        data-json='<?= json_encode($data, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES) ?>'>
    </div>
<?php endif; ?>


<div id="search-bar" class="search-restaurant-wrapper">
    <div id="location-wrapper" class="location-wrapper">
        <i class="fa-solid fa-location-dot"></i>
        <span class="location-text" id="current-location">Mencari lokasi...</span>
    </div>
    <div id="search-group" class="search-group">
        <div class="input-wrapper">
            <i class="fa-solid fa-map-marker-alt left-icon"></i>
            <input id="lokasi_awal" type="text" placeholder="Lokasi awal...">
            <i id="btnCloseAwal" class="fa-solid fa-x right-icon"></i>

        </div>

        <div class="input-wrapper">
            <i class="fa-solid fa-flag-checkered left-icon"></i>
            <input id="lokasi_akhir" type="text" placeholder="Lokasi tujuan...">
            <i id="btnCloseAkhir" class="fa-solid fa-x right-icon"></i>

        </div>
    </div>


    <div id="option-buttons" class="option-buttons">
        <button class="option-btn pilih" onclick="chooseFromMap()">
            <i class="fa-solid fa-map"></i> Pilih dari Peta
        </button>
        <button class="option-btn lokasi" onclick="chooseCurrentLocation()">
            <i class="fa-solid fa-location-crosshairs"></i> Lokasi Saya
        </button>
    </div>

</div>

<div id="map" class="map"></div>

<!-- Card info rute -->
<div id="route-card" class="route-card" style="display:none">
    <!-- ====== STATUS DEFAULT ====== -->
    <div id="trip-info">
        <div class="info-section">
            <div class="trip-info-title">📊 Info Perjalanan</div>
            <!-- 🔥 Garis pembatas -->
            <div class="eta-divider"></div>
            <div class="trip-item">🚩 <strong>Awal:</strong> <span id="start-text"></span></div>
            <div class="trip-item">🏁 <strong>Tujuan:</strong> <span id="end-text"></span></div>
            <div class="trip-item">🛣️ <strong>Jarak:</strong> <span id="distance-text"></span></div>
            <div class="trip-item">⏱️ <strong>Durasi:</strong> <span id="duration-text"></span></div>
            <div hidden class="trip-item">💰 <strong>Ongkos:</strong> Rp <span id="biaya-text"></span></div>
            <div hidden class="trip-item">📱 <strong>Biaya Aplikasi:</strong> Rp <span id="biaya-aplikasi-text"></span>
            </div>
        </div>
        <!-- 💰 Tarif & Pembayaran -->
        <div class="tarif-section" onclick="openPaymentPopup()">
            <div class="payment-method">
                <i class="fa-solid fa-money-bill-wave"></i>
                <span id="payment-method">Tunai</span>
            </div>
            <div class="tarif-text">
                <i class="fa-solid fa-wallet"></i>
                <span id="total-text">Rp 0</span>
            </div>
        </div>
        <button id="order-btn" class="order-btn">
            <span id="btn-text" class="btn-text">Pesan Sekarang</span>
            <span id="btn-spinner" hidden class="btn-spinner"></span>
        </button>
    </div>


    <!-- ====== STATUS DRIVER DATANG ====== -->
    <div id="driver-info" class="driver-info-card" style="display:none">

        <!-- Header status -->
        <div class="driver-header">
            <div class="driver-status-pulse"></div>
            <span id="driver-status-text" class="driver-status-text">Driver Menuju Lokasi Anda</span>
        </div>

        <!-- Profile Driver -->
        <div class="driver-profile">
            <!-- Foto + Rating -->
            <div class="driver-photo-wrap">
                <img id="driver-photo" class="driver-photo" src="https://img.icons8.com/fluency/96/user-male-circle.png"
                    alt="Driver">
                <div class="driver-performance">
                    <i class="fa-solid fa-star"></i>
                    <span id="driver-rating-value">0</span>
                </div>

            </div>

            <!-- Detail Driver -->
            <div class="driver-details">
                <div id="driver-name" class="driver-name">Nama Driver</div>
                <div class="vehicle-info">
                    <strong>Kendaraan :</strong> <span id="vehicle-brand">Honda Beat</span><br>
                    <strong>No. Polisi :</strong> <span id="vehicle-plate">BA 1234 XY</span>
                </div>
            </div>

            <!-- Tombol Chat -->
            <div class="chat-driver">
                <a id="chat-driver-btn" target="_blank" title="Chat Driver">
                    <i class="fa-brands fa-whatsapp"></i>
                </a>
            </div>
        </div>


        <!-- 🔥 Garis pembatas -->
        <div class="eta-divider"></div>

        <!-- ETA + Jarak -->
        <div class="eta-info">
            <div class="trip-item">
                <i class="fa-solid fa-flag-checkered"></i>
                <strong>Awal:</strong> <span id="start-text1"></span>
            </div>

            <div class="trip-item">
                <i class="fa-solid fa-location-dot"></i>
                <strong>Tujuan:</strong> <span id="end-text1"></span>
            </div>

            <!-- 🔥 Garis pembatas -->
            <div class="eta-divider"></div>

            <div class="trip-item">
                <i class="fa-solid fa-motorcycle"></i>
                <span id="eta-text">Driver tiba dalam 5 menit</span>
            </div>

            <div class="trip-item">
                <i class="fa-solid fa-road"></i>
                <span id="distance-to-customer">Jarak: - km</span>
            </div>

            <!-- 🔥 Garis pembatas -->
            <div class="eta-divider"></div>

            <!-- 💰 Tarif & Pembayaran -->
            <div class="tarif-section">
                <div class="payment-method">
                    <i class="fa-solid fa-money-bill-wave"></i>
                    <span id="payment-method">Tunai</span>
                </div>
                <div class="tarif-text">
                    <i class="fa-solid fa-wallet"></i>
                    <span id="tarif-text">Rp 0</span>
                </div>
            </div>

        </div>
    </div>
</div>

<!-- Overlay Pembayaran: Alfa Go -->
<div id="payment-overlay" class="ag-overlay" aria-hidden="true">
    <div class="ag-backdrop" onclick="closePaymentOverlay()"></div>

    <div class="ag-sheet" role="dialog" aria-modal="true" aria-labelledby="ag-title">
        <div class="ag-handle"></div>
        <div class="ag-header">
            <div class="ag-title">
                <i class="fa-solid fa-wallet"></i>
                <span id="ag-title">Pilih Metode Pembayaran</span>
            </div>
            <button class="ag-close" onclick="closePaymentOverlay()" aria-label="Tutup">
                <i class="fa-solid fa-xmark"></i>
            </button>
        </div>

        <!-- Info total / saldo -->
        <div class="ag-summary">
            <div class="ag-summary-left">
                <i class="fa-solid fa-receipt"></i> Total Tagihan
            </div>
            <div class="ag-summary-right" id="ag-total-due">Rp 0</div>
        </div>

        <div class="ag-list" role="list">
            <!-- TUNAI -->
            <button class="ag-item" role="listitem" onclick="selectPaymentAG('Tunai')" data-method="Tunai">
                <div class="ag-left">
                    <div class="ag-icon ag-cash"><i class="fa-solid fa-money-bill-wave"></i></div>
                    <div class="ag-text">
                        <div class="ag-label">Tunai</div>
                        <div class="ag-sub">Bayar langsung ke driver</div>
                    </div>
                </div>
                <div class="ag-right">
                    <div class="ag-amount" id="ag-amount-cash">Rp 0</div>
                    <!-- <i class="fa-solid fa-chevron-right ag-chevron"></i> -->
                </div>
            </button>

            <!-- QRIS -->
            <button hidden class="ag-item" role="listitem" onclick="selectPaymentAG('QRIS')" data-method="QRIS">
                <div class="ag-left">
                    <div class="ag-icon ag-qris"><i class="fa-solid fa-qrcode"></i></div>
                    <div class="ag-text">
                        <div class="ag-label">QRIS</div>
                        <div class="ag-sub">Scan QR di aplikasi</div>
                    </div>
                </div>
                <div class="ag-right">
                    <div class="ag-amount" id="ag-amount-qris">Rp 0</div>
                    <i class="fa-solid fa-chevron-right ag-chevron"></i>
                </div>
            </button>

            <!-- SALDO (ambil dari DB) -->
            <button class="ag-item" role="listitem" onclick="selectPaymentAG('Saldo')" data-method="Saldo"
                id="ag-item-saldo">
                <div class="ag-left">
                    <div class="ag-icon ag-saldo"><i class="fa-solid fa-coins"></i></div>
                    <div class="ag-text">
                        <div class="ag-label">Saldo</div>
                        <div class="ag-sub">Pembayaran pakai dompet Alfa Go</div>
                    </div>
                </div>
                <div class="ag-right">
                    <div class="ag-amount" id="ag-amount-saldo">Rp 0</div>
                    <i class="fa-solid fa-circle-exclamation ag-warn" id="ag-warn-saldo" style="display:none"
                        title="Saldo tidak cukup"></i>
                </div>
            </button>
        </div>

        <div class="ag-footer">
            <button class="ag-confirm" id="ag-confirm-btn" onclick="confirmPaymentAG()">
                <i class="fa-solid fa-check"></i> Gunakan Metode Ini
            </button>
        </div>
    </div>
</div>

<button id="center-btn" class="fab-btn" title="Pusatkan Lokasi">
    <i class="fa-solid fa-crosshairs"></i>
</button>

<button id="back-btn" class="back-btn hidden" title="Kembali">
    <i class="fa-solid fa-arrow-left"></i>
</button>


<!-- Floating jumlah driver -->
<div hidden class="driver-floating" id="driverFloating">
    <i class="fa-solid fa-motorcycle"></i>
    <span id="driverCount">0 Driver</span>
</div>


<script src="<?= base_url('js/alfaride.js') ?>"></script>

<?= $this->endSection() ?>